/*============================================================================*
 *  FILE: 
 *     macro.c
 *
 *  Description: 
 *     NNsi Macro Executing
 *
 *===========================================================================*/
#define MACRO_C
#include "local.h"

#ifdef USE_MACRO
static UInt16 getMacroValue(NNshMacroRecord *lineData, UInt16 *gr);
#endif

#ifdef USE_MACRO
/*=========================================================================*/
/*   Function : outputMacroLog                                             */
/*                                                }Np̃Oo͂ */
/*=========================================================================*/
static void outputMacroLog(DmOpenRef dbRefW, UInt8 level, UInt16 code, Char *data)
{
    NNshMacroResult  logRec;

    MemSet(&logRec, sizeof(logRec), 0x00);
    logRec.dateTime = TimGetSeconds();
    logRec.logLevel = level;
    logRec.errCode  = code;
    StrNCopy(logRec.logData, data, MAX_LOGRECLEN);
    EntryRecord_NNsh(dbRefW, sizeof(NNshMacroResult), &logRec);
    return;
}
#endif


#ifdef USE_MACRO
/*=========================================================================*/
/*   Function :  macroDataOperation                                        */
/*                                                      }Ñf[^ */
/*=========================================================================*/
static UInt16 *macroSelectGR(NNshMacroRecord *lineData, UInt16 *gr)
{
    if ((lineData->dst >= NNSH_MACROOP_GR_OFFSET)&&
        (lineData->dst <= NNSH_MACROOP_GR_MAX))
    {
        // w肳ꂽ GR ɑ
        return (&gr[lineData->dst - NNSH_MACROOP_GR_OFFSET]);
    }
    // GR0  
    return (gr);
}
#endif

#ifdef USE_MACRO
/*=========================================================================*/
/*   Function :  macroDataOperation                                        */
/*                                                        NNsiݒ̒l */
/*=========================================================================*/
static void macroDataOperation(NNshMacroRecord *lineData, UInt16 *gr, Boolean setter)
{
    UInt16 value, setValue, *data;

    value    = 0;
    setValue = getMacroValue(lineData, gr);
    switch (lineData->MacroData.numData.subCommand)
    {
      case NNSH_MACROOPCMD_AUTOSTARTMACRO:
        // }Ns
        value = (NNshGlobal->NNsiParam)->autostartMacro;
        if (setter == true)
        {
            // lݒ肪wĂꍇAAA
            (NNshGlobal->NNsiParam)->autostartMacro = setValue;
        }
        break;

      case NNSH_MACROOPCMD_NEWARRIVAL_LINE:
        // VmFsɉؒf
        value = (NNshGlobal->NNsiParam)->disconnArrivalEnd;
        if (setter == true)
        {
            // lݒ肪wĂꍇAAA
            (NNshGlobal->NNsiParam)->disconnArrivalEnd = setValue;
        }
        break;

      case NNSH_MACROOPCMD_NEWARRIVAL_DA:
        // VmFsDAN
        value = (NNshGlobal->NNsiParam)->use_DAplugin;
        if (setter == true)
        {
            // lݒ肪wĂꍇAAA
            (NNshGlobal->NNsiParam)->use_DAplugin = setValue;
        }
        break;

      case NNSH_MACROOPCMD_NEWARRIVAL_ROLOG:
        // QƃO̎擾x
        value = (NNshGlobal->NNsiParam)->getROLogLevel;
        if (setter == true)
        {
            // lݒ肪wĂꍇAAA
            (NNshGlobal->NNsiParam)->getROLogLevel = setValue;
        }
        break;

      case NNSH_MACROOPCMD_NEWARRIVAL_BEEP:
        // VmFIɃr[v
        value = (NNshGlobal->NNsiParam)->autoBeep;
        if (setter == true)
        {
            // lݒ肪wĂꍇAAA
            (NNshGlobal->NNsiParam)->autoBeep = setValue;
        }
        break;
        
      case NNSH_MACROOPCMD_COPY_AND_DELETE:
        // QƃOɃRs[ƂA폜{
        value = (NNshGlobal->NNsiParam)->copyDelReadOnly;
        if (setter == true)
        {
            // lݒ肪wĂꍇAAA
            (NNshGlobal->NNsiParam)->copyDelReadOnly = setValue;
        }
        break;

      default:
        // Ȃ
        break;
    }
    data  = macroSelectGR(lineData, gr);
    *data = value;
    return;
}
#endif

#ifdef USE_MACRO
/*=========================================================================*/
/*   Function : getMacroValue                                              */
/*                                            }ÑIyhl擾 */
/*=========================================================================*/
static UInt16 getMacroValue(NNshMacroRecord *lineData, UInt16 *gr)
{
    if ((lineData->src >= NNSH_MACROOP_GR_OFFSET)&&
        (lineData->src <= NNSH_MACROOP_GR_MAX))
    {
        // WX^ǂݍ񂾒l
        return (gr[lineData->src - NNSH_MACROOP_GR_OFFSET]);
    }

    // Rl擾
    return (lineData->MacroData.numData.operator);
}
#endif

#ifdef USE_MACRO
/*=========================================================================*/
/*   Function : checkMacroCommandAvailable                                 */
/*                                            }NR}h̎smF */
/*=========================================================================*/
static Boolean checkMacroCommandAvailable(UInt16 command, UInt16 halt)
{
    // sR}hXg
    UInt16  okCmdList[] = {
        MULTIBTN_FEATURE_GET,    MULTIBTN_FEATURE_ALLGET,    MULTIBTN_FEATURE_PARTGET,
        MULTIBTN_FEATURE_DELETE, MULTIBTN_FEATURE_SORT,      MULTIBTN_FEATURE_SEARCH,
        MULTIBTN_FEATURE_NEXT,   MULTIBTN_FEATURE_PREV,      MULTIBTN_FEATURE_TOP,
        MULTIBTN_FEATURE_BOTTOM, MULTIBTN_FEATURE_COPYGIKO,  MULTIBTN_FEATURE_DELNOTGET,
        MULTIBTN_FEATURE_DBCOPY, MULTIBTN_FEATURE_GRAPHMODE, MULTIBTN_FEATURE_DISCONN,
        MULTIBTN_FEATURE_GETLIST,MULTIBTN_FEATURE_NEWARRIVAL,MULTIBTN_FEATURE_SELECTNEXT,
        MULTIBTN_FEATURE_SELECTPREV,MULTIBTN_FEATURE_PREVPAGE,MULTIBTN_FEATURE_NEXTPAGE,
        MULTIBTN_FEATURE_TO_NOTREAD,MULTIBTN_FEATURE_TO_GETALL,MULTIBTN_FEATURE_LOGCHARGE,
        MULTIBTN_FEATURE_SETLOGCHRG,MULTIBTN_FEATURE_BT_ON,  MULTIBTN_FEATURE_BT_OFF,
        MULTIBTN_FEATURE_TO_OFFLINE,MULTIBTN_FEATURE_TO_FAVOR,MULTIBTN_FEATURE_TO_USER1,
        MULTIBTN_FEATURE_TO_USER2,MULTIBTN_FEATURE_TO_USER3, MULTIBTN_FEATURE_TO_USER4,
        MULTIBTN_FEATURE_TO_USER5,MULTIBTN_FEATURE_OYSTERLOGIN, MULTIBTN_FEATURE_NEXTSEARCHBBS, 
        MULTIBTN_FEATURE_UPDATERESNUM, MULTIBTN_FEATURE_BE_LOGIN, 0,
        0,0
    };
    UInt16  check, *cmdPtr;

    // }Ns`FbN
    if (halt > MAX_HALT_OPERATION)
    {
        // sɂЂ
        return (false);
    }

    // ꗗʋ@\sł邩ǂ̃`FbN
    if (((command)&(MULTIBTN_FEATURE)) == (MULTIBTN_FEATURE))
    {
        check = (command)&(MULTIBTN_FEATURE_MASK);
        cmdPtr = okCmdList;
        while (*cmdPtr != 0)
        {
            if (check == *cmdPtr)
            {
                // s\R}hXgɔAs
                return (true);
            }
            cmdPtr++;
        }
        // s\R}hXgɂȂAs֎~
        return (false);
    }

    // s
    return (true);
}
#endif

#ifdef USE_MACRO
/*-------------------------------------------------------------------------*/
/*   Function : setFileListItems                                           */
/*                                                t@Cꗗ̃Xgݒ */
/*-------------------------------------------------------------------------*/
static UInt16 setFileListItems(Char *fnameP)
{
    Err                  ret, err;
    UInt16               cardNo, cnt;
    LocalID              dbLocalID;
    DmSearchStateType    state;
    Char                 fileName[MINIBUF + MARGIN], *ptr;

    // VFS̎gpݒɂ킹ătOݒAt@CƁAꗗ\
    ptr = fnameP;
    cnt = 0;

    // Palm{̓ɂt@C̈ꗗ擾
    ret = DmGetNextDatabaseByTypeCreator(true, &state, 
                                         DATA_DBTYPE_ID, 
                                         DBSOFT_CREATOR_ID,
                                         false, &cardNo, &dbLocalID);
    while ((ret == errNone)&&(dbLocalID != 0))
    {
        // t@C擾
        MemSet(fileName, sizeof(fileName), 0x00);
        err = DmDatabaseInfo(cardNo, dbLocalID, fileName,
                             NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                             NULL, NULL, NULL);
        if (err == errNone)
        {
            // 擾t@CXgACeɃRs[
            if ((fnameP != NULL)&&(cnt < MAX_MACRO_DBFILES))
            {
                StrCopy(ptr, fileName);
                ptr = ptr + StrLen(ptr) + 1;
                cnt++;
            }
        }

        // ڈȍ~̃f[^擾
        ret = DmGetNextDatabaseByTypeCreator(false, &state,
                                             DATA_DBTYPE_ID, 
                                             DBSOFT_CREATOR_ID,
                                             false, &cardNo, &dbLocalID);
    }
    return (cnt);
}
#endif

#ifdef USE_MACRO
/*=========================================================================*/
/*   Function : NNsi_ExecuteMacroSelection                                 */
/*                                                          }NIs */
/*=========================================================================*/
Boolean NNsi_ExecuteMacroSelection(void)
{
    Char   *ptr, *dbFileNamePtr, dbFileName[MINIBUF + MARGIN];
    UInt16  cnt, btnId;

    // 
    MemSet(dbFileName, sizeof(dbFileName), 0x00);    
    cnt = 0;
    dbFileNamePtr = MEMALLOC_PTR((MINIBUF) * (MAX_MACRO_DBFILES) + MARGIN);
    if (dbFileNamePtr == NULL)
    {
        NNsh_DebugMessage(ALTID_INFO, " memory allocation failure... ", "", 0);
        return (false);   
    }
    MemSet(dbFileNamePtr, ((MINIBUF) * (MAX_MACRO_DBFILES) + MARGIN), 0x00);

    // }Nt@C𒊏o
    cnt = setFileListItems(dbFileNamePtr);
    if (cnt == 0)
    {
        NNsh_DebugMessage(ALTID_INFO, " macro count is zero... ", "", 0);
        return (false);
    }    

    // IEBhEJ
    btnId = NNshWinSelectionWindow(FRMID_DIRSELECTION, dbFileNamePtr, cnt, 0);
    if (btnId == BTNID_JUMPCANCEL)
    {
        // LZ
        MEMFREE_PTR(dbFileNamePtr);
        NNsh_DebugMessage(ALTID_INFO, "selection canceled ", "", 0);
        return (false);    
    }

    // IXNvgt@C𒊏o 
    ptr = dbFileNamePtr;
    for (cnt = 0; cnt < (MAX_MACRO_DBFILES); cnt++)
    {
        if (cnt == NNshGlobal->jumpSelection)
        {
            StrCopy(dbFileName, ptr);
            break;        
        } 
        ptr = ptr + StrLen(ptr) + 1;
    }

    // mۂ̊J
    MEMFREE_PTR(dbFileNamePtr);

    // fobO\...
    NNsh_DebugMessage(ALTID_INFO, " Macro Name: ", dbFileName, 0);

    // I}Ns...
    if (StrLen(dbFileName) != 0)
    {
        NNsi_ExecuteMacroMain(dbFileName, DBVERSION_MACRO, DBSOFT_CREATOR_ID, DATA_DBTYPE_ID);
        return (true);
    }
    return (false);
}
#endif

#ifdef USE_MACRO
/*=========================================================================*/
/*   Function : NNsi_ExecuteMacroMain                                      */
/*                                                        }NsC */
/*=========================================================================*/
void NNsi_ExecuteMacroMain(Char *macroDBName, UInt16 macroDBVersion, UInt32 creator, UInt32 type)
{
    Err                  ret;
    Boolean              penState;
    Char                *buf, *grBuf;
    UInt16              *gr, recQnt, cnt, command, *data, *stack, *top;
    UInt16               halt, savedParam, autoOffTime, y;
    UInt32               code;
    NNshMacroRecord     *lineData;
    DmOpenRef            dbRefR, dbRefW;
    MemHandle            dataH, tmpH;
    NNshSubjectDatabase *subjDB;
    
    // f[^
    halt     = 0;
    code     = 0;
    lineData = NULL;

    // ̈̊m
    stack = MEMALLOC_PTR(sizeof(UInt16) * NOF_REGISTER + MARGIN);
    if (stack == NULL)
    {
        // ̈mێsAI
        return;
    }
    MemSet(stack, ((sizeof(UInt16) * NOF_REGISTER) + MARGIN), 0x00);
    top = stack;

    // ̈̊m
    gr = MEMALLOC_PTR((sizeof(UInt16) * NOF_REGISTER) + MARGIN);
    if (gr == NULL)
    {
        // ̈mێsAI
        return;
    }
    MemSet(gr, (sizeof(UInt16) * NOF_REGISTER + MARGIN), 0x00);

    // ̈̊m
    grBuf = MEMALLOC_PTR(sizeof(Char) * TEXTBUFSIZE + MARGIN);
    if (grBuf == NULL)
    {
        // ̈mێsAI
        MEMFREE_PTR(gr);
        return;
    }
    MemSet(grBuf, (sizeof(Char) * TEXTBUFSIZE + MARGIN), 0x00);

    // ̈̊m
    subjDB = MEMALLOC_PTR(sizeof(NNshSubjectDatabase) + MARGIN);
    if (subjDB == NULL)
    {
        // ̈mێsAI
        MEMFREE_PTR(grBuf);
        MEMFREE_PTR(gr);
        return;
    }
    MemSet(subjDB, (sizeof(NNshSubjectDatabase) + MARGIN), 0x00);

    // ̈̊m
    buf = MEMALLOC_PTR(MAX_STRLEN + MARGIN);
    if (buf == NULL)
    {
        // ̈mێsAI
        MEMFREE_PTR(subjDB);
        MEMFREE_PTR(grBuf);
        MEMFREE_PTR(gr);
        return;
    }
    MemSet(buf, (MAX_STRLEN + MARGIN), 0x00);

    // }NsAmF_CAOȗ
    savedParam = (NNshGlobal->NNsiParam)->confirmationDisable;
    (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;

    // f[^x[XJ(XNvgt@C)
    OpenDB_wCreator(macroDBName, macroDBVersion, creator, type, false, &dbRefR);
    if (dbRefR == 0)
    {
        // G[AI
        goto FUNC_END;
    }

    // f[^x[XJ(Ot@C)
    OpenDatabase_NNsh(DBNAME_MACRORESULT, DBVERSION_MACRO, &dbRefW);
    if (dbRefW == 0)
    {
        // G[AI
        CloseDatabase_NNsh(dbRefR);
        goto FUNC_END;
    }
    GetDBCount_NNsh(dbRefW, &recQnt);
    while (recQnt != 0)
    {
        //  łɃOt@CL^ĂꍇASR[h폜
        (void) DeleteRecordIDX_NNsh(dbRefW, (recQnt - 1));
        recQnt--;
    }

    // XNvg̃R[hmF
    GetDBCount_NNsh(dbRefR, &recQnt);

    // dnee^C}𖳌ɂ
    autoOffTime = SysSetAutoOffTime(0);
    (void) EvtResetAutoOffTimer();

    cnt = 0;
    while (cnt < recQnt)
    {
        // R[hǂݏo
        ret = GetRecordReadOnly_NNsh(dbRefR, cnt, &dataH, (void **) &lineData);
        if (ret != errNone)
        {
            // R[hǂݏosÃR[hֈړ
            dataH = 0;
            goto NEXT_COMMAND;
        }

        switch (lineData->opCode)
        {
          case NNSH_MACROCMD_XOR:
            // rI_aƂ
            command = getMacroValue(lineData, gr);
            data    = macroSelectGR(lineData, gr);
            *data   = *data ^ command;
            break;

          case NNSH_MACROCMD_AND:
            // l_ς
            command = getMacroValue(lineData, gr);
            data    = macroSelectGR(lineData, gr);
            *data   = *data & command;
            break;

          case NNSH_MACROCMD_OR:
            // l_a
            command = getMacroValue(lineData, gr);
            data    = macroSelectGR(lineData, gr);
            *data   = *data | command;
            break;

          case NNSH_MACROCMD_ADD:
            // lZ
            command = getMacroValue(lineData, gr);
            data    = macroSelectGR(lineData, gr);
            *data   = *data + command;
            break;

          case NNSH_MACROCMD_CMP:
          case NNSH_MACROCMD_SUB:
            // lrāǍʂ
            command = getMacroValue(lineData, gr);
            data    = macroSelectGR(lineData, gr);
            *data   = *data - command;
            break;

          case NNSH_MACROCMD_JNZ:
            // l[łȂ΃Wv
            data    = macroSelectGR(lineData, gr);
            if (*data != 0)
            {
                // Wv́Asrc or l擾
                command = getMacroValue(lineData, gr);
                if ((command > 0)&&(command <= recQnt))
                {
                    cnt = command - 1 - 1;
                }
                else
                {
                    // R}hss(Wvs)
                    outputMacroLog(dbRefW, NNSH_MACROLOGLEVEL_ERROR, (cnt + 1),
                                   "CANNOT JUMP");
                }
            }
            break;

          case NNSH_MACROCMD_JZ:
            // l[ȂWv
            data    = macroSelectGR(lineData, gr);
            if (*data == 0)
            {
                // Wv́Asrc or l擾
                command = getMacroValue(lineData, gr);
                if ((command > 0)&&(command <= recQnt))
                {
                    cnt = command - 1 - 1;
                }
                else
                {
                    // R}hss(Wvs)
                    outputMacroLog(dbRefW, NNSH_MACROLOGLEVEL_ERROR, (cnt + 1),
                                   "CANNOT JUMP");
                }
            }
            break;

          case NNSH_MACROCMD_MOVE:
            // f[^(l)̑
            data    = macroSelectGR(lineData, gr);
            command = getMacroValue(lineData, gr);
            *data   = command;
            break;

          case NNSH_MACROCMD_JMP:
            // V[PX̖Wv
            command = getMacroValue(lineData, gr);
            if ((command > 0)&&(command <= recQnt))
            {
                cnt = command - 1 - 1;
            }
            else
            {
                // R}hss(Wvs)
                outputMacroLog(dbRefW, NNSH_MACROLOGLEVEL_ERROR, (cnt + 1),
                               "CANNOT JUMP");
            }
            break;

          case NNSH_MACROCMD_EXECUTE:
            // @\̎s
            command = getMacroValue(lineData, gr);

            // R}hsmF
            if (checkMacroCommandAvailable(((command)|(MULTIBTN_FEATURE)), halt) == true)
            {
                // R}hs
                ExecuteAction(command);
            }
            else
            {
                // R}hss(Oo)
                outputMacroLog(dbRefW, NNSH_MACROLOGLEVEL_ERROR, command,
                               "PROHIBIT EXECUTION.");
            }
            break;

          case NNSH_MACROCMD_MESSAGE:
            // Oo
            if ((lineData->src >= NNSH_MACROOP_GR_OFFSET)&&
                (lineData->src <= NNSH_MACROOP_GR_MAX))
            {
                // srcGRxw肳Ăꍇ
                MemSet(buf, (MAX_STRLEN + MARGIN), 0x00);
                StrCopy(buf, "[gr");
                NUMCATI(buf, lineData->src - NNSH_MACROOP_GR_OFFSET);
                StrCat (buf, " = ");
                command = gr[lineData->src - NNSH_MACROOP_GR_OFFSET];
                NUMCATI(buf, command);
                StrCat (buf, "] ");
                // ɒǉ
                StrNCopy(&buf[StrLen(buf)], lineData->MacroData.strData.data,
                         (MAX_STRLEN - StrLen(buf)));
                outputMacroLog(dbRefW, lineData->MacroData.strData.operator, 0,
                               buf);
            }
            else
            {
                // ^ꂽf[^̂܂ܕ\
                outputMacroLog(dbRefW, lineData->MacroData.strData.operator, 0,
                               lineData->MacroData.strData.data);
            }
            break;

          case NNSH_MACROCMD_BEEP:
            // r[v炷
            command = getMacroValue(lineData, gr);
            switch (command)
            {
              case 0:
                // Info 
                NNsh_BeepSound(sndInfo);
                break;

              case 1:
                // Alarm(NNsh_BeepSound()sndAlarmɕϊ)
                NNsh_BeepSound(sndClick);
                break;

              case 2:
                // Error 
                NNsh_BeepSound(sndError);
                break;

              case 3:
                // Confirmation 
                NNsh_BeepSound(sndConfirmation);
                break;

              case 0xffff:
                // A[ƃOo
                NNsh_BeepSound(sndAlarm);
                outputMacroLog(dbRefW, NNSH_MACROLOGLEVEL_ERROR, 0,
                                             lineData->MacroData.strData.data);
                break;

              default:
                // A[
                NNsh_BeepSound(sndAlarm);
                break;
            }
            break;

          case NNSH_MACROCMD_MACROEND:
            // }NI(ĨOo͂)
            outputMacroLog(dbRefW, NNSH_MACROLOGLEVEL_DEBUG, 0, "<< MACRO END >>");

            // R[hԍI[o[A[vIɔ
            cnt = recQnt;
            break;

          case NNSH_MACROCMD_OPERATE:
            // NNsiݒύX
            macroDataOperation(lineData, gr, true);
            break;

          case NNSH_MACROCMD_STATUS:
            // NNsiݒ̒l擾
            macroDataOperation(lineData, gr, false);
            break;

          case NNSH_MACROCMD_SETTABNUM:
            // ݂̃^ui[
            data  = macroSelectGR(lineData, gr);
            *data = Show_tab_info(false);
            break;

          case NNSH_MACROCMD_STRSTR:
            // 񂪊܂܂邩`FbN
            data  = macroSelectGR(lineData, gr);
            *data = 1;
            if (NNshGlobal->nofTitleItems != 0)
            {
                command = convertListIndexToMsgIndex((NNshGlobal->NNsiParam)->selectedTitleItem);
                if (Get_Subject_Database(command, subjDB) == errNone)
                {
                    if (StrStr(subjDB->threadTitle, 
                                         lineData->MacroData.strData.data) != NULL)
                    {
                        // 񂪊܂܂Ă
                        *data = 0;
                    }
                }
            }
            break;

          case NNSH_MACROCMD_STRCMP:
            // 񂪈v邩`FbN
            data  = macroSelectGR(lineData, gr);
            *data = 1;
            if (NNshGlobal->nofTitleItems != 0)
            {
                command = convertListIndexToMsgIndex((NNshGlobal->NNsiParam)->selectedTitleItem);
                if (Get_Subject_Database(command, subjDB) == errNone)
                {
                    if (StrCompare(subjDB->threadTitle, 
                                         lineData->MacroData.strData.data) != NULL)
                    {
                        // 񂪈v
                        *data = 0;
                    }
                }
            }
            break;

          case NNSH_MACROCMD_GETMESNUM:
            // 擾X𔽉f
            data  = macroSelectGR(lineData, gr);
            *data = 0;
            command = convertListIndexToMsgIndex((NNshGlobal->NNsiParam)->selectedTitleItem);
            if (Get_Subject_Database(command, subjDB) == errNone)
            {
                // 擾X
                *data = subjDB->maxLoc;
            }
            break;

          case NNSH_MACROCMD_MESSTATUS:
            // 擾X̏Ԃ𔽉f
            data  = macroSelectGR(lineData, gr);
            *data = 0;
            command = convertListIndexToMsgIndex((NNshGlobal->NNsiParam)->selectedTitleItem);
            if (Get_Subject_Database(command, subjDB) == errNone)
            {
                // XԂ
                *data = subjDB->state;
            }
            break;

          case NNSH_MACROCMD_BBSTYPE:
            // BBS^Cv𔽉f
            data  = macroSelectGR(lineData, gr);
            *data = 0;
            command = convertListIndexToMsgIndex((NNshGlobal->NNsiParam)->selectedTitleItem);
            if (Get_Subject_Database(command, subjDB) == errNone)
            {
                // BBS^Cv
                *data = subjDB->bbsType;
            }
            break;

          case NNSH_MACROCMD_IMPORT:
#ifdef USE_XML_OUTPUT
            if ((NNshGlobal->NNsiParam)->useVFS == NNSH_NOTSUPPORT_VFS)
            {
                // VFS T|[g@͂̂܂NNsiݒC|[g
                Input_NNsiSet_XML(FILE_XML_NNSISET);
                break;
            }
            // VFST|[g@
            command = (NNshGlobal->NNsiParam)->useVFS;   // VFSݒ̈ꎞL
            data    = macroSelectGR(lineData, gr);
            if (*data == 0)
            {
                // (Palmǂݏo悤ɂ)
                (NNshGlobal->NNsiParam)->useVFS = 0;
            }
            else
            {
                // (VFSݒɍXV)
                (NNshGlobal->NNsiParam)->useVFS = ((NNSH_VFS_ENABLE)|
                                     (NNSH_VFS_WORKAROUND)|
                                     (NNSH_VFS_USEOFFLINE)|
                                     (NNSH_VFS_DIROFFLINE)|
                                     (NNSH_VFS_DBBACKUP));
                
            }
            // NNsiݒC|[g
            Input_NNsiSet_XML(FILE_XML_NNSISET);
            (NNshGlobal->NNsiParam)->useVFS = command;  // VFSݒ̕
#endif
            break;

          case NNSH_MACROCMD_EXPORT:
#ifdef USE_XML_OUTPUT
            // NNsiݒ̃GNX|[g
            Output_NNsiSet_XML(FILE_XML_NNSISET);
#endif
            break;

          case NNSH_MACROCMD_LAUNCHDA:
            // DAN
            code = lineData->MacroData.numData.data1;
            code = code << 16;
            code = code + lineData->MacroData.numData.data2;

            ///////////////////// DA NmFpO  //////////////////////////
            MemSet(buf, (MAX_STRLEN + MARGIN), 0x00);
            StrCopy(buf, "DA:0x");
            NUMCATH(buf, code);
            outputMacroLog(dbRefW, NNSH_MACROLOGLEVEL_INFO, 0, buf);
            ///////////////////////////////////////////////////////////////////

            // dOFF^C}ꎞIɕ
            (void) SysSetAutoOffTime(autoOffTime);
            (void) EvtResetAutoOffTimer();

            // DAN
            LaunchDA_NNsh(code);

            // dOFF^C}~
            (void) SysSetAutoOffTime(0);
            (void) EvtResetAutoOffTimer();
            break;

          case NNSH_MACROCMD_CLIPCOPY:
             // Nbv{[hɃRs[
             ClipboardAddItem(clipboardText, lineData->MacroData.strData.data, 
                              (StrLen(lineData->MacroData.strData.data) + 1));
            break;

          case NNSH_MACROCMD_CLIPADD:
             // Nbv{[hɒǉ
             ClipboardAppendItem(clipboardText, 
                                 lineData->MacroData.strData.data, 
                                 (StrLen(lineData->MacroData.strData.data) + 1));
            break;

          case NNSH_MACROCMD_CLIPINSTR:
            // Nbv{[h̕Ɋ܂܂邩mF
            data  = macroSelectGR(lineData, gr);
            *data = 1;
            tmpH = ClipboardGetItem(clipboardText, &command);
            if (tmpH != 0)
            {
                // Nbv{[h̓eobt@ɃRs[
                if (command > TEXTBUFSIZE)
                {
                    command = TEXTBUFSIZE;
                }
                MemSet(grBuf, (sizeof(Char) * TEXTBUFSIZE + MARGIN), 0x00);
                MemMove(grBuf, MemHandleLock(tmpH), command);
                MemHandleUnlock(tmpH);
                if (StrStr(grBuf, lineData->MacroData.strData.data) != NULL)
                {
                    // f[^܂܂Ă
                    *data = 0;
                }
            }
            break;

          case NNSH_MACROCMD_TITLECLIP:
            // X^CgNbv{[hɃRs[
            if (NNshGlobal->nofTitleItems != 0)
            {
                command = convertListIndexToMsgIndex((NNshGlobal->NNsiParam)->selectedTitleItem);
                if (Get_Subject_Database(command, subjDB) == errNone)
                {
                    ClipboardAddItem(clipboardText, subjDB->threadTitle, 
                                            (StrLen(subjDB->threadTitle) + 1));
                }
            }
            break;

          case NNSH_MACROCMD_SET_FINDBBSSTR:
            // ^upɃNbv{[h̕Rs[
            tmpH = ClipboardGetItem(clipboardText, &command);
            if (tmpH != 0)
            {
                // Nbv{[h̓eobt@ɃRs[
                if (command > BUFSIZE)
                {
                    command = BUFSIZE - 1;
                }
                if (NNshGlobal->searchBBSH == 0)
                {
                    NNshGlobal->searchBBSH = MemHandleNew(BUFSIZE);
                    if (NNshGlobal->searchBBSH == 0)
                    {
                        // ̈mێsAȂɂȂ
                        break;
                    }
                }
                MemSet(MemHandleLock(NNshGlobal->searchBBSH), BUFSIZE, 0x00);
                MemHandleUnlock(NNshGlobal->searchBBSH);
                MemMove(MemHandleLock(NNshGlobal->searchBBSH), MemHandleLock(tmpH), command);
                MemHandleUnlock(tmpH);
                MemHandleUnlock(NNshGlobal->searchBBSH);
            }
            break;

          case NNSH_MACROCMD_SET_FINDTHREADSTR:
            // X^CpɃNbv{[h̕Rs[
            tmpH = ClipboardGetItem(clipboardText, &command);
            if (tmpH != 0)
            {
                // Nbv{[h̓eobt@ɃRs[
                if (command > BUFSIZE)
                {
                    command = BUFSIZE - 1;
                }
                if (NNshGlobal->searchTitleH == 0)
                {
                    NNshGlobal->searchTitleH = MemHandleNew(BUFSIZE);
                    if (NNshGlobal->searchTitleH == 0)
                    {
                        // ̈mێsAȂɂȂ
                        break;
                    }
                }
                MemSet(MemHandleLock(NNshGlobal->searchTitleH), BUFSIZE, 0x00);
                MemHandleUnlock(NNshGlobal->searchTitleH);
                MemMove(MemHandleLock(NNshGlobal->searchTitleH), MemHandleLock(tmpH), command);
                MemHandleUnlock(tmpH);
                MemHandleUnlock(NNshGlobal->searchTitleH);
            }
            break;

          case NNSH_MACROCMD_UPDATE_RESNUM:
            // X̃XXVi[(1.03)
            if (NNshGlobal->nofTitleItems != 0)
            {
                command = convertListIndexToMsgIndex((NNshGlobal->NNsiParam)->selectedTitleItem);
                data    = macroSelectGR(lineData, gr);
                *data   = UpdateThreadResponseNumber(command);
            }
            break;
          case NNSH_MACROCMD_JPL:
            // l̏ꍇɂ̓Wv(1.03)
            data    = macroSelectGR(lineData, gr);
            if ((*data > 0)&&(*data <= 0x7fff))
            {
                // Wv́Asrc or l擾
                command = getMacroValue(lineData, gr);
                if ((command > 0)&&(command <= recQnt))
                {
                    cnt = command - 1 - 1;
                }
                else
                {
                    // R}hss(Wvs)
                    outputMacroLog(dbRefW, NNSH_MACROLOGLEVEL_ERROR, (cnt + 1),
                                   "CANNOT JUMP");
                }
            }
            break;

          case NNSH_MACROCMD_JMI:
            // l()ꍇɂ̓Wv(1.03)
            data    = macroSelectGR(lineData, gr);
            if (*data > 0x7fff)
            {
                // Wv́Asrc or l擾
                command = getMacroValue(lineData, gr);
                if ((command > 0)&&(command <= recQnt))
                {
                    cnt = command - 1 - 1;
                }
                else
                {
                    // R}hss(Wvs)
                    outputMacroLog(dbRefW, NNSH_MACROLOGLEVEL_ERROR, (cnt + 1),
                                   "CANNOT JUMP");
                }
            }
            break;

          case NNSH_MACROCMD_OUTPUTTITLE:
            // X^CgOo(1.03)
            MemSet(buf, (MAX_STRLEN + MARGIN), 0x00);
            command = convertListIndexToMsgIndex((NNshGlobal->NNsiParam)->selectedTitleItem);
            if (Get_Subject_Database(command, subjDB) == errNone)
            {
                StrNCopy(buf, subjDB->threadTitle, MAX_STRLEN);
                outputMacroLog(dbRefW, lineData->MacroData.strData.operator, 0,
                               buf);
            }
            break;

          case NNSH_MACROCMD_OUTPUTCLIP:
            // Nbv{[hOo(1.03)
            MemSet(buf, (MAX_STRLEN + MARGIN), 0x00);
            tmpH = ClipboardGetItem(clipboardText, &command);
            if (tmpH != 0)
            {
                if (command > MAX_STRLEN)
                {
                    command = MAX_STRLEN;
                }
                StrNCopy(buf, MemHandleLock(tmpH), command);
                outputMacroLog(dbRefW, lineData->MacroData.strData.operator, 0,
                               buf);
                MemHandleUnlock(tmpH);
            }                
            break;

          case NNSH_MACROCMD_REMARK:
            // ߕAȂ
            break;

          case NNSH_MACROCMD_PUSH:
            // X^bNPUSH(X^bNTCY̌E)
            if ((stack + sizeof(UInt16) * NOF_REGISTER) != top)
            {
                command = getMacroValue(lineData, gr);
                *top    = command;
                top++;
            }
            break;
         
          case NNSH_MACROCMD_POP:
            // X^bNPOP(1.04)
            if (top != stack)
            {
                data  = macroSelectGR(lineData, gr);
                *data = *top;
                top--;
            }
            break;

          case NNSH_MACROCMD_GETRECNUM:
            // R[hԍ擾(1.04)
            data    = macroSelectGR(lineData, gr);
            if (NNshGlobal->nofTitleItems != 0)
            {
                command = convertListIndexToMsgIndex((NNshGlobal->NNsiParam)->selectedTitleItem);
            }
            else
            {
                // Ȃ傫Ȑi[...
                command = 0xfffd;
            }
            *data = command;
            break;

          case NNSH_MACROCMD_FINDTHREADSTRCOPY:
            // X^CNbv{[hɃRs[
            MemSet(buf, (MAX_STRLEN + MARGIN), 0x00);
            if (NNshGlobal->searchTitleH != 0)
            {
                StrNCopy(buf, MemHandleLock(NNshGlobal->searchTitleH), MAX_STRLEN);
                MemHandleUnlock(NNshGlobal->searchTitleH);
            }
            else
            {
                StrCopy(buf, " ");
            }
            ClipboardAddItem(clipboardText, buf, StrLen(buf));
            break;

          case NNSH_MACROCMD_INPUTDIALOG:
            // ̓_CAO\ (͕Nbv{[hɃRs[)
            MemSet(buf, (MAX_STRLEN + MARGIN), 0x00);
            DataInputDialog(lineData->MacroData.strData.data, buf, MAX_STRLEN, 
                            NNSH_DIALOG_USE_MACROINPUT, NULL);
            ClipboardAddItem(clipboardText, buf, StrLen(buf));
            break;
            
          case NNSH_MACROCMD_OUTPUTDIALOG:
            // _CAO\
            NNsh_ErrorMessage(ALTID_INFO, lineData->MacroData.strData.data, "", 0);
            break;

          case NNSH_MACROCMD_CONFIRMDIALOG:
            // Nbv{[h̕\AmF_CAO\
            //  ({^ꂽ(OK/Cancel)WX^ɔfj
            MemSet(buf, (MAX_STRLEN + MARGIN), 0x00);
            tmpH = ClipboardGetItem(clipboardText, &command);
            if (tmpH != 0)
            {
                // Nbv{[h當擾
                if (command > MAX_STRLEN)
                {
                    command = MAX_STRLEN;
                }
                StrNCopy(buf, MemHandleLock(tmpH), command);
                MemHandleUnlock(tmpH);
            }
            else
            {
                // _CAOɕ\Ȃ
                StrNCopy(buf, " Are you OK? ", StrLen(" "));
            }
            data    = macroSelectGR(lineData, gr);
            command = NNsh_ErrorMessage(ALTID_CONFIRM, buf, "", 0);
            *data   = command;
            break;

          default:
            // R}hR[hُAȂɂsȂ
            break;
        }

NEXT_COMMAND:
        // R[hAւ
        ReleaseRecordReadOnly_NNsh(dbRefR, dataH);
        cnt++;

        // y̏ԂE(ʃ^bvĂ邩mF)
        EvtGetPen(&command, &y, &penState);
        if (penState == true)
        {
            // y_EĂA~邩mFs
            if (NNsh_ErrorMessage(ALTID_CONFIRM,
                                  MSG_CONFIRM_ABORT_MACRO, 
                                  MSG_LINE_NUMBER, cnt) == 0)
            {
                // OKꂽAbreak
                break;
            }
        }
    }

    // dOFF^C}𕜋
    (void) SysSetAutoOffTime(autoOffTime);
    (void) EvtResetAutoOffTimer();

    // f[^x[XďI    
    CloseDatabase_NNsh(dbRefW);
    CloseDatabase_NNsh(dbRefR);

FUNC_END:
    MEMFREE_PTR(buf);
    MEMFREE_PTR(subjDB);
    MEMFREE_PTR(grBuf);
    MEMFREE_PTR(gr);
    MEMFREE_PTR(stack);
    (NNshGlobal->NNsiParam)->confirmationDisable = savedParam;

    // IuU[炷
    // SndPlaySystemSound(sndAlarm);

    // }NIʒm
    NNsh_InformMessage(ALTID_INFO, MSG_MACROEXEC_DONE, "", 0);
    return;
}
#endif

#ifdef USE_MACRO
/*=========================================================================*/
/*   Function : setSourceDataDisplay                                       */
/*                                        \[Xf[^eobt@ɏo */
/*=========================================================================*/
static UInt16 setSourceDataDisplay(Char *buffer, NNshMacroRecord *lineData)
{
    if ((lineData->src >= NNSH_MACROOP_GR_OFFSET)&&
         (lineData->src <= NNSH_MACROOP_GR_MAX))
    {
        StrCat (buffer, "gr");
        NUMCATI(buffer, lineData->src - NNSH_MACROOP_GR_OFFSET);
        StrCat (buffer, " ");
        return (NNSH_MACROOPCMD_DISABLE);
    }

    // Rl擾
    NUMCATI(buffer, lineData->MacroData.numData.operator);
    return (lineData->MacroData.numData.operator);
}
#endif

#ifdef USE_MACRO
/*=========================================================================*/
/*   Function : setExecFuncDataDisplay                                     */
/*                                                        @\֐̎擾 */
/*=========================================================================*/
static void setExecFuncDataDisplay(Char *buffer, UInt16 command)
{
    Char        *ptr, **kw, buf[MAX_FUNCCHAR_BUF];
    MemHandle    memH;
    NNshWordList wordList;

    // obt@̃NA
    MemSet(buf, sizeof(buf), 0x00);
    MemSet(&wordList, sizeof(wordList), 0x00);
    
    // ꗗ@\Xg̎擾iXgO\[X擾j
    memH = DmGetResource('tSTR', MULTIBTN_FEATUREMSG_STRINGS);
    if (memH == 0)
    {
        return;
    }
    ptr = MemHandleLock(memH);
    if (ptr == NULL)
    {
        return;
    }

    // L[[h؂oāAꎞobt@ɃRs[
    SeparateWordList(ptr, &wordList);
    kw = MemHandleLock(wordList.wordmemH);
    StrNCopy(buf, kw[command], MAX_FUNCCHAR_BUF - 1);
    MemHandleUnlock(wordList.wordmemH);
    ReleaseWordList(&wordList);
    
    // Rs[
    StrCat(buffer, buf);

    MemHandleUnlock(memH);
    DmReleaseResource(memH);
    return;
}
#endif

#ifdef USE_MACRO
/*=========================================================================*/
/*   Function : NNsi_MacroDataView                                         */
/*                                                        }Ne\ */
/*=========================================================================*/
void NNsi_MacroDataView(Char *macroDBName, UInt16 macroDBVersion)
{
    Err              ret;
    Char           **script, logData[TINYBUF];
    UInt16           macroCnt, lp, command;
    MemHandle        dataH;
    NNshMacroRecord *lineData;
    DmOpenRef        dbRefR;

    // f[^̏
    script   = NULL;
    macroCnt = 0;

    // G[\p
    MemSet (logData, sizeof(logData), 0x00);
    StrCopy(logData, "MEMERR");

    // f[^x[XJ(XNvgt@C)
    OpenDatabase_NNsh(macroDBName, macroDBVersion, &dbRefR);
    if (dbRefR == 0)
    {
        // G[AI
        return;
    }

    // XNvg̃R[hmF
    GetDBCount_NNsh(dbRefR, &macroCnt);

    script = MEMALLOC_PTR(sizeof(Char *) * macroCnt + MARGIN);
    if (script == NULL)
    {
        // mۃG[AI
        CloseDatabase_NNsh(dbRefR);
        return;
    }
    MemSet(script, (sizeof(Char *) * macroCnt + MARGIN), 0x00);

    // Of[^o    
    for (lp = 0; lp < macroCnt; lp++)
    {
        // R[hǂݏo
        ret = GetRecordReadOnly_NNsh(dbRefR, lp, &dataH, (void **) &lineData);
        if (ret != errNone)
        {
            // R[hǂݏosÃR[hֈړ
            dataH = 0;
            script[lp] = logData;
            goto NEXT_COMMAND;
        }
        script[lp] = MEMALLOC_PTR(MAX_LOGVIEW_BUFFER + MARGIN);
        if (script[lp] == NULL)
        {
            // ̈mۃG[
            script[lp] = logData;
            goto NEXT_COMMAND;
        }
        MemSet(script[lp], (MAX_LOGVIEW_BUFFER + MARGIN), 0x00);

        // sԍ\
        NUMCATI(script[lp], (lp + 1));
        StrCat (script[lp], "  ");

        switch (lineData->opCode)
        {
          case NNSH_MACROCMD_XOR:
            // lZ
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " XOR ");
            setSourceDataDisplay(script[lp], lineData);
            StrCat (script[lp], " ");
            break;

          case NNSH_MACROCMD_AND:
            // lZ
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " AND ");
            setSourceDataDisplay(script[lp], lineData);
            StrCat (script[lp], " ");
            break;

          case NNSH_MACROCMD_OR:
            // lZ
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " OR ");
            setSourceDataDisplay(script[lp], lineData);
            StrCat (script[lp], " ");
            break;

          case NNSH_MACROCMD_ADD:
            // lZ
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " + ");
            setSourceDataDisplay(script[lp], lineData);
            StrCat (script[lp], " ");
            break;

          case NNSH_MACROCMD_CMP:
          case NNSH_MACROCMD_SUB:
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " - ");
            setSourceDataDisplay(script[lp], lineData);
            StrCat (script[lp], " ");
            break;

          case NNSH_MACROCMD_JNZ:
            StrCat (script[lp], "IF gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], "<> 0 THEN GOTO ");
            setSourceDataDisplay(script[lp], lineData);
            StrCat (script[lp], "  ");
            break;

          case NNSH_MACROCMD_JZ:
            StrCat (script[lp], "IF gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " = 0 THEN GOTO ");
            setSourceDataDisplay(script[lp], lineData);
            StrCat (script[lp], " ");
            break;

          case NNSH_MACROCMD_MOVE:
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := ");
            setSourceDataDisplay(script[lp], lineData);
            StrCat (script[lp], " ");
            break;

          case NNSH_MACROCMD_JMP:
            StrCat (script[lp], "GOTO ");
            setSourceDataDisplay(script[lp], lineData);
            StrCat (script[lp], "  ");
            break;

          case NNSH_MACROCMD_EXECUTE:
            // @\̎s
            StrCat (script[lp], "CALL (");
            command = setSourceDataDisplay(script[lp], lineData);
            if (command != NNSH_MACROOPCMD_DISABLE)
            {
                StrCat (script[lp], ":");
                setExecFuncDataDisplay(script[lp], command);
                StrCat (script[lp], " ");
            }
            StrCat (script[lp], ") ");
            break;

          case NNSH_MACROCMD_MESSAGE:
            // Oo
            StrCat (script[lp], "PRINT ");
            if ((lineData->src >= NNSH_MACROOP_GR_OFFSET)&&
                (lineData->src <= NNSH_MACROOP_GR_MAX))
            {
                // GRx \
                StrCat (script[lp], "(gr");
                NUMCATI(script[lp], lineData->src - NNSH_MACROOP_GR_OFFSET);
                StrCat (script[lp], ") ");
            }
            else
            {
                // \
                StrCat (script[lp], "\"");
                StrCat (script[lp], lineData->MacroData.strData.data);
                StrCat (script[lp], "\" ");
            }
            break;

          case NNSH_MACROCMD_BEEP:
            // r[v炷
            StrCat (script[lp], "BEEP ");
            setSourceDataDisplay(script[lp], lineData);
            StrCat (script[lp], "  ");
            break;

          case NNSH_MACROCMD_MACROEND:
            // }NI
            StrCat (script[lp], "END ");
            break;

          case NNSH_MACROCMD_SETTABNUM:
            // ^ui[
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := ");
            StrCat (script[lp], "(tabNum) ");
            break;

          case NNSH_MACROCMD_STRSTR:
            // w肵񂪃X^CgɊ܂܂邩
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := strstr(title, \"");
            StrCat (script[lp], lineData->MacroData.strData.data);
            StrCat (script[lp], "\") ");
            break;            

          case NNSH_MACROCMD_STRCMP:
            // w肵񂪃X^CgɊ܂܂邩
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := strstr(title, \"");
            StrCat (script[lp], lineData->MacroData.strData.data);
            StrCat (script[lp], "\") ");
            break;            

          case NNSH_MACROCMD_OPERATE:
            // NNsiݒl̎擾
            switch (lineData->MacroData.numData.subCommand)
            {
              case NNSH_MACROOPCMD_AUTOSTARTMACRO:
                // }Ns̒l擾
                StrCat(script[lp], "(autoMacro) := ");
                break;

              case NNSH_MACROOPCMD_NEWARRIVAL_LINE:
                // VmFsɉؒf
                StrCat(script[lp], "(chkLINE) := ");
                break;

              case NNSH_MACROOPCMD_NEWARRIVAL_DA:
                // VmFsDAN
                StrCat(script[lp], "(chkDA) := ");
                break;

              case NNSH_MACROOPCMD_NEWARRIVAL_ROLOG:
                // QƃO擾x
                StrCat(script[lp], "(ROlogLvl) := ");
                break;

              case NNSH_MACROOPCMD_NEWARRIVAL_BEEP:
                // VmFIɃr[v
                StrCat(script[lp], "(chkBEEP) := ");
                break;

              case NNSH_MACROOPCMD_COPY_AND_DELETE:
                // QƃORs[ɍ폜{
                StrCat(script[lp], "(cp&rm) := ");
                break;

              default:
                StrCat(script[lp], "nop ");
                break;
            }
            setSourceDataDisplay(script[lp], lineData);
            StrCat(script[lp], ", save ");
            /** not break; **/

          case NNSH_MACROCMD_STATUS:
            // NNsiݒl̎擾
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := ");
            switch (lineData->MacroData.numData.subCommand)
            {
              case NNSH_MACROOPCMD_AUTOSTARTMACRO:
                // }Ns̒l擾
                StrCat(script[lp], "(autoMacro)");
                break;

              case NNSH_MACROOPCMD_NEWARRIVAL_LINE:
                // VmFsɉؒf
                StrCat(script[lp], "(chkLINE)");
                break;

              case NNSH_MACROOPCMD_NEWARRIVAL_DA:
                // VmFsDAN
                StrCat(script[lp], "(chkDA)");
                break;

              case NNSH_MACROOPCMD_NEWARRIVAL_ROLOG:
                // QƃO擾x
                StrCat(script[lp], "(ROlogLvl)");
                break;

              case NNSH_MACROOPCMD_NEWARRIVAL_BEEP:
                // VmFIɃr[v
                StrCat(script[lp], "(chkBEEP)");
                break;

              case NNSH_MACROOPCMD_COPY_AND_DELETE:
                // QƃORs[ɍ폜{
                StrCat(script[lp], "(cp&rm)");
                break;

              default:
                StrCat(script[lp], "0");
                break;
            }
            break;

          case NNSH_MACROCMD_GETMESNUM:
            // X𔽉f
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := mesNum(title) ");
            break;            

          case NNSH_MACROCMD_MESSTATUS:
            // XԂ𔽉f
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := mesStatus(title) ");
            break;

          case NNSH_MACROCMD_BBSTYPE:
            // XBBS^Cv𔽉f
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := bbsType(title) ");
            break;

          case NNSH_MACROCMD_IMPORT:
            // NNsiݒC|[g
#ifdef USE_XML_OUTPUT
            StrCat (script[lp], "IMPORT '");
            StrCat (script[lp], FILE_XML_NNSISET);
            if (setSourceDataDisplay(script[lp], lineData) == 0)
            {
                StrCat (script[lp], "' from VFS");
            }
            else
            {
                StrCat (script[lp], "' from Palm");
            }
#else
            StrCat (script[lp], "NOP ");
#endif
            break;

          case NNSH_MACROCMD_EXPORT:
            // NNsiݒGNX|[g
#ifdef USE_XML_OUTPUT
            StrCat (script[lp], "EXPORT '");
            StrCat (script[lp], FILE_XML_NNSISET);
            StrCat (script[lp], "' ");
#else
            StrCat (script[lp], "NOP ");
#endif
            break;

          case NNSH_MACROCMD_LAUNCHDA:
            // DAN
            StrCat (script[lp], "LAUNCH '");
            logData[0] = ((0xff00 & lineData->MacroData.numData.data1) >> 8); 
            logData[1] = ((0x00ff & lineData->MacroData.numData.data1));
            logData[2] = ((0xff00 & lineData->MacroData.numData.data2) >> 8);
            logData[3] = ((0x00ff & lineData->MacroData.numData.data2));
            logData[4] = '\0';
            StrCat (script[lp], logData);            
            StrCat (script[lp], "' as DA");
            break;

          case NNSH_MACROCMD_CLIPCOPY:
            // Nbv{[hɃRs[
            StrCat (script[lp], "COPY(clip, \"");
            StrCat (script[lp], lineData->MacroData.strData.data);
            StrCat (script[lp], "\") ");
            break;

          case NNSH_MACROCMD_CLIPADD:
             // Nbv{[hɒǉ
            StrCat (script[lp], "APPEND(clip, \"");
            StrCat (script[lp], lineData->MacroData.strData.data);
            StrCat (script[lp], "\") ");
            break;

          case NNSH_MACROCMD_CLIPINSTR:
            // Nbv{[h̕Ɋ܂܂邩mF
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := strstr(clip, \"");
            StrCat (script[lp], lineData->MacroData.strData.data);
            StrCat (script[lp], "\") ");
            break;

          case NNSH_MACROCMD_TITLECLIP:
            // X^CgNbv{[hɃRs[
            StrCat(script[lp], "COPY(clip, title)");
            break;

          case NNSH_MACROCMD_SET_FINDBBSSTR:
            // Nbv{[h̓eaarpɐݒ
            StrCat(script[lp], "COPY(findBBS, clip)");
            break;

          case NNSH_MACROCMD_SET_FINDTHREADSTR:
            // Nbv{[h̓eXpɐݒ
            StrCat(script[lp], "COPY(findTHREAD, clip)");
            break;

          case NNSH_MACROCMD_UPDATE_RESNUM:
            // XXVĊi[
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := updateMesNum(title) ");
            break;

          case NNSH_MACROCMD_JPL:
            // ̒lȂWv
            StrCat (script[lp], "IF gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], "> 0 THEN GOTO ");
            setSourceDataDisplay(script[lp], lineData);
            StrCat (script[lp], "  ");
            break;

          case NNSH_MACROCMD_JMI:
            // ̒lȂWv
            StrCat (script[lp], "IF gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], "< 0 THEN GOTO ");
            setSourceDataDisplay(script[lp], lineData);
            StrCat (script[lp], "  ");
            break;

          case NNSH_MACROCMD_OUTPUTTITLE:
            // X^CgOo
            StrCat (script[lp], "PRINT title");
            break;

          case NNSH_MACROCMD_OUTPUTCLIP:
            // Nbv{[h̓eOo
            StrCat (script[lp], "PRINT clip");
            break;

          case NNSH_MACROCMD_REMARK:
            // (\邾)
            StrCat (script[lp], "' ");
            StrCat (script[lp], lineData->MacroData.strData.data);
            break;

          case NNSH_MACROCMD_PUSH:
            // X^bNPUSH
            StrCat (script[lp], "PUSH");
            setSourceDataDisplay(script[lp], lineData);
            break;

          case NNSH_MACROCMD_POP:
            // X^bNPOP
            StrCat (script[lp], "POP ");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            break;

          case NNSH_MACROCMD_GETRECNUM:
            // R[hԍi[
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := RecordIndex(title)");
            break;

          case NNSH_MACROCMD_FINDTHREADSTRCOPY:
            // XNbv{[hɃRs[
            StrCat (script[lp], "COPY(clip, findTHREAD)");
            break;
          case NNSH_MACROCMD_INPUTDIALOG:
            // ͂ (1.05)
            StrCat (script[lp], "clip := INPUT \"");
            StrCat (script[lp], lineData->MacroData.strData.data);
            break;

          case NNSH_MACROCMD_OUTPUTDIALOG:
            // o͂ (1.05)
            StrCat (script[lp], "OUTPUT \"");
            StrCat (script[lp], lineData->MacroData.strData.data);
            StrCat (script[lp], "\"");
            break;

          case NNSH_MACROCMD_CONFIRMDIALOG:
            // Nbv{[h̕\mF (1.05)
            StrCat (script[lp], "gr");
            NUMCATI(script[lp], lineData->dst - NNSH_MACROOP_GR_OFFSET);
            StrCat (script[lp], " := CONFIRM (clip)");
            break;

          default:
            // R}hR[hُAȂɂsȂ
            StrCat (script[lp], "  ");
            break;
        }

NEXT_COMMAND:
        // R[hAւ
        ReleaseRecordReadOnly_NNsh(dbRefR, dataH);
    }
    CloseDatabase_NNsh(dbRefR);

    // }Nf[^̕\
    DataViewForm(NNSH_MACROCMD_VIEWTITLE, macroCnt, script);

    // mۂ̈J
    for (lp = 0; lp < macroCnt; lp++)
    {
        if ((script[lp] != NULL)&&(script[lp] != logData))
        {
            MEMFREE_PTR(script[lp]);
        }
    }
    MEMFREE_PTR(script);
    return;
}
#endif
        
#ifdef USE_MACRO
/*=========================================================================*/
/*   Function : NNsi_MacroExecLogView                                      */
/*                                                          }Ns */
/*=========================================================================*/
void NNsi_MacroExecLogView(Char *macroDBName, UInt16 macroDBVersion)
{
    Err              ret;
    Char           **script, logData[TINYBUF];
    UInt16           macroCnt, lp;
    MemHandle        dataH;
    NNshMacroResult *lineData;
    DmOpenRef        dbRefR;
    DateTimeType     dateTime;

    // f[^̏
    script   = NULL;
    macroCnt = 0;

    // G[\p
    MemSet (logData, sizeof(logData), 0x00);
    StrCopy(logData, "MEMERR");

    // f[^x[XJ(XNvgt@C)
    OpenDatabase_NNsh(macroDBName, macroDBVersion, &dbRefR);
    if (dbRefR == 0)
    {
        // G[AI
        return;
    }

    // XNvg̃R[hmF
    GetDBCount_NNsh(dbRefR, &macroCnt);

    script = MEMALLOC_PTR(sizeof(Char *) * macroCnt + MARGIN);
    if (script == NULL)
    {
        // mۃG[AI
        CloseDatabase_NNsh(dbRefR);
        return;
    }
    MemSet(script, (sizeof(Char *) * macroCnt + MARGIN), 0x00);

    // Of[^o    
    for (lp = 0; lp < macroCnt; lp++)
    {
        // R[h()ǂݏo R[h̎ႢԍŐṼf[^Ȃ
        ret = GetRecordReadOnly_NNsh(dbRefR, (macroCnt - (1 + lp)), &dataH, (void **) &lineData);
        if (ret != errNone)
        {
            // R[hǂݏosÃR[hֈړ
            dataH = 0;
            script[lp] = logData;
            goto NEXT_COMMAND;
        }
        script[lp] = MEMALLOC_PTR(MAX_LOGOUTPUT_BUFFER + MARGIN);
        if (script[lp] == NULL)
        {
            // ̈mۃG[
            script[lp] = logData;
            goto NEXT_COMMAND;
        }
        MemSet(script[lp], (MAX_LOGOUTPUT_BUFFER + MARGIN), 0x00);

        // \
        MemSet(&dateTime, sizeof(dateTime), 0x00);
        TimSecondsToDateTime(lineData->dateTime, &dateTime);
        DateToAscii(dateTime.month, dateTime.day, dateTime.year,
                    dfYMDWithDashes, script[lp]);
        StrCat(script[lp], " ");
        TimeToAscii(dateTime.hour, dateTime.minute, tfColon24h, 
                    &script[lp][StrLen(script[lp])]);
        StrCat(script[lp], ":");
        NUMCATI(script[lp], dateTime.second);      

        // OxƃG[R[h\(G[R[h̓G[̂)
        StrCat (script[lp], "[");
        NUMCATI(script[lp], lineData->logLevel);
        if (lineData->errCode != 0)
        {
            StrCat (script[lp], ":0x");
            NUMCATH(script[lp], lineData->errCode);
        }
        StrCat (script[lp], "] ");

        // Of[^\
        StrCat (script[lp], lineData->logData);

NEXT_COMMAND:
        // R[hAւ
        ReleaseRecordReadOnly_NNsh(dbRefR, dataH);
    }
    CloseDatabase_NNsh(dbRefR);

    // \_CAOJ
    DataViewForm(NNSH_MACROLOG_VIEWTITLE, macroCnt, script);

    // mۂ̈J
    for (lp = 0; lp < macroCnt; lp++)
    {
        if ((script[lp] != NULL)&&(script[lp] != logData))
        {
            MEMFREE_PTR(script[lp]);
        }
    }
    MEMFREE_PTR(script);
    return;
}        
#endif
