#ifndef SCREENCONTROL_H
#define SCREENCONTROL_H

#include <QWidget>
#include "a2BcConstants.h"
#include "ui_a2BC.h"
#include "screenData.h"
#include "a2BCmodel.h"
#include "a2BChttpConnection.h"
#include "a2BCindexParser.h"

class a2BCthread;
class screenControl : public QWidget
{
    Q_OBJECT

public:
    screenControl(Ui::a2BCMain *apForm, QWidget *parent = 0);
    virtual ~screenControl();

public:
	void completedGetFile (bool error, QString &arFileName);

public slots:
	void selection_bbsTableFile();
	void select_updateBbsTableFile();
	void executeUpdate();
	void cancelUpdate();

	void changed_bbsTableFile();
	void changed_bbsTableUrl();
	void changed_interval();

	void updateMessage(const QString &arMessage);
	void completedCommunication(int error, QString &arMessage);

    void startedUpdate();
    void completedUpdate();

signals:
    void nextCommunication();
    void completedCommunication(int);

private:
	void createClasses(void);
	void deleteClasses(void);
	void initializeDatas(void);
    void connectSignals(void);
	void updateFormData(void);

private:
    Ui::a2BCMain       *mpForm;
    screenData         *mpDB;
	a2BCmodel          *mpModel;
	a2BChttpConnection *mpHttpConn;
	QHttp              *mpHttpMain;
    a2BCthread         *mpTimer;
    a2BCindexParser    *mpIndexParser;
};

#endif
/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
