#ifndef A2BCINDEXPARSER_H
#define A2BCINDEXPARSER_H

#include <QWidget>
#include <QString>
#include <QTextStream>

class a2BCindexParser :  public QWidget
{
    Q_OBJECT

public:
    a2BCindexParser(QWidget *parent = 0);
    virtual ~a2BCindexParser();

public:
    virtual int parseIndexFile(const QString &arFileName);
    virtual void outputIndexFile(bool aRemoveError, bool outputSubjectTxt);


public slots:

signals:

public:
    virtual void   clearIndexFile();    

    QString          getIndexFileName(int index);
    QString          getFileName(int index);
    QString          getOptionData(int index);
    QString          getNickName(int index);

    int             getFileStatus(int index);
    int             getNofMessage(int index);
    int             getCurrentMessage(int index);
    quint64          getLastUpdate(int index);

    void            setFileStatus(int index, int status);
    void            setNofMessage(int index, int status);
    void            setCurrentMessage(int index, int status);
    void            setLastUpdate(int index);
    

private:
    virtual bool process_line(const QString &arFileName, QString &arLineData);

private:
    QVector<QString> mIndexFileName;
    QVector<QString> mDatFileName;
    QVector<QString> mReserve2;
    QVector<QString> mOptionData;
    
    QVector<int>    mDatFileStatus;
    QVector<int>    mNofMessage;
    QVector<int>    mCurrentMessage;
    QVector<quint64> mLastUpdate;
    
};

#endif // #ifndef #ifndef A2BCINDEXPARSER_H

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
