#include <QFile>
#include <QTextStream>
#include <QTextCodec>
#include <QTextCodecPlugin>
#include <QMessageBox>
#include "a2BCbbsTableTrim.h"
#include "a2BcConstants.h"

/*!
 *  RXgN^
 * 
 */
a2BCbbsTableTrim::a2BCbbsTableTrim(QWidget *parent) : QWidget(parent)
{

}

/*!
 *  fXgN^
 * 
 */
a2BCbbsTableTrim::~a2BCbbsTableTrim()
{

}

/*!
 *  f[^̃Zbg
 * 
 */
void a2BCbbsTableTrim::reset()
{
    mBbsTableAppend.clear();
}

/*!
 *  H
 * 
 */
bool a2BCbbsTableTrim::prepare(QString &arFileName)
{
    mBbsTableFileName = "";
    if (QFile::exists(arFileName) != true)
    {
        // t@C݂ȂꍇAG[
        return (false);
    }

    mBbsTableFileName = arFileName;

    QFile bbsTableFile(arFileName);
    if (!bbsTableFile.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        return (false);
    }
    QFile bbsTableBakFile(arFileName + ".back");
    if (!bbsTableBakFile.open(QIODevice::WriteOnly | QIODevice::Text))
    {
        bbsTableFile.close();
        return (false);
    }
  
    QTextStream in(&bbsTableFile);
    QTextStream out(&bbsTableBakFile);
    while (!in.atEnd())
    {
        QString line = in.readLine();
        if (line.contains("<!--a2BC-->") != true)
        {
            // f[^o͂
            out << line << endl;
        }
    }
    bbsTableBakFile.close();
    bbsTableFile.close();

    return (true);
}

/*!
 *  bbstable.html̉H{
 * 
 */
bool a2BCbbsTableTrim::output(void)
{
    QFile bbsTableBakFile(mBbsTableFileName + ".back");
    if (!bbsTableBakFile.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        return (false);
    }

    QFile bbsTableFile(mBbsTableFileName);
    if (!bbsTableFile.open(QIODevice::WriteOnly | QIODevice::Text))
    {
        bbsTableBakFile.close();
        return (false);
    }
  
    QTextCodec  *codec = QTextCodec::codecForName("Shift_JIS");
    if (codec == 0)
    {
        codec = QTextCodec::codecForName("MS_Kanji");
    }
    if (codec == 0)
    {
        codec = QTextCodec::codecForName("sjis");
    }
    if (codec == 0)
    {
        codec = QTextCodec::codecForName("SJIS");
    }
    QTextStream out(&bbsTableFile);
    QTextStream in(&bbsTableBakFile);
    QString     data;
    if (codec != 0)
    {
        out.setCodec(codec);
    }
    else
    {
        out.setCodec(QTextCodec::codecForLocale());
//        out.setCodec("Shift_JIS");
    }
    out << "<!--a2BC-->" << endl;
    int count = 0;

    for (QVector<QByteArray>::ConstIterator it = mBbsTableAppend.begin(); it != mBbsTableAppend.end(); it++)
    {
        ///// ŃJeS (ya2B-xxz) o͂
        if ((count % 50) == 0)
        {
            QString num;
            num.setNum(count / 50);
            if (codec != 0)
            {
                data = codec->toUnicode("y<B>a2B");
                out << data;
            }
            else
            {
                out << "y<B>a2B";
            }

            if ((count / 50) != 0)
            {
                out << "-" << num;
            }
            
            if (codec != 0)
            {
                data = codec->toUnicode("</B>z");
                out << data << "<!--a2BC-->" << endl;
            }
            else
            {
                out << "</B>z<!--a2BC-->" << endl;
            }
        }

        // (URL)1o͂
        if (codec != 0)
        {
            QString string = codec->toUnicode(*it);
            out << "<A HREF=" << string << "</A>" << "<!--a2BC-->" << endl;
        }
        else
        {
            out << "<A HREF=" << (*it) << "</A>" << "<!--a2BC-->" << endl;;
        }
        count++;
    }

    if (codec != 0)
    {
        data = codec->toUnicode("y<B>-----</B>z");
        out << data << "<!--a2BC-->" << endl;
    }
    else
    {
        out << "y<B>-----</B>z<!--a2BC-->" << endl;
    }
    out << "<!--a2BC-->" << endl;

    ////////// ̃f[^̂܂܏o͂ //////////
    out.setCodec(QTextCodec::codecForLocale());
    while (!in.atEnd())
    {
        QString line = in.readLine();
        if (line.contains("<!--a2BC-->") != true)
        {
            // f[^o͂
            out << line << endl;
        }
    }
    bbsTableBakFile.close();
    bbsTableFile.close();
    
    QFile::remove(mBbsTableFileName + ".back");
    return (true);
}

/*!
 *  f[^̒ǉ
 * 
 */
void a2BCbbsTableTrim::append(QByteArray &arData)
{
    mBbsTableAppend.append(arData);
    return;
}

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
