/*
 *  $Id: logList.cs,v 1.5 2005/02/26 13:17:49 mrsa Exp $
 *    --- NNsi̎QƃOf[^x[Ẍꗗ\...
 *
 *
 */
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace NEET
{
	/// <summary>
	///   Oꗗ
	/// </summary>
	public class frmLogList : System.Windows.Forms.Form
	{
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.DataGrid listGrid;
		private System.Windows.Forms.Button btnEdit;
		private System.Windows.Forms.Button btnDelete;
		private System.Windows.Forms.Button btnSave;
		private System.Windows.Forms.Button btnNew;

		private int                 mMaxRecordNumber;   // DB̃R[h
		private getLogDbContainer	mLogDataContainer;	// OReiNX
		private bool                mEnabledLogData;    // Of[^L
		private DataSet				mGetLogDataSet = null;
		private DataTable           mDataTable = null;
		private frmNEETsetting		mFrmNeetSetting = null;

		public frmLogList(frmNEETsetting aFrmNeetSetting)
		{
			//
			// Windows tH[fUCiT|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent Ăяǒ̃RXgN^R[hǉ
			//
			mEnabledLogData = false;
			mFrmNeetSetting = aFrmNeetSetting;
		}

		/// <summary>
		/// gpĂ郊\[X̌㏈s܂B
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows tH[fUCiŐꂽR[h
		/// <summary>
		/// fUCiT|[gɕKvȃ\bhłB̃\bh̓e
		/// R[hGfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.listGrid = new System.Windows.Forms.DataGrid();
			this.btnEdit = new System.Windows.Forms.Button();
			this.btnDelete = new System.Windows.Forms.Button();
			this.btnSave = new System.Windows.Forms.Button();
			this.btnNew = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.listGrid)).BeginInit();
			this.SuspendLayout();
			// 
			// listGrid
			// 
			this.listGrid.AllowSorting = false;
			this.listGrid.CaptionText = "o^ςݎQƃOꗗ";
			this.listGrid.DataMember = "";
			this.listGrid.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.listGrid.Location = new System.Drawing.Point(8, 8);
			this.listGrid.Name = "listGrid";
			this.listGrid.ReadOnly = true;
			this.listGrid.RowHeadersVisible = false;
			this.listGrid.Size = new System.Drawing.Size(600, 320);
			this.listGrid.TabIndex = 0;
			// 
			// btnEdit
			// 
			this.btnEdit.Location = new System.Drawing.Point(8, 336);
			this.btnEdit.Name = "btnEdit";
			this.btnEdit.Size = new System.Drawing.Size(88, 23);
			this.btnEdit.TabIndex = 1;
			this.btnEdit.Text = "R[hҏW...";
			this.btnEdit.Click += new System.EventHandler(this.btnEdit_Click);
			// 
			// btnDelete
			// 
			this.btnDelete.Location = new System.Drawing.Point(216, 336);
			this.btnDelete.Name = "btnDelete";
			this.btnDelete.Size = new System.Drawing.Size(88, 23);
			this.btnDelete.TabIndex = 3;
			this.btnDelete.Text = "P폜";
			this.btnDelete.Click += new System.EventHandler(this.btnDelete_Click);
			// 
			// btnSave
			// 
			this.btnSave.Location = new System.Drawing.Point(512, 336);
			this.btnSave.Name = "btnSave";
			this.btnSave.Size = new System.Drawing.Size(96, 23);
			this.btnSave.TabIndex = 4;
			this.btnSave.Text = "t@Cۑ";
			this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
			// 
			// btnNew
			// 
			this.btnNew.Location = new System.Drawing.Point(104, 336);
			this.btnNew.Name = "btnNew";
			this.btnNew.Size = new System.Drawing.Size(88, 23);
			this.btnNew.TabIndex = 2;
			this.btnNew.Text = "VKR[h...";
			this.btnNew.Click += new System.EventHandler(this.btnNew_Click);
			// 
			// frmLogList
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(616, 365);
			this.Controls.Add(this.btnNew);
			this.Controls.Add(this.btnSave);
			this.Controls.Add(this.btnDelete);
			this.Controls.Add(this.btnEdit);
			this.Controls.Add(this.listGrid);
			this.Name = "frmLogList";
			this.Text = "NEET  -- a NNsi\'s Expanding and Editing Tool";
			((System.ComponentModel.ISupportInitialize)(this.listGrid)).EndInit();
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		///  OReiNXݒ肷 (ݒ...)
		/// </summary>
		public void setLogContainer(ref getLogDbContainer arLogDataContainer)
		{
			mLogDataContainer = arLogDataContainer;
			mEnabledLogData   = true;
			mMaxRecordNumber  = mLogDataContainer.numberOfGetLogRecords();
		}

		/// <summary>
		///   f[^Aʕ\
		/// </summary>
		public void prepareDataset()
		{
			if (mEnabledLogData != true)
			{
				// f[^[hĂȂ΁AI
				return;
			}

			// ꗗ\p̗̈揀
			mGetLogDataSet   = new DataSet("QƃOf[^ꗗ");
			mDataTable       = new DataTable();
			DataColumn[]  dc = new DataColumn[4];

			// f[^x
			mDataTable.TableName = "QƃOf[^ꗗ";
			mDataTable = mGetLogDataSet.Tables.Add("m_QƃO");
			dc[0] = mDataTable.Columns.Add("No", Type.GetType("System.String"));
			mDataTable.PrimaryKey = dc;
			mDataTable.Columns.Add("O", Type.GetType("System.String"));
			mDataTable.Columns.Add("URL", Type.GetType("System.String"));
			mDataTable.Columns.Add("Lv", Type.GetType("System.String"));

			// R[ho^
			for (int loop = 0; loop < mMaxRecordNumber; loop++)
			{
				logRecord data = mLogDataContainer.getRecordData(loop);
				string title = data.DataTitle;
				string url   = data.DataURL;
				mDataTable.Rows.Add(new object[]{(loop + 1), title, url, data.Usable});
			}

			// e[u̕\X^C(̕)w肷
			DataGridTableStyle  tblStyle;
			DataGridColumnStyle col1, col2, col3, col4;

			tblStyle = new DataGridTableStyle();
			tblStyle.MappingName = "m_QƃO";
			tblStyle.AllowSorting = false;

			col1 = new DataGridTextBoxColumn();
			col1.MappingName = "No";
			col1.HeaderText = "#";
			col1.Width = 20;
			tblStyle.GridColumnStyles.Add(col1);

			col2 = new DataGridTextBoxColumn();
			col2.MappingName = "O";
			col2.HeaderText = "O";
			col2.Width = 190;
			tblStyle.GridColumnStyles.Add(col2);

			col3 = new DataGridTextBoxColumn();
			col3.MappingName = "URL";
			col3.HeaderText = "擾URL";
			col3.Width = 335;
			tblStyle.GridColumnStyles.Add(col3);

			col4 = new DataGridTextBoxColumn();
			col4.MappingName = "Lv";
			col4.HeaderText = "Lv";
			col4.Width = 20;
			tblStyle.GridColumnStyles.Add(col4);

			listGrid.TableStyles.Add(tblStyle);
			listGrid.RowHeaderWidth = 15;
			listGrid.AllowSorting = false;
			listGrid.SetDataBinding(mGetLogDataSet, "m_QƃO");
		}


		/// <summary>
		///   R[h̕ҏW
		/// </summary>
		private void btnEdit_Click(object sender, System.EventArgs e)
		{
			// ݑI𒆂̃R[hԍ擾
			int row = listGrid.CurrentRowIndex;

			if (mLogDataContainer.numberOfGetLogRecords() == 0)
			{
				return;
			}

			// R[hȂΕҏW͂Ȃ
			if (row < 0)
			{
				return;
			}

			// ҏW_CAO𐶐J
			editRecord(row);

			return;
		}

		/// <summary>
		///   VKR[h̒ǉ
		/// </summary>
		private void btnNew_Click(object sender, System.EventArgs e)
		{
			// VR[hIuWFNg擾
			logRecord data   = mLogDataContainer.newRecordData();
			mMaxRecordNumber = mLogDataContainer.numberOfGetLogRecords();

			string title = data.DataTitle;
			string url   = data.DataURL;
			mDataTable.Rows.Add(new object[]{mMaxRecordNumber, title, url, data.Usable});

			// ǉR[hҏW...
			editRecord((mMaxRecordNumber - 1));
		}

		/// <summary>
		///   f[^t@Co
		/// </summary>
		private void btnSave_Click(object sender, System.EventArgs e)
		{
			// o̓f[^x[Xt@Cݒ肷
			mLogDataContainer.selectLogDatabaseFileNameToSave();

			// f[^o͂̊mF
			if (MessageBox.Show("QƃODBt@Co͂܂B",
								"t@Co͂̊mF",
								MessageBoxButtons.OKCancel,
								MessageBoxIcon.Question) == DialogResult.Cancel)
			{
				// ȂɂI
				return;
			}

			// {^Ȃ悤ɂ
			btnSave.Enabled = false;

			// f[^x[Xt@C֏o͂...
			if (mLogDataContainer.saveGetLogDatabase() == false)
			{
				MessageBox.Show("QƃODB̏o͂Ɏs܂...B",
								"G[",
								MessageBoxButtons.OK,
								MessageBoxIcon.Error);
			}
			else
			{
				// o͕
				MessageBox.Show("QƃODBo͂܂B", "DBo͊",
								MessageBoxButtons.OK,
								MessageBoxIcon.Information);
			}

			// ۑ{^悤ɂ
			btnSave.Enabled = true;
			return;
		}

		/// <summary>
		///   R[hҏW_CAO𐶐
		/// </summary>
		private void editRecord(int aRow)
		{
			// ҏW_CAO𐶐
			WinForm editDialog = new WinForm(this, ref mLogDataContainer);

			// ҏW_CAOɂ{^Lɂ
			editDialog.activateEditFormButtons();

			// ca̐擪R[hҏW_CAOɕ\ݒɂ
			editDialog.updateScreenData(aRow);

			// ҏW_CAOJ
			//  (ҏW̓{^𖳌ɂ)
			controlButtons(false);
			editDialog.ShowDialog();
			controlButtons(true);

			return;
		}


		/// <summary>
		///   f[^e[u(\)eXV
		/// </summary>
		public void refreshDataTable()
		{
			// I𒆂̃R[hL
			int row = listGrid.CurrentRowIndex;

			mMaxRecordNumber = mLogDataContainer.numberOfGetLogRecords();

			// f[^e[ũR[hSčXV
			mDataTable.Rows.Clear();
			for (int loop = 0; loop < mMaxRecordNumber; loop++)
			{
				logRecord data = mLogDataContainer.getRecordData(loop);
				string title = data.DataTitle;
				string url   = data.DataURL;
				mDataTable.Rows.Add(new object[]{(loop + 1), title, url, data.Usable});
			}

			// I𒆃R[h߂
			if (row >= mMaxRecordNumber)
			{
				row = (mMaxRecordNumber - 1);
			}
			if (row < 0)
			{
				row = 0;
			}
			listGrid.CurrentRowIndex = row;
			return;
		}

		/// <summary>
		///   R[hP폜
		/// </summary>
		private void btnDelete_Click(object sender, System.EventArgs e)
		{
			if (MessageBox.Show("I𒆂̃R[h폜܂B",
								"R[h폜̊mF",
								MessageBoxButtons.OKCancel,
								MessageBoxIcon.Question) == DialogResult.Cancel)
			{
				// ȂɂI
				return;
			}
			// I𒆂̃R[h폜
			int row = listGrid.CurrentRowIndex;
			mLogDataContainer.removeRecord(row);

			// f[^e[uXV
			refreshDataTable();
			return;
		}


		/// <summary>
		///   {^̐s
		/// </summary>
		private void controlButtons(bool aData)
		{
			btnDelete.Enabled = aData;
			btnNew.Enabled    = aData;
			btnEdit.Enabled   = aData;
			btnSave.Enabled   = aData;

			return;
		}
	}
}
