/*
 *  $Id$
 *    --- NNsiBBSf[^ݒ (PR[h)
 *
 *
 */
using System;

namespace NEET
{
	/// <summary>
	///   BBSf[^ ̊Tv
	///     NNsiBBS-NNsi.pdb ̓eiPR[hjLNX
	/// </summary>
	public class bbsRecord : IComparable
	{
		private string mBoardNick;
		private string mBoardURL;
		private string mBoardName;
		private uint   mBbsType;
		private uint   mState;
		private int    mReserved;

		const int    NNSH_BBSSTATE_VISIBLE   = 0x01;
		const int    NNSH_BBSSTATE_INVISIBLE = 0x00;

		const int    NNSH_BBSSTATE_LEVELMASK = 0x0e;
		const int    NNSH_BBSSTATE_NOTFAVOR  = 0xf1;
		const int    NNSH_BBSSTATE_FAVOR_L1  = 0x02;
		const int    NNSH_BBSSTATE_FAVOR_L2  = 0x04;
		const int    NNSH_BBSSTATE_FAVOR_L3  = 0x06;
		const int    NNSH_BBSSTATE_FAVOR_L4  = 0x08;
		const int    NNSH_BBSSTATE_FAVOR     = 0x0e;

		const int    NNSH_BBSSTATE_SUSPEND   = 0x10;

		const int    NNSH_BBSTYPE_2ch                = 0x00; // 2˂
		const int    NNSH_BBSTYPE_MACHIBBS           = 0x01; // ܂BBS
		const int    NNSH_BBSTYPE_SHITARABA          = 0x02; // BBS
		const int    NNSH_BBSTYPE_SHITARABAJBBS_OLD  = 0x03; // ( JBBS)
		const int    NNSH_BBSTYPE_OTHERBBS           = 0x04; // 2ch݊BBS
		const int    NNSH_BBSTYPE_PLUGINSUPPORT      = 0x05; // 2ch`ϊBBS
		const int    NNSH_BBSTYPE_HTML               = 0x06; // html`f[^
		const int    NNSH_BBSTYPE_SHITARABAJBBS_RAW  = 0x07; // @JBBS
		const int    NNSH_BBSTYPE_PLAINTEXT          = 0x08; // eLXg`
		const int    NNSH_BBSTYPE_2ch_EUC            = 0x09; // 2ch(EUC`)
		const int    NNSH_BBSTYPE_OTHERBBS_2         = 0x0a; // 2ch݊(2)

		// <summary>
		//   jbNl[
		// </summary>
		public string boardNick
		{
			get
			{
				return (mBoardNick);
			}

			set
			{
				mBoardNick = value;
			}
		}

		// <summary>
		//   URL
		// </summary>
		public string boardURL
		{
			get
			{
				return (mBoardURL);
			}

			set
			{
				mBoardURL = value;
			}
		}

		// <summary>
		//   
		// </summary>
		public string boardName
		{
			get
			{
				return (mBoardName);
			}

			set
			{
				mBoardName = value;
			}
		}


		// <summary>
		//   BBS^Cv
		// </summary>
		public uint bbsType
		{
			get
			{
				return (mBbsType);
			}

			set
			{
				mBbsType = value;
			}
		}

		// <summary>
		//   BBS
		// </summary>
		public uint bbsState
		{
			get
			{
				return (mState);
			}

			set
			{
				mState = value;
			}
		}

		// <summary>
		//   \̈
		// </summary>
		public int reserved
		{
			get
			{
				return (mReserved);
			}

			set
			{
				mReserved = value;
			}
		}

		// Cɓ背xi\j
		public string favoriteLevel
		{
			get
			{
				switch ((mState)&(NNSH_BBSSTATE_LEVELMASK))
				{
				  case NNSH_BBSSTATE_FAVOR:
					return ("H");
					break;
				  case NNSH_BBSSTATE_FAVOR_L1:
					return ("L");
					break;
				  case NNSH_BBSSTATE_FAVOR_L2:
					return ("1");
					break;
				  case NNSH_BBSSTATE_FAVOR_L3:
					return ("2");
					break;
				  case NNSH_BBSSTATE_FAVOR_L4:
					return ("3");
					break;

				  default:
					break;
				}
				return ("-");
			}

		}

		// Cɓ背xil\j
		public int favoriteLevelNumber
		{
			get
			{
				switch ((mState)&(NNSH_BBSSTATE_LEVELMASK))
				{
				  case NNSH_BBSSTATE_FAVOR_L1:
					return (1);
					break;

				  case NNSH_BBSSTATE_FAVOR_L2:
					return (2);
					break;

				  case NNSH_BBSSTATE_FAVOR_L3:
					return (3);
					break;

				  case NNSH_BBSSTATE_FAVOR_L4:
					return (4);
					break;

				  case NNSH_BBSSTATE_FAVOR:
					return (5);
					break;

				  default:
					break;
				}
				return (0);
			}

			set
			{
				// XCɓ背xNA
				switch ((mState)&(NNSH_BBSSTATE_LEVELMASK))
				{
				  case NNSH_BBSSTATE_FAVOR:
					mState = mState - NNSH_BBSSTATE_FAVOR;
					break;

				  case NNSH_BBSSTATE_FAVOR_L1:
					mState = mState - NNSH_BBSSTATE_FAVOR_L1;
					break;

				  case NNSH_BBSSTATE_FAVOR_L2:
					mState = mState - NNSH_BBSSTATE_FAVOR_L2;
					break;

				  case NNSH_BBSSTATE_FAVOR_L3:
					mState = mState - NNSH_BBSSTATE_FAVOR_L3;
					break;

				  case NNSH_BBSSTATE_FAVOR_L4:
					mState = mState - NNSH_BBSSTATE_FAVOR_L4;
					break;

				  default:
					break;
				}

				// ݒ肳ꂽXCɓ背x𔽉f
				switch (value)
				{
				  case 1:
					mState = mState + NNSH_BBSSTATE_FAVOR_L1;
					break;

				  case 2:
					mState = mState + NNSH_BBSSTATE_FAVOR_L2;
					break;

				  case 3:
					mState = mState + NNSH_BBSSTATE_FAVOR_L3;
					break;

				  case 4:
					mState = mState + NNSH_BBSSTATE_FAVOR_L4;
					break;

				  case 5:
					mState = mState + NNSH_BBSSTATE_FAVOR;
					break;

				  default:
					// Ȃ...
					break;
				}

			}

		}

		// 擾~[h
		public bool suspendMode
		{
			get
			{
				if (((mState)&(NNSH_BBSSTATE_SUSPEND)) == (NNSH_BBSSTATE_SUSPEND))
				{
					return (true);
				}
				return (false);
			}

			set
			{
				if (((mState)&(NNSH_BBSSTATE_SUSPEND)) == (NNSH_BBSSTATE_SUSPEND))
				{
					mState = mState - (NNSH_BBSSTATE_SUSPEND);
				}

				if (value == true)
				{
					mState = mState + (NNSH_BBSSTATE_SUSPEND);
				}
			}

		}

		// ꗗɕ\
		public bool useBoardList
		{
			get
			{
				if ((mState & (NNSH_BBSSTATE_VISIBLE)) == (NNSH_BBSSTATE_VISIBLE))
				{
					return (true);
				}
				return (false);
			}

			set
			{
				if (((mState)&(NNSH_BBSSTATE_VISIBLE)) == (NNSH_BBSSTATE_VISIBLE))
				{
					mState = mState - (NNSH_BBSSTATE_VISIBLE);
				}

				if (value == true)
				{
					mState = mState + (NNSH_BBSSTATE_VISIBLE);
				}
			}
		}

		/// <summary>
		///   RXgN^
		/// </summary>
		public bbsRecord()
		{
			//
			// TODO: RXgN^̃WbNɒǉ
			//
			mBoardNick = "zznewBoard/";
			mBoardURL  = "http://";
			mBoardName = "New Board";
		}

		// \[gp̔rf[^
		public int CompareTo(Object rhs)
		{
			bbsRecord r = (bbsRecord) rhs;
			return (this.boardNick.CompareTo(r.boardNick));
		}
	}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//    f[^x[X̒`  (NNsi)
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//
//#define MAX_URL                     80
//#define MAX_BOARDNAME               40
//#define MAX_NICKNAME                16
//
//// (f[^x[X̍\)
//typedef struct {
//	Char   boardNick[MAX_NICKNAME];    // {[hjbNl[
//	Char   boardURL [MAX_URL];         // {[hURL
//	Char   boardName[MAX_BOARDNAME];   // {[h
//	UInt8  bbsType;                    // {[hTYPE
//	UInt8  state;                      // {[hgp
//	Int16  reserved;                   // (\̈FȑO͎gpĂ)
//} NNshBoardDatabase;
//
//
//#define NNSH_BBSSTATE_VISIBLE       0x01         // \
//#define NNSH_BBSSTATE_INVISIBLE     0x00         // \
//
//#define NNSH_BBSSTATE_LEVELMASK     0x0e         // Xxo}XN
//#define NNSH_BBSSTATE_NOTFAVOR      0xf1         // XxNA
//#define NNSH_BBSSTATE_FAVOR_L1      0x02         // XxL1
//#define NNSH_BBSSTATE_FAVOR_L2      0x04         // XxL2
//#define NNSH_BBSSTATE_FAVOR_L3      0x06         // XxL3
//#define NNSH_BBSSTATE_FAVOR_L4      0x08         // XxL4
//#define NNSH_BBSSTATE_FAVOR         0x0e         // XxHIGH
//
//#define NNSH_BBSSTATE_SUSPEND       0x10   // u擾~vBBSł
//#define NNSH_BBSSTATE_NOTSUSPEND    0xef   // u擾~vBBSł͂Ȃ(MASKl)
//
///** BBS-DB̃{[h^Cv **/
//#define NNSH_BBSTYPE_2ch                 0x00    // 2ch(ʏ탂[h)
//#define NNSH_BBSTYPE_MACHIBBS            0x01    // ܂BBS(ꃂ[h)
//#define NNSH_BBSTYPE_SHITARABA           0x02    // BBS
//#define NNSH_BBSTYPE_SHITARABAJBBS_OLD   0x03    // @JBBS
//#define NNSH_BBSTYPE_OTHERBBS            0x04    // 2ch݊BBS
//#define NNSH_BBSTYPE_PLUGINSUPPORT       0x05    // 2ch`ϊBBS
//#define NNSH_BBSTYPE_HTML                0x06    // html`f[^
//#define NNSH_BBSTYPE_SHITARABAJBBS_RAW   0x07    // @JBBS(RAWMODE)
//#define NNSH_BBSTYPE_PLAINTEXT           0x08    // ʏ̃eLXg`
//#define NNSH_BBSTYPE_2ch_EUC             0x09    // 2ch(EUC`)
//#define NNSH_BBSTYPE_OTHERBBS_2          0x0a    // 2ch݊`(2)
//#define NNSH_BBSTYPE_ERROR               0xff    // {[h^CvG[
//#define NNSH_BBSTYPE_MASK                0x1f    // {[h^CvMASK
//#define NNSH_BBSTYPE_CHARSETMASK         0xe0    // {[h̕R[h
//#define NNSH_BBSTYPE_CHAR_SJIS           0x00    // WR[h(SHIFT JIS)
//#define NNSH_BBSTYPE_CHAR_EUC            0x20    // EUCR[h
//#define NNSH_BBSTYPE_CHAR_JIS            0x40    // JISR[h(iso-2022-jp)
//#define NNSH_BBSTYPE_CHAR_SHIFT             5    // EVtg
//
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

}

