/*
 *  $Id$
  *    --- NNsiBBSf[^x[X̋L^ꏊ...
 *
 */
using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Diagnostics;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;
using System.Net;

namespace NEET
{
	/// <summary>
	///  ؂蕶DB̃Rei
	/// </summary>
	public class bbsDbContainer
	{
		// ut@CJv_CAO
		private System.Windows.Forms.OpenFileDialog fileSelectionDialog = null;

		// PalmOSDBt@C̃ANZT(par.exewrapperNX)
		private PalmDatabaseAccessor mDbAccessor		= null;

		// bbs cãR[hƈꎞt@C̕ϊ
		private bbsDbParser          mDbParser			= null;

		// bbs ca̓̓t@C
		private string			    mDbName				= null;

		// bbs cãIuWFNgǗpXg
		private ArrayList			mDbArrayList		= null;

		/// <summary>
		///   RXgN^
		/// </summary>
		public bbsDbContainer(string aDbName, ref PalmDatabaseAccessor aAccessor)
		{
			//  IuWFNg̏...
			mDbName			= aDbName;
			mDbAccessor		= aAccessor;
			mDbArrayList	= new ArrayList();
			mDbParser		= new bbsDbParser();
			fileSelectionDialog = new System.Windows.Forms.OpenFileDialog();
			fileSelectionDialog.AddExtension = true;

		}

		/// <summary>
		///    f[^ReiNX
		///    (DBt@Cf[^ǂݏoăIuWFNgɓWJ)
		/// </summary>
		public bool initializeDatas()
		{
			int nofRecords = 0;

			// cãwb_ǂŃR[h擾
			if (mDbAccessor.getRecordNumber(out nofRecords) == false)
			{
				// DB̓ǂݍݎsBBB(I)
				MessageBox.Show("DBt@C ܂ par.exȅꏊ" +
								"w肳ĂȂ悤łB\n" +
								"(t@Cݒ̌肢܂B)",
								"Access Failure",
								MessageBoxButtons.OK,
								MessageBoxIcon.Error);
				return (false);
			}

			// R[h̊mFsAR[hf[^ǂݍ
			if (nofRecords == 0)
			{
				// R[hȂǂݍ܂Ȃ...
				return (true);
			}

			// ꎞt@C̎w
			string tempFileName = mDbName + ".temp";

			// R[ĥ鐔ǂݍŃIuWFNgɕϊAo^
			for (int loop = 0; loop < nofRecords; loop++)
			{
				try
				{
					// par.exegp1R[ht@CɓWJ
					if (mDbAccessor.pickUpRecord(loop, tempFileName) != false)
					{
						// f[^L^pR[h𐶐
						bbsRecord entryRecord = new bbsRecord();

						// R[h͂
						mDbParser.inputRecordFromTemporaryFile(tempFileName, ref entryRecord);

						// R[hXgɓo^
						mDbArrayList.Add(entryRecord);
					}
				}
				catch
				{
					// ϊɎsĂȂ...
				}
			}

			try
			{
				// ꎞt@C폜
				File.Delete(tempFileName);
			}
			catch
			{
				// 폜s...łȂ...
			}
			return (true);
		}

		/// <summary>
		///   QƃOcãR[hԂ
		/// </summary>
		public int numberOfRecords()
		{
			return (mDbArrayList.Count);
		}

		/// <summary>
		///   R[h̏擾
		/// </summary>
		public bbsRecord getRecordData(int aIndexNumber)
		{
			if ((aIndexNumber < 0)&&
				(aIndexNumber >= mDbArrayList.Count))
			{
				return (null);
			}
			return ((bbsRecord) mDbArrayList[aIndexNumber]);
		}

		/// <summary>
		///    VKR[h̒ǉ
		/// </summary>
		public bbsRecord newRecordData()
		{
			// OR[h𐶐
			bbsRecord entryRecord = new bbsRecord();

			// VR[hIuWFNgXgɓo^
			mDbArrayList.Add(entryRecord);

			return (entryRecord);
		}

		/// <summary>
		///   R[hP폜
		/// </summary>
		public void removeRecord(int aIndexNumber)
		{
			bbsRecord targetRecord = (bbsRecord) mDbArrayList[aIndexNumber];

			mDbArrayList.Remove(targetRecord);
			return;
		}

		/// <summary>
		///   f[^̃\[gs
		/// </summary>
		public void doSort()
		{
			mDbArrayList.Sort();
		}

		/// <summary>
		///   OR[hQۑ
		/// </summary>
		public bool saveDatabase(bool aOverWrite)
		{
			if (aOverWrite != true)
			{
				try
				{
					fileSelectionDialog.CheckFileExists = false;
					fileSelectionDialog.FileName = mDbName;
					if (fileSelectionDialog.ShowDialog() == DialogResult.Cancel)
					{
						// t@Co͂̒f...
						return (false);
					}
				}
				catch
				{
					// Ȃ...
				}
			}
			else
			{
				// t@C͂caƂĎw肳ꂽ...
				fileSelectionDialog.FileName = mDbName;
			}

			// ꎞt@C̎w
			string tempFileName = mDbName + ".temp";

			// ۑt@C̎w
			string targetFileName = fileSelectionDialog.FileName;

			// t@C݂ꍇɂ́Arenameĕۊǂ
			if (File.Exists(targetFileName) == true)
			{
				try
				{
					File.Move(targetFileName, targetFileName + ".BAK");
				}
				catch
				{
					// G[ɂȂƂ͉Ȃ
				}
			}

			// f[^x[Xt@CVKɍ쐬
			try
			{
				mDbAccessor.createDatabase(targetFileName,
										  mDbParser.getDbName(),
										  mDbParser.getDbType(),
										  mDbParser.getDbCreatorName(),
										  mDbParser.getDbVersion());
			}
			catch
			{
				// DBt@CVK쐬Ɏs...
				MessageBox.Show("DBt@C̍쐬Ɏs܂B",
								"t@C쐬s",
								MessageBoxButtons.OK,
								MessageBoxIcon.Error);
				return (false);
			}

			// [vāAێĂIuWFNgSāiSR[hjo
			for (int loop = 0; loop < mDbArrayList.Count; loop++)
			{
				bbsRecord theData = getRecordData(loop);
				try
				{
					// ꎞt@Cɏo͌ADBt@Cɏo
					mDbParser.outputRecordToTemporaryFile(tempFileName, ref theData);
					mDbAccessor.appendRecordToDatabase(targetFileName, tempFileName);
				}
				catch
				{
					// o͎sAAAłȂ...
				}
			}
			try
			{
				// ꎞt@C폜
				File.Delete(tempFileName);
			}
			catch
			{
				// 폜s...łȂ...
			}
			return (true);
		}
	}
}

