/*============================================================================*
 *  FILE: 
 *     getloglist.c
 *
 *  Description: 
 *     QƃO擾ݒ̈ꗗ
 *===========================================================================*/
#define GETLOGLIST_C
#include "local.h"

#ifdef USE_LOGCHARGE

/*------------------------------------------------------------------------*/
/*   Function : selectionMenu_getLogList                                  */
/*                                     擾OꗗʑIj[̕\ */
/*------------------------------------------------------------------------*/
static UInt16 selectionMenu_getLogList(void)
{
    UInt16  btnId, feature, nofItems;
    UInt16 *jumpList;
    Char   *listLabel, *numP;

    // Wvꗗݒ
    feature  = NNSH_GETLOG_FEATURE_NONE;
    nofItems = 0;
    listLabel = MEMALLOC_PTR(NNSH_ITEMLEN_GETLOGJUMP * NNSH_NOF_JUMPMSG_GETLOG + MARGIN);
    if (listLabel == NULL)
    {
        return (feature);
    }
    MemSet(listLabel, (NNSH_ITEMLEN_GETLOGJUMP * NNSH_NOF_JUMPMSG_GETLOG + MARGIN), 0x00);
    numP = listLabel;

    jumpList = MEMALLOC_PTR(NNSH_NOF_JUMPMSG_GETLOG + MARGIN);
    if (jumpList == NULL)
    {
        MEMFREE_PTR(listLabel);
        return (feature);
    }
    MemSet(jumpList, (NNSH_NOF_JUMPMSG_GETLOG + MARGIN), 0x00);


    // Ij[ꗗǉ

    // XgɁuꗗ֖߂vǉ
    StrCopy(numP, NNSH_JUMPMSG_GETLOGRETURN);
    numP = numP + sizeof(NNSH_JUMPMSG_GETLOGRETURN);
    jumpList[nofItems] = (NNSH_JUMPSEL_GETLOGRETURN);
    nofItems++;

    // XgɁuJvǉ
    StrCopy(numP, NNSH_JUMPMSG_GETLOG_OPEN);
    numP = numP + sizeof(NNSH_JUMPMSG_GETLOG_OPEN);
    jumpList[nofItems] = (NNSH_JUMPSEL_GETLOG_OPEN);
    nofItems++;

    if (NNshGlobal->browserCreator != 0)
    {
        // XgɁuuEUŊJvǉ
        StrCopy(numP, NNSH_JUMPMSG_GETLOGBROWSER);
        numP = numP + sizeof(NNSH_JUMPMSG_GETLOGBROWSER);
        jumpList[nofItems] = (NNSH_JUMPSEL_GETLOGBROWSER);
        nofItems++;
    }

    if ((CheckInstalledResource_NNsh('appl', 'asUR') != false)||
         (CheckInstalledResource_NNsh('DAcc', 'mmuA') != false))
    {
        // MemoURL/MemoURLDACXg[Ă...
        // XgɁuMemoURLɑvǉ
        StrCopy(numP, NNSH_JUMPMSG_MEMOURL);
        numP = numP + sizeof(NNSH_JUMPMSG_MEMOURL);
        jumpList[nofItems] = (NNSH_JUMPSEL_MEMOURL);
        nofItems++;
    }

    // XgɁuTCgvǉ
    StrCopy(numP, NNSH_JUMPMSG_GETLOG_WWWINFO);
    numP = numP + sizeof(NNSH_JUMPMSG_GETLOG_WWWINFO);
    jumpList[nofItems] = (NNSH_JUMPSEL_GETLOG_WWWINFO);
    nofItems++;

    // XgɁuVmFvǉ
    StrCopy(numP, NNSH_JUMPMSG_GETLOG_CHECK);
    numP = numP + sizeof(NNSH_JUMPMSG_GETLOG_CHECK);
    jumpList[nofItems] = (NNSH_JUMPSEL_GETLOG_CHECK);
    nofItems++;

    // XgɁuj[vǉ
    StrCopy(numP, NNSH_JUMPMSG_GETLOG_OPENMNU);
    numP = numP + sizeof(NNSH_JUMPMSG_GETLOG_OPENMNU);
    jumpList[nofItems] = (NNSH_JUMPSEL_GETLOG_OPENMNU);
    nofItems++;

    // XgɁuLevelύXvǉ
    StrCopy(numP, NNSH_JUMPMSG_GETLOG_LEVEL);
    numP = numP + sizeof(NNSH_JUMPMSG_GETLOG_LEVEL);
    jumpList[nofItems] = (NNSH_JUMPSEL_GETLOG_LEVEL);
    nofItems++;

    // XgɁuؒfvǉ
    StrCopy(numP, NNSH_JUMPMSG_GETLOG_DISCONN);
    numP = numP + sizeof(NNSH_JUMPMSG_GETLOG_DISCONN);
    jumpList[nofItems] = (NNSH_JUMPSEL_GETLOG_DISCONN);
    nofItems++;

    // NNsiI
    if ((NNshGlobal->NNsiParam)->addMenuNNsiEnd != 0)
    {
        StrCopy(numP, NNSH_JUMPMSG_NNSIEND);
        numP = numP + sizeof(NNSH_JUMPMSG_NNSIEND);
        jumpList[nofItems] = NNSH_JUMPSEL_NNSIEND;
        nofItems++;
    }

#ifdef USE_BT_CONTROL
    // Bluetooth On/Off
    if ((NNshGlobal->NNsiParam)->addBtOnOff != 0)
    {
        // XgɁuBt On/Bt Offvǉ
        StrCopy(numP, NNSH_JUMPMSG_GETLOG_BT_ON);
        numP = numP + sizeof(NNSH_JUMPMSG_GETLOG_BT_ON);
        jumpList[nofItems] = (NNSH_JUMPSEL_GETLOG_BT_ON);
        nofItems++;

        StrCopy(numP, NNSH_JUMPMSG_GETLOG_BT_OFF);
        numP = numP + sizeof(NNSH_JUMPMSG_GETLOG_BT_OFF);
        jumpList[nofItems] = (NNSH_JUMPSEL_GETLOG_BT_OFF);
        nofItems++;
    }
#endif

    // IEBhE\
    btnId = NNshWinSelectionWindow(FRMID_JUMPMSG, listLabel, nofItems, 0);
    if (btnId != BTNID_JUMPCANCEL)
    {
        switch (jumpList[NNshGlobal->jumpSelection])
        {
          case NNSH_JUMPSEL_GETLOGRETURN:
            feature = NNSH_GETLOG_FEATURE_CLOSE_GETLOG;
            break;
          case NNSH_JUMPSEL_GETLOG_OPEN:
            feature = NNSH_GETLOG_FEATURE_OPEN_NNSI;
            break;
          case NNSH_JUMPSEL_GETLOGBROWSER:
            feature = NNSH_GETLOG_FEATURE_OPENWEB;
            break;
          case NNSH_JUMPSEL_GETLOG_MEMOURL:
            feature = NNSH_GETLOG_FEATURE_OPEN_MEMOURL;
            break;
          case NNSH_JUMPSEL_GETLOG_CHECK:
            feature = NNSH_GETLOG_FEATURE_CHECK_NEWARRIVAL;
            break;
          case NNSH_JUMPSEL_GETLOG_OPENMNU:
            feature = NNSH_GETLOG_FEATURE_OPEN_GETLOGMENU;
            break;
          case NNSH_JUMPSEL_GETLOG_LEVEL:
            feature = NNSH_GETLOG_FEATURE_OPEN_GETLEVEL;
            break;
          case NNSH_JUMPSEL_GETLOG_DISCONN:
            feature = NNSH_GETLOG_FEATURE_FORCE_DISCONNECT;
            break;
          case NNSH_JUMPSEL_GETLOG_BT_ON:
            feature = NNSH_GETLOG_FEATURE_BT_ON;
            break;
          case NNSH_JUMPSEL_GETLOG_BT_OFF:
            feature = NNSH_GETLOG_FEATURE_BT_OFF;
            break;
          case NNSH_JUMPSEL_GETLOG_NNSIEND:
            feature = NNSH_GETLOG_FEATURE_NNSIEND;
            break;
          case NNSH_JUMPSEL_GETLOG_EDIT:
            feature = NNSH_GETLOG_FEATURE_EDITITEM;
            break;
          case NNSH_JUMPSEL_GETLOG_NEW:
            feature = NNSH_GETLOG_FEATURE_ENTRY_NEWSITE;
            break;
          case NNSH_JUMPSEL_GETLOG_SEPA:
            feature = NNSH_GETLOG_FEATURE_EDIT_SEPARATOR;
            break;
          case NNSH_JUMPSEL_MEMOURL:
            feature = NNSH_GETLOG_FEATURE_OPEN_MEMOURL;
            break;
          case NNSH_JUMPSEL_GETLOG_WWWINFO:
            feature = NNSH_GETLOG_FEATURE_SITE_INFORMATION;
            break;
          default:
            break;
        }
    }

    MEMFREE_PTR(jumpList);
    MEMFREE_PTR(listLabel);
    return (feature);
}

/*-------------------------------------------------------------------------*/
/*   Function : displayString                                              */
/*                                                          ʕ\̍XV */
/*-------------------------------------------------------------------------*/
static void displayString(Char *lineData, RectangleType *dimF, UInt16 command)
{
    IndexedColorType color;
    UInt16           len, isReverse;
    
    isReverse = command & NNSH_GETLOGSTATE_MASK_SELECT;

#ifdef USE_COLOR
    // tHgJ[̐ݒ(ǂ̐Fɂ)
    if ((NNshGlobal->NNsiParam)->useColor != 0)
    {
        if ((command & NNSH_GETLOGSTATE_MASK_UPDATE) == NNSH_GETLOGSTATE_UPDATE)
        {
            color = (IndexedColorType) (NNshGlobal->NNsiParam)->colorNew;
            WinSetForeColor(color);
            WinSetTextColor(color);
        }
        if ((command & NNSH_GETLOGSTATE_DATETIME) == NNSH_GETLOGSTATE_DATETIME)
        {
            color = (IndexedColorType) (NNshGlobal->NNsiParam)->colorUnknown;
            WinSetForeColor(color);
            WinSetTextColor(color);
        }
    }
#endif

#ifdef USE_CLIE
    if (NNshGlobal->hrRef != 0)
    {
        // tHg̃[hbv(`̈ɓe}邽)
        if (NNshGlobal->hrVer >= HR_VERSION_SUPPORT_FNTSIZE)
        {
            len = HRFntWordWrap(NNshGlobal->hrRef, lineData, dimF->extent.x);
        }
        else
        {
            len = FntWordWrap(lineData, dimF->extent.x);
        }
        // CLIEnC]`(Truncateĕ\)
        HRWinDrawTruncChars(NNshGlobal->hrRef, 
                            lineData, len,
                            dimF->topLeft.x, dimF->topLeft.y, dimF->extent.x);
        if (isReverse != 0)
        {
            // J[\ʒu𔽓]
            HRWinDrawInvertedChars(NNshGlobal->hrRef, 
                                   lineData, len,
                                   dimF->topLeft.x, dimF->topLeft.y);
        }
    }
    else
#endif
    {
        // ʏ탂[h`(Truncateĕ\)
        len = FntWordWrap(lineData, dimF->extent.x);
        WinDrawTruncChars(lineData, len, dimF->topLeft.x,
                          dimF->topLeft.y, dimF->extent.x);
        if (isReverse != 0)
        {
            // J[\ʒu𔽓]
            WinDrawInvertedChars(lineData, len,
                                 dimF->topLeft.x, dimF->topLeft.y);
        }
    }

#ifdef USE_COLOR
    // ǂ̐Fɖ߂
    if ((NNshGlobal->NNsiParam)->useColor != 0)
    {
        if (((command & NNSH_GETLOGSTATE_MASK_UPDATE) == NNSH_GETLOGSTATE_UPDATE)||
            ((command & NNSH_GETLOGSTATE_DATETIME) == NNSH_GETLOGSTATE_DATETIME))
        {
            color = (IndexedColorType) (NNshGlobal->NNsiParam)->colorAlready;
            WinSetForeColor(color);
            WinSetTextColor(color);
        }
    }
#endif
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : createList_getLogList                                      */
/*                                                  ʕ\p̕擾 */
/*                                                                         */
/*-------------------------------------------------------------------------*/
static void createList_getLogList(UInt16 getLevel, NNshDispList *displayList)
{
    Err                  ret;
    DmOpenRef            dbRef;
    UInt16               lp, maxRec;
    NNshGetLogDatabase  *dbData;
    MemHandle            memH;

    // JEg̓[
    displayList->dataCount = 0;

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        return;
    }

    // R[h擾
    maxRec = 0;
    GetDBCount_NNsh(dbRef, &maxRec);

    if (maxRec > MAX_GETLOG_RECORDS)
    {
        // R[h̍ő匏𒴂Ăꍇɂ͍ő匏܂ŕ\...
        NNsh_DebugMessage(ALTID_ERROR, "OVERFLOW LogParmanent-NNsi", " cnt:", maxRec);
        maxRec = MAX_GETLOG_RECORDS;
    }
    for (lp = 0; lp < maxRec; lp++)
    {
        // R[h́Atǂݏo悤ɂ
        ret = GetRecordReadOnly_NNsh(dbRef, (maxRec - (lp + 1)), &memH, (void **) &dbData);
        if (ret != errNone)
        {
            // Of[^擾ɃG[A
            NNsh_DebugMessage(ALTID_ERROR, "GetRecordReadOnly_NNsh()", " ret:", ret);
            break;
        }
        if ((getLevel == 0)||((getLevel - 1) == dbData->usable))
        {
            // \ׂR[ho
            if (displayList->dataCount < MAX_GETLOG_RECORDS)
            {
                displayList->title[displayList->dataCount] =
                         MEMALLOC_PTR(MAX_TITLE_LABEL + MAX_GETLOG_URL + (MARGIN * 2));
                if (displayList->title[displayList->dataCount] == NULL)
                {
                    // ̈̊mۂɎs...
                    break;
                }
                // f[^(^CgƍXV)i[
                MemSet(displayList->title[displayList->dataCount],
                       (MAX_TITLE_LABEL + MAX_GETLOG_URL + (MARGIN * 2)), 0x00);
                StrCopy(displayList->title[displayList->dataCount], dbData->dataTitle);
                StrCat (displayList->title[displayList->dataCount], " (");
                StrNCopy(&displayList->title[displayList->dataCount][StrLen(displayList->title[displayList->dataCount])], dbData->dataURL, MAX_TITLE_LABEL);
                if (StrLen(dbData->dataURL) > MAX_TITLE_LABEL)
                {
                    displayList->title[displayList->dataCount][StrLen(displayList->title[displayList->dataCount])] = chrEllipsis;
                }
                StrCat (displayList->title[displayList->dataCount], ") ");
                displayList->updateTime[displayList->dataCount] = dbData->lastUpdate;
                displayList->recNum[displayList->dataCount] = (maxRec - (lp + 1));
                if (dbData->state != NNSH_SUBJSTATUS_NOT_YET)
                {
                    // 擾Ăꍇ...ŏʃrbg𗧂ĂĂ...
                    displayList->recNum[displayList->dataCount] = displayList->recNum[displayList->dataCount] | NNSH_GETLOG_NEWARRIVAL_LOG;
                }
                (displayList->dataCount)++;
            }
        }
        // DBR[hJ
        ReleaseRecordReadOnly_NNsh(dbRef, memH);     
    }

    // f[^x[X
    CloseDatabase_NNsh(dbRef);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : RefreshDisplay_getLogList                                  */
/*                                                          ʕ\̍XV */
/*-------------------------------------------------------------------------*/
void RefreshDisplay_getLogList(FormType *frm, UInt16 command, UInt16 parameter)
{
    RectangleType        dimF, dateF;
    Char                 lineData[BUFSIZE];
    Int16                pics;
    UInt16               fontID, nlines, fontHeight, update;
    UInt16               startLine, lineStatus, lp;
    UInt32               currentTime;
    DateTimeType         dateBuf;
    NNshDispList        *displayList;
    
    // [N̈ϐɔf
    displayList = NNshGlobal->dispList;

    // ݎ擾
    currentTime = TimGetSeconds();

    // Ԃ̏
    lineStatus = NNSH_DISP_ALL;
    startLine  = (NNshGlobal->NNsiParam)->getLogListPage;

    // ʂĕ`悷
    switch (command)
    {
      case NNSH_STEP_REDRAW:
        // FrmEraseForm(frm);
        FrmDrawForm(frm);
        break;

      case NNSH_STEP_NEWOPEN:
        FrmEraseForm(frm);
        FrmDrawForm(frm);
        
        // |bvAbvgK̃x(ݒ胍Oxɍ킹)XV
        if ((NNshGlobal->NNsiParam)->getROLogLevel == 0)
        {
             update = 0;
        }
        else
        {
             update = (NNshGlobal->NNsiParam)->getROLogLevel + 1;
        }
        NNshWinSetPopItems(frm, POPTRID_GETLOGLEVEL, LSTID_GETLOGLEVEL, update);
        break;
    }

    // ʂ̑傫ƕ\\s擾
    FrmGetObjectBounds(frm,
                   FrmGetObjectIndex(frm, GADID_MESSAGE_LIST), &dimF);
    fontID = ((NNshGlobal->NNsiParam)->useSonyTinyFontTitle == 0) ?
                           (NNshGlobal->NNsiParam)->currentFont : (NNshGlobal->NNsiParam)->sonyHRFontTitle;
    NNsi_UpdateRectangle(&dimF, (NNshGlobal->NNsiParam)->useSonyTinyFontTitle,
                                                &fontID, &fontHeight, &nlines);

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, " ::disp:: nlines:%d, (%d+%d, %d+%d)",
                      nlines, dimF.topLeft.x, dimF.extent.x , dimF.topLeft.y , dimF.extent.y);
#endif // #ifdef USE_REPORTER

    // ZNVʕ\͈͂𒴂Ăꍇ...
    if (parameter >= nlines)
    {
        parameter = nlines - 1;
    }
    NNshGlobal->work1 = displayList->dataCount;

    // R}h\ʒu̐擪ƕ\Ԃ肷
    switch (command)
    {
      case NNSH_STEP_TO_TOP:
        // 擪y[W\
        startLine  = 0;
        lineStatus = NNSH_DISP_UPPERLIMIT;
        break;

      case NNSH_STEP_PAGEUP:
        // Py[W\
        if ((NNshGlobal->NNsiParam)->getLogListPage <= nlines)
        {
            startLine  = 0;
            lineStatus = NNSH_DISP_UPPERLIMIT;
        }
        else
        {
            startLine  = (NNshGlobal->NNsiParam)->getLogListPage - nlines;
            lineStatus = NNSH_DISP_HALFWAY;
        }
        break;

      case NNSH_STEP_PAGEDOWN:
        // Py[W\
        if (((NNshGlobal->NNsiParam)->getLogListPage + nlines) >= displayList->dataCount)
        {
            startLine  = (NNshGlobal->NNsiParam)->getLogListPage;
            lineStatus = NNSH_DISP_LOWERLIMIT;
        }
        else
        {
            startLine  = (NNshGlobal->NNsiParam)->getLogListPage + nlines;
            lineStatus = NNSH_DISP_HALFWAY;
        }
        break;

      case NNSH_STEP_TO_BOTTOM:
        // y[W\
        startLine  = ((displayList->dataCount) < nlines) ? 
                                     0 : (displayList->dataCount) - nlines;
        lineStatus = NNSH_DISP_LOWERLIMIT;
        break;

      default:
        // ̑iĕ`Hj
        startLine  = (NNshGlobal->NNsiParam)->getLogListPage;
        if (startLine != 0)
        {
            lineStatus = NNSH_DISP_HALFWAY;
        }
        else
        {
            lineStatus = NNSH_DISP_UPPERLIMIT;
        }
        break;
    }

    // y[WԂ𔽉f
    if (lineStatus != NNSH_DISP_UPPERLIMIT)
    {
        if (startLine + nlines >= displayList->dataCount)
        {
            lineStatus = NNSH_DISP_LOWERLIMIT;
        }
        else
        {
            lineStatus = NNSH_DISP_HALFWAY;
        }
    }
    if (displayList->dataCount <= nlines)
    {
        lineStatus = NNSH_DISP_ALL;
    }

    // \̈NA
    NNsi_EraseRectangle(&dimF);

#ifdef USE_HIGHDENSITY
    // 𑜓x̐ݒ
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        // FntSetFont((NNshGlobal->NNsiParam)->sonyHRFontTitle);
        break;

      case kDensityLow:
      default:
        break;
    }
#endif   // #ifdef USE_HIGHDENSITY

    // ̕`isPʂŕ`悷j
    parameter = parameter + startLine;

    // IACezĂ邩ǂ̃`FbN
    if (parameter >= displayList->dataCount)
    {
        parameter = displayList->dataCount - 1;
    }
    for (lp = 0; lp < displayList->dataCount; lp++)
    {
        if (lp < startLine)
        {
            // \f[^ł͂ȂÃf[^T
            continue;
        }
        if (lp >= startLine + nlines)
        {
            // \\̈搔𒴂ꍇɂ̓[v𔲂
            break;
        }

        // I񂩂ǂ`FbN
        update = 0;
        if (parameter == lp)
        {
            update = update | NNSH_GETLOGSTATE_SELECTED;
        }

        // Pso
        MemSet(lineData, sizeof(lineData), 0x00);
        if (displayList->updateTime[lp] != 0)
        {
            // XVƌݎ20ȓꍇ...
            if (((currentTime - displayList->updateTime[lp]) < (60 * 20))&&
                ((displayList->recNum[lp] & 0x8000) != 0))
            {
                // XV}[N
                StrCopy(lineData, "* ");
                update = update | NNSH_GETLOGSTATE_UPDATE;
            }
            else
            {
                StrCopy(lineData, "   ");
            }
            StrCat(lineData, displayList->title[lp]);
            displayString(lineData, &dimF, update);

            // ŐV`FbN\
            MemSet(lineData, sizeof(lineData), 0x00);
            MemSet(&dateBuf, sizeof(dateBuf), 0x00);
            TimSecondsToDateTime(displayList->updateTime[lp], &dateBuf);

            DateToAscii((UInt8)  dateBuf.month,
                        (UInt8)  dateBuf.day,
                        (UInt16) dateBuf.year, 
                        dfYMDWithSlashes,
                        lineData);
            StrCat(lineData, ",");
            TimeToAscii((UInt8) dateBuf.hour,
                        (UInt8) dateBuf.minute,
                        tfColon24h,
                        &lineData[StrLen(lineData)]);
            MemMove(&dateF, &dimF, sizeof(RectangleType));

#ifdef USE_CLIE
            if (NNshGlobal->hrRef != 0)
            {
                // tHg̃[hbv(`̈ɓe}邽)
                if (NNshGlobal->hrVer >= HR_VERSION_SUPPORT_FNTSIZE)
                {
                    pics = HRFntCharsWidth(NNshGlobal->hrRef, lineData, 15);
                }
                else
                {
                    pics = FntCharsWidth(lineData, 15);
                }
            }
            else
#endif
            {
                pics = FntCharsWidth(lineData, 15);
            }

#ifdef USE_REPORTER
            HostTraceOutputTL(appErrorClass, "()()UPDATE: %s  pics:%d", lineData, pics);
#endif // #ifdef USE_REPORTER
            // 炠A炢ʂȏȁBBBt@N^OKv!!
            dateF.topLeft.x = dimF.extent.x - pics - MARGIN;
            dateF.extent.x  = pics + MARGIN;
            dateF.extent.y  = fontHeight;
            NNsi_EraseRectangle(&dateF);
            dateF.topLeft.x = dimF.extent.x - pics;
            dateF.extent.x  = pics;
            update = ((update & NNSH_GETLOGSTATE_SELECTED) | NNSH_GETLOGSTATE_DATETIME);
            displayString(lineData, &dateF, update);
        }
        else
        {
            // XVȂA^Cg\
            StrCopy(lineData, "   ");
            StrCat(lineData, displayList->title[lp]);

            displayString(lineData, &dimF, update);
        }

        // ̍sɕ`ʒuړ
        dimF.topLeft.y = dimF.topLeft.y + fontHeight;

    }

#ifdef USE_HIGHDENSITY
    // 𑜓x̐ݒ
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),
                      NNshGlobal->os5HighDensity);
        WinSetCoordinateSystem(kCoordinatesStandard);
        // FntSetFont((NNshGlobal->NNsiParam)->sonyHRFont);
        break;

      case kDensityLow:
      default:
        break;
    }
#endif   // #ifdef USE_HIGHDENSITY

    // 擪swork1ɁA\\swork2ɋL
    (NNshGlobal->NNsiParam)->getLogListPage = startLine;
    NNshGlobal->work2 = nlines;

    // ㉺{^̕\ݒ
    NNsh_UpDownButtonControl(frm, lineStatus, BTNID_LISTPREV, BTNID_LISTNEXT);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : openNNsiThread_getLogList                                  */
/*                                                              NNsiŊJ */
/*-------------------------------------------------------------------------*/
static UInt16 openNNsiThread_getLogList(UInt16 recNum)
{
    Err                  ret;
    UInt16               index;
    Char                 fileName[MAX_THREADFILENAME + MARGIN];
    DmOpenRef            dbRef;
    NNshGetLogDatabase  *dbData;
#ifdef CHECK_GETLOGTHREAD_INFORMATION_STRICTLY
    NNshSubjectDatabase *subjData;
    MemHandle            memH;
#endif

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "OPEN THREAD(recNum:%d)", recNum);
#endif // #ifdef USE_REPORTER


    dbData = MEMALLOC_PTR(sizeof(NNshGetLogDatabase) + MARGIN);
    if (dbData == NULL)
    {
        return (NNSH_DATABASE_BLANK);
    }
    MemSet(dbData, (sizeof(NNshGetLogDatabase) + MARGIN), 0x00);

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        index = NNSH_DATABASE_BLANK;
        goto FUNC_END;
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "OPEN:openNNsiThread_getLogList()");
#endif // #ifdef USE_REPORTER

    ret = GetRecord_NNsh(dbRef, recNum, sizeof(NNshGetLogDatabase), dbData);
    if (ret != errNone)
    {
        // G[,@IB
        NNsh_DebugMessage(ALTID_ERROR, "GetRecord_NNsh() ", "ret:", ret);
        CloseDatabase_NNsh(dbRef);
        goto FUNC_END;
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "GET:openNNsiThread_getLogList()");
#endif // #ifdef USE_REPORTER

    // f[^擾AXVf[^𗎂Ƃ
    dbData->state = NNSH_SUBJSTATUS_NOT_YET;
    UpdateRecord_NNsh(dbRef, recNum, sizeof(NNshGetLogDatabase), dbData);

    CloseDatabase_NNsh(dbRef);

    // Xf[^x[X̌ݒ
    MemSet(fileName, sizeof(fileName), 0x00);

    // t@Cw肷(Jt@ĆAftHĝ̖̂̂...)
    StrCopy(fileName, FILE_LOGCHARGE_PREFIX);
    NUMCATI(fileName, recNum);
    StrCat (fileName, "-0-0");
    StrCat (fileName, FILE_LOGCHARGE_SUFFIX);    

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "FILE:openNNsiThread_getLogList()");
#endif // #ifdef USE_REPORTER

    // Xf[^x[X̃I[v
    dbRef = 0;
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        index = NNSH_DATABASE_BLANK;
        goto FUNC_END;
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "FILE:openNNsiThread_getLogList()");
#endif // #ifdef USE_REPORTER

    // 擾ς݃O݂邩ǂ̃`FbN
    // (Xf[^̂cáAt@Cł̃\[gĂȂ̂œȂAAA)
    if (IsExistRecordRR_NNsh(dbRef, fileName, NNSH_KEYTYPE_CHAR, 0, &index) != errNone)
    {
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "NOT FOUND:openNNsiThread_getLogList()");
#endif // #ifdef USE_REPORTER

        // R[hAI
        index = NNSH_DATABASE_BLANK;
        CloseDatabase_NNsh(dbRef);
        goto FUNC_END;
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "FIND:openNNsiThread_getLogList()");
#endif // #ifdef USE_REPORTER

#ifdef CHECK_GETLOGTHREAD_INFORMATION_STRICTLY
    // R[h擾
    ret = GetRecordReadOnly_NNsh(dbRef, index, &memH, (void**) &subjData);
    if (ret != errNone)
    {
        index = NNSH_DATABASE_BLANK;
        CloseDatabase_NNsh(dbRef);
        goto FUNC_END;
    }

    // XԂ̊mF
    switch (subjData->state)
    {
      case NNSH_SUBJSTATUS_NOT_YET:
      case NNSH_SUBJSTATUS_DELETE:
        // 擾̏ꍇɂ́AI[vȂ
        index = NNSH_DATABASE_BLANK;
        break;

      default:
        // 擾ς݃Ȍꍇɂ́AI[vݒs
        (NNshGlobal->NNsiParam)->openMsgIndex = index;
        (NNshGlobal->msgIndex)->openMsg = 0;
        break;
    }
    // mۂR[h
    ReleaseRecordReadOnly_NNsh(dbRef, memH);
#else
    // lĂ݂΁AQƃO͎擾ς݂Subj-DBɊi[Ȃ...
    (NNshGlobal->NNsiParam)->openMsgIndex = index;
#endif
    CloseDatabase_NNsh(dbRef);

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "GOTO VIEW FORM fileName:%s", fileName);
#endif // #ifdef USE_REPORTER

FUNC_END:
    MEMFREE_PTR(dbData);
    return (index);
}

/*-------------------------------------------------------------------------*/
/*   Function : GetLogChargeDB                                             */
/*                                              Of[^x[Xf[^̎擾 */
/*-------------------------------------------------------------------------*/
static Err GetLogChargeDB(UInt16 recNum, NNshGetLogDatabase *dbData)
{
    Err                 ret;
    DmOpenRef           dbRef;

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        return (~errNone);
    }
    MemSet(dbData, sizeof(NNshGetLogDatabase), 0x00);
    ret = GetRecord_NNsh(dbRef, recNum, sizeof(NNshGetLogDatabase), dbData);
    CloseDatabase_NNsh(dbRef);
    if (ret != errNone)
    {
        // G[,@IB
        NNsh_DebugMessage(ALTID_ERROR, "GetRecord_NNsh() ", "ret:", ret);
        /** not return; **/
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :  showSiteInfo_getLogList                                   */
/*                                                         TCg̕\ */
/*-------------------------------------------------------------------------*/
static void showSiteInfo_getLogList(UInt16 recNum)
{
    Err                 ret;
    NNshGetLogDatabase  dbData;
    Char                logBuf[BIGBUF];

    // QƃO`[WpDB̎擾
    ret = GetLogChargeDB(recNum, &dbData);
    if (ret != errNone)
    {
        // G[,@IB
        NNsh_DebugMessage(ALTID_ERROR, "GetLogChargeDB() ", "ret:", ret);
        return;
    }
    MemSet(logBuf, sizeof(logBuf), 0x00);
    if (dbData.wwwcMode != 0)
    {
        StrCat(logBuf, "[WWWC]");
    }
    if (dbData.rssData != 0)
    {
        StrCat(logBuf, "[RSS]");
    }
    if (dbData.getDepth != 0)
    {
        StrCat(logBuf, "[link]");
    }
    if (dbData.getDateTime[0] != '\0')
    {
        StrCat (logBuf, "\n[");
        StrCat (logBuf, dbData.getDateTime);
        StrCat (logBuf, "]\n---\n");
    }
    StrCat (logBuf, dbData.dataTitle);
    StrCat (logBuf, "\n");
    StrCat (logBuf, dbData.dataURL);
    StrCat (logBuf, "\n\n");
    StrCat (logBuf, dbData.dataFileName);
    StrCat (logBuf, "\n");

    //ʕ\    
    NNsh_ErrorMessage(ALTID_INFO, logBuf, "", 0);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : beamSiteURL_getLogList                                     */
/*                                                       URLBEAM */
/*-------------------------------------------------------------------------*/
static void beamSiteURL_getLogList(UInt16 recNum)
{
    Err                 ret;
    NNshGetLogDatabase  dbData;
    Char                logBuf[BIGBUF];

    // QƃO`[WpDB̎擾
    ret = GetLogChargeDB(recNum, &dbData);
    if (ret != errNone)
    {
        // G[,@IB
        NNsh_DebugMessage(ALTID_ERROR, "GetLogChargeDB() ", "ret:", ret);
        return;
    }

    // BEAMMf[^̐...
    MemSet(logBuf, sizeof(logBuf), 0x00);
    StrCopy(logBuf, NNSI_NNSIEXT_URL_START);
    StrCat (logBuf, dbData.dataURL);
    StrCat (logBuf, "\"");
    StrCat (logBuf, dbData.dataTitle);
    StrCat (logBuf, "\"");
    StrCat (logBuf, NNSI_NNSIEXT_URL_END);

    // f[^̑M
    SendToExternalDevice(dbData.dataTitle, logBuf, SOFT_CREATOR_ID);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : openWebBrowser_getLogList                                  */
/*                                                       WebuEUŊJ */
/*-------------------------------------------------------------------------*/
static void openWebBrowser_getLogList(UInt16 recNum)
{
    Err                 ret;
    NNshGetLogDatabase  dbData;
    DmOpenRef           dbRef;

    // QƃO`[WpDB̎擾

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        return;
    }
    MemSet(&dbData, sizeof(NNshGetLogDatabase), 0x00);
    ret = GetRecord_NNsh(dbRef, recNum, sizeof(NNshGetLogDatabase), &dbData);
    if (ret != errNone)
    {
        // G[,@IB
        NNsh_DebugMessage(ALTID_ERROR, "GetRecord_NNsh() ", "ret:", ret);
        CloseDatabase_NNsh(dbRef);
        return;
    }

    // f[^擾AXVf[^𗎂Ƃ
    dbData.state = NNSH_SUBJSTATUS_NOT_YET;
    UpdateRecord_NNsh(dbRef, recNum, sizeof(NNshGetLogDatabase), &dbData);
    CloseDatabase_NNsh(dbRef);

    // NetFrontN(NNsiIɋN)
    if (NNshGlobal->browserCreator != 0)
    {
        (void) WebBrowserCommand(NNshGlobal->browserCreator, 0, 0, 
                                 NNshGlobal->browserLaunchCode,
                                 dbData.dataURL, MAX_GETLOG_URL, NULL);
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : openURLwebDA_getLogList                                    */
/*                                                             webDAŊJ */
/*-------------------------------------------------------------------------*/
static void openURLwebDA_getLogList(UInt16 recNum)
{
    Err                 ret;
    NNshGetLogDatabase  dbData;
    DmOpenRef           dbRef;

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        return;
    }
    MemSet(&dbData, sizeof(NNshGetLogDatabase), 0x00);
    ret = GetRecord_NNsh(dbRef, recNum, sizeof(NNshGetLogDatabase), &dbData);
    if (ret != errNone)
    {
        // G[,@IB
        NNsh_DebugMessage(ALTID_ERROR, "GetRecord_NNsh() ", "ret:", ret);
        CloseDatabase_NNsh(dbRef);
        return;
    }

    // f[^擾AXVf[^𗎂Ƃ
    dbData.state = NNSH_SUBJSTATUS_NOT_YET;
    UpdateRecord_NNsh(dbRef, recNum, sizeof(NNshGetLogDatabase), &dbData);
    CloseDatabase_NNsh(dbRef);

    // Nbv{[hɑIĂURLRs[
    ClipboardAddItem(clipboardText, dbData.dataURL, StrLen(dbData.dataURL));

    // webDAN
    if (CheckInstalledResource_NNsh('DAcc', 'wbDA') != false)
    {
        // webDACXg[Ăꍇ...
        (void) LaunchResource_NNsh('DAcc','wbDA','code',1000);
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : openMemoURL_getLogList                                     */
/*                                                MemoURL(MemoURLDA)ŊJ */
/*-------------------------------------------------------------------------*/
static void openMemoURL_getLogList(UInt16 recNum)
{
    Err                 ret;
    NNshGetLogDatabase  dbData;
    Char                logMsg[MAX_GETLOG_URL + MAX_TITLE_LABEL + (MARGIN * 2)];
    UInt16              len;

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "OPEN MEMO URL(recNum:%d)", recNum);
#endif // #ifdef USE_REPORTER

    // QƃO`[WpDB̎擾
    ret = GetLogChargeDB(recNum, &dbData);
    if (ret != errNone)
    {
        // G[,@IB
        NNsh_DebugMessage(ALTID_ERROR, "GetRecord_NNsh() ", "ret:", ret);
        return;
    }

    if (CheckInstalledResource_NNsh('DAcc', 'mmuA') != false)
    {
        // MemoURLDACXg[Ăꍇ...
        MemSet (logMsg, sizeof(logMsg), 0x00);
        StrCopy(logMsg, dbData.dataTitle);
        len = StrLen(logMsg);
        StrCopy(&logMsg[len + 1], dbData.dataURL);
        len  = len + 1 + StrLen(dbData.dataURL);

        // Nbv{[hɑIURLRs[
        ClipboardAddItem(clipboardText, logMsg, len);

#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, " COPIED URL :%s(len:%d)", logMsg, len);
#endif // #ifdef USE_REPORTER

        NNsh_DebugMessage(ALTID_INFO, "SEND to MemoURLDA URL:", dbData.dataURL, 0);

        (void) LaunchResource_NNsh('DAcc','mmuA','code',1000);
        return;
    }
    NNsh_DebugMessage(ALTID_INFO, "SEND to MemoURL URL:", dbData.dataURL, 0);

    // URLMemoURL֑
    if (CheckInstalledResource_NNsh('appl', 'asUR') == false)
    {
        // MemoURLCXg[ĂȂA
        return;
    }

    MemSet(logMsg, sizeof(logMsg), 0x00);
    logMsg[0] = '1';
    StrCopy(&logMsg[2], dbData.dataTitle); // X^C^Cg...
    len = StrLen(&logMsg[2]) + 2;
    StrCopy(&logMsg[len + 1], dbData.dataURL);
    len = len + 1 + StrLen(dbData.dataURL);

    // w肳ꂽURLMemoURLɑ
    (void) WebBrowserCommand('asUR', 0, 0, 0x8001, logMsg, len, NULL);
    return;
}


/*-------------------------------------------------------------------------*/
/*   Function : checkGadget_getLogList                                     */
/*                                                ^bv̈̃`FbN */
/*-------------------------------------------------------------------------*/
static UInt16 checkGadget_getLogList(EventType *event, FormType *frm, RectangleType *rect)
{
    Coord  locY;
    UInt16 fontID, nlines, fontHeight, selItem;

    // IACe肷
    if ((NNshGlobal->NNsiParam)->useSonyTinyFontTitle == 0)
    {
        fontID = (NNshGlobal->NNsiParam)->currentFont;
    }
    else
    {
        fontID = (NNshGlobal->NNsiParam)->sonyHRFontTitle;
    }
    NNsi_UpdateRectangle(rect, (NNshGlobal->NNsiParam)->useSonyTinyFontTitle,
                         &fontID, &fontHeight, &nlines);

#ifdef USE_CLIE
    if (NNshGlobal->hrRef != 0)
    {
        locY = (event->screenY * 2) - rect->topLeft.y;
    }
    else
#endif
    {
#ifdef USE_HIGHDENSITY
        // 𑜓xɂ킹ĕ`̈̍擾
        switch (NNshGlobal->os5HighDensity)
        {
          case kDensityDouble:
            locY = (event->screenY * 2) - rect->topLeft.y;
            break;

          case kDensityTriple:
            locY = (event->screenY * 3) - rect->topLeft.y;
            break;

          case kDensityQuadruple:
            locY = (event->screenY * 4) - rect->topLeft.y;
            break;

          case kDensityOneAndAHalf:
            locY = (event->screenY * 3 / 2) - rect->topLeft.y;
            break;

          case kDensityLow:
          default:
            locY = event->screenY - rect->topLeft.y;
            break;
        }
#else
        locY = event->screenY - rect->topLeft.y;
#endif // #ifdef USE_HIGHDENSITY
    }
    selItem = locY / fontHeight;

    if ((selItem + (NNshGlobal->NNsiParam)->getLogListPage) >= NNshGlobal->work1)
    {
        // ͈͊ȎIꍇAȂ
        return (0);
    }

    if (selItem == (NNshGlobal->NNsiParam)->getLogListSelection)
    {
        // _u^bvoAWebuEUŊJƂ
        return (vchrJogRelease);
    }

    // IACeړ
    (NNshGlobal->NNsiParam)->getLogListSelection = selItem;
    return (chrCapital_R);
}

/*=========================================================================*/
/*   Function :   Handler_GetLogList                                       */
/*                                QƃO̎擾ꗗʂ̃Cxgnh */
/*=========================================================================*/
Boolean Handler_GetLogList(EventType *event)
{
    FormType     *frm;
    RectangleType dimF;
    UInt16        itemId, feature;

    // {^`FbNȊÕCxg͑߂
    itemId = 0;
    switch (event->eType)
    {
      case popSelectEvent:
        // |bvAbvgK[ύX
        itemId = event->data.popSelect.listID;
        break;

      case menuEvent:
        // j[I
        itemId = event->data.menu.itemID;
        break;

      case ctlSelectEvent:
        // {^ꂽ(֐i)
        itemId = event->data.ctlSelect.controlID;
        break;

      case ctlRepeatEvent:
        // s[g{^ꂽ(֐i)
        itemId = event->data.ctlRepeat.controlID;
        break;

#ifdef USE_HANDERA
      case displayExtentChangedEvent:
        // ʂ̉]
        if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
        {
            frm = FrmGetActiveForm();
            HandEraResizeForm(frm);
            RefreshDisplay_getLogList(frm, NNSH_STEP_REDRAW, (NNshGlobal->NNsiParam)->getLogListSelection);
        }
        return (true);
        break;
#endif  // #ifdef USE_HANDERA

#ifdef USE_PIN_DIA
      case winDisplayChangedEvent:
        // ʂ̃TCYύX
        if ((NNshGlobal->device == NNSH_DEVICE_DIASUPPORT)||
            (NNshGlobal->device == NNSH_DEVICE_GARMIN))
        {
            frm = FrmGetActiveForm();
            if (HandEraResizeForm(frm) == true)
            {
                RefreshDisplay_getLogList(frm, NNSH_STEP_REDRAW, (NNshGlobal->NNsiParam)->getLogListSelection);
            }
        }
        return (true);
        break;
#endif

      case keyDownEvent:
        // L[͂
        itemId = KeyConvertFiveWayToJogChara(event);
        break;

      case penDownEvent:
        // ʃ^bvm
        frm = FrmGetActiveForm();
        FrmGetObjectBounds(frm, 
                           FrmGetObjectIndex(frm, GADID_MESSAGE_TAPPED),&dimF);
        if (RctPtInRectangle(event->screenX, event->screenY, &dimF))
        {
            // Gadget^bv(== XI)
            itemId = checkGadget_getLogList(event, frm, &dimF);
            break;
        }
        FrmGetObjectBounds(frm, 
                           FrmGetObjectIndex(frm, GADID_MESSAGE_LIST),&dimF);
        if (RctPtInRectangle(event->screenX, event->screenY, &dimF))
        {
            // Gadget^bv(== X̉E[)

            // y[W{^ꂽ`FbN
            FrmGetObjectBounds(frm, 
                               FrmGetObjectIndex(frm, BTNID_LISTNEXT),&dimF);
            if (RctPtInRectangle(event->screenX, event->screenY, &dimF))
            {
                // y[W{^ꂽƂɂ
                itemId = BTNID_LISTNEXT;
                break;
            }

            // Oy[W{^ꂽ`FbN
            FrmGetObjectBounds(frm, 
                               FrmGetObjectIndex(frm, BTNID_LISTPREV),&dimF);
            if (RctPtInRectangle(event->screenX, event->screenY, &dimF))
            {
                // Oy[W{^ꂽƂɂ
                itemId = BTNID_LISTPREV;
                break;
            }

            // XIƂɂ
            FrmGetObjectBounds(frm, 
                           FrmGetObjectIndex(frm, GADID_MESSAGE_LIST),&dimF);
            itemId = checkGadget_getLogList(event, frm, &dimF);
            break;
        }
        return (false); 
        break;

      default: 
        return (false);
        break;
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "::GetLog:: itemId:%d[work1:%d work2:%d work3:%d]",
                      itemId, (NNshGlobal->NNsiParam)->getLogListPage, NNshGlobal->work2, (NNshGlobal->NNsiParam)->getLogListSelection);
#endif // #ifdef USE_REPORTER

    // R}hs
    switch (itemId)
    {
      case chrCapital_U:
      case chrSmall_U:
      case MNUID_SITE_INFO:
        // TCg̕\
        feature = NNSH_GETLOG_FEATURE_SITE_INFORMATION;
        break;

      case chrCapital_C:
      case chrSmall_C:
      case MNUID_CONFIG_GETLOG:
        // QƃOꗗݒʂJ
        feature = NNSH_GETLOG_FEATURE_CONFIG_GETLOG;
        break;

      case BTNID_BUTTON1:
      case chrDigitOne:
        // NNsiŊJ
        feature = NNSH_GETLOG_FEATURE_OPEN_NNSI;
        break;

      case chrCapital_Z:  // ZL[̓
      case chrSmall_Z:
      case MNUID_BACK:
      case SELTRID_BACK:
        // ꗗʂJ
        feature = NNSH_GETLOG_FEATURE_CLOSE_GETLOG;
        break;

      case chrDigitFour:
      case BTNID_BUTTON4:
      case MNUID_ENTRY:
        // TCg̓o^
        feature = NNSH_GETLOG_FEATURE_ENTRY_NEWSITE;
        break;
         
      case chrDigitFive:
      case BTNID_BUTTON5:
      case MNUID_SETSEPA:
        // ؂̐ݒʂJ
        feature = NNSH_GETLOG_FEATURE_EDIT_SEPARATOR;
        break;

      case chrDigitSix:
      case BTNID_BUTTON6:
      case chrSpace:
      case chrSJISIdeographicSpace:
      case MNUID_GETLOGOPE:
        // VmF{
        feature = NNSH_GETLOG_FEATURE_CHECK_NEWARRIVAL;
        break;

      case MNUID_SITE_DETAIL:
      case chrDigitThree:
      case chrCapital_E:  // EL[̓
      case chrSmall_E:
      case BTNID_BUTTON3:
        // f[^ҏW
        feature = NNSH_GETLOG_FEATURE_EDITITEM;
        break;

      case vchrJogBack:
      case chrBackspace:
      case chrEscape:
      case vchrThumbWheelBack:
      case vchrGarminEscape:
        // Jog Back
        feature = (NNshGlobal->NNsiParam)->getLogFeature.jogBack;
        break;

      case vchrJogRelease:
      case chrCarriageReturn:
      case chrLineFeed:
      case vchrThumbWheelPush:
        // Jog Push
        feature = (NNshGlobal->NNsiParam)->getLogFeature.jogPush;
        break;

      case chrDigitTwo:
      case chrCapital_W:  // WL[̓
      case chrSmall_W:
      case BTNID_BUTTON2:
        // WebuEUŊJ
        feature = NNSH_GETLOG_FEATURE_OPENWEB;
        break;

      case vchrPageUp:
      case vchrJogUp:
      case vchrTrgJogUp:
      case vchrPrevField:
      case vchrThumbWheelUp:
      case chrUpArrow:
        // up
        feature = (NNshGlobal->NNsiParam)->getLogFeature.up;
        break;

      case vchrPageDown:
      case vchrJogDown:
      case vchrTrgJogDown:
      case vchrNextField:
      case vchrThumbWheelDown:
      case chrDownArrow:
        // down
        feature = (NNshGlobal->NNsiParam)->getLogFeature.down;
        break;


      case chrLeftArrow:         // J[\L[(5way)
      case vchrJogLeft:
        feature = (NNshGlobal->NNsiParam)->getLogFeature.left;
        break;

      case chrCapital_P:  // PL[̓
      case chrSmall_P:
      case BTNID_LISTPREV:
        // Oy[W
        feature = NNSH_GETLOG_FEATURE_PREVPAGE;
        break;

      case chrRightArrow:         // J[\L[E(5wayE)
      case vchrJogRight:
        feature = (NNshGlobal->NNsiParam)->getLogFeature.right;
        break;

      case chrCapital_N:  // NL[̓
      case chrSmall_N:
      case BTNID_LISTNEXT:
        // y[W
        feature = NNSH_GETLOG_FEATURE_NEXTPAGE;
        break;

      case chrCapital_T:       // TL[̓
      case chrSmall_T:
        // 擪\
        feature = NNSH_GETLOG_FEATURE_TOP;
        break;

      case chrCapital_B:  // BL[̓
      case chrSmall_B:
        // \
        feature = NNSH_GETLOG_FEATURE_BOTTOM;
        break;

      // QL[
      case chrCapital_Q:
      case chrSmall_Q:
      case MNUID_NET_DISCONN:
        // ؒf
        feature = NNSH_GETLOG_FEATURE_DISCONNECT;
        break;

      case chrDigitSeven:
        // L[7 (Bt ON)
        feature = NNSH_GETLOG_FEATURE_BT_ON;
        break;

      case chrDigitEight:
        // L[8 (Bt Off)
        feature = NNSH_GETLOG_FEATURE_BT_OFF;
        break;

      case LSTID_GETLOGLEVEL:
        // |bvAbvgK[XV
        feature = NNSH_GETLOG_FEATURE_CREATELIST;
        break;

      // LL[
      case chrCapital_L:
      case chrSmall_L:
        // 񃌃xI
        feature = NNSH_GETLOG_FEATURE_OPEN_GETLEVEL;
        break;

      // ?L[
      case chrQuestionMark:
      case MNUID_NNSI_END:
        // NNsiI
        feature = NNSH_GETLOG_FEATURE_NNSIEND;
        break;

      // VL[
      case chrCapital_V:
      case chrSmall_V:
      case MNUID_SHOW_VERSION:
        // o[W\
        feature = NNSH_GETLOG_FEATURE_SHOWVERSION;
        break;

      // RL[
      case chrCapital_R:
      case chrSmall_R:
        // ʂ̍ĕ`
        feature = NNSH_GETLOG_FEATURE_REDRAW;
        break;

      // AL[
      case chrCapital_A:
      case chrSmall_A:
      case MNUID_NET_CONFIG:
        // lbg[NݒJ
        feature = NNSH_GETLOG_FEATURE_NETCONFIG;
        break;

      // IL[
      case chrCapital_I:
      case chrSmall_I:
      case MNUID_SHOW_DEVICEINFO:
        // foCX̏\
        feature = NNSH_GETLOG_FEATURE_DEVICEINFO;
        break;

      // !L[
      case chrExclamationMark:
      case MNUID_GOTO_DUMMY:
        // _~[ʂ֑J
        feature = NNSH_GETLOG_FEATURE_OPEN_DUMMY;
        break;

      case chrDigitNine:
      case MNUID_CONFIG_NNSH:
        // NNsiݒJ
        feature = NNSH_GETLOG_FEATURE_OPEN_NNSISET;
        break;

      case chrCapital_H:
      case chrSmall_H:
      case MNUID_SHOW_HELP:
        feature = NNSH_GETLOG_FEATURE_HELP;
        break;

      case chrCapital_X:
      case chrSmall_X:
        // Ij[
        feature = NNSH_GETLOG_FEATURE_OPENMENU;
        break;

#if 0
      case vchrCapture:
      case vchrVoiceRec:
      case vchrVZ90functionMenu:      
      case vchrGarminRecord:
#endif
      case vchrHard5:
        if ((NNshGlobal->NNsiParam)->useHardKeyControl == 0)
        {
            // n[hL[䂵Ȃꍇ͏I
            return (false);
        }
        // CLIELv`[{^Ƃ̐ݒ
        feature = (NNshGlobal->NNsiParam)->getLogFeature.clieCapture;
        break;

      case vchrHard1:
        if ((NNshGlobal->NNsiParam)->useHardKeyControl == 0)
        {
            // n[hL[䂵Ȃꍇ͏I
            return (false);
        }
        // n[hL[PƂ̐ݒ
        feature = (NNshGlobal->NNsiParam)->getLogFeature.key1;
        break;

      case vchrHard2:
        if ((NNshGlobal->NNsiParam)->useHardKeyControl == 0)
        {
            // n[hL[䂵Ȃꍇ͏I
            return (false);
        }
        // n[hL[QƂ̐ݒ
        feature = (NNshGlobal->NNsiParam)->getLogFeature.key2;
        break;

      case vchrHard3:
        if ((NNshGlobal->NNsiParam)->useHardKeyControl == 0)
        {
            // n[hL[䂵Ȃꍇ͏I
            return (false);
        }
        // n[hL[RƂ̐ݒ
        feature = (NNshGlobal->NNsiParam)->getLogFeature.key3;
        break;

      case vchrHard4:
        if ((NNshGlobal->NNsiParam)->useHardKeyControl == 0)
        {
            // n[hL[䂵Ȃꍇ͏I
            return (false);
        }
        // n[hL[SƂ̐ݒ
        feature = (NNshGlobal->NNsiParam)->getLogFeature.key4;
        break;

      case chrCapital_S:
      case chrSmall_S:
      case MNUID_BEAM_URL:
        // tqkM
        feature = NNSH_GETLOG_FEATURE_BEAM_URL;
        break;

      case chrCapital_Y:
      case chrSmall_Y:
      case MNUID_OPEN_WEBDA:
        // webDAŊJ
        feature = NNSH_GETLOG_FEATURE_OPENWEBDA;
        break;

#ifdef USE_PIN_DIA
      case vchrTT3Short:
      case vchrTT3Long:
        // ʂ̃TCYύX
        if ((NNshGlobal->device == NNSH_DEVICE_DIASUPPORT)||
            (NNshGlobal->device == NNSH_DEVICE_GARMIN))
        {
            if (HandEraResizeForm(FrmGetActiveForm()) == true)
            {
                RefreshDisplay_getLogList(FrmGetActiveForm(), NNSH_STEP_REDRAW, (NNshGlobal->NNsiParam)->getLogListSelection);
            }
        }
        return (true);
        break;
#endif

      default:
        // LȊO
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "<>UNKNOWN(%d)<>", itemId);
#endif // #ifdef USE_REPORTER
        return (false);
        break;
    }

EXEC_FEATURE:
    Execute_GetLogList(feature);
    switch (feature)
    {
      case NNSH_GETLOG_FEATURE_CONFIG_GETLOG:
      case NNSH_GETLOG_FEATURE_EDIT_SEPARATOR:
        // ʕ\ĕ`悷
        // (NNshGlobal->NNsiParam)->getLogListSelection = 0;
        Execute_GetLogList(NNSH_GETLOG_FEATURE_CREATELIST);
        break;

      case NNSH_GETLOG_FEATURE_EDITITEM:
      case NNSH_GETLOG_FEATURE_ENTRY_NEWSITE:
        // ʕ\NA
        (NNshGlobal->NNsiParam)->getLogListPage = 0;
        NNshGlobal->work2 = 0;
        (NNshGlobal->NNsiParam)->getLogListSelection = 0;
        Execute_GetLogList(NNSH_GETLOG_FEATURE_CREATELIST);
        break;

      case NNSH_GETLOG_FEATURE_CREATELIST:
      case NNSH_GETLOG_FEATURE_CHECK_NEWARRIVAL:
        // 
        return (false);
        break;

      case NNSH_GETLOG_FEATURE_OPENMENU:
        // Ij[Jꍇɂ́Aēx@\sB
        if (NNshGlobal->jumpSelection != NNSH_GETLOG_FEATURE_NONE)
        {
            // 
            feature = NNshGlobal->jumpSelection;
            goto EXEC_FEATURE;
        }
        break;

      default:
        // Ȃ
        break;
    }
    return (true);
}

/*=========================================================================*/
/*   Function :  Execute_GetLogList                                        */
/*                            QƃOʂŎs\ȋ@\̈ꗗ(@\) */
/*=========================================================================*/
Boolean Execute_GetLogList(UInt16 feature)
{
    FormType     *frm;
    EventType    *dummyEvent;
    UInt16        selItem, savedParam;
    ListType     *lstP;

    frm = FrmGetActiveForm();
    switch (feature)
    {
      case NNSH_GETLOG_FEATURE_CLOSE_GETLOG:
        // ꗗʂJ
        CloseForm_GetLogList(FRMID_THREAD);
        break;

      case NNSH_GETLOG_FEATURE_CHECK_NEWARRIVAL:
        // VmF{
        selItem = LstGetSelection(FrmGetObjectPtr(frm, 
                                  FrmGetObjectIndex(frm, LSTID_GETLOGLEVEL)));
        if (selItem > 1)
        {
            // Xgԍ񃌃xɒ
            selItem--;
        }
        savedParam = (NNshGlobal->NNsiParam)->getROLogLevel;

        // 񃌃x^uɍ킹ĕύX
        (NNshGlobal->NNsiParam)->getROLogLevel = selItem;

        // VmFOɂc`{ݒ肾ꍇ...
        if ((NNshGlobal->NNsiParam)->preOnDAnewArrival != 0)
        {
            // DAN
            LaunchDA_NNsh(((NNshGlobal->NNsiParam)->prepareDAforNewArrival));
        }

        // QƃO̎擾s
        GetReadOnlyLogData_NNsh();

        // 񃌃xɖ߂
        (NNshGlobal->NNsiParam)->getROLogLevel = savedParam;

        // f[^蒼Ă݂
        lstP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_GETLOGLEVEL));
        selItem = LstGetSelection(lstP);
        Show_BusyForm(MSG_FINDING_WAIT);
        ClearList_getLogList (NNshGlobal->dispList);
        createList_getLogList(selItem, NNshGlobal->dispList);
        Hide_BusyForm(false);

        // PalmOS v3.5ȉȂAÕtH[B
        if (NNshGlobal->palmOSVersion < 0x03503000)
        {
            FrmEraseForm(FrmGetActiveForm());
            FrmDrawForm(FrmGetActiveForm());
        }

        // ʂ̍ĕ`{
        (NNshGlobal->NNsiParam)->getLogListSelection = 0;
        RefreshDisplay_getLogList(frm, NNSH_STEP_TO_TOP, (NNshGlobal->NNsiParam)->getLogListSelection);

        // NNsiݒ-9̃p[^𗬗pāAVmF̏{

        if ((NNshGlobal->NNsiParam)->use_DAplugin != 0)
        {
            // VmFIɃ[`FbN̊mF{(cMDAN)
            (void) LaunchResource_NNsh('DAcc','cMDA','code',1000);
        }

        if ((NNshGlobal->NNsiParam)->disconnArrivalEnd != 0)
        {
            // uVmFvIɉؒf
            savedParam = (NNshGlobal->NNsiParam)->confirmationDisable;
            (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
            NNshNet_LineHangup();
            (NNshGlobal->NNsiParam)->confirmationDisable = savedParam;
        }

        // uVmFvɃr[v炵Ă݂
        if ((NNshGlobal->NNsiParam)->autoBeep != 0)
        {
            SndPlaySystemSound(sndAlarm);
        }
        break;

      case NNSH_GETLOG_FEATURE_EDITITEM:
        // TCgf[^̕ҏW
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, " EDIT RECORD:%d",
                          ((NNshGlobal->dispList)->recNum[(NNshGlobal->NNsiParam)->getLogListSelection + (NNshGlobal->NNsiParam)->getLogListPage]) & NNSH_GETLOG_NEWARRIVAL_CLEAR_MASK);
#endif // #ifdef USE_REPORTER
        SetLogGetURL(((NNshGlobal->dispList)->recNum[(NNshGlobal->NNsiParam)->getLogListSelection + (NNshGlobal->NNsiParam)->getLogListPage]) & NNSH_GETLOG_NEWARRIVAL_CLEAR_MASK);
        break;

      case NNSH_GETLOG_FEATURE_PREVITEM:
        // ЂƂI
        if ((NNshGlobal->NNsiParam)->getLogListSelection > 0)
        {
            (NNshGlobal->NNsiParam)->getLogListSelection--;
            RefreshDisplay_getLogList(frm, NNSH_STEP_REDRAW, (NNshGlobal->NNsiParam)->getLogListSelection);
        }
        else
        {
            if ((NNshGlobal->NNsiParam)->getLogListPage == 0)
            {
                // Oy[WȂꍇɂ͏I
                return (true);
            }
            // Oy[W
            (NNshGlobal->NNsiParam)->getLogListSelection = (NNshGlobal->work2 - 1);
            RefreshDisplay_getLogList(frm, NNSH_STEP_PAGEUP, (NNshGlobal->NNsiParam)->getLogListSelection);
        }
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "<>Jog UP<>");
#endif // #ifdef USE_REPORTER
        break;

      case NNSH_GETLOG_FEATURE_NEXTITEM:
        // ЂƂI
        if (((NNshGlobal->NNsiParam)->getLogListSelection + (NNshGlobal->NNsiParam)->getLogListPage) >= NNshGlobal->work1)
        {
            // zĂAJ[\𖖔ɂ킹
            (NNshGlobal->NNsiParam)->getLogListSelection = NNshGlobal->work1 - (NNshGlobal->NNsiParam)->getLogListPage - 1;
            RefreshDisplay_getLogList(frm, NNSH_STEP_REDRAW, (NNshGlobal->NNsiParam)->getLogListSelection);
#ifdef USE_REPORTER
            HostTraceOutputTL(appErrorClass, "<>ADJUST<>");
#endif // #ifdef USE_REPORTER
            return (true);
        }
        if ((NNshGlobal->NNsiParam)->getLogListSelection < (NNshGlobal->work2 - 1))
        {
            (NNshGlobal->NNsiParam)->getLogListSelection++;
            RefreshDisplay_getLogList(frm, NNSH_STEP_REDRAW, (NNshGlobal->NNsiParam)->getLogListSelection);
#ifdef USE_REPORTER
            HostTraceOutputTL(appErrorClass, "<>REDRAW<>");
#endif // #ifdef USE_REPORTER
        }
        else
        {
            if (((NNshGlobal->NNsiParam)->getLogListSelection == (NNshGlobal->work2 - 1))&&
                ((NNshGlobal->NNsiParam)->getLogListSelection + (NNshGlobal->NNsiParam)->getLogListPage == NNshGlobal->work1))
            {
                // y[WȂꍇɂ͏I
                return (true);
            }
            // y[W\
            (NNshGlobal->NNsiParam)->getLogListSelection = 0;
            RefreshDisplay_getLogList(frm, NNSH_STEP_PAGEDOWN, (NNshGlobal->NNsiParam)->getLogListSelection);
        }
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "<>Jog DOWN<>");
#endif // #ifdef USE_REPORTER
        break;

      case NNSH_GETLOG_FEATURE_PREVPAGE:
        // Oy[W
        RefreshDisplay_getLogList(frm, NNSH_STEP_PAGEUP, (NNshGlobal->NNsiParam)->getLogListSelection);
        break;

      case NNSH_GETLOG_FEATURE_NEXTPAGE:
        // y[W
        RefreshDisplay_getLogList(frm, NNSH_STEP_PAGEDOWN, (NNshGlobal->NNsiParam)->getLogListSelection);
        break;

      case NNSH_GETLOG_FEATURE_TOP:
        // ꗗ̐擪
        (NNshGlobal->NNsiParam)->getLogListSelection = 0;
        RefreshDisplay_getLogList(frm, NNSH_STEP_TO_TOP, (NNshGlobal->NNsiParam)->getLogListSelection);
        break;

      case NNSH_GETLOG_FEATURE_BOTTOM:
        // ꗗ̖
        (NNshGlobal->NNsiParam)->getLogListSelection = (NNshGlobal->work2 - 1);
        RefreshDisplay_getLogList(frm, NNSH_STEP_TO_BOTTOM, (NNshGlobal->NNsiParam)->getLogListSelection);
        break;

      case NNSH_GETLOG_FEATURE_CREATELIST:
        // ꗗč\z
        lstP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_GETLOGLEVEL));
        selItem = LstGetSelection(lstP);
        Show_BusyForm(MSG_FINDING_WAIT);

        // 񃌃x̃p[^ۑ
        if (selItem == 0)
        {
            (NNshGlobal->NNsiParam)->getROLogLevel = 0;
        }
        else
        {
            (NNshGlobal->NNsiParam)->getROLogLevel = selItem - 1;
        }
        ClearList_getLogList (NNshGlobal->dispList);
        createList_getLogList(selItem, NNshGlobal->dispList);
        Hide_BusyForm(false);
        if (NNshGlobal->palmOSVersion < 0x03503000)
        {
            FrmEraseForm(FrmGetActiveForm());
            FrmDrawForm(FrmGetActiveForm());
        }
        (NNshGlobal->NNsiParam)->getLogListSelection = 0;
        RefreshDisplay_getLogList(frm, NNSH_STEP_TO_TOP, (NNshGlobal->NNsiParam)->getLogListSelection);
        break;

      case NNSH_GETLOG_FEATURE_EDIT_SEPARATOR:
        // ؂ݒʂJ
        SetLogCharge_LogToken(0);
        break;

      case NNSH_GETLOG_FEATURE_ENTRY_NEWSITE:
        // VKo^ʂJ
        SetLogGetURL(NNSH_ITEM_LASTITEM);
        break;

      case NNSH_GETLOG_FEATURE_OPEN_GETLEVEL:
        // VmFxJ
        CtlHitControl(FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, POPTRID_GETLOGLEVEL)));
        break;

      case NNSH_GETLOG_FEATURE_REDRAW:
        // ʂ̍ĕ`
        RefreshDisplay_getLogList(frm, NNSH_STEP_REDRAW, (NNshGlobal->NNsiParam)->getLogListSelection);
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "<>REDRAW<>REDRAW<>");
#endif // #ifdef USE_REPORTER
        break;

      case NNSH_GETLOG_FEATURE_OPENWEB:
        // WebuEUŊJ
        openWebBrowser_getLogList(((NNshGlobal->dispList)->recNum[(NNshGlobal->NNsiParam)->getLogListSelection + (NNshGlobal->NNsiParam)->getLogListPage]) & NNSH_GETLOG_NEWARRIVAL_CLEAR_MASK);
        break;

      case NNSH_GETLOG_FEATURE_BT_ON:
#ifdef USE_BT_CONTROL
        OpenBluetoothPreferences(true);
#endif  // #ifdef USE_BT_CONTROL

      case NNSH_GETLOG_FEATURE_BT_OFF:
#ifdef USE_BT_CONTROL
        OpenBluetoothPreferences(false);
#endif  // #ifdef USE_BT_CONTROL
        break;

      case NNSH_GETLOG_FEATURE_DISCONNECT:
        // ؒf
        NNshNet_LineHangup();
        break;

      case NNSH_GETLOG_FEATURE_NETCONFIG:
        // lbg[NݒʂJ
        OpenNetworkPreferences();
        break;

      case NNSH_GETLOG_FEATURE_DEVICEINFO:
        // foCX\
        ShowDeviceInfo_NNsh();
        break;

      case NNSH_GETLOG_FEATURE_OPEN_DUMMY:
        // _~[ʂJ
        CloseForm_GetLogList(FRMID_NNSI_DUMMY);
        break;

      case NNSH_GETLOG_FEATURE_OPEN_NNSISET:
        // NNsiݒʂJ
        CloseForm_GetLogList(FRMID_NNSI_SETTING_ABSTRACT);
        break;

      case NNSH_GETLOG_FEATURE_SHOWVERSION:
        // o[W̕\
        ShowVersion_NNsh();
        break;

      case NNSH_GETLOG_FEATURE_HELP:
        // wv\
        // (Nbv{[hɁAnnDAɓnf[^ɂĂ̎wi[)
        ClipboardAddItem(clipboardText, 
                         nnDA_NNSIEXT_VIEWSTART
                         nnDA_NNSIEXT_INFONAME
                         nnDA_NNSIEXT_HELPGETLOG
                         nnDA_NNSIEXT_ENDINFONAME
                         nnDA_NNSIEXT_ENDVIEW,
                         sizeof(nnDA_NNSIEXT_VIEWSTART
                                 nnDA_NNSIEXT_INFONAME
                                 nnDA_NNSIEXT_HELPGETLOG
                                 nnDA_NNSIEXT_ENDINFONAME
                                 nnDA_NNSIEXT_ENDVIEW));
        // nnDAN
        (void) LaunchResource_NNsh('DAcc','nnDA','code',1000);
        break;

     case NNSH_GETLOG_FEATURE_NNSIEND:
        // NNsiI
        dummyEvent = &(NNshGlobal->dummyEvent);
        MemSet(dummyEvent, sizeof(EventType), 0x00);
        dummyEvent->eType = appStopEvent;
        EvtAddEventToQueue(dummyEvent);
        break;

      case NNSH_GETLOG_FEATURE_OPENMENU:
        // Ij[\
        NNshGlobal->jumpSelection = selectionMenu_getLogList();
        break;

      case NNSH_GETLOG_FEATURE_FORCE_DISCONNECT:
        // ؒf̂Q
        savedParam = (NNshGlobal->NNsiParam)->confirmationDisable;
        (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
        NNshNet_LineHangup();
        (NNshGlobal->NNsiParam)->confirmationDisable = savedParam;
        break;

      case NNSH_GETLOG_FEATURE_OPEN_GETLOGMENU:
        // j[J
        // (_~[ō㕔penDownEvent𐶐)
        dummyEvent = &(NNshGlobal->dummyEvent);
        MemSet(dummyEvent, sizeof(EventType), 0x00);
        dummyEvent->eType    = penDownEvent;
        dummyEvent->penDown  = true;
        dummyEvent->tapCount = 1;
        dummyEvent->screenX  = 5;
        dummyEvent->screenY  = 5;
        EvtAddEventToQueue(dummyEvent);
        break;

      case NNSH_GETLOG_FEATURE_OPEN_MEMOURL:
        // MemoURLŊJ
        openMemoURL_getLogList(((NNshGlobal->dispList)->recNum[(NNshGlobal->NNsiParam)->getLogListSelection + (NNshGlobal->NNsiParam)->getLogListPage]) & NNSH_GETLOG_NEWARRIVAL_CLEAR_MASK);
        break;

      case NNSH_GETLOG_FEATURE_CONFIG_GETLOG:
        // QƃOꗗʂ̃n[hL[ڍאݒ{
        GetLog_SetHardKeyFeature();
        break;

      case NNSH_GETLOG_FEATURE_OPEN_NNSI:
        // 擾ONNsiŊJ
        selItem = openNNsiThread_getLogList(((NNshGlobal->dispList)->recNum[(NNshGlobal->NNsiParam)->getLogListSelection + (NNshGlobal->NNsiParam)->getLogListPage]) & NNSH_GETLOG_NEWARRIVAL_CLEAR_MASK);
        if (selItem != NNSH_DATABASE_BLANK)
        {
            // O͎擾ĂAAAQƉʂJ
            CloseForm_GetLogList(FRMID_MESSAGE);
            return (true);
        }
        // O擾łĂȂAWebuEUŊJmF
        if (NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_CONFIRM_OPENWEB, "", 0) == 0)
        {
            // WebuEUŊJ
            openWebBrowser_getLogList(((NNshGlobal->dispList)->recNum[(NNshGlobal->NNsiParam)->getLogListSelection + (NNshGlobal->NNsiParam)->getLogListPage]) & NNSH_GETLOG_NEWARRIVAL_CLEAR_MASK);
        }
        break;

      case NNSH_GETLOG_FEATURE_SITE_INFORMATION:
        // TCg\
        showSiteInfo_getLogList(((NNshGlobal->dispList)->recNum[(NNshGlobal->NNsiParam)->getLogListSelection + (NNshGlobal->NNsiParam)->getLogListPage]) & NNSH_GETLOG_NEWARRIVAL_CLEAR_MASK);
        break;

      case NNSH_GETLOG_FEATURE_BEAM_URL:
        // TCgBeam
        beamSiteURL_getLogList(((NNshGlobal->dispList)->recNum[(NNshGlobal->NNsiParam)->getLogListSelection + (NNshGlobal->NNsiParam)->getLogListPage]) & NNSH_GETLOG_NEWARRIVAL_CLEAR_MASK);
        break;

      case NNSH_GETLOG_FEATURE_OPENWEBDA:
        // TCgwebDAŊJ
        openURLwebDA_getLogList(((NNshGlobal->dispList)->recNum[(NNshGlobal->NNsiParam)->getLogListSelection + (NNshGlobal->NNsiParam)->getLogListPage]) & NNSH_GETLOG_NEWARRIVAL_CLEAR_MASK);
        break;

      default:
        // mȂ@\ԍw肳ꂽ
        NNsh_DebugMessage(ALTID_INFO, "Unknown Feature Number :", "", feature);
        return (false);
        break;
    }
    return (true);
}

/*=========================================================================*/
/*   Function :   clearList_getLogList                                     */
/*                              QƃO̎擾ꗗ\pf[^NA */
/*=========================================================================*/
void ClearList_getLogList(NNshDispList *dispList)
{
    UInt16 lp;

    for (lp = 0; lp < dispList->dataCount; lp++)
    {
        MEMFREE_PTR(dispList->title[lp]);
    }
    dispList->dataCount = 0;
    return;
}


/*=========================================================================*/
/*   Function :   CloseForm_GetLogList                                     */
/*                                          QƃO̎擾ꗗʂ */
/*=========================================================================*/
Err CloseForm_GetLogList(UInt16 nextFormId)
{

    // Ƃ܂...
    ClearList_getLogList(NNshGlobal->dispList);
    MEMFREE_PTR(NNshGlobal->dispList);

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "CLOSE getloglist next: %d ", nextFormId);
#endif // #ifdef USE_REPORTER

    if (nextFormId != 0)
    {
        // ̉ʂJ...
        FrmGotoForm(nextFormId);
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function :   OpenForm_GetLogList                                      */
/*                                            QƃO̎擾ꗗʂJ */
/*=========================================================================*/
Err OpenForm_GetLogList(FormType  *frm)
{
    UInt16 update;

    // [N̈mۂ
    NNshGlobal->dispList = MEMALLOC_PTR(sizeof(NNshDispList) + MARGIN);
    if (NNshGlobal->dispList == NULL)
    {
        // [N̈̊mێs...
        return (~errNone);
    }
    MemSet(NNshGlobal->dispList, (sizeof(NNshDispList) + MARGIN), 0x00);

    // ꗗ(ݒ胍Oxɍ킹)XV
    if ((NNshGlobal->NNsiParam)->getROLogLevel == 0)
    {
        update = 0;
    }
    else
    {
         update = (NNshGlobal->NNsiParam)->getROLogLevel + 1;
    }

    // ʂɕ\f[^\z
    Show_BusyForm(MSG_FINDING_WAIT);
    createList_getLogList(update, NNshGlobal->dispList);
    Hide_BusyForm(false);

    // work1 ́A\f[^̃ACeAwork2́A\\Ci[
    // (NNshGlobal->NNsiParam)->getLogListPage      = 0;
    // (NNshGlobal->NNsiParam)->getLogListSelection = 0;
    NNshGlobal->work1 = 0;
    NNshGlobal->work2 = 0;

    RefreshDisplay_getLogList(frm, NNSH_STEP_NEWOPEN, (NNshGlobal->NNsiParam)->getLogListSelection);

    // JtH[IDݒ肷(ݒ蒆ɂ́AlastFrmID͕ύXȂ)
    if (((NNshGlobal->NNsiParam)->useBookmark != 0)&&((NNshGlobal->NNsiParam)->bookMsgNumber != 0))
    {
        // ݒ蒆Ȃ̂ŁAȂ
    }
    else
    {
        (NNshGlobal->NNsiParam)->lastFrmID = NNSH_FRMID_GETLOGLIST;
    }
    NNshGlobal->backFormId = FRMID_LISTGETLOG;
    return (errNone);
}
#endif  // #ifdef USE_LOGCHARGE
