/*============================================================================*
 *  FILE: 
 *     msgmgr.c
 *
 *  Description: 
 *     Message(Thread) manager for NNsh. 
 *
 *===========================================================================*/
#define MSGMGR_C
#include "local.h"
extern UInt32 CreateThreadIndexSub_ARM();

/*=========================================================================*/
/*   Function : CreateThreadIndexSub                                       */
/*                                              (CfbNX擾̎) */
/*=========================================================================*/
static Err createThreadIndexSub(Char   *buffer, UInt32 size, UInt32 offset,
                                UInt32 *nofMsg, UInt32 *msgOffset)
{
    Char *chkPtr, *ptr;
    
    chkPtr = buffer;
    while (chkPtr < buffer + size)
    {
        // bZ[W̋؂T
        ptr = chkPtr;
        while ((*ptr != '\x0a')&&(*ptr != '\0'))
        {
            ptr++;
        }
        if (*ptr != '\0')
        {
            ptr = ptr + 1;
            if (*nofMsg < (NNshGlobal->NNsiParam)->msgNumLimit)
            {
                (*nofMsg)++;
                msgOffset[(*nofMsg)] = (UInt32) ptr - (UInt32) buffer + offset;
                chkPtr = ptr;
            }
            else
            {
                return (~errNone - 1);
            }
        }
        else
        {
            // Ƃ肠ɂ
            chkPtr = ptr + 1;
        }
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function : get_subject_database                                       */
/*                                                         X擾  */
/*=========================================================================*/
Err Get_Subject_Database(UInt16 index, NNshSubjectDatabase *subjDB)
{
    Err       ret;
    DmOpenRef dbRef;

    // XǗDBI[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "OpenDatabase_NNsh() ", " ", 0);
        return (~errNone);
    }

    // Xf[^擾
    ret = GetRecord_NNsh(dbRef, index, sizeof(NNshSubjectDatabase), subjDB);
    if (ret != errNone)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "GetRecord_NNsh() ", " ", ret);
    }
    CloseDatabase_NNsh(dbRef);
    return (ret);
}

/*=========================================================================*/
/*   Function : MoveMessageToReadOnly                                      */
/*                                  (bZ[WQƃOXɈړ) */
/*=========================================================================*/
Err MoveMessageToReadOnly(UInt16 index)
{
    Err                 ret;
    NNshSubjectDatabase subjDb;

    ////////////////////  f[^x[X̏XXV  ////////////////////

    // ̈̏
    MemSet(&subjDb, sizeof(subjDb), 0x00);

    // f[^x[Xf[^擾
    ret = Get_Subject_Database(index, &subjDb);
    if (ret != errNone)
    {
        // 肦Ȃ͂H
        NNsh_DebugMessage(ALTID_ERROR, "get_subject_database()"," ", ret);
        return (ret);
    }

    // Xuǂ݂ݐpvɍXV
    MemSet (subjDb.boardNick, MAX_NICKNAME, 0x00);
    StrCopy(subjDb.boardNick, OFFLINE_THREAD_NICK);

    // f[^XV
    ret = update_subject_database(index, &subjDb);
    if (ret != errNone)
    {
        // 肦Ȃ͂...
        NNsh_DebugMessage(ALTID_ERROR, "update_subject_database()"," ", ret);
        return (ret);
    }
    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function : checkLogChargeThread                                       */
/*                                        (O`[WX`FbN) */
/*-------------------------------------------------------------------------*/
static void checkLogChargeThread(Char *fileName, NNshGetLogDatabase *dbData, UInt32 *tokenId) 
{
    DmOpenRef  dbRef;
    Char      *chkPtr;
    UInt16     recNum, depth;

    // O`[WOǂmF
    depth = 1;
    chkPtr = StrStr(fileName, FILE_LOGCHARGE_PREFIX);
    if (chkPtr != NULL)
    {
        // O`[WOƊmFAR[hԍ؂o
        chkPtr = chkPtr +  (sizeof(FILE_LOGCHARGE_PREFIX) - 1);
        recNum = StrAToI(chkPtr);
        if (recNum == NNSH_MSGNUM_UNKNOWN)
        {
            // f[^O`[WOł͂Ȃ
            // (Ńt@CtO)
            MemSet(dbData, sizeof(NNshGetLogDatabase), 0x00);
            *tokenId = 0;
            return;
        }

        // QƃO`[WpDB̎擾
        OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
        if (dbRef != 0)
        {
            // ODB̃I[vA؂oR[hԍf[^擾
            MemSet(dbData, sizeof(NNshGetLogDatabase), 0x00);

            // R[h̓ǂݏo
            GetRecord_NNsh(dbRef, recNum, sizeof(NNshGetLogDatabase), dbData);

            // f[^x[X
            CloseDatabase_NNsh(dbRef);
        }

        // 擾[xmF
        while (*chkPtr != '-')
        {
            chkPtr++;
        }
        chkPtr++;
        depth = StrAToI(chkPtr);
    }
    
    if (depth != 0)
    {
        // 擾[xႤꍇAf[^NA
        *tokenId = dbData->subTokenId;   
        MemSet(dbData, sizeof(NNshGetLogDatabase), 0x00);
    }
    else
    {
        *tokenId = dbData->tokenId;   
    }
    return;
}


/*-------------------------------------------------------------------------*/
/*   Function : createThreadIndexSub_HTML                                  */
/*                                            (HTMLpCfbNX) */
/*-------------------------------------------------------------------------*/
static Err createThreadIndexSub_HTML(Char *buffer, UInt32 size, UInt32 offset,
                                      UInt32 *nofMsg, UInt32 *msgOffset, 
                                      Char *fileName, UInt16 kanjiCode, 
                                      UInt16 *status, UInt32 tokenId)
{
    Char *chkPtr, *ptr, *start, *end, *token, dummy, *orgPtr;
 
    NNshLogTokenDatabase *rec;
    
    NNsh_DebugMessage(ALTID_INFO, "createThreadIndexSub_HTML", "", 0);

    // f[^̖
    if (*status == NNSH_MSGTOKENSTATE_END)
    {
        // ؂f[^̖܂ŌĂяoĂAbZ[W͏Ȃ
        return (errNone);
    }

    rec = MEMALLOC_PTR(sizeof(NNshLogTokenDatabase) + MARGIN);
    if (rec == NULL)
    {
        // f[^w肳ĂȂƂAf[^_~[ɒu
        dummy  = 0;
        start = &dummy;
        end   = &dummy;
        token = &dummy;
    }
    else
    {
        MemSet(rec, (sizeof(NNshLogTokenDatabase) + MARGIN), 0x00);
#ifdef USE_LOGCHARGE
        if (GetLogToken(tokenId, rec) != errNone)
        {
            // f[^w肳ĂȂƂAf[^_~[ɒu
            dummy  = 0;
            start = &dummy;
            end   = &dummy;
            token = &dummy;
            MEMFREE_PTR(rec);
            rec = NULL;
        }
        else
        {
            start = rec->startToken;
            end   = rec->endToken;
            token = rec->dataToken;
        }
#else   // #ifdef USE_LOGCHARGE
        {
            // f[^w肳ĂȂƂAf[^_~[ɒu
            dummy  = 0;
            start = &dummy;
            end   = &dummy;
            token = &dummy;
            MEMFREE_PTR(rec);
            rec = NULL;
        }
#endif   // #ifdef USE_LOGCHARGE
    }

    // f[^̐擪
    chkPtr = buffer;
    if (*status == NNSH_MSGTOKENSTATE_NONE)
    {
        //  擪̋؂蕶T
        if (*start != 0)
        {
            ptr = StrStr(buffer, start);
            if (ptr == NULL)
            {
                // f[^擪̋؂肪ȂA͏I
                MEMFREE_PTR(rec);
                return (errNone);
            }
            ptr = ptr + StrLen(start);
            msgOffset[0] = ((UInt32) (ptr - buffer)) + offset;
            chkPtr = ptr;
            *status = NNSH_MSGTOKENSTATE_MESSAGE;
        }
        else
        {
            *status = NNSH_MSGTOKENSTATE_MESSAGE;
        }
    }
    if (*status == NNSH_MSGTOKENSTATE_MESSAGE)
    {
        // ̋؂蕶Ă邩T
        if (*end != 0)
        {
            ptr = StrStr(buffer, end);
            if (ptr != NULL)
            {
                // f[^𔭌I f[^͂܂łƂ
                *status = NNSH_MSGTOKENSTATE_END;
                size = (ptr - buffer) + StrLen(end);
            }
        }
    }

    // f[^̋؂蕶T
    if (*token != 0)
    {
        while (chkPtr < buffer + size)
        {
            // bZ[W̋؂T
            ptr = StrStr(chkPtr, token);
            if (ptr == NULL)
            {
                // ؂肪ȂA͏I
                break;
            }
            ptr = ptr + StrLen(token);
            if (*nofMsg < (NNshGlobal->NNsiParam)->msgNumLimit)
            {
                (*nofMsg)++;
                msgOffset[(*nofMsg)] = (UInt32) ptr - (UInt32) buffer + offset;
                chkPtr = ptr;
            }
            else
            {
                // bZ[W̊i[\ȍő吔𒴂(I[ot[\)
                NNsh_WarningMessage(ALTID_WARN, "Index Number overflow", "", 0);
                MEMFREE_PTR(rec);
                return (~errNone - 1);
            }
        }
    }
    else
    {
        // ̃p[X(BIGBUF * 2(1280bytes)ŁACfbNX쐬)
        // Ag[N'>'ŋ؂B
        ptr = chkPtr;
        while(chkPtr < buffer + size)
        {
            ptr = ptr + BIGBUF * 2;
            if (ptr > buffer + size)
            {
                ptr = buffer + size;
            }
            orgPtr = ptr;
            if (kanjiCode == NNSH_KANJICODE_JIS)
            {
                // JISR[ĥƂAAA
                while ((*ptr != '\0')&&(ptr > buffer))
                {
                    // JISR[hł́A^ÕR[h邽߁AsR[hŐ؂
                    if (*ptr == 0x0a)
                    {
                        ptr++;
                        break;
                    }
                    // GXP[vł؂
                    if (*ptr == 0x1b)
                    {
                        break;
                    }
                    ptr--;
                }
            }
            else
            {
                // R[hJISȊO
                while ((*ptr != '\0')&&(ptr > chkPtr))
                {
                    // ^O܂͉sR[hŐ؂ 
                    if ((*ptr == '>')||(*ptr == '\x0a'))
                    {
                        ptr++;
                        break;
                    }
                    ptr--;
                }
                if (ptr == chkPtr)
                {
                    // ^O܂܂ĂȂ...
                    ptr = orgPtr;
                }
            }

            if (*nofMsg < (NNshGlobal->NNsiParam)->msgNumLimit)
            {
                (*nofMsg)++;
                msgOffset[(*nofMsg)] = (UInt32) ptr - (UInt32) buffer + offset;
                chkPtr = ptr;
            }
            else
            {
                // bZ[W̊i[\ȍő吔𒴂(I[ot[\)
                NNsh_WarningMessage(ALTID_WARN, "Index Number overflow", "", 0);
                MEMFREE_PTR(rec);
                return (~errNone - 1);
            }
        }
    }
    MEMFREE_PTR(rec);
    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function : createThreadIndexSub_MachiBBS                              */
/*                            (CfbNX擾̎:܂BBSp`[) */
/*-------------------------------------------------------------------------*/
static Err createThreadIndexSub_MachiBBS(Char  *buffer,    UInt32  size,
                                         UInt32  offset,    UInt32 *nofMsg, 
                                         UInt32 *msgOffset, UInt16 endTokenType, 
                                         Char   *start,     Char   *end)
{
    Char   *chkPtr, *ptr;
    
    chkPtr = buffer;

    // 擪ǂݏoƂAbZ[W̐擪肷
    if (*nofMsg == 0)
    {
        ptr = StrStr(chkPtr, start);
        if (ptr == NULL)
        {
            // ؂肪ȂA͏I(G[)
            NNsh_DebugMessage(ALTID_ERROR, "Not Found Message Top :", start, 0);
            return (~errNone - 2);
        }
        ptr = ptr + StrLen(start);
        msgOffset[0] = ((UInt32) (ptr - buffer)) + offset;
        chkPtr = ptr;
    }
    while (chkPtr < buffer + size)
    {
        // bZ[W̋؂T
        ptr = StrStr(chkPtr, end);
        if (ptr == NULL)
        {
            // ؂肪ȂA͏I
            break;
        }

        // ؂g[N^Cv̎wmF
        if (endTokenType != NNSH_DISABLE)
        {
            // ؂g[N^Cv̎w肪ꍇ...

            // ؂g[N̑Oɂf[^mF
            if ((endTokenType & NNSH_TOKEN_BEFORE_NUMBER) == NNSH_TOKEN_BEFORE_NUMBER)
            {
                // ؂g[N̑Of[^͐łȂ΂ȂȂ
                if ((*(ptr - 1) < '0')||(*(ptr - 1) > '9'))
                {
                    // ؂g[Nł͂ȂA
                    chkPtr = ptr + StrLen(end);
                    continue;
                }
            }
            if ((endTokenType & NNSH_TOKEN_BEFORE_LETTER) == NNSH_TOKEN_BEFORE_LETTER)
            {
                // ؂g[N̑Of[^͕łȂ΂ȂȂ
                if (*(ptr - 1) <= ' ')
                {
                    // ؂g[Nł͂ȂA
                    chkPtr = ptr + StrLen(end);
                    continue;
                }
            }

            // ؂g[N̎Ƀ|C^i߂
            ptr = ptr + StrLen(end);

            // ؂g[Ňɂf[^mF
            if ((endTokenType & NNSH_TOKEN_AFTER_NUMBER) == NNSH_TOKEN_AFTER_NUMBER)
            {
                // ؂g[Ňf[^͐łȂ΂ȂȂ
                if ((*(ptr + 1) < '0')||(*(ptr + 1) > '9'))
                {
                    // ؂g[Nł͂ȂA
                    chkPtr = ptr;
                    continue;
                }
            }
            if ((endTokenType & NNSH_TOKEN_AFTER_LETTER) == NNSH_TOKEN_AFTER_LETTER)
            {
                // ؂g[Ňf[^͕łȂ΂ȂȂ
                if (*(ptr + 1) <= ' ')
                {
                    // ؂g[Nł͂ȂA
                    chkPtr = ptr;
                    continue;
                }
            }
        }
        else
        {
            // ؂f[^^Cv̎w肪Ȃꍇɂ́A
            // ɋ؂ƔfA؂g[N̎Ƀ|C^i߂
            ptr = ptr + StrLen(end);
        }

        if (*nofMsg < (NNshGlobal->NNsiParam)->msgNumLimit)
        {
            (*nofMsg)++;
            msgOffset[(*nofMsg)] = (UInt32) ptr - (UInt32) buffer + offset;
            chkPtr = ptr;
        }
        else
        {
            // bZ[W̊i[\ȍő吔𒴂(I[ot[\)
            NNsh_WarningMessage(ALTID_WARN, "Index Number overflow", "", 0);
            return (~errNone - 1);
        }
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function : createMessageThreadIndex                                   */
/*                                (bZ[WXbh̃CfbNX쐬)   */
/*=========================================================================*/
Err CreateMessageThreadIndex(NNshMessageIndex *index, UInt32 *nofMsg,
                             UInt32 *msgOffset, UInt16 bbsType)
{
    Err          ret = errNone;
    UInt32       fileSize, readSize, chkPoint;
    Char        *bufPtr, *ptr;
    NNshGetLogDatabase *dbData;
#ifdef USE_ARMLET
    UInt32       armArgs[7];
    MemHandle    armH;
    void        *armP;

    // ARMlet̊֐|C^擾
    armH = 0;
    armP = NULL;
    if ((NNshGlobal->NNsiParam)->useARMlet != 0)
    {
        armH = DmGetResource('armc', RSCID_createThreadIndexSub_ARM);
        if (armH != 0)
        {
            armP = MemHandleLock(armH);
        }
    }
#endif

    // CfbNX쐬\
    Show_BusyForm(MSG_CREATE_MESSAGE_IDX);

    dbData = NULL;
    if ((bbsType & NNSH_BBSTYPE_MASK)  == NNSH_BBSTYPE_HTML)
    {
        // html^Cvf[^̂Ƃ́ADB擾Ă
        dbData = MEMALLOC_PTR(sizeof(NNshGetLogDatabase) + MARGIN);
        if (dbData != NULL)
        {
            MemSet(dbData, sizeof(NNshGetLogDatabase), 0x00);

            // O`[W̃Xǂ`FbN
            checkLogChargeThread(index->threadFile, dbData, &fileSize);
            if (NNshGlobal->tokenId == 0)
            {
                // ̃CfbNX̓f[^p[^ɔf
                NNshGlobal->tokenId = fileSize;
            }

            // x[XɂȂURL̐؂os
            if (dbData->dataURL[0] != 0x00)
            {
                StrNCopy(index->baseURL, dbData->dataURL, MAX_URL);
                for (ptr = index->baseURL + StrLen(index->baseURL) - 1;
                     ((*ptr != '/')&&(ptr > index->baseURL)); ptr--)
                {
                    // Ȃ
                }
                ptr++;
                *ptr = '\0';
            }
        }
    }

    // ꎞIɓǂݍޗ̈̏
    bufPtr   = index->buffer;
    *nofMsg  = 0;
    fileSize = 0;
    while (fileSize < index->fileSize)
    {
        MemSet(bufPtr, (NNshGlobal->NNsiParam)->bufferSize, 0x00);
        readSize = 0;
        ret      = ReadFile_NNsh(&(index->fileRef), fileSize,
                                 (NNshGlobal->NNsiParam)->bufferSize, bufPtr, &readSize);
        switch (ret)
        {
            case vfsErrFileEOF:
            case fileErrEOF:
            case errNone:
              // read OK, create Index!
              break;

            default:
              // read failure!
              goto FUNC_END;
              break;
        }
        switch (bbsType & NNSH_BBSTYPE_MASK)
        {
          case NNSH_BBSTYPE_MACHIBBS:
            //  ܂BBS/΁iaar̓g[N߁Ag[N
            // rŃobt@sƂ̑΍ꂽ()B
            if (ret == errNone)
            {
                chkPoint = readSize - sizeof(NNSH_MACHITOKEN_END) + 2;
            }
            else
            {
                chkPoint = readSize;
            }
            //  ܂BBS̃CfbNX͏(html)
            ret = createThreadIndexSub_MachiBBS(index->buffer, readSize,
                                                fileSize, nofMsg, msgOffset,
                                                NNSH_DISABLE,
                                                NNSH_MACHITOKEN_START,
                                                NNSH_MACHITOKEN_END);
            readSize = chkPoint;
            break;

          case NNSH_BBSTYPE_SHITARABAJBBS_OLD:
            //  ܂BBS/΁iaar̓g[N߁Ag[N
            // rŃobt@sƂ̑΍ꂽ()B
            if (ret == errNone)
            {
                chkPoint = readSize - sizeof(NNSH_JBBSTOKEN_END) + 2;
            }
            else
            {
                chkPoint = readSize;
            }
            //  ܂BBS̃CfbNX͏(html)
            ret = createThreadIndexSub_MachiBBS(index->buffer, readSize,
                                                fileSize, nofMsg, msgOffset,
                                                NNSH_DISABLE,
                                                NNSH_JBBSTOKEN_START,
                                                NNSH_JBBSTOKEN_END);
            readSize = chkPoint;
            break;

          case NNSH_BBSTYPE_SHITARABAJBBS_RAW:
            //  ܂BBS/΁iaar̓g[N߁Ag[N
            // rŃobt@sƂ̑΍ꂽ()B
            if (ret == errNone)
            {
                chkPoint = readSize - sizeof(NNSH_JBBSTOKEN_RAW_END_RES) + 2;
            }
            else
            {
                chkPoint = readSize;
            }
            //  ܂BBS̃CfbNX͏(html)
            ret = createThreadIndexSub_MachiBBS(index->buffer, readSize,
                                                fileSize, nofMsg, msgOffset,
                                                (NNSH_TOKEN_BEFORE_LETTER),
                                                NNSH_JBBSTOKEN_RAW_START_RES,
                                                NNSH_JBBSTOKEN_RAW_END_RES);
            readSize = chkPoint;
            break;

          case NNSH_BBSTYPE_HTML:
            // HTML^CṽCfbNX
            ret = createThreadIndexSub_HTML(index->buffer, readSize, 
                                            fileSize, nofMsg, msgOffset,
                                            index->threadFile, 
                                            ((bbsType & NNSH_BBSTYPE_CHARSETMASK) >> NNSH_BBSTYPE_CHAR_SHIFT),
                                            &(index->msgStatus), NNshGlobal->tokenId);
           break;

          case NNSH_BBSTYPE_2ch:
          case NNSH_BBSTYPE_SHITARABA:
          case NNSH_BBSTYPE_OTHERBBS:
          default:
            //  2˂/΂̃CfbNX͏(datǂ)
#ifdef USE_ARMLET
            if (armP != NULL)
            {
                // ARMletgpẴCfbNX͏
                MemSet(armArgs, sizeof(armArgs), 0x00);
                armArgs[0] = (UInt32) msgOffset;
                armArgs[1] = (UInt32) nofMsg;
                armArgs[2] = (UInt32) fileSize;
                armArgs[3] = (UInt32) (NNshGlobal->NNsiParam)->msgNumLimit;
                armArgs[4] = (UInt32) readSize;
                armArgs[5] = (UInt32) index->buffer;
                ret        = (Err) PceNativeCall(armP, armArgs);
            }
            else
#endif
            {
                // ARMletgpȂꍇ̃CfbNX͏
                ret = createThreadIndexSub(index->buffer, readSize,
                                           fileSize, nofMsg, msgOffset);
            }
            break;
        }
        if (ret != errNone)
        {
            // CfbNXI[ot[(肦Ȃ͂...)Arł߂
            // bZ[W̊i[\ȍő吔𒴂(I[ot[\)
            NNsh_WarningMessage(ALTID_WARN, "Index Number overflow", "", 0);

            // Ƃ肠ǂ߂悤ɂ(errNoneɒu)
            ret = errNone;
            break;
        }

        // ǂݍ݈ʒu fileSizeɐݒ肷B
        fileSize = fileSize + readSize;        
    }

FUNC_END:
#ifdef USE_ARMLET
    // ARMlet̊֐
    if (armP != NULL)
    {
        MemHandleUnlock(armH);
    }
    if (armH != 0)
    {
        DmReleaseResource(armH);
    }
#endif
    MEMFREE_PTR(dbData);
    Hide_BusyForm(true);
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function : getLastMessageNumShitaraba                                 */
/*                                 XɊi[Ă郌X̍ő吔擾  */
/*-------------------------------------------------------------------------*/
Err getLastMessageNumShitaraba(UInt16 *resNum)
{
    Err           ret;
    UInt32        fileSize, offset, readSize;
    Char         *realBuf, *ptr, *bottom;
    NNshFileRef   fileRef;

    // 
    *resNum = 1;

    // "bZ[Wϊ" \s
    Show_BusyForm(MSG_MESSAGE_CHECK_LAST);

    // ꎞobt@̈m
    realBuf = MEMALLOC_PTR((NNshGlobal->NNsiParam)->bufferSize + MARGIN);
    if (realBuf == NULL)
    {
        // ꎞ̈̊mۂɎs
        Hide_BusyForm(false);
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:",
                          (NNshGlobal->NNsiParam)->bufferSize + MARGIN);
        return (~errNone);
    }
    MemSet(realBuf, ((NNshGlobal->NNsiParam)->bufferSize + MARGIN), 0x00);

    // ǂݏot@C̃I[v
    ret = OpenFile_NNsh(FILE_RECVMSG,
                        (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                        &fileRef);
    if (ret != errNone)
    {
        Hide_BusyForm(false);
        NNsh_DebugMessage(ALTID_ERROR, "Read File Open :", FILE_RECVMSG, ret);
        return (ret);
    }

    // MbZ[WTCY擾
    GetFileSize_NNsh(&fileRef, &fileSize);

    // t@C̓ǂݏoʒuݒ肷
    if (fileSize <= (NNshGlobal->NNsiParam)->bufferSize)
    {
        offset = 0;
    }
    else
    {
        offset = fileSize - (NNshGlobal->NNsiParam)->bufferSize;
    }

    // t@Cf[^ǂݏo(t@C̖)
    ret = ReadFile_NNsh(&fileRef, offset, (NNshGlobal->NNsiParam)->bufferSize, realBuf, &readSize);
    CloseFile_NNsh(&fileRef);
    if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
    {        
        NNsh_InformMessage(ALTID_ERROR, "ReadFile_NNsh :",  FILE_RECVMSG, ret);
        goto END_FUNC;
    }

    //////////////////////////////////////////// Xԍ̌
    ptr = realBuf + readSize;
    while ((ptr - 1) > realBuf)
    {
        // XԍLĂT(obt@ɂ/\x0a[0-9]+<>/)
        if (((*ptr >= '0')&&(*ptr <= '9'))&&(*(ptr - 1) == '\x0a'))
        {
            // lf[^؂o
            bottom = ptr;
            while ((*bottom >= '0')&&(*bottom <= '9'))
            {
                bottom++;
            }
            if ((*bottom == '<')&&(*(bottom + 1) == '>'))
            {
                *bottom = '\0';
                *resNum = StrAToI(ptr);
                goto END_FUNC;
            }
        }
        ptr--;         
    }
    ////////////////////////////////////////////

END_FUNC:    
    MEMFREE_PTR(realBuf);
    Hide_BusyForm(false);

    NNsh_DebugMessage(ALTID_INFO, "RES NUM :",  "", *resNum);
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function : update_subject_database                                    */
/*                                                         XXV  */
/*-------------------------------------------------------------------------*/
Err update_subject_database(UInt16 index, NNshSubjectDatabase *subjDB)
{
    Err       ret;
    DmOpenRef dbRef;

    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "OpenDatabase_NNsh() ", " ", 0);
        return (~errNone);
    }

    // Xf[^XV
    ret = UpdateRecord_NNsh(dbRef,index,sizeof(NNshSubjectDatabase),subjDB);
    if (ret != errNone)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "GetRecord_NNsh() ", " ", ret);
    }
    CloseDatabase_NNsh(dbRef);

    // XꗗDBXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_SUBJECT));

    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   NNshMSG_entryDatabase                                    */
/*                                                bZ[WDBɓo^ */
/*-------------------------------------------------------------------------*/
static void message_entryDatabase(UInt16 idxMES,UInt32 fileSize,UInt16 bbsType)
{
    Err                 ret;
    NNshSubjectDatabase subjDb;

    // ̈̏
    MemSet(&subjDb, sizeof(subjDb), 0x00);

    if (idxMES != NNSH_NOTENTRY_THREAD)
    {
        // f[^x[Xf[^擾
        ret = Get_Subject_Database(idxMES, &subjDb);
        if (ret != errNone)
        {
            // 肦Ȃ͂H
            NNsh_DebugMessage(ALTID_ERROR, "get_subject_database()"," ", ret);
            return;
        }
    }

    ///// DBɏރf[^쐬 /////

    // Ԓlق
    if (fileSize != 0)
    {
        subjDb.state        = NNSH_SUBJSTATUS_NEW;
        subjDb.currentLoc   = 1;
        subjDb.fileSize     = fileSize;
        subjDb.bbsType      = (UInt8) bbsType;
        subjDb.msgAttribute = (subjDb.msgAttribute & NNSH_MSGATTR_NOTERROR);

        // X̋L^o^
        if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) != 0)
        {
            // XL^VFS
            subjDb.msgState = FILEMGR_STATE_OPENED_VFS;
        }
        else
        {    
            // XL^Palm{
            subjDb.msgState = FILEMGR_STATE_OPENED_STREAM;
        }

        // ΁JBBS(rawmode)̂Ƃ́AXԍ擾
        if (bbsType == NNSH_BBSTYPE_SHITARABAJBBS_RAW)
        {
            // ̃Xԍ擾
            (void) getLastMessageNumShitaraba(&(subjDb.maxLoc));
        }
    }
    else
    {
        subjDb.state      = NNSH_SUBJSTATUS_NOT_YET;
        subjDb.currentLoc = 0;
        subjDb.fileSize   = 0;
        subjDb.bbsType    = (UInt8) bbsType;
    }

    // f[^XV
    ret = update_subject_database(idxMES, &subjDb);
    if (ret != errNone)
    {
        // 肦Ȃ͂...
        NNsh_DebugMessage(ALTID_ERROR, "update_subject_database()","",ret);
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   NNshMSG_entryMessage                                     */
/*                                                  bZ[WϊAo^ */
/*-------------------------------------------------------------------------*/
static Err message_entryMessage(Char *targetFile, UInt32 *dataSize, UInt16 bbsType)
{
    Err           ret;
    Boolean       deleteLogFile;
    UInt32        fileSize, offset, readSize, writeSize, chkSize;
    Char         *buffer, *ptr, *realBuf, *bakPtr;
    NNshFileRef  fileRefR, fileRefW;

    deleteLogFile = false;
    fileSize  = 0;
    offset    = 0;

    // "bZ[Wϊ" \s
    Show_BusyForm(MSG_MESSAGE_ENTRY);

    // f[^TCY
    *dataSize = 0;

    // ǂݏot@C̃I[v
    ret = OpenFile_NNsh(FILE_RECVMSG,
                        (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                        &fileRefR);
    if (ret != errNone)
    {
        Hide_BusyForm(false);
        NNsh_DebugMessage(ALTID_ERROR, "Read File Open :", FILE_RECVMSG, ret);
        return (ret);
    }

    // ꎞobt@̈m
    realBuf = MEMALLOC_PTR((NNshGlobal->NNsiParam)->bufferSize + MARGIN);
    if (realBuf == NULL)
    {
        // ꎞ̈̊mۂɎs
        Hide_BusyForm(false);
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:",
                          (NNshGlobal->NNsiParam)->bufferSize + MARGIN);
        CloseFile_NNsh(&fileRefR);
        return (~errNone);
    }
    buffer = realBuf;
    MemSet(buffer, ((NNshGlobal->NNsiParam)->bufferSize + MARGIN), 0x00);

    // MbZ[WTCY擾
    GetFileSize_NNsh(&fileRefR, &fileSize);

    // 󂫗eʂ̊mF(VFŜ)
    if (CheckFileSpace_NNsh(NNSH_DISABLE, fileSize) != errNone)
    {
        // 󂫗eʕsAIB
        ret = ~errNone - 10;
        goto END_FUNC;
    }

    // f[^̓ǂݍ
    ret = ReadFile_NNsh(&fileRefR, offset,
                        (NNshGlobal->NNsiParam)->bufferSize, buffer, &readSize);
    if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
    {        
        NNsh_DebugMessage(ALTID_ERROR, "ReadFile_NNsh :",  FILE_RECVMSG, ret);
        goto END_FUNC;
    }
    ret = errNone;

    // _E[h́At@C̍Ō׍H(ƎԂ邯)
    if ((NNshGlobal->NNsiParam)->enablePartGet != 0)
    {
        while ((readSize != 0)&&
               (*((Char *) (buffer + readSize - 1)) != '\x0a'))
        {
            readSize--;
        }
        // IɎMt@CTCYbZ[W̍ŌɒB
        fileSize = readSize;
    }

    // HTTPwb_̏I
    ptr = StrStr(buffer, NNSH_HTTP_HEADER_ENDTOKEN);
    if (ptr == NULL)
    {
        // {fBf[^Ȃ
        NNsh_DebugMessage(ALTID_ERROR, "Wrong data(not found separator,",
                          "[\xd\xa\xd\xa])", 0);
        ret = ~errNone + 3;
        goto END_FUNC;
    }

    // HTTP̉R[h`FbN(HTTP/1.[01] 20[06])
    //   StrLen("HTTP/1.1 200") ==> 12 ɒu(̂)
#ifdef USE_STRNCOMPARE
    if ((StrNCompare(buffer,"HTTP/1.1 200",12) != 0)&&
        (StrNCompare(buffer,"HTTP/1.1 206",12) != 0)&&
        (StrNCompare(buffer,"HTTP/1.0 206",12) != 0)&&
        (StrNCompare(buffer,"HTTP/1.0 200",12) != 0))
#else
    if ((buffer[0] != 'H')||(buffer[1] != 'T')||(buffer[2] != 'T')||
        (buffer[3] != 'P')||(buffer[4] != '/')||(buffer[5] != '1')||
        (buffer[6] != '.')||((buffer[7] != '1')&&(buffer[7] != '0'))||
        (buffer[8] != ' ')||(buffer[9] != '2')||(buffer[10] != '0')||
        ((buffer[11] != '0')&&(buffer[11] != '6')))
#endif
    {
#ifdef USE_STRSTR
        ptr = StrStr(buffer, "\x0a");
#else
        ptr = buffer;
        while ((*ptr != '\x0a')&&(*ptr != '\0'))
        {
            ptr++;
        }
#endif
        *ptr = '\0';
        if (*(ptr - 1) == '\x0d')
        {
            *(ptr - 1) = '\0';
        }
        // T[oX|Xُ
        NNsh_InformMessage(ALTID_ERROR, MSG_RECV_NOTACCEPTED, buffer, 0);
        ret = ~errNone + 10;
        goto END_FUNC;
    }
    ptr = ptr + 4;
    *dataSize = fileSize - (ptr - buffer);

    switch (bbsType)
    {
      case NNSH_BBSTYPE_MACHIBBS:
#if 0
        //  ܂BBŜƂɂ́AbZ[W̐擪܂Ńf[^
        // ǂݔ΂s
        bakPtr = ptr;
        ptr = StrStr(ptr, NNSH_MACHITOKEN_START);
        if (ptr == NULL)
        {
            ptr = bakPtr;
        }
#endif
        break;

      case NNSH_BBSTYPE_SHITARABAJBBS_OLD:
#if 0
        bakPtr = ptr;
        ptr = StrStr(ptr, NNSH_JBBSTOKEN_START);
        if (ptr == NULL)
        {
            ptr = bakPtr;
        }
#endif
        break;

      case NNSH_BBSTYPE_SHITARABAJBBS_RAW:
        bakPtr = ptr;
        ptr = StrStr(ptr, NNSH_JBBSTOKEN_RAW_START);
        if (ptr == NULL)
        {
            ptr = bakPtr;
        }
        else
        {
            // ptr = ptr + StrLen(NNSH_JBBSTOKEN_RAW_START);
            // f[^̐擪<>ɒuB
            *ptr       = '<';
            *(ptr + 1) = '>';
        }

        // [MEMO]
        // Mt@C̃TCY炷H(7oCgĂ͗l...)
        //
        break;

      case NNSH_BBSTYPE_2ch:
      case NNSH_BBSTYPE_SHITARABA:
      case NNSH_BBSTYPE_OTHERBBS:
      default:
        // ȂɂȂ
        break;
    }

    // f[^݂̃`FbN(ނɒ)
    if (((UInt32) ptr & 1)&&((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_WORKAROUND))
    {
        ptr--;
        *ptr = ' ';
    }

    chkSize = readSize - (ptr - buffer);
    if (((chkSize % 2) == 1)&&((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_WORKAROUND))
    {
        if (ptr[chkSize - 1] == '\x0a')
        {
            ptr[chkSize]     = ptr[chkSize - 1];
            ptr[chkSize - 1] = ' ';
            NNsh_DebugMessage(ALTID_WARN, "APPEND SPACE(pre)", "", chkSize);
        }
        else
        {
            ptr[chkSize]     = ' ';
            NNsh_DebugMessage(ALTID_WARN, "APPEND SPACE(post)", "", chkSize);
        }
        chkSize++;
    }

    // Ƀt@C݂ꍇ͈U폜ĂI[vB
    (void) DeleteFile_NNsh(targetFile, NNSH_VFS_ENABLE);
    ret = OpenFile_NNsh(targetFile,
                        NNSH_FILEMODE_APPEND, &fileRefW);
    if (ret != errNone)
    {
        // ݃t@C̃I[vɎs
        NNsh_InformMessage(ALTID_ERROR,
                           MSG_WRITEFILE_OPENFAIL, targetFile, ret);
        deleteLogFile = false;
        *dataSize = 0;
        goto END_FUNC;
    }

    // f[^̏(ǋL)
    ret = AppendFile_NNsh(&fileRefW, chkSize, ptr ,&writeSize);
    if (ret != errNone)
    {
        CloseFile_NNsh(&fileRefW);
        NNsh_InformMessage(ALTID_ERROR, "WriteFile_NNsh(1st)", "", ret);
        deleteLogFile = true;
        *dataSize = 0;
        ret = ~errNone + 11;
        goto END_FUNC;
    }
    offset = readSize;

    // f[^ŌɂȂ܂ŒǋL
    while (offset < *dataSize)
    {
        MemSet(buffer, (NNshGlobal->NNsiParam)->bufferSize + MARGIN, 0x00);
        readSize = 0;
        ret = ReadFile_NNsh(&fileRefR, offset, (NNshGlobal->NNsiParam)->bufferSize,
                            buffer, &readSize);
        if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
        {        
            NNsh_InformMessage(ALTID_ERROR, "ReadFile_NNsh()", "", ret);
            deleteLogFile = true;
            *dataSize = 0;
            break;
        }
        ret = errNone;
        chkSize = 0;
        if (((readSize % 2) == 1)&&((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_WORKAROUND))
        {
            if (ptr[readSize - 1] == '\x0a')
            {
                buffer[readSize]     = buffer[readSize - 1];
                buffer[readSize - 1] = ' ';
                NNsh_DebugMessage(ALTID_WARN, "APPEND spase(pre)", "",
                                  readSize);
            }
            else
            {
                buffer[readSize] = ' ';
                NNsh_DebugMessage(ALTID_WARN, "APPEND spase(post)",
                                  "", readSize);
            }
            chkSize++;
        }
        ret = AppendFile_NNsh(&fileRefW, readSize+chkSize, buffer, &writeSize);
        if (ret != errNone)
        {
            NNsh_InformMessage(ALTID_ERROR, "AppendFile_NNsh()", "", ret);
            deleteLogFile = true;
            *dataSize = 0;
            break;
        }
        offset = offset + readSize;
    }
    CloseFile_NNsh(&fileRefW);

END_FUNC:
    CloseFile_NNsh(&fileRefR);
    MEMFREE_PTR(realBuf);
    if (deleteLogFile != false)
    {
        // r[ȃOt@CcĂƂɂ́At@C폜B
        (void) DeleteFile_NNsh(targetFile, NNSH_VFS_ENABLE);
    }
    Hide_BusyForm(false);

    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   NNshMSG_appendMessage                                    */
/*                                            bZ[WϊAo^(ǋL) */
/*-------------------------------------------------------------------------*/
static Err message_appendMessage(Char *targetFile, NNshSubjectDatabase *mesDB)
{
    Err          ret;
    UInt32       fileSize, offset, readSize, writeSize, parseSize,chkSize;
    Char        *buffer, *ptr, *realBuf, tmpBuf[TINYBUF + MARGIN], *tmpPtr;
    NNshFileRef  fileRefR, fileRefW;

    // f[^o^\
    Show_BusyForm(MSG_MESSAGE_ENTRY);

    ret = OpenFile_NNsh(FILE_RECVMSG,
                        (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                        &fileRefR);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Read File Open :",FILE_RECVMSG, ret);
    }

    // ꎞobt@̈m
    realBuf = MEMALLOC_PTR((NNshGlobal->NNsiParam)->bufferSize + MARGIN);
    if (realBuf == NULL)
    {
        NNsh_DebugMessage(ALTID_ERROR, "MEMALLOC_PTR()", " size:",
                          (NNshGlobal->NNsiParam)->bufferSize + MARGIN);
        ret = errNone - 10;
        goto END_FUNC;
    }
    buffer = realBuf;

    // MbZ[W̃TCY擾(wb_)
    GetFileSize_NNsh(&fileRefR, &fileSize);

    // 󂫗eʂ̊mF(VFŜ)
    if (CheckFileSpace_NNsh(NNSH_DISABLE, fileSize) != errNone)
    {
        // 󂫗eʕsAIB
        ret = ~errNone;
        goto END_FUNC;
    }

    parseSize = 0;
    readSize  = 0;
    offset    = 0;

    // f[^̓ǂݍ
    MemSet(buffer, (NNshGlobal->NNsiParam)->bufferSize + MARGIN, 0x00);
    ret = ReadFile_NNsh(&fileRefR, offset, (NNshGlobal->NNsiParam)->bufferSize,
                        buffer, &readSize);
    if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
    {
        NNsh_InformMessage(ALTID_ERROR, "ReadFile_NNsh()", "", ret);

        goto END_FUNC;
    }

    // _E[h́At@C̍Ō׍H(ƎԂ邯)
    if ((NNshGlobal->NNsiParam)->enablePartGet != 0)
    {
        while ((readSize != 0)&&
               (*((Char *) (buffer + readSize - 1)) != '\x0a'))
        {
            readSize--;
        }
        // IɎMt@CTCYbZ[W̍ŌɒB
        fileSize = readSize;
    }

    // HTTP{fB
    ptr = StrStr(buffer, NNSH_HTTP_HEADER_ENDTOKEN);
    if (ptr == NULL)
    {
        // f[^ُ
        NNsh_InformMessage(ALTID_ERROR, "ERR>Wrong data(not found separator,",
                           "(" NNSH_HTTP_HEADER_ENDTOKEN ")", 0);
        goto END_FUNC;
    }
    parseSize = ptr - buffer;
    ptr       = ptr + 4;
    parseSize = parseSize + 4;

    // @JBBS(rawmode)ȊÓA`FbN
    if (mesDB->bbsType != NNSH_BBSTYPE_SHITARABAJBBS_RAW)
    {
        // HTTP̉R[h`FbN (𐔎݂̂ɂ)
        // StrLen("HTTP/1.1 200") ==> 12 ɒu(̂)
        // if ((StrNCompare(buffer,"HTTP/1.1 200 OK", 12) == 0)||
        //    (StrNCompare(buffer,"HTTP/1.0 200 OK", 12) == 0))
        if ((buffer[9] == '2')&&(buffer[10] == '0')&&(buffer[11] == '0'))
        {
            // Ȃ񂩒m񂯂ǁASbZ[Wł(ȁH)B
            CloseFile_NNsh(&fileRefR);
            MEMFREE_PTR(realBuf);
            Hide_BusyForm(false);

            // bZ[WׂĂłƂDEBUG\
            NNsh_DebugMessage(ALTID_INFO, "Received ALL MESSAGE!! ", targetFile, 0);

            // ׂẴf[^M鏈ɐ؂ւ
            ret = errNone;
            ret = message_entryMessage(targetFile, &fileSize, NNSH_BBSTYPE_2ch);
            mesDB->state      = NNSH_SUBJSTATUS_NEW;
            mesDB->fileSize   = fileSize;

            // X̋L^o^
            if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) != 0)
            {    
                // XL^VFS
                mesDB->msgState = FILEMGR_STATE_OPENED_VFS;
            }
            else
            {    
                // XL^Palm{
                mesDB->msgState = FILEMGR_STATE_OPENED_STREAM;
            }
            return (ret);
        }

        // 擾f[^ŁA{fBłȂꍇ...
        if ((parseSize + 1 == readSize)&&(*ptr == '\x0a'))
        {
            // XXVȂ
            CloseFile_NNsh(&fileRefR);
            MEMFREE_PTR(realBuf);
            Hide_BusyForm(false);
            return (NNSH_MSGSTATE_NOTMODIFIED);
        }
        if (*ptr != '\x0a')
        {
            // f[^G[H(G[̏ڍׂ͖`FbN)
            CloseFile_NNsh(&fileRefR);
            MEMFREE_PTR(realBuf);
            Hide_BusyForm(false);

            return (NNSH_MSGSTATE_ERROR);
        }
        // XV`FbNp̕(1oCg)߂B
        ptr++;
        parseSize++;
    }
    else
    {
        // @JBBS(rawmode)̍擾
        MemSet (tmpBuf, sizeof(tmpBuf), 0x00);
        NUMCATI(tmpBuf, (mesDB->maxLoc + 1));
        StrCat (tmpBuf, "<>");
        tmpPtr = StrStr(ptr, tmpBuf);
        if (tmpPtr == NULL)
        {
            // XXVȂ
            CloseFile_NNsh(&fileRefR);
            MEMFREE_PTR(realBuf);
            Hide_BusyForm(false);
            return (NNSH_MSGSTATE_NOTMODIFIED);
        }

        // f[^𒲐
#if 0
        *(tmpPtr - 3) = '<';
        *(tmpPtr - 2) = '>';
        *(tmpPtr - 1) = '\x0a';
        *(tmpPtr - 3) = '<';
        *(tmpPtr - 2) = '>';
        *(tmpPtr - 1) = '\x0a';
#endif
        parseSize = parseSize + (tmpPtr - 3) - ptr;
    }

    // wb_t@CTCYɕύX
    fileSize = fileSize - (ptr - buffer);

    if (((UInt32) ptr & 1)&&((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_WORKAROUND))
    {
        ptr--;
        *ptr = ' ';
    }
     // f[^̏(ǋL)
    chkSize  = readSize - (ptr - buffer);
    if (((chkSize % 2) == 1)&&((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_WORKAROUND))
    {
        //  Ō̕LڂȂ̂ł͂ȂAŌ̑̕Oɋ󔒂}
        // ƂŁA݃oCgɂB(v0.80r003) łH
        if (ptr[chkSize - 1] == '\x0a')
        {
            ptr[chkSize]     = ptr[chkSize - 1];
            ptr[chkSize - 1] = ' ';
            NNsh_DebugMessage(ALTID_WARN, "append spc(pre)", "", chkSize);
        }
        else
        {
            buffer[chkSize] = ' ';
            NNsh_DebugMessage(ALTID_WARN, "append spc(post)", "", chkSize);
        }
        chkSize++;
    }

    // ݃t@CI[v
    ret = OpenFile_NNsh(targetFile, NNSH_FILEMODE_APPEND, &fileRefW);
    if (ret != errNone)
    {
        NNsh_InformMessage(ALTID_ERROR, "ERR>OpenFile_NNsh", targetFile, ret);
        ret = errNone;
        goto END_FUNC;
    }

    ret = AppendFile_NNsh(&fileRefW, chkSize, ptr, &writeSize);
    if (ret != errNone)
    {
        NNsh_InformMessage(ALTID_ERROR, "WRITEFile_NNsh(1st)", "", ret);
        ret = errNone;
        goto END_FUNC;
    }
    offset = readSize;

    while (offset < fileSize)
    {
        MemSet(buffer, (NNshGlobal->NNsiParam)->bufferSize + MARGIN, 0x00);
        readSize = 0;
        ret = ReadFile_NNsh(&fileRefR, offset, (NNshGlobal->NNsiParam)->bufferSize,
                            buffer, &readSize);
        if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
        {        
            NNsh_InformMessage(ALTID_ERROR, "ERR>ReadFile_NNsh", "", ret);
            break;
        }
        chkSize = 0;
        if (((readSize % 2) == 1)&&((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_WORKAROUND))
        {
            if (ptr[readSize - 1] == '\x0a')
            {
                buffer[readSize]     = buffer[readSize - 1];
                buffer[readSize - 1] = ' ';
                NNsh_DebugMessage(ALTID_WARN, "Append space(pre)", "",
                                  readSize);
            }
            else
            {
                buffer[readSize] = ' ';
                NNsh_DebugMessage(ALTID_WARN, "Append space(post)", "",
                                  readSize);
            }
            chkSize++;
        }
        ret = AppendFile_NNsh(&fileRefW, readSize+chkSize, buffer, &writeSize);
        if (ret != errNone)
        {
            NNsh_InformMessage(ALTID_ERROR, "ERR>WriteFile_NNsh()", "", ret);
            break;
        }
        offset = offset + readSize;
    }
    mesDB->fileSize = mesDB->fileSize + fileSize;
    if (fileSize != 0)
    {
        // update
        mesDB->state = NNSH_SUBJSTATUS_UPDATE;

        // X̋L^o^
        if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) != 0)
        {
            // XL^VFS
            mesDB->msgState = FILEMGR_STATE_OPENED_VFS;
        }
        else
        {    
            // XL^Palm{
            mesDB->msgState = FILEMGR_STATE_OPENED_STREAM;
        }
    }
    CloseFile_NNsh(&fileRefW);
    ret = errNone;

END_FUNC:    
    CloseFile_NNsh(&fileRefR);
    MEMFREE_PTR(realBuf);
    Hide_BusyForm(false);

    return (ret);
}

/*=========================================================================*/
/*   Function :   Get_AllMessage                                           */
/*                                                        bZ[WS擾 */
/*=========================================================================*/
Err Get_AllMessage(Char *url, Char *boardNick, Char *file, UInt16 idxMES,
                   UInt16 bbsType)
{
    Err                  ret;
    UInt32               fileSize, range;
    Char                 fileName[MAXLENGTH_FILENAME];

    // bZ[Wi[t@C쐬
    MemSet (fileName, sizeof(fileName), 0x00);
    StrCopy(fileName, boardNick);
    StrCat (fileName, file);

    // _E[hw莞ɂ̓Wݒs
    if ((NNshGlobal->NNsiParam)->enablePartGet != 0)
    {
        range = (UInt32) (NNshGlobal->NNsiParam)->partGetSize - NNSH_HTTPGET_HEADERMAX;
    }
    else
    {
        range = HTTP_RANGE_OMIT;
    }

    // bZ[WM
    ret = NNshHttp_comm(HTTP_SENDTYPE_GET, url, NULL, NULL,
                        HTTP_GETSUBJECT_START, range, NULL);
    if (ret != errNone)
    {
        // ʐMG[
        if (ret == netErrTimeout)
        {
            NNsh_InformMessage(ALTID_ERROR, MSG_OCCUR_TIMEOUT, "", ret);
        }
        else
        {
            NNsh_InformMessage(ALTID_ERROR, MSG_ERROR_HTTP_COMM, "", ret);
        }
        return (ret);
    }

    // Mf[^ϊAo^B
    ret = message_entryMessage (fileName, &fileSize, bbsType);
    if (ret == errNone)
    {
        // MG[łȂƂɂ́A擾f[^x[Xɓo^
        message_entryDatabase(idxMES, fileSize, bbsType);
    }
    return (ret);
}

/*=========================================================================*/
/*   Function :   Get_PartMessage                                          */
/*                                                      bZ[W擾 */
/*=========================================================================*/
Err Get_PartMessage(Char *url, Char *boardNick, NNshSubjectDatabase *mesDB, 
                    UInt16 idxMES, Char *message)
{
    Err    ret, ret1;
    Char   fileName[MAXLENGTH_FILENAME];
    UInt32 range;

    // bZ[Wi[t@C쐬
    MemSet (fileName, sizeof(fileName), 0x00);
    StrCopy(fileName, boardNick);
    StrCat (fileName, mesDB->threadFileName);

    // _E[hw莞ɂ̓Wݒs
    if ((NNshGlobal->NNsiParam)->enablePartGet != 0)
    {
        range = (UInt32) (NNshGlobal->NNsiParam)->partGetSize - 
                         NNSH_HTTPGET_HEADERMAX + (mesDB->fileSize - 1);
    }
    else
    {
        range = HTTP_RANGE_OMIT;
    }

    // httpŁAX擾
    if (mesDB->bbsType != NNSH_BBSTYPE_SHITARABAJBBS_RAW)
    {
        // bZ[W𑗎M(@JBBSȊÔƂ)
        ret = NNshHttp_comm(HTTP_SENDTYPE_GET, url, NULL, NULL,
                            (mesDB->fileSize - 1), range, message);
    }
    else
    {
        // @JBBŜƂ... rawmode Ȃ̂ŁAURLɎ擾Xԍǉ
        NUMCATI(url, (mesDB->maxLoc + 1));
        StrCat (url, "-");
        NNsh_DebugMessage(ALTID_INFO, " SHITARABA URL:", url, 0);

        // bZ[W𑗎M
        ret = NNshHttp_comm(HTTP_SENDTYPE_GET, url, NULL, NULL,
                            HTTP_RANGE_OMIT, range, message);
    }

    if (ret != errNone)
    {
        // ʐMG[
        if (ret == netErrTimeout)
        {
            NNsh_InformMessage(ALTID_ERROR, MSG_OCCUR_TIMEOUT, "", ret);
        }
        else
        {
            NNsh_InformMessage(ALTID_ERROR, MSG_ERROR_HTTP_COMM, "", ret);
        }
        return (ret);
    }

    // Mf[^ϊAo^B
    ret1 = message_appendMessage(fileName, mesDB);
    switch (ret1)
    {
      case errNone:
        // f[^ϊAւށB
        // A΁JBBS(rawmode)̂Ƃ́AXԍ擾
        if (mesDB->bbsType == NNSH_BBSTYPE_SHITARABAJBBS_RAW)
        {
            // ̃Xԍ擾
            (void) getLastMessageNumShitaraba(&(mesDB->maxLoc));
        }
        break;

      case NNSH_MSGSTATE_NOTMODIFIED:
        // f[^XV
        NNsh_InformMessage(ALTID_INFO, 
                           MSG_RECV_NOTMODIFY, mesDB->threadTitle, 0);
        goto FUNC_END;
        break;

      case NNSH_MSGSTATE_ERROR:
        // f[^Ms
        NNsh_InformMessage(ALTID_ERROR, 
                          MSG_RECV_PARTMSG_ERROR, mesDB->threadTitle, ret);
        // mesDB->state        = NNSH_SUBJSTATUS_UNKNOWN;

        // XɃG[ݒ肷(擾\XNA)
        mesDB->msgAttribute = (mesDB->msgAttribute | NNSH_MSGATTR_ERROR);
        mesDB->msgAttribute = (mesDB->msgAttribute & NNSH_MSGATTR_NOTRESERVE);
        (void) update_subject_database(idxMES, mesDB);
        return (NNSH_ERRORCODE_PARTGET);
        break;

      default:
        break;
    }
FUNC_END:
    // X̃G[NA
    mesDB->msgAttribute = ((mesDB->msgAttribute)&
                           (NNSH_MSGATTR_NOTERROR)&(NNSH_MSGATTR_NOTRESERVE));

    // XbZ[Wf[^x[X̓eXVB
    ret = update_subject_database(idxMES, mesDB);
    if (ret != errNone)
    {
        // 肦Ȃ͂...
        NNsh_DebugMessage(ALTID_ERROR, "update_subject_database()"," ", ret);
    }
    return (ret1);
}

/*=========================================================================*/
/*   Function : MoveSubject_BBS                                            */
/*                                              X̏ύX */
/*=========================================================================*/
Err MoveSubject_BBS(Char *dest, Char *src)
{
    Err                 ret;
    UInt16              index, cnt;
    DmOpenRef           dbRef;
    NNshSubjectDatabase subjDB;

    // XǗDBI[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "OpenDatabase_NNsh() ", " ", 0);
        return (~errNone);
    }
    GetDBCount_NNsh(dbRef, &cnt);
    for (index = 0; index < cnt; cnt++)
    {
        // Xf[^擾
        ret = GetRecord_NNsh(dbRef, index,
                             sizeof(NNshSubjectDatabase), &subjDB);
        if (ret != errNone)
        {
            // G[(fobO\)
            NNsh_DebugMessage(ALTID_ERROR, "GetRecord_NNsh() ", " ", ret);
            continue;
        }

        // w肵{[hjbNl[`FbN
        if (StrCompare(subjDB.boardNick, src) == 0)
        {
            // Xړ
            MemSet (subjDB.boardNick, MAX_NICKNAME, 0x00);
            StrCopy(subjDB.boardNick, dest);
            UpdateRecord_NNsh(dbRef, index,
                              sizeof(NNshSubjectDatabase), &subjDB);
        }
    }
    CloseDatabase_NNsh(dbRef);

    // XꗗDBXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_SUBJECT));


    return (errNone);
}

/*=========================================================================*/
/*   Function : MarkMessageIndex                                           */
/*                                           bZ[Wǂݏo󋵂ݒ  */
/*=========================================================================*/
void MarkMessageIndex(UInt16 index, UInt16 favor)
{
    Err                  ret;
    NNshSubjectDatabase  subjDB;

    ret = Get_Subject_Database(index, &subjDB);
    if (ret == errNone)
    {
        if ((NNshGlobal->msgIndex) != NULL)
        {
            subjDB.currentLoc = (NNshGlobal->msgIndex)->openMsg;
            subjDB.maxLoc     = (NNshGlobal->msgIndex)->nofMsg;    
            if ((NNshGlobal->msgIndex)->nofMsg == 
                                             (NNshGlobal->msgIndex)->openMsg)
            {
                subjDB.state = NNSH_SUBJSTATUS_ALREADY;
            }
            else
            {
                subjDB.state = NNSH_SUBJSTATUS_REMAIN;
            }

            // MSG̏ꏊsꍇɂ́AL^LB
            if ((subjDB.msgState == 0)&&
                (subjDB.maxLoc != 0)&&(subjDB.currentLoc != 0))
            {
                if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) != 0)
                {
                    // XL^VFS
                    subjDB.msgState = FILEMGR_STATE_OPENED_VFS;
                }
                else
                {    
                    // XL^Palm{
                    subjDB.msgState = FILEMGR_STATE_OPENED_STREAM;
                }
            }
        }
        switch (favor)
        {
          case NNSH_MSGATTR_NOTSPECIFY:
            // Cɓݒ͕ύXȂ
            break;
          case 0:
            // CɓݒNA
            subjDB.msgAttribute 
                               = (subjDB.msgAttribute & NNSH_MSGATTR_NOTFAVOR);
            break;
          default:
            // w肳ꂽCɓݒs
            subjDB.msgAttribute 
                  = ((subjDB.msgAttribute & NNSH_MSGATTR_NOTFAVOR)| favor);
            break;
        }

        (void) update_subject_database(index, &subjDB);
    }
    return;
}

/*=========================================================================*/
/*   Function :   GetThreadDataFromMesNum                                  */
/*                                            Xԍw̃bZ[W擾 */
/*=========================================================================*/
Boolean GetThreadDataFromMesNum(Boolean *updateBBS, Char *buf, UInt16 bufLen, UInt16 *recNum)
{
    Boolean              rep = false;
    Err                  ret;
    UInt16               btnId, index, dataIndex;
    UInt32               size;
    DmOpenRef            dbRef;
    Char                *ptr, *nPtr;
    NNshBoardDatabase    bbsData;
    NNshSubjectDatabase  subjDb;

    // ̈̏
    index = 0;
    MemSet(&subjDb,  sizeof(NNshSubjectDatabase), 0x00);
    MemSet(&bbsData, sizeof(NNshBoardDatabase),   0x00);
    *updateBBS = false;
    *recNum = 0;

    // ̓f[^Nick؂o
    ptr  = buf;
    nPtr = subjDb.boardNick;
    while (*ptr != '/')
    { 
        *nPtr = *ptr;
        ptr++;
        nPtr++;
        if (*ptr == '\0')
        {
            // f[^擾G[AI
            NNsh_InformMessage(ALTID_ERROR, MSG_ERROR_GETFAILURE, "", 0);
            return (false);
        }
    }
    *nPtr = '/';    // Nick̍Ō '/'tĂ

    // Xԍ؂o
    ptr++;
    nPtr = subjDb.threadFileName;
    while ((*ptr != '/')&&(*ptr != '\0'))
    {
        *nPtr = *ptr;
        nPtr++;
        ptr++;
    }

    // BBSꗗǂݍݒ̃bZ[W\
    Show_BusyForm(MSG_READ_BBSLIST_WAIT);

    // ̎擾
    ret = Get_BBS_Database(subjDb.boardNick, &bbsData, &index);
    if (ret != errNone)
    {
        // 擾ɎsAG[\ďI
        NNsh_InformMessage(ALTID_ERROR, subjDb.boardNick,
                          MSG_WRONG_BOARDNICK, ret);
        Hide_BusyForm(false);
        return (false);
    }

    // bZ[W̋L
    MemSet (buf, bufLen, 0x00);
    StrCopy(buf, bbsData.boardName);
    StrCat (buf, MSG_CONFIRM_GETTHREAD);
    StrCat (buf, subjDb.threadFileName);
    StrCat (buf, ")");

    // bZ[W̍폜
    Hide_BusyForm(false);

    // bZ[W擾(URL)̍쐬
    switch (bbsData.bbsType)
    {
      case NNSH_BBSTYPE_MACHIBBS:
        // ܂BBSf[^擾(HTMLǂ)
        StrCat (subjDb.threadFileName, ".cgi");

        //////////////////////////////////////////////////////////////////////
        // ݁A܂aarɂ͂̋@\͎gpłȂ|\ďIB
        NNsh_InformMessage(ALTID_WARN, MSG_NOTSUPPORT_MACHI,"",0);
        return (false);
        //////////////////////////////////////////////////////////////////////
        break;

      case NNSH_BBSTYPE_SHITARABAJBBS_OLD:
      case NNSH_BBSTYPE_SHITARABAJBBS_RAW:
        // ΁JBBSf[^擾(HTMLǂ)
        StrCat (subjDb.threadFileName, ".cgi");   // gq

        //////////////////////////////////////////////////////////////////////
        // ݁A̋@\͎gpłȂ|\ďIB
        NNsh_InformMessage(ALTID_WARN, MSG_NOTSUPPORT_BBS,"",0);
        return (false);
        //////////////////////////////////////////////////////////////////////
        break;

      case NNSH_BBSTYPE_SHITARABA:
      case NNSH_BBSTYPE_2ch:
      case NNSH_BBSTYPE_OTHERBBS:
      default:
        // 2chf[^擾(datǂ)
        StrCat (subjDb.threadFileName, ".dat");   // gq
        break;
    }

    // {ɃX擾邩mFs
    btnId = NNsh_ConfirmMessage(ALTID_CONFIRM, buf, "", 0);
    if (btnId != 0)
    {
        // 擾LZ
        NNsh_InformMessage(ALTID_INFO, MSG_ABORT_INFO, "", 0);
        return (false);
    }

    // f[^擾URL𐶐
    CreateThreadURL(NNSH_DISABLE, buf, bufLen, &bbsData, &subjDb);

    // Xf[^擾ς݂mFB
    if (Check_same_thread(NNSH_NOTENTRY_THREAD, &subjDb, &subjDb, &dataIndex)
                                                                    == errNone)
    {
        // 擾ς݂ƔA擾ɐ؂ւ
        ret = Get_PartMessage(buf,bbsData.boardNick,&subjDb,dataIndex,NULL);

        // 擾I̕\(DEBUGIvVL̂)
        NNsh_InformMessage(ALTID_INFO, MSG_GET_PARTMESSAGE_END,
                           subjDb.threadTitle, ret);

        // 擾X̃R[hԍi[
        *recNum = dataIndex;
        rep = (ret == errNone) ? true : false;
        return (rep);
    }

    ////////////  bZ[WS擾̏  ///////////

    // X擾̃bZ[W\
    Show_BusyForm(MSG_MESSAGE_INFO_WAIT);

    /////////////////////////////////////////////////////////////////////////
    // f[^x[XɃXf[^()ǉ X^Cg͌Œǉ遦
    /////////////////////////////////////////////////////////////////////////
    StrCopy(subjDb.threadTitle, "(Unknown)");

    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // bZ[W̍폜
        Hide_BusyForm(false);

        // G[
        NNsh_DebugMessage(ALTID_ERROR, "OpenDatabase_NNsh()", "", 0);
        return (false);
    }
    EntryRecord_NNsh(dbRef, sizeof(NNshSubjectDatabase), &subjDb);
    CloseDatabase_NNsh(dbRef);

    // XꗗDBXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_SUBJECT));

    /** (VFS)fBNg쐬 **/
    (void) CreateDir_NNsh(bbsData.boardNick);
    
    // bZ[W̍폜
    Hide_BusyForm(false);

    // O擾ыL^
    ret = Get_AllMessage(buf, bbsData.boardNick, subjDb.threadFileName,
                         0, (UInt16) bbsData.bbsType);
    if (ret != errNone)
    {
        // Xt@C ϐbufɏoA(O)Xt@C폜
        MemSet (buf, bufLen, 0x00);
        StrCopy(buf, bbsData.boardNick);
        StrCat (buf, subjDb.threadFileName);
        if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) == 0)
        {
            // Palm{̏̃O폜
            ret = DeleteFile_NNsh(buf, NNSH_VFS_DISABLE);
        }
        else
        {
            // VFS̃O폜
            ret = DeleteFile_NNsh(buf, NNSH_VFS_ENABLE);
        }

        // G[(ǉf[^x[Xf[^폜)
        (void) OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
        DeleteRecordIDX_NNsh(dbRef, 0);
        CloseDatabase_NNsh(dbRef);
        NNsh_DebugMessage(ALTID_ERROR, "Get_AllMessage()", "", ret);
        return (false);
    }

    //////////////////X^Cg擾/////////////////////////

    // X擾̃bZ[W\
    Show_BusyForm(MSG_MESSAGE_INFO_WAIT);

    // X擾
    (void) Get_Subject_Database(0, &subjDb);

    // t@CTCYꎞIɋL
    size = subjDb.fileSize;

    // Xt@C ϐbufɏo
    MemSet (buf, bufLen, 0x00);
    StrCopy(buf, bbsData.boardNick);
    StrCat (buf, subjDb.threadFileName);

    // BBSɐݒ肳ꂽWXx𔽉f
    switch ((bbsData.state)&(NNSH_BBSSTATE_LEVELMASK))
    {
      case NNSH_BBSSTATE_FAVOR_L1:
        // Lxɐݒ
        subjDb.msgAttribute
             = ((subjDb.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR_L1));
        break;

      case NNSH_BBSSTATE_FAVOR_L2:
        // 1xɐݒ
        subjDb.msgAttribute
             = ((subjDb.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR_L2));
        break;

      case NNSH_BBSSTATE_FAVOR_L3:
        // 2xɐݒ
        subjDb.msgAttribute
             = ((subjDb.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR_L3));
        break;

      case NNSH_BBSSTATE_FAVOR_L4:
        // 3xɐݒ
        subjDb.msgAttribute
             = ((subjDb.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR_L4));
        break;

      case NNSH_BBSSTATE_FAVOR:
        // Hxɐݒ
        subjDb.msgAttribute
             = ((subjDb.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR));
        break;

      default:
        // Ȃ
        break;
    }

    // t@CX擾
    ret = SetThreadInformation(buf, (NNSH_FILEMODE_READONLY), NULL, &subjDb);
    if (ret != errNone)
    {
        // G[
        NNsh_DebugMessage(ALTID_ERROR, "SetThreadInformation()\nFileName:",
                          subjDb.threadFileName, ret);
        // ^[ɏp
    }

    // t@CTCY߂
    subjDb.fileSize = size;

    // R[h̓o^
    ret = update_subject_database(0, &subjDb);

    // bZ[W̍폜
    Hide_BusyForm(false);

    if (ret != errNone)
    {
        // G[
        NNsh_DebugMessage(ALTID_ERROR, "update_subject_database()", "", ret);
        return (false);
    }

    // 擾I̕\
    NNsh_InformMessage(ALTID_INFO,MSG_GET_MESSAGE_END,subjDb.threadTitle,ret);

    if ((bbsData.state & NNSH_BBSSTATE_VISIBLE) == NNSH_BBSSTATE_VISIBLE)
    {
        // BBSgpݒɂčXV
        bbsData.state = ((NNSH_BBSSTATE_LEVELMASK)&(bbsData.state))|(NNSH_BBSSTATE_VISIBLE);

        // BBS̍XV
        Update_BBS_Database(index, &bbsData);

        *updateBBS = true;

        // gpBBSꗗǉꂽƂʒm
        NNsh_InformMessage(ALTID_WARN,bbsData.boardName,MSG_WARN_BBSUPDATE,0);

        // BBS^CgCfbNXp̗̈U
        if (NNshGlobal->boardIdxH != 0)
        {
            MemHandleFree(NNshGlobal->boardIdxH);
            NNshGlobal->boardIdxH = 0;
        }
        MEMFREE_PTR((NNshGlobal->bbsTitles));
    }
    return (true);
}


/*=========================================================================*/
/*   Function :   Hander_MessageInfo                                       */
/*                                 bZ[W񑀍쎞̃Cxgnh  */
/*=========================================================================*/
Boolean Handler_MessageInfo(EventType *event)
{
    FormType *frm;
    UInt16    itemId, status;

    // Cxg؂ւ
    itemId = 0;
    switch (event->eType)
    { 
      case menuEvent:
        break;

      case keyDownEvent:
        // L[͂
        itemId = KeyConvertFiveWayToJogChara(event);
        break;

      case ctlSelectEvent:
        break;

      default: 
        break;
    }

    status = 1;
    frm = FrmGetActiveForm();
    switch (itemId)
    {
      case chrDigitOne:
        SetControlValue(frm, PBTNID_FAVOR_L0, &status);
        status = 0;
        SetControlValue(frm, PBTNID_FAVOR_L1, &status);
        SetControlValue(frm, PBTNID_FAVOR_L2, &status);
        SetControlValue(frm, PBTNID_FAVOR_L3, &status);
        SetControlValue(frm, PBTNID_FAVOR_L4, &status);
        SetControlValue(frm, PBTNID_FAVOR_L5, &status);
        break;

      case chrDigitTwo:
        SetControlValue(frm, PBTNID_FAVOR_L1, &status);
        status = 0;
        SetControlValue(frm, PBTNID_FAVOR_L0, &status);
        SetControlValue(frm, PBTNID_FAVOR_L2, &status);
        SetControlValue(frm, PBTNID_FAVOR_L3, &status);
        SetControlValue(frm, PBTNID_FAVOR_L4, &status);
        SetControlValue(frm, PBTNID_FAVOR_L5, &status);
        break;

      case chrDigitThree:
        SetControlValue(frm, PBTNID_FAVOR_L2, &status);
        status = 0;
        SetControlValue(frm, PBTNID_FAVOR_L0, &status);
        SetControlValue(frm, PBTNID_FAVOR_L1, &status);
        SetControlValue(frm, PBTNID_FAVOR_L3, &status);
        SetControlValue(frm, PBTNID_FAVOR_L4, &status);
        SetControlValue(frm, PBTNID_FAVOR_L5, &status);
        break;

      case chrDigitFour:
        SetControlValue(frm, PBTNID_FAVOR_L3, &status);
        status = 0;
        SetControlValue(frm, PBTNID_FAVOR_L0, &status);
        SetControlValue(frm, PBTNID_FAVOR_L1, &status);
        SetControlValue(frm, PBTNID_FAVOR_L2, &status);
        SetControlValue(frm, PBTNID_FAVOR_L4, &status);
        SetControlValue(frm, PBTNID_FAVOR_L5, &status);
        break;

      case chrDigitFive:
        SetControlValue(frm, PBTNID_FAVOR_L4, &status);
        status = 0;
        SetControlValue(frm, PBTNID_FAVOR_L0, &status);
        SetControlValue(frm, PBTNID_FAVOR_L1, &status);
        SetControlValue(frm, PBTNID_FAVOR_L2, &status);
        SetControlValue(frm, PBTNID_FAVOR_L3, &status);
        SetControlValue(frm, PBTNID_FAVOR_L5, &status);
        break;

      case chrDigitSix:
        SetControlValue(frm, PBTNID_FAVOR_L5, &status);
        status = 0;
        SetControlValue(frm, PBTNID_FAVOR_L0, &status);
        SetControlValue(frm, PBTNID_FAVOR_L1, &status);
        SetControlValue(frm, PBTNID_FAVOR_L2, &status);
        SetControlValue(frm, PBTNID_FAVOR_L3, &status);
        SetControlValue(frm, PBTNID_FAVOR_L4, &status);
        break;

      case chrCapital_W:
      case chrSmall_W:
        // uEUŊJ
        CtlHitControl(FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_OPEN_BROWSER)));
        break;

      default:
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function : DisplayMessageInformations                                 */
/*                                                     X\  */
/*=========================================================================*/
Err DisplayMessageInformations(UInt16 msgIndex, UInt16 *msgAttribute)
{
    Err                 ret;
    Char                logBuf[BIGBUF], *urlTop;
    UInt16              index, btnId, status;
    FormType           *prevFrm, *diagFrm;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // bZ[Wf[^x[X擾
    ret = Get_Subject_Database(msgIndex, &mesInfo);
    if (ret != errNone)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "get_subject_database()", "", ret);
        return (ret);
    }

    // BBSf[^x[X擾
    ret = Get_BBS_Database(mesInfo.boardNick, &bbsInfo, &index);
    if (ret != errNone)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "Get_BBS_Database() nick:", 
                          mesInfo.boardNick, ret);
        return (ret);
    }
    // indexԍwork1Ɋi[
    NNshGlobal->work1 = index;

    /////////////////// XbZ[W\z  ///////////////////////

    // ݂̉ʃ|C^擾
    prevFrm = FrmGetActiveForm();

    // PalmOS v3.5ȉȂAÕtH[B
    if (NNshGlobal->palmOSVersion < 0x03503000)
    {
        FrmEraseForm(prevFrm);
    }

    // XʂJ
    diagFrm  = FrmInitForm(FRMID_MESSAGEINFO);
    if (diagFrm != NULL)
    {
        // tH[ANeBuɂ
        FrmSetActiveForm(diagFrm);

        // Cxgnh̐ݒ
        FrmSetEventHandler(diagFrm, Handler_MessageInfo);

        // bZ[W̐
        MemSet (logBuf, sizeof(logBuf), 0x00);
        StrCat (logBuf, NNSH_MSGINFO_MSGNUM);
        NUMCATI(logBuf, mesInfo.currentLoc);
        StrCat (logBuf, "/");
        NUMCATI(logBuf, mesInfo.maxLoc);

        // bZ[W̕\
        NNshWinSetFieldText(diagFrm,FLDID_MSGSTATUS,false,logBuf,StrLen(logBuf));

        // t@C̍쐬
        MemSet (logBuf, sizeof(logBuf), 0x00);
        StrCopy(logBuf, NNSH_MSGINFO_FILELOC);

        // bZ[W̋L^ӏo͂
        switch (mesInfo.msgState)
        {
          case FILEMGR_STATE_OPENED_VFS:
            StrCat(logBuf, "VFS (");
            break;
          case FILEMGR_STATE_OPENED_STREAM:
            StrCat(logBuf, "Palm (");
            break;
          default:
            StrCat(logBuf, "??? (");
            break;
        }
        NUMCATI(logBuf, mesInfo.fileSize);
        StrCat (logBuf, " bytes)");

        // t@C̕\
        NNshWinSetFieldText(diagFrm,FLDID_FILESTATUS,false,logBuf,StrLen(logBuf));

        // ̑̍쐬
        MemSet (logBuf, sizeof(logBuf), 0x00);
        StrCopy(logBuf, NNSH_MSGINFO_STATUS);

        // 擾~aarǂ̕\
        if (((bbsInfo.state) & (NNSH_BBSSTATE_SUSPEND)) == NNSH_BBSSTATE_SUSPEND)
        {
            StrCat(logBuf, NNSH_MSGINFO_SUSPEND);
        }

        // XԂ̕\
        switch(mesInfo.state)
        {
          case NNSH_SUBJSTATUS_NOT_YET:
            // 擾
            StrCat(logBuf, NNSH_SUBJSTATUSMSG_NOT_YET);
            break;
          case NNSH_SUBJSTATUS_NEW:
            // VK擾
            StrCat(logBuf, NNSH_SUBJSTATUSMSG_NEW);
            break;
          case NNSH_SUBJSTATUS_UPDATE:
            // XV擾
            StrCat(logBuf, NNSH_SUBJSTATUSMSG_UPDATE);
            break;
          case NNSH_SUBJSTATUS_REMAIN:
            // ǂ
            StrCat(logBuf, NNSH_SUBJSTATUSMSG_REMAIN);
            break;
          case NNSH_SUBJSTATUS_ALREADY:
            // 
            StrCat(logBuf, NNSH_SUBJSTATUSMSG_ALREADY);
            break;
          case NNSH_SUBJSTATUS_UNKNOWN:
          default:
            // ԕs
            StrCat(logBuf, NNSH_SUBJSTATUSMSG_UNKNOWN);
            break;
        }
        if ((mesInfo.msgAttribute & NNSH_MSGATTR_ERROR) != 0)
        {
            // MG[\
            StrCat(logBuf, NNSH_MSGINFO_RECVERR);
        }
        if ((mesInfo.msgAttribute & NNSH_MSGATTR_GETRESERVE) != 0)
        {
            // 擾\\
            StrCat(logBuf, NNSH_MSGINFO_RECVRESERVE);
        }

        // ̑(bZ[W擾)̕\
        NNshWinSetFieldText(diagFrm, FLDID_ETCSTATUS,
                            false, logBuf, StrLen(logBuf));

        // X^Cg̐ݒ
        // (̃^CgɋLURLėp邽߁A\ԂύX)
        MemSet (logBuf, sizeof(logBuf), 0x00);
        StrCopy(logBuf, mesInfo.threadTitle);
        StrCat (logBuf, "\n");

        // XURL̐擪|C^L
        urlTop = &logBuf[StrLen(logBuf)];

        // XURL
        CreateThreadBrowserURL(NNSH_DISABLE, urlTop, &bbsInfo, &mesInfo);

        // XURL̐ݒ
        NNshWinSetFieldText(diagFrm,FLDID_MSGURL,true,logBuf,StrLen(logBuf));

        // ݂̃XCɓ背xݒ
        status = 1;
        switch(mesInfo.msgAttribute & NNSH_MSGATTR_FAVOR)
        {
          case NNSH_MSGATTR_FAVOR_L1:
            // Cɓ背x()
            SetControlValue(diagFrm, PBTNID_FAVOR_L1, &status);
            break;

          case NNSH_MSGATTR_FAVOR_L2:
            // Cɓ背x()
            SetControlValue(diagFrm, PBTNID_FAVOR_L2, &status);
            break;

          case NNSH_MSGATTR_FAVOR_L3:
            // Cɓ背x()
            SetControlValue(diagFrm, PBTNID_FAVOR_L3, &status);
            break;

          case NNSH_MSGATTR_FAVOR_L4:
            // Cɓ背x()
            SetControlValue(diagFrm, PBTNID_FAVOR_L4, &status);
            break;

          case NNSH_MSGATTR_FAVOR:
            // Cɓ背x()
            SetControlValue(diagFrm, PBTNID_FAVOR_L5, &status);
            break;

          default:
            // Cɓł͂Ȃ
            SetControlValue(diagFrm, PBTNID_FAVOR_L0, &status);
            break;
        }

        // _CAOI[v
        btnId = FrmDoDialog(diagFrm);

        // Xx̐ݒ茋ʊmF
        status = 0;
        UpdateParameter(diagFrm, PBTNID_FAVOR_L0, &status);
        if (status != 0)
        {
            // Cɓݒ肳ĂȂ
            *msgAttribute = 0;
            goto DELETE_DIALOG;
        }
        UpdateParameter(diagFrm, PBTNID_FAVOR_L1, &status);
        if (status != 0)
        {
            // Cɓݒ()
            *msgAttribute = NNSH_MSGATTR_FAVOR_L1;
            goto DELETE_DIALOG;
        }
        UpdateParameter(diagFrm, PBTNID_FAVOR_L2, &status);
        if (status != 0)
        {
            // Cɓݒ()
            *msgAttribute = NNSH_MSGATTR_FAVOR_L2;
            goto DELETE_DIALOG;
        }
        UpdateParameter(diagFrm, PBTNID_FAVOR_L3, &status);
        if (status != 0)
        {
            // Cɓݒ()
            *msgAttribute = NNSH_MSGATTR_FAVOR_L3;
            goto DELETE_DIALOG;
        }
        UpdateParameter(diagFrm, PBTNID_FAVOR_L4, &status);
        if (status != 0)
        {
            // Cɓݒ()
            *msgAttribute = NNSH_MSGATTR_FAVOR_L4;
            goto DELETE_DIALOG;
        }
        UpdateParameter(diagFrm, PBTNID_FAVOR_L5, &status);
        if (status != 0)
        {
            // Cɓݒ()
            *msgAttribute = NNSH_MSGATTR_FAVOR;
            goto DELETE_DIALOG;
        }

DELETE_DIALOG:
        // _CAO
        FrmSetActiveForm(prevFrm);
        FrmDeleteForm(diagFrm);

        if (btnId == BTNID_OPEN_BROWSER)
        {
            // uuEUŊJv{^ꂽƂ

            // Cɓݒɂ(f[^x[X)XV
            MarkMessageIndex(msgIndex, *msgAttribute);

            // WebuEUCXg[Ă邩mF
            if (NNshGlobal->browserCreator == 0)
            {
                // installĂȂƂ"T|[gĂ܂" \s
                NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
                return (errNone);
            }


            // WebBrowserŊJƂAŐVTOJ悤ɂ
            if ((NNshGlobal->NNsiParam)->browseMesNum != 0)
            {
                switch (bbsInfo.bbsType)
                {
                  case NNSH_BBSTYPE_SHITARABAJBBS_OLD:
                  case NNSH_BBSTYPE_MACHIBBS:
                    StrCat(logBuf, "&LAST=");
                    break;

                  case NNSH_BBSTYPE_SHITARABA:
                    StrCat(logBuf, "&ls=");
                    break;

                  case NNSH_BBSTYPE_SHITARABAJBBS_RAW:
                  case NNSH_BBSTYPE_2ch:
                  case NNSH_BBSTYPE_OTHERBBS:
                  default:
                    if ((NNshGlobal->NNsiParam)->useImodeURL != 0)
                    {
                        StrCat(logBuf, "/n");
                        goto OPEN_WEB;
                    }
                    else
                    {
                        StrCat(logBuf, "/l");
                    }
                    break;
                }
                NUMCATI(logBuf, (NNshGlobal->NNsiParam)->browseMesNum);
            }
            else
            {
                // i-modepURLꍇAURL𒲐
                if ((NNshGlobal->NNsiParam)->useImodeURL != 0)
                {
                    switch (bbsInfo.bbsType)
                    {
                      case NNSH_BBSTYPE_2ch:
                        StrCat(logBuf, "/i");
                        break;

                      case NNSH_BBSTYPE_SHITARABAJBBS_OLD:
                      case NNSH_BBSTYPE_SHITARABAJBBS_RAW:
                      case NNSH_BBSTYPE_MACHIBBS:
                      case NNSH_BBSTYPE_SHITARABA:
                      case NNSH_BBSTYPE_OTHERBBS:
                      default:
                        break;
                    }
                }
            }
OPEN_WEB:
            // WebuEUŊJmF
            if (NNsh_ConfirmMessage(ALTID_CONFIRM, urlTop,
                                    MSG_WEBLAUNCH_CONFIRM, 0) == 0)
            {
                // Web BrowserN(NNsiIɋN)
                (void) WebBrowserCommand(NNshGlobal->browserCreator,
                                         0, 0, 
                                         NNshGlobal->browserLaunchCode,
                                         urlTop, StrLen(urlTop), NULL);
            }
            return (errNone);
        }        
    }

    // Cɓݒɂ(f[^x[X)XV
    NNshGlobal->updateHR = NNSH_UPDATE_DISPLAY;
    MarkMessageIndex(msgIndex, *msgAttribute);

    return (errNone);
}

/*=========================================================================*/
/*   Function :   Get_MessageFromMesNum                                    */
/*                                            Xԍw̃bZ[W擾 */
/*=========================================================================*/
Boolean Get_MessageFromMesNum(Boolean *updateBBS, UInt16 *recNum, Boolean useClipboard)
{
    DmOpenRef dbRef;
    Boolean   ret;
    Char     *url, *clipP;
    MemHandle memH;
    UInt16    len;
    
    // [Nobt@̊mۂƏ
    url     = MEMALLOC_PTR(BUFSIZE);
    if (url == NULL)
    {
        return (false);
    }
    MemSet(url, BUFSIZE, 0x00);

    // Nbv{[h̃f[^gpꍇ
    if (useClipboard == true)
    {
        // Nbv{[h̃f[^擾
        memH = ClipboardGetItem(clipboardText, &len);
        if ((len != 0)&&(memH != 0))
        {
            len = (len > (BUFSIZE - 1)) ? (BUFSIZE - 1) : len;
            clipP = MemHandleLock(memH);
            if (clipP != NULL)
            {
                // Nbv{[h̃f[^ftHgf[^ƂăRs[
                StrNCopy(url, clipP, len);
            }
            MemHandleUnlock(memH);                
        }
    }

    // ͕̎擾
    ret = DataInputDialog(NNSH_INPUTWIN_GETMESNUM, url, BUFSIZE,
                          NNSH_DIALOG_USE_GETMESNUM, NULL);
    if (ret != false)
    {
        //  擾\@\LłlbgɐڑĂȂꍇA
        // 擾\񂷂邩mF
        if (((NNshGlobal->NNsiParam)->getReserveFeature != 0)&&(NNshGlobal->netRef == 0))
        {
            if (NNsh_ConfirmMessage(ALTID_CONFIRM,
                                    NNSH_MSGINFO_RESERVE, "", 0) == 0)
            {
                // 擾\񂪎wꂽ
                OpenDatabase_NNsh(DBNAME_GETRESERVE,
                                  DBVERSION_GETRESERVE, &dbRef);
                if (dbRef == 0)
                {
                    // DBI[vG[
                    NNsh_DebugMessage(ALTID_ERROR, "OpenDatabase_NNsh():",
                                      DBNAME_GETRESERVE, 0);
                    return (false);
                }
                // caɓo^AI
                (void) EntryRecord_NNsh(dbRef, BUFSIZE, url);
                CloseDatabase_NNsh(dbRef);
                return (true);
            }
        }

        // Xԍw̃bZ[W擾s
        ret = GetThreadDataFromMesNum(updateBBS, url, BUFSIZE, recNum);
    }

    // mۂ̈
    MEMFREE_PTR(url);
    return (ret);
}

/*=========================================================================*/
/*   Function : CreateThreadURL                                            */
/*                                               f[^擾URL𐶐   */
/*=========================================================================*/
Err CreateThreadURL(UInt16 urlType, Char *url, UInt16 bufSize, 
                    NNshBoardDatabase *bbsInfo, NNshSubjectDatabase *mesInfo)
{
    Char   *ptr;
    UInt16  size;

    MemSet (url, bufSize, 0x00);
    StrCopy(url, bbsInfo->boardURL);

    switch (bbsInfo->bbsType)
    {
      case NNSH_BBSTYPE_MACHIBBS:
        // JBBS/܂BBSf[^擾(HTMLǂ)
        StrCat (url, URL_PREFIX_MACHIBBS);
        StrCat (url, mesInfo->boardNick);
        // boardNick̖ɂ '/'폜
        if (url[StrLen(url) - 1] == '/')
        {
            url[StrLen(url) - 1] = '\0';
        } 
        StrCat (url, "&KEY=");
        StrCat (url, mesInfo->threadFileName);
        ptr = &url[StrLen(url) - 1];
        // threadFileName̊gq폜
        while (*ptr != '.')
        {
            ptr--;
        }
        *ptr = '\0';
        break;

      case NNSH_BBSTYPE_SHITARABAJBBS_OLD:
        // @JBBS Vread.cgiΉ
        size = 0;
        ptr = &url[StrLen(url) - 1];
        ptr--;
        size++;
        while ((ptr > url)&&(*ptr != '/'))
        {
            ptr--;
            size++;
        }

        // "/bbs/read.cgi" JeS̑Oɑ}
        MemMove(ptr + (sizeof("/bbs/read.cgi") - 1), ptr, (size + 1));

        StrCopy(ptr, "/bbs/read.cgi");
        url[StrLen(url)] = '/';

        StrCat(url, mesInfo->boardNick);
        StrCat(url, mesInfo->threadFileName);
        ptr = &url[StrLen(url) - 1];
        // threadFileName̊gq폜
        while (*ptr != '.')
        {
            ptr--;
        }
        *ptr = '/';
        ptr++;
        *ptr = '\0';

        NNsh_DebugMessage(ALTID_INFO, "URL:", url, 0);
        break;

      case NNSH_BBSTYPE_SHITARABAJBBS_RAW:
        // @JBBS(rawmode.cgi)Ή
        size = 0;
        ptr = &url[StrLen(url) - 1];
        ptr--;
        size++;
        while ((ptr > url)&&(*ptr != '/'))
        {
            ptr--;
            size++;
        }

        // "/bbs/rawmode.cgi" JeS̑Oɑ}
        MemMove(ptr + (sizeof("/bbs/rawmode.cgi") - 1), ptr, (size + 1));

        StrCopy(ptr, "/bbs/rawmode.cgi");
        url[StrLen(url)] = '/';

        StrCat(url, mesInfo->boardNick);
        StrCat(url, mesInfo->threadFileName);
        ptr = &url[StrLen(url) - 1];
        // threadFileName̊gq폜
        while (*ptr != '.')
        {
            ptr--;
        }
        *ptr = '/';
        ptr++;
        *ptr = '\0';

        NNsh_DebugMessage(ALTID_INFO, "URL:", url, 0);
        break;

      case NNSH_BBSTYPE_SHITARABA:
        // ΂f[^擾(datǂ)
        StrCat (url, "bbs/");
        StrCat (url, mesInfo->boardNick);
        StrCat (url, "dat/");
        StrCat (url, mesInfo->threadFileName);
        break;

      case NNSH_BBSTYPE_2ch:
      case NNSH_BBSTYPE_OTHERBBS:
      default:
        // Q˂邩f[^擾(datǂ)
        StrCat (url, "dat/");
        StrCat (url, mesInfo->threadFileName);
        break;
    }
    return (errNone);
}


/*=========================================================================*/
/*   Function : CreateThreadBrowserURL                                     */
/*                                 f[^擾URL(WebBrowserp)𐶐   */
/*=========================================================================*/
void CreateThreadBrowserURL(UInt16 urlType, Char *url,
                            NNshBoardDatabase    *bbsInfo,
                            NNshSubjectDatabase  *mesInfo)
{
    Char *ptr;

    StrCat(url, bbsInfo->boardURL);
    switch (bbsInfo->bbsType)
    {
      case NNSH_BBSTYPE_MACHIBBS:
        // ܂aar̂tqko͂
        if ((NNshGlobal->NNsiParam)->useImodeURL == 0)
        {
            StrCat (url, URL_PREFIX_MACHIBBS);
        }
        else
        {
            StrCat (url, URL_PREFIX_MACHIBBS_IMODE);
        }
        StrCat (url, mesInfo->boardNick);
        // boardNick̖ɂ '/'폜
        if (url[StrLen(url) - 1] == '/')
        {
            url[StrLen(url) - 1] = '\0';
        } 
        StrCat (url, "&KEY=");
        StrCat (url, mesInfo->threadFileName);
        break;

      case NNSH_BBSTYPE_SHITARABAJBBS_OLD:
      case NNSH_BBSTYPE_SHITARABAJBBS_RAW:
        // ΁iaar̂tqko͂
        if ((NNshGlobal->NNsiParam)->useImodeURL == 0)
        {
            StrCat (url, URL_PREFIX_SHITARABAJBBS);
        }
        else
        {
            StrCat (url, URL_PREFIX_SHITARABAJBBS_IMODE);
        }
        StrCat (url, mesInfo->boardNick);
        // boardNick̖ɂ '/'폜
        if (url[StrLen(url) - 1] == '/')
        {
            url[StrLen(url) - 1] = '\0';
        } 
        StrCat (url, "&KEY=");
        StrCat (url, mesInfo->threadFileName);
        NNsh_DebugMessage(ALTID_INFO, "URL:", url, 0);
        break;

      case NNSH_BBSTYPE_SHITARABA:
        // ΂̂tqko͂
        if ((NNshGlobal->NNsiParam)->useImodeURL == 0)
        {
            StrCat (url, URL_PREFIX_SHITARABA);
        }
        else
        {
            StrCat (url, URL_PREFIX_SHITARABA_IMODE);
        }
        StrCat (url, mesInfo->boardNick);
        // boardNick̖ɂ '/'폜
        if (url[StrLen(url) - 1] == '/')
        {
            url[StrLen(url) - 1] = '\0';
        } 
        StrCat (url, "&key=");
        StrCat (url, mesInfo->threadFileName);
        break;

      case NNSH_BBSTYPE_2ch:
      case NNSH_BBSTYPE_OTHERBBS:
      default: 
        // 2chURLɂ́A{[h܂܂Ă̂ŁA̕B
        ptr = url + StrLen(url) - 2;
        while (*ptr != '/')
        {
            ptr--;
        }
        *ptr = '\0';
        StrCat (url, "/");
        if ((NNshGlobal->NNsiParam)->useImodeURL == 0)
        {
            StrCat (url, URL_PREFIX);
        }
        else
        {
            StrCat (url, URL_PREFIX_IMODE);
        }
        StrCat (url, bbsInfo->boardNick);
        StrCat (url, mesInfo->threadFileName);
        break;
    }

    // ".dat"  ".cgi " ͍폜
    ptr = url + StrLen(url) - 1;
    while (*ptr != '.')
    {
        ptr--;
    }
    *ptr = '\0';

    return;
}

/*=========================================================================*/
/*   Function : MoveLogMessage                                             */
/*                                (ObZ[WPalm/VFSֈړ) */
/*=========================================================================*/
Err MoveLogMessage(UInt16 index)
{
    Err                 ret;
    UInt16              copyMode, delMode;
    Char                logFileName[MAX_NICKNAME + MAX_THREADFILENAME + MARGIN];
    NNshSubjectDatabase subjDb;

    // VFSp[^ON̂Ƃ̂ݎ{
    if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) == 0)
    {
        // VFS̃[ĥŎ{Ȃ
        return (NNSH_ERRORCODE_WRONGVFSMODE);
    }

    // ̈̏
    MemSet(&subjDb, sizeof(subjDb), 0x00);

    // f[^x[Xf[^擾
    ret = Get_Subject_Database(index, &subjDb);
    if (ret != errNone)
    {
        // 肦Ȃ͂H
        NNsh_DebugMessage(ALTID_ERROR, "get_subject_database()"," ", ret);
        return (ret);
    }

    switch (subjDb.msgState)
    {
      case FILEMGR_STATE_OPENED_STREAM:
        // PalmVFSփOf[^ړ
        copyMode = NNSH_COPY_PALM_TO_VFS;
        delMode  = NNSH_VFS_DISABLE;
        subjDb.msgState = FILEMGR_STATE_OPENED_VFS;

        // (VFS)fBNg쐬
        (void) CreateDir_NNsh(subjDb.boardNick);
        break;

      case FILEMGR_STATE_OPENED_VFS:
        // VFSPalmփOf[^ړ
        copyMode = NNSH_COPY_VFS_TO_PALM;
        delMode  = NNSH_VFS_ENABLE;
        subjDb.msgState = FILEMGR_STATE_OPENED_STREAM;
        break;

      default:
        // 肦Ȃ͂AAAȂŏI
        // 肦Ȃ͂H
        NNsh_DebugMessage(ALTID_ERROR, "wrong msgState :", subjDb.threadFileName, subjDb.msgState);
        return (~errNone);
        break;
    }

    // Of[^̃t@C쐬ARs[{
    MemSet (logFileName, sizeof(logFileName), 0x00);
    StrCopy(logFileName, subjDb.boardNick);
    StrCat (logFileName, subjDb.threadFileName);
    ret = CopyFile_NNsh(logFileName, logFileName, copyMode);
    if (ret != errNone)
    {
        // t@C̃Rs[Ɏs
        // Rs[悤Ƃt@C(r[ȃt@C)폜
        delMode = (delMode == NNSH_VFS_DISABLE) ?
                                            NNSH_VFS_ENABLE : NNSH_VFS_DISABLE;
        DeleteFile_NNsh(logFileName, delMode);
        return (NNSH_ERRORCODE_COPYFAIL);
    }

    // Rs[Ot@C폜
    DeleteFile_NNsh(logFileName, delMode);

    // f[^XV
    ret = update_subject_database(index, &subjDb);
    if (ret != errNone)
    {
        // 肦Ȃ͂...
        NNsh_DebugMessage(ALTID_ERROR, "update_subject_database()"," ", ret);
        return (ret);
    }
    return (errNone);
}

#ifdef USE_SSL
/*=========================================================================*/
/*   Function : ProceedOysterLogin                                         */
/*                                                        ̃OC */
/*=========================================================================*/
Err ProceedOysterLogin(void)
{
    Err          err;
    Boolean      ret;
    UInt32       dummy;
    Int32        timeData, sample;
    DateTimeType dateBuf;
    NNshFileRef  fileRef;
    Char         *buffer, *buf, *ptr, *sId;

    buffer = MEMALLOC_PTR(BIGBUF + MARGIN);
    if (buffer == NULL)
    {
        // OC{Ȃ
        return (errNone);
    }
    MemSet (buffer, (BIGBUF + MARGIN),  0x00);
    if (NNshGlobal->loginDateTime != 0)
    {
        // OC\
        StrCopy(buffer, MSG_LOGINDATETIME);

        MemSet(&dateBuf, sizeof(dateBuf), 0x00);
        TimSecondsToDateTime(NNshGlobal->loginDateTime, &dateBuf);

        DateToAscii((UInt8)  dateBuf.month,
                    (UInt8)  dateBuf.day,
                    (UInt16) dateBuf.year, 
                    dfYMDLongWithDot,
                    &buffer[StrLen(buffer)]);

        TimeToAscii((UInt8) dateBuf.hour,
                    (UInt8) dateBuf.minute,
                     tfColon24h,
                    &buffer[StrLen(buffer)]);
    }
    else
    {
        // OCĂȂƂ\
        StrCopy(buffer, MSG_NOTLOGIN);
    }
    dummy    = TimGetSeconds() - NNshGlobal->loginDateTime;
    timeData = (Int32) dummy;
    sample   = ((TIME_24HOUR_SECOND) - (Int32) 10);
    if (timeData > sample)
    {
        // ăOCKvȂƂ\
        StrCat(buffer, MSG_LOGIN_INFO);
    }

    ret = DataInputPassword("2ch LOGIN", (NNshGlobal->NNsiParam)->oysterUserId,
                            sizeof((NNshGlobal->NNsiParam)->oysterUserId) - 1,
                            NNshGlobal->oysterPassword,
                            sizeof(NNshGlobal->oysterPassword) - 1,
                            buffer);
    // Cancel{^ꂽƂ
    if (ret == false)
    {
        // OC{Ȃ
        MEMFREE_PTR(buffer);
        return (errNone);
    }

    // OCs邩mF
    if (NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_LOGIN_CONFIRM,
                            (NNshGlobal->NNsiParam)->oysterUserId, 0) != 0) 
    {
        // OC{Ȃ
        MEMFREE_PTR(buffer);
        return (errNone);
    }

    MemSet(buffer, sizeof(buffer),  0x00);
    StrCopy(buffer, "ID=");
    StrCat(buffer, (NNshGlobal->NNsiParam)->oysterUserId);
    StrCat(buffer, "&PW=");
    StrCat(buffer, NNshGlobal->oysterPassword);
    ptr = buffer;

    // o͗pt@C̏
    (void) DeleteFile_NNsh(FILE_SENDMSG, NNSH_VFS_DISABLE);
    if (OpenFile_NNsh(FILE_SENDMSG, 
                      (NNSH_FILEMODE_APPEND|NNSH_FILEMODE_TEMPFILE),
                      &fileRef) != errNone)
    {
        // t@Copens
        MEMFREE_PTR(buffer);
        return (~errNone);
    }

    // f[^oăt@CN[Y
    (void) AppendFile_NNsh(&fileRef, StrLen(ptr), ptr, &dummy);
    CloseFile_NNsh(&fileRef);

    // f[^̑M
#ifdef USE_OLD_2ch_LOGINSERVER
    err = NNshHttp_comm(HTTP_SENDTYPE_POST_2chLOGIN,
                        "https://tiger2.he.net/~tora3n2c/futen.cgi",
                        NULL, NULL, HTTP_RANGE_OMIT, HTTP_RANGE_OMIT, NULL);
#else
    err = NNshHttp_comm(HTTP_SENDTYPE_POST_2chLOGIN,
                        "https://2chv.tora3.net/futen.cgi",
                        NULL, NULL, HTTP_RANGE_OMIT, HTTP_RANGE_OMIT, NULL);
#endif
    if (err != errNone)
    {
        // (^CAEgȊO)ʐMG[
        if (err != netErrTimeout)
        {
            NNsh_InformMessage(ALTID_ERROR, MSG_ERROR_HTTP_COMM, "[LOGIN]", err);
            MEMFREE_PTR(buffer);
            return (err);
        }

        // ʐM^CAEg
        NNsh_InformMessage(ALTID_ERROR, MSG_OCCUR_TIMEOUT, "[LOGIN]", err);
        MEMFREE_PTR(buffer);
        return (err);
    }

#if 0
    // 񂾂ƁAǂݏoɈڂ̂͂₷̂... 1bwait...
    SysTaskDelay(1 * SysTicksPerSecond());
#endif

    // Mf[^͂
    err = OpenFile_NNsh(FILE_RECVMSG,
                        (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                        &fileRef);
    if (err != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "HTTP Reply Message ", "", err);
        MEMFREE_PTR(buffer);
        return (err);
    }
    buf = MEMALLOC_PTR(NNSH_WORKBUF_MIN);
    if (buf == NULL)
    {
        MEMFREE_PTR(buffer);
        return (~errNone);
    }

    (void) ReadFile_NNsh(&fileRef, 0, NNSH_WORKBUF_MIN, buf, &dummy);
    CloseFile_NNsh(&fileRef);

    // Rec̐擪T
    ptr = StrStr(buf, NNSH_HTTP_HEADER_ENDTOKEN);
    if (ptr == NULL)
    {
        // f[^ُ
        NNsh_InformMessage(ALTID_ERROR, "ERR>Wrong data(not found separator,",
                           "(" NNSH_HTTP_HEADER_ENDTOKEN ")", 0);
        MEMFREE_PTR(buf);
        MEMFREE_PTR(buffer);
        return (~errNone - 10);
    }

    // ꂽUASessionIDiƔFOKƂȂjL
    sId = StrStr(ptr, "SESSION-ID=");
    if (sId == NULL)
    {
        // T[oG[AI
        // (OCɎsƂʒm)
        NNsh_InformMessage(ALTID_INFO, MSG_LOGIN_FAILURE, "(abnormal)", 0);
        goto FUNC_END;
    }
    // if (sId != NULL)
    {
        // f[^̖T
        sId = sId + StrLen("SESSION-ID=");

        // G[...
        if ((*(sId + 0) == 'E')&&(*(sId + 1) == 'R')&&(*(sId + 2) == 'R')&&
            (*(sId + 3) == 'O')&&(*(sId + 4) == 'R'))
        {
            // T[oG[AI
            // (OCɎsƂʒm)
            NNsh_InformMessage(ALTID_INFO, MSG_LOGIN_FAILURE, "", 0);
            goto FUNC_END;
        }

        ptr = sId;
        while (*ptr > ' ')
        {
            ptr++;
        }
        *ptr = '\0';
        
        dummy = StrLen(sId);
        ptr = MEMALLOC_PTR(dummy + MARGIN);
        if (ptr != NULL)
        {
            // ZbVhcRs[
            MemSet(ptr, (dummy + MARGIN), 0x00);
            StrCopy(ptr, sId);
            NNshGlobal->connectedSessionId = ptr;
        }
        ptr = sId;
        while ((*ptr != ':')&&(*ptr != '\0'))
        {
            ptr++;
        }
        if (*ptr != '\0')
        {
            *ptr = '\0';
            dummy = StrLen(sId);
            ptr = MEMALLOC_PTR(dummy + MARGIN);
            if (ptr != NULL)
            {
                // [U[G[WFgRs[
                MemSet(ptr, (dummy + MARGIN), 0x00);
                StrCopy(ptr, sId);
                NNshGlobal->customizedUserAgent = ptr;
            }
        }            
    }
    // OCL^Ă
    NNshGlobal->loginDateTime = TimGetSeconds();

    // OCɐ\
    NNsh_InformMessage(ALTID_INFO, MSG_LOGIN_SUCCESS, (NNshGlobal->NNsiParam)->oysterUserId, 0);

FUNC_END:
    MEMFREE_PTR(buf);
    MEMFREE_PTR(buffer);
    return (errNone);
}
#endif

/*=========================================================================*/
/*   Function : UpdateThreadResponseNumber                                 */
/*                                              XɊ܂܂郌XXV */
/*=========================================================================*/
UInt16  UpdateThreadResponseNumber(UInt16 dbIndex)
{
    Err                  ret;
    NNshSubjectDatabase *subjDB;
    NNshMessageIndex    *msgIndex;
    UInt16               bufferSize, fileMode, nofMsg;
    Char                *fileName, *area;

    fileName = MEMALLOC_PTR(MAXLENGTH_FILENAME + MARGIN);
    if (fileName == NULL)
    {
        // ̈mێs...
        return (0);
    }

    subjDB = MEMALLOC_PTR(sizeof(NNshSubjectDatabase) + MARGIN);
    if (subjDB == NULL)
    {
        // ̈mێs...
        MEMFREE_PTR(fileName);
        return (0);
    }

    // X܂擾
    ret = Get_Subject_Database(dbIndex, subjDB);
    if (ret != errNone)
    {
        // subjectf[^x[Xf[^擾Ɏs
        NNsh_DebugMessage(ALTID_ERROR, "Get_Subject_Database()", "", ret);
        MEMFREE_PTR(fileName);
        MEMFREE_PTR(subjDB);
        return (0);
    }

    bufferSize = sizeof(NNshMessageIndex) + (NNshGlobal->NNsiParam)->bufferSize + MARGIN * 2;
    msgIndex   = MEMALLOC_PTR(bufferSize);
    if (msgIndex == NULL)
    {
        MEMFREE_PTR(subjDB);
        MEMFREE_PTR(fileName);
        return (0);
    }
    MemSet(msgIndex, bufferSize, 0x00);

    // bZ[WItZbg̈mۂ
    bufferSize = sizeof(UInt32) * ((NNshGlobal->NNsiParam)->msgNumLimit + MARGIN);
    (msgIndex)->msgOffset = MEMALLOC_PTR(bufferSize);
    if ((msgIndex)->msgOffset == NULL)
    {
        // bZ[WItZbg̈̊mێs
        MEMFREE_PTR(msgIndex);
        MEMFREE_PTR(subjDB);
        MEMFREE_PTR(fileName);
        NNsh_InformMessage(ALTID_ERROR, MSG_ERR_MEMPTR_NEW_BUFF, " size:",
                           bufferSize);
        return (0);
    }
    MemSet((msgIndex)->msgOffset, bufferSize, 0x00);

    msgIndex->bbsType = (UInt16) subjDB->bbsType;

    // ǂݍރt@C̏
    MemSet (fileName, sizeof(fileName), 0x00);

    // OFFLINEX̂Ƃ́AboardNicktȂ悤ɂ
    if (StrCompare(subjDB->boardNick, OFFLINE_THREAD_NICK) != 0)
    {
        StrCopy(fileName, subjDB->boardNick);
    }
    else
    {
        // OFFLINEXVFSɊi[Ăꍇɂ́AfBNgtB
        if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_USEOFFLINE) != 0)
        {
            // Ox[XfBNgt
            if ((NNshGlobal->logPrefixH == 0)||
                ((area = MemHandleLock(NNshGlobal->logPrefixH)) == NULL))
            {
                StrCopy(fileName, LOGDATAFILE_PREFIX);
            }
            else
            {
                StrCopy(fileName, area);
                MemHandleUnlock(NNshGlobal->logPrefixH);
            }

            // ɃTufBNgĕt
            GetSubDirectoryName(subjDB->dirIndex, &fileName[StrLen(fileName)]);
        }
    }
    StrCat (fileName, subjDB->threadFileName);

    // t@Ĉ肩ŁAJ[h؂ւ
    if (subjDB->msgState == FILEMGR_STATE_OPENED_STREAM)
    {
        fileMode = ((NNSH_FILEMODE_TEMPFILE)|(NNSH_FILEMODE_READONLY));
    }
    else
    {
        fileMode = (NNSH_FILEMODE_READONLY);
    }
    nofMsg = 0;
    ret = OpenFile_NNsh(fileName,fileMode,&(msgIndex->fileRef));
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Message File Open :", fileName, ret);
        goto FUNC_END;
    }
    GetFileSize_NNsh(&(msgIndex->fileRef), &(msgIndex->fileSize));

    //  bZ[WXbh̃CfbNX쐬
    ret = CreateMessageThreadIndex(msgIndex, &(msgIndex->nofMsg), 
                                   msgIndex->msgOffset,
                                   (UInt16) subjDB->bbsType);
    if (ret != errNone)
    {
        // X̔ԍ擾ɎsAXVȂ
        msgIndex->nofMsg = 0;
        NNsh_DebugMessage(ALTID_ERROR, "ERR>index creation failure", "", ret);
    }
    nofMsg = msgIndex->nofMsg;
    CloseFile_NNsh(&(msgIndex->fileRef));

FUNC_END:
    // I
    MEMFREE_PTR((msgIndex)->msgOffset);
    MEMFREE_PTR(msgIndex);
    MEMFREE_PTR(fileName);

    // MXɍXVǂmF
    if (nofMsg != 0)
    {
        if (subjDB->maxLoc != nofMsg)
        {
            // X̍XVmAő僌XƃXԂύX
            subjDB->maxLoc = nofMsg;
            subjDB->state  = NNSH_SUBJSTATUS_REMAIN;
        }
        else
        {
            // XSǂłȂƂAuVv}[NĂ
            // ɁAǃ}[NɕύX
            if ((subjDB->maxLoc > subjDB->currentLoc)&&
                (subjDB->state == NNSH_SUBJSTATUS_NEW))
            {
                // New}[N
                subjDB->state = NNSH_SUBJSTATUS_REMAIN;
            }
        }

        // XcaXV
        update_subject_database(dbIndex, subjDB); 
    }

    MEMFREE_PTR(subjDB);
    return (nofMsg);
}
