/*============================================================================*
 *  FILE: 
 *     getlog.c
 *
 *  Description: 
 *     QƃÕO擾
 *===========================================================================*/
#define GETLOG_C
#include "local.h"

#ifdef USE_LOGCHARGE

/*--------------------------------------------------------------------------*/
/*  getLogFileList() : Ot@C擾ׂURL̈ꗗ擾        */
/*                                                                          */
/*                                                                          */
/*        ̊֐̈ŁAXVf[^ : urlCnt, listArray, urlList */
/*--------------------------------------------------------------------------*/
static Err getLogFileList(Char   *fileName,  Char   *baseURL,
                          UInt32  tokenId,   UInt16 *urlCnt,
                          Char  **listArray, Char  **urlList)
{
    Err           ret;
    UInt16        maxCnt, maxSize, bufCnt, status;
    UInt32        offset, readSize;
    Char         *buffer, *chkPtr, *tempURL, *urlPtr, *urlArray;
    Char         *ptr, *ptr2;
    NNshFileRef   fileRef;
    NNshLogTokenDatabase *logToken;
    
    // 擾URLꗗ̍őTCYϐɔf
    maxCnt = *urlCnt;

    // ϐNA
    *urlCnt = 0;
    *listArray  = NULL;

    // URLobt@̈̊m
    tempURL = MEMALLOC_PTR((MAX_GETLOG_URL) + MARGIN);
    if (tempURL == NULL)
    {
        return (~errNone);
    }
    MemSet(tempURL, (MAX_GETLOG_URL + MARGIN), 0x00);

    // URLꗗ̊i[̈mۂ
    maxSize = (MAX_GETLOG_URL + 1) * maxCnt + MARGIN;
    if (maxSize > NNSH_WORKBUF_MAX)
    {
        maxSize = NNSH_WORKBUF_MAX;
    }
    *urlList = MEMALLOC_PTR(maxSize);
    if (*urlList == NULL)
    {
        MEMFREE_PTR(tempURL);
        return (~errNone);
    }
    MemSet(*urlList, maxSize, 0x00);
    urlArray = *urlList;

    // t@Cǂݍݗ̈mۂ
    maxSize = (NNshGlobal->NNsiParam)->bufferSize - maxSize;
    buffer = MEMALLOC_PTR(maxSize + MARGIN);
    if (buffer == NULL)
    {
        MEMFREE_PTR(tempURL);
        MEMFREE_PTR(*urlList);
        return (~errNone);
    }
    MemSet(buffer, (maxSize + MARGIN), 0x00);
    maxSize = maxSize - MARGIN;
    
    // g[Nf[^̗̈mۂ
    logToken = MEMALLOC_PTR(sizeof(NNshLogTokenDatabase) + MARGIN);
    if (logToken == NULL)
    {
        MEMFREE_PTR(tempURL);
        MEMFREE_PTR(buffer);
        MEMFREE_PTR(*urlList);
        return (~errNone);
    }

    // g[Nf[^̎擾
    MemSet(logToken, (sizeof(NNshLogTokenDatabase) + MARGIN), 0x00);
    if (GetLogToken(tokenId, logToken) != errNone)
    {
        MemSet(logToken, (sizeof(NNshLogTokenDatabase) + MARGIN), 0x00);
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, " startToken : %s ", logToken->startToken);
    HostTraceOutputTL(appErrorClass, " endToken : %s ", logToken->endToken);
#endif // #ifdef USE_REPORTER

    // t@C̃I[v
    ret = OpenFile_NNsh(fileName, NNSH_FILEMODE_READONLY, &fileRef);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Read File Open :", fileName, ret);
        MEMFREE_PTR(tempURL);
        MEMFREE_PTR(logToken);
        MEMFREE_PTR(buffer);
        MEMFREE_PTR(*urlList);
        return (ret);
    }

    // t@Cf[^ubNƂɎ擾
    status = NNSH_MSGTOKENSTATE_NONE;
    offset = 0;
    while ((ret == errNone)&&(status != NNSH_MSGTOKENSTATE_END))
    {
        readSize = 0;
        MemSet(buffer, (maxSize + MARGIN), 0x00);

        ret  = ReadFile_NNsh(&fileRef, offset, maxSize, buffer, &readSize);
        if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
        {        
            // t@Cǂ݂݃G[AI
            NNsh_InformMessage(ALTID_ERROR, "ReadFile_NNsh() :", fileName, ret);
            break;
        }

        chkPtr = buffer;
        if ((status == NNSH_MSGTOKENSTATE_NONE)&&(logToken->startToken[0] != '\0'))
        {
            //  擪̋؂蕶T
            ptr = StrStr(buffer, logToken->startToken);
            if (ptr == NULL)
            {
                // f[^擪̋؂肪ȂAobt@ǂݍ
                continue;
            }
            chkPtr = ptr + StrLen(logToken->startToken);
        }
        status = NNSH_MSGTOKENSTATE_MESSAGE;

        // ǂݍ񂾃obt@ɁA̋؂蕶Ă邩ׂ
        if (logToken->endToken[0] != '\0')
        {
            ptr = StrStr(buffer, logToken->endToken);
            if (ptr != NULL)
            {
                // f[^𔭌I f[^͂܂łƂ
                // (f[^̃|C^ʒuvZ܂łȂ߁A
                //  ςȌvZ@iobt@̐擪΁[ƃCNgj
                //  ɂ...)
                readSize = 0;
                while (ptr > buffer)
                {
                    ptr--;
                    readSize++;
                }
                status = NNSH_MSGTOKENSTATE_END;
#ifdef USE_REPORTER
                HostTraceOutputTL(appErrorClass, " DETECT END SEPARATOR ");
#endif // #ifdef USE_REPORTER
            }
        }

#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, " FILE readSize : %lu, buffer : %p ", readSize, buffer);
#endif // #ifdef USE_REPORTER

        //  AnchorT... (chkPtrɌJn̐擪Aǂݍ݃TCYreadSize)
        while (chkPtr < (buffer + readSize))
        {
            ptr = StrStr(chkPtr, "<link>");
            if (ptr != NULL)
            {
                // <link> o...NtempURLɐ؂o
                ptr = StrStr(ptr, "http://");
                if (ptr != NULL)
                {
                    // URL̖肷...
                    ptr2 = StrStr(ptr, "<");
                    while (ptr < ptr2)
                    {
                        ptr2--;
                        if (*ptr2 > ' ')
                        {
                            break;
                        }
                    }
                    MemSet(tempURL, (MAX_GETLOG_URL + MARGIN), 0x00);
                    MemMove(tempURL, ptr, ((ptr2 - ptr) + 1));
                    // ؂oURLÓǂ`FbN郍WbN...
                    goto VALIDATE_URL;
                }
            }

            // 啶AJ[ƏAJ[̂ǂ炩܂܂邩`FbN
            ptr = StrStr(chkPtr, "<a");
            ptr2 = StrStr(chkPtr, "<A");
            if ((ptr == NULL)&&(ptr2 == NULL))
            {
                // AJ[ȂAƂ肠AƂ߂Ă݂B
                if (readSize > MARGIN)
                {
                    readSize = readSize - MARGIN;
                }
                // t@C̎̃ubNֈړ
#ifdef USE_REPORTER
                HostTraceOutputTL(appErrorClass, " not found anchor : readSize :%d", readSize);
#endif // #ifdef USE_REPORTER
                break;
            }
            if ((ptr == NULL)||((ptr2 != NULL)&&(ptr > ptr2)))
            {
                // 啶AJ[̕AJ[Oɂꍇɂ́Aptr
                // 啶AJ[̂̂ɓւ
                ptr = ptr2;
            }
            ptr = ptr + 2; // "<a"ɂ߂
            ptr2 = StrStr(ptr, ">");  // AJ[̖擾ł邩mF
            if (ptr2 == NULL)
            {
                // AJ[̖mFłȂAt@C̎ubNֈړ
                if (ptr != buffer)
                {
                    readSize = (ptr - buffer);
                }
#ifdef USE_REPORTER
                HostTraceOutputTL(appErrorClass, " NOT FOUND TAIL OF ANCHOR readSize: %d ", readSize);
#endif // #ifdef USE_REPORTER
                break;
            }
            // URL ptr ` ptr2 ̊Ԃ(m)B
            while ((ptr < ptr2)&&(*ptr != '\0'))
            {
                if (((*ptr == 'h')||(*ptr == 'H'))&&
                    ((*(ptr + 1) == 'r')||(*(ptr + 1) == 'R'))&&
                    ((*(ptr + 2) == 'e')||(*(ptr + 2) == 'E'))&&
                    ((*(ptr + 3) == 'f')||(*(ptr + 3) == 'F')))
                {
                    while ((*ptr != '"')&&(*ptr != '\'')&&
                           (*ptr != '.')&&(*ptr != '/')&&
                           (ptr < ptr2)&&(*ptr != '\0'))
                    {
                        ptr++;
                    }
                    break;
                }
                ptr++;
            }
            if (ptr >= ptr2)
            {
                // f[^ُÃAJ[͂
                chkPtr = ptr2 + 1;
                continue;
            }
            if (*ptr != '/')
            {
                ptr++;
            }
            // tempURLփAJ[؂o
            bufCnt = 0;
            MemSet(tempURL, (MAX_GETLOG_URL + MARGIN), 0x00);
            urlPtr = tempURL;
            while ((*ptr != '"')&&(*ptr != '\'')&&(*ptr != ' ')&&
                    (*ptr != 0x00)&&(ptr < ptr2))
            {
                if (bufCnt < MAX_GETLOG_URL)
                {
                    // URLURLi[obt@Ɏ܂Ƃ͕Rs[
                    *urlPtr = *ptr;
                    urlPtr++;
                    bufCnt++;
                }
                ptr++;
            }

#ifdef USE_REPORTER
            if (bufCnt > MAX_GETLOG_URL)
            {
                HostTraceOutputTL(appErrorClass, " ...DATA OVERFLOW... %d(%s)", bufCnt, tempURL);
            }
#endif // #ifdef USE_REPORTER
            
            // tempURLɐ؂oURLAꂪ(擾̂)ÓURL`FbN
            // L͈̔͊O肵ȂmF
            if (ptr >= buffer + readSize)
            {
                // L͈̔͊OAURLo^͂Ȃ
#ifdef USE_REPORTER
                HostTraceOutputTL(appErrorClass, " RANGE OVER : %s ", tempURL);
#endif // #ifdef USE_REPORTER
                // breakÃobt@̈ǂݍ...
                break;
            }

            // x
            ptr = StrStr(tempURL, "#");
            if (ptr != NULL)
            {
                // #tĂAÓURLł͂Ȃ
                // (̃AJ[͂)
                chkPtr = ptr2 + 1;
                continue;
            }

VALIDATE_URL:
            ptr = tempURL;
            if (((*ptr == 'h')||(*ptr == 'H'))&&
                ((*(ptr + 1) == 't')||(*(ptr + 1) == 'T'))&&
                ((*(ptr + 2) == 't')||(*(ptr + 2) == 'T'))&&
                ((*(ptr + 3) == 'p')||(*(ptr + 3) == 'P')))
            {
                //////////////////////////////////////////////////////////////
                // httpvgR(URL)tAÓURLAURLXgɓo^
                // (ő僊Nȉ̏ꍇ)
                //////////////////////////////////////////////////////////////
                if (*urlCnt < maxCnt)
                {
                    if ((urlArray + StrLen(tempURL)) < (maxSize + *urlList))                        
                    {
                        StrCopy(urlArray, tempURL);
                        urlArray[StrLen(tempURL)] = '\0';                      
                        listArray[*urlCnt] = urlArray;
                        urlArray = urlArray + StrLen(urlArray) + 1;
                        (*urlCnt)++;
                    }
#ifdef USE_REPORTER
                    HostTraceOutputTL(appErrorClass, " %d, URL:%s ", *urlCnt, tempURL);
#endif // #ifdef USE_REPORTER
                }
                chkPtr = ptr2 + 1;
                continue;  // ̃AJ[Tɂ
            }
            ///////////////////////////////////////////////////////////////////
            // x[XURLʂ̂ƂŎw肳Ăꍇ
            // iΈʒuŃAJ[w肳Ăꍇ...j
            // x[XURL炩߃Rs[
            ///////////////////////////////////////////////////////////////////
            StrCopy(urlArray, baseURL);
            ptr = urlArray + StrLen(urlArray) - 1;
            // '/'T
            while ((ptr > urlArray)&&(*ptr != '/'))
            {
                ptr--;
            }
            ptr++;

            // 擪̕mFRs[
            MemSet(ptr, (StrLen(tempURL) + 1), 0x00);
            if ((tempURL[0] == '.')||(tempURL[0] == '/'))
            {
                // ΃AhXpXH( '/'͂ƈُ킾ǁAAA)
                StrCopy(ptr, &tempURL[1]);
            }
            else
            {
                StrCopy(ptr, tempURL);
            }

            // (ő僊Nȉ̏ꍇAURLƂēo^)
            if (*urlCnt < maxCnt)
            {
                listArray[*urlCnt] = urlArray;
                urlArray = urlArray + StrLen(urlArray) + 1;
                (*urlCnt)++;
#ifdef USE_REPORTER
                HostTraceOutputTL(appErrorClass, " %d, url:%s ", *urlCnt, tempURL);
#endif // #ifdef USE_REPORTER
            }
            chkPtr = ptr2 + 1;
        }             // while (chkPtr < buffer + readSize)
        offset = offset + readSize;   // ǂݍސ擪肷
    }                 // while ((ret == errNone)&&(status != NNSH_MSGTOKENSTATE_END))
    ret = errNone;

    // Ƃ܂
    CloseFile_NNsh(&fileRef);
    MEMFREE_PTR(tempURL);
    MEMFREE_PTR(logToken);
    MEMFREE_PTR(buffer);
    return (ret);
}

/*--------------------------------------------------------------------------*/
/*  ReadOnlyLogDataPickup() : QƃÕO擾                      */
/*                                                                          */
/*                                                                          */
/*                    ̊֐̈ŁAXVf[^ : url, fileName  */
/*--------------------------------------------------------------------------*/
Err ReadOnlyLogDataPickup(NNshGetLogDatabase *dbData, Char *url, Char *fileName, UInt16 recNum, UInt16 depth, UInt16 number, Char *dateTime)
{
    Err                  ret;
    Boolean              workAround, updateRecord;
    UInt16               index, bufSize, kanjiCode, redirectCnt, titleSize;
    UInt32               readSize, offset, dummy, offsetW;
    DmOpenRef            subjRef;
    Char                *ptr, *file, *realBuf, *chk, *dateBuf;
    NNshSubjectDatabase *subjDb;
    NNshFileRef          fileRefR, fileRefW;

    // ̈mۂ
    bufSize = sizeof(NNshSubjectDatabase) + MARGIN;
    subjDb = MEMALLOC_PTR(bufSize);
    if (subjDb == NULL)
    {
        // ꎞ̈̊mۂɎs
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:", bufSize);
        return (~errNone);
    }
    MemSet(subjDb, sizeof(NNshSubjectDatabase) + MARGIN, 0x00);
  
    dateBuf = MEMALLOC_PTR(sizeof("If-Modified-Since: ") + MAX_GETLOG_DATETIME + MARGIN);
    if (dateBuf == NULL)
    {
        // ꎞ̈̊mۂɎs...
        MEMFREE_PTR(subjDb);
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:", (sizeof("If-Modified-Since: ") + MAX_GETLOG_DATETIME + MARGIN));
        return (~errNone);
    } 
    MemSet(dateBuf, (sizeof("If-Modified-Since: ") + MAX_GETLOG_DATETIME + MARGIN), 0x00);
  
    // w肳ꂽURL\
    NNsh_DebugMessage(ALTID_INFO, "url:", url, 0);

    // R[h
    kanjiCode = dbData->kanjiCode;

    // ꎞobt@̈m
    bufSize = (NNshGlobal->NNsiParam)->bufferSize + MARGIN;
    realBuf = MEMALLOC_PTR(bufSize);
    if (realBuf == NULL)
    {
        // ꎞ̈̊mۂɎs
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:", bufSize);
        MEMFREE_PTR(dateBuf);
        MEMFREE_PTR(subjDb);
        return (~errNone);
    }
    MemSet(realBuf, bufSize, 0x00);
    bufSize = bufSize - MARGIN;

    // Xf[^x[X̃I[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &subjRef);
    if (subjRef == 0)
    {
        // G[(fobO\)
        NNsh_DebugMessage(ALTID_ERROR, "OpenDatabase_NNsh() ", " ", 0);
        MEMFREE_PTR(subjDb);
        MEMFREE_PTR(dateBuf);
        MEMFREE_PTR(realBuf);
        return (~errNone);
    }

    // ot@C̓ƁAXcaɏރf[^
    if (StrLen(fileName) != 0)
    {
        // Ƀt@Cw肳Ăꍇɂ́Ãt@Cgp
        //                                      (t@CXDBɊi[)
        StrNCopy(subjDb->threadFileName, fileName, MAX_THREADFILENAME);
    }
    MemSet(fileName, sizeof(fileName), 0x00);

    // OFFLINEXVFSɊi[ꍇɂ́AfBNgtB
    workAround = false;
    if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_USEOFFLINE) != 0)
    {
        // Ox[XfBNgt
        if ((NNshGlobal->logPrefixH == 0)||
            ((ptr = MemHandleLock(NNshGlobal->logPrefixH)) == NULL))
        {
            StrCopy(fileName, LOGDATAFILE_PREFIX);
        }
        else
        {
            StrCopy(fileName, ptr);
            MemHandleUnlock(NNshGlobal->logPrefixH);
        }
        subjDb->msgState = FILEMGR_STATE_OPENED_VFS; 

        // CLIE4pstOĂ邩`FbN
        if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_WORKAROUND) != 0)
        {
            workAround = true;
        }       
    }
    else
    {
        subjDb->msgState = FILEMGR_STATE_OPENED_STREAM;        
    }    
    StrCopy(subjDb->threadTitle, dbData->dataTitlePrefix);
    StrCopy(subjDb->boardNick, OFFLINE_THREAD_NICK);
    subjDb->state = NNSH_SUBJSTATUS_UNKNOWN;

    // Ot@C̍\z
    file = &fileName[StrLen(fileName)];
    if (StrLen(subjDb->threadFileName) != 0)
    {
        // Ƀt@Cw肳Ăꍇ(̃t@C𗘗p)
        StrCat(fileName, subjDb->threadFileName);
    }
    else
    {
        // Ƀt@Cw肳ĂȂꍇ(IɃt@C𐶐)
        StrCat (fileName, FILE_LOGCHARGE_PREFIX);
        NUMCATI(fileName, recNum);
        StrCat (fileName, "-");
        NUMCATI(fileName, depth);
        StrCat (fileName, "-");
        NUMCATI(fileName, number);    
        StrCat (fileName, FILE_LOGCHARGE_SUFFIX);    
        StrNCopy(subjDb->threadFileName, file, MAX_THREADFILENAME);
    }

    redirectCnt = 0;

    // 擾ς݃O݂邩ǂ̃`FbN
    // (Xf[^̂cáAt@Cł̃\[gĂȂ̂œȂAAA)
    if (IsExistRecordRR_NNsh(subjRef, subjDb->threadFileName, NNSH_KEYTYPE_CHAR, 0, &index) == errNone)
    {
        // f[^ɂAf[^̍XV`FbNɐ؂ւ
        if (dbData->getDateTime[0] != '\0')
        {
            StrCopy(dateBuf, "If-Modified-Since: ");
            StrCat (dateBuf, dbData->getDateTime);
        }
        updateRecord = true;   // 擾ς݃O݂
    }
    else
    {
        // 擾ς݃O݂Ȃ
        updateRecord = false;
    }

////////  _CNgwꍇɂ́Aɖ߂ĂƂȂ  ////////
GET_URL_DATA:

    // f[^̎擾
    // zXgXꗗf[^擾
    if (dbData->wwwcMode != 0)
    {
        // ꕔ(wb_̂)擾
        ret = NNshHttp_comm(HTTP_SENDTYPE_GET_NOTMONA, url, NULL, dateBuf,
                            HTTP_GETLOG_START, HTTP_GETLOG_LEN, NULL);
    }
    else
    {
        // ʏ擾[h
        ret = NNshHttp_comm(HTTP_SENDTYPE_GET_NOTMONA, url, NULL, dateBuf,
                            HTTP_RANGE_OMIT, HTTP_RANGE_OMIT, NULL);
    }

    if (ret != errNone)
    {
        // (^CAEgȊO)ʐMG[
        if (ret != netErrTimeout)
        {
            NNsh_InformMessage(ALTID_ERROR,MSG_ERROR_HTTP_COMM, "[logCharge]", ret);
            goto FUNC_END;
        }

        // ʐM^CAEg
        NNsh_InformMessage(ALTID_ERROR, MSG_OCCUR_TIMEOUT, "[logCharge]", ret);
        goto FUNC_END;
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "logGET URL:%s [DONE]", url);
#endif // #ifdef USE_REPORTER

    // ǂݏot@C̃I[v
    ret = OpenFile_NNsh(FILE_RECVMSG,
                        (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                        &fileRefR);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Read File Open :", FILE_RECVMSG, ret);
        goto FUNC_END;
    }

    // BUSYEBhE\
    Show_BusyForm(MSG_MESSAGE_ENTRY);

    // f[^̓ǂݏo
    readSize = 0;
    MemSet(realBuf, bufSize, 0x00);
    ret  = ReadFile_NNsh(&fileRefR, 0, bufSize, realBuf, &readSize);
    if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
    {
        NNsh_DebugMessage(ALTID_ERROR, "Read Failure :", FILE_RECVMSG, ret);
        goto CLOSE_END;
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "++++++++++HTTP MESSAGE++++++++++");
    HostTraceOutputTL(appErrorClass, "%s", realBuf);
    HostTraceOutputTL(appErrorClass, "++++++++++++++++++++++++++++++++");
#endif // #ifdef USE_REPORTER
    
    // if ((StrNCompare(realBuf,"HTTP/1.1 3", 10) == 0)||
    //     (StrNCompare(realBuf,  "HTTP/1.0 3", 10) == 0))
    if ((redirectCnt < MAX_REDIRECT_COUNT)&&(((realBuf[0] == 'H')&&
        (realBuf[1] == 'T')&&(realBuf[2] == 'T')&&
        (realBuf[3] == 'P')&&(realBuf[9] == '3'))))
    {
        // R[h(304, Not Modified)̂Ƃ...
        if ((realBuf[10] == '0')&&(realBuf[11] == '4'))
        {
            // f[^̍XV͍s킸IB
            NNsh_DebugMessage(ALTID_INFO, "HTTP/1.x 304 Not Modified :", url, 0);
            goto CLOSE_END;
        }

        // {ȂA"Location:" TׂA
        ptr = StrStr(realBuf, "http://");
        if (ptr != NULL)
        {
            // _CNgĂAAAʂURLēxf[^蒼
            Hide_BusyForm(false);
            CloseFile_NNsh(&fileRefR);
        
            chk = ptr;
            // f[^̖T
            while ((*chk != 0x0d)&&(chk < ptr + (MAX_GETLOG_URL - 1)))
            {
                chk++;
            }
            chk = 0x00;

            // VURLRs[
            MemSet(url, MAX_GETLOG_URL, 0x00);
            StrNCopy(url, ptr, MAX_GETLOG_URL);

            redirectCnt++;

#ifdef USE_REPORTER
            HostTraceOutputTL(appErrorClass, "REDIRECT(%d) TO URL:%s ", redirectCnt, url);
#endif // #ifdef USE_REPORTER

            // f[^̍ēx蒼
            goto GET_URL_DATA;
        }
    }

    // T[o̍XV擾i[
    chk = "Last-modified";
    ptr = StrStr(realBuf, chk);
    if (ptr == NULL)
    {
        chk = "Last-Modified";
        ptr = StrStr(realBuf, chk);
        if (ptr == NULL)
        {
            // T[ȏM擾i[
            chk = "Date";
            ptr = StrStr(realBuf, chk);
        }
    }
    if ((dateTime != NULL)&&(ptr != NULL))
    {
        ptr = ptr + StrLen(chk);
        while ((*ptr != '\x0d')&&((*ptr == ':')||(*ptr <= ' ')))
        {
            ptr++;
        }
        dummy = 0;
        while ((dummy < MAX_GETLOG_DATETIME)&&
                (*(ptr + dummy) != '\x0d')&&
                (*(ptr + dummy) != '\x0a')&&
                (*(ptr + dummy) != '\0'))
        {
            dummy++;
        }
        MemSet(dateTime, MAX_GETLOG_DATETIME, 0x00);
        StrNCopy(dateTime, ptr, dummy);

#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "DateTime>>>%s", dateTime);
#endif // #ifdef USE_REPORTER
    }

    if (dbData->wwwcMode != 0)
    {
        // XV`FbNIAŐ܂Ԃ...
        // (subjDBȂ...̂AŁH)
        NNsh_DebugMessage(ALTID_INFO, "SITE UPDATE :", url, 0);
        if (updateRecord == true)
        {
            // ɃOꍇAxbZ[Woɂ
            NNsh_DebugMessage(ALTID_WARN, "LOG DATA EXIST, but... ", "", 0);
        }
        goto CLOSE_END;
    }

    // R[h̃`FbN
    ptr = StrStr(realBuf, "charset=");
    dummy = StrLen("charset=");
    if (ptr == NULL)
    {
        // charsetȂꍇɂ́Aencodinggp
        ptr   = StrStr(realBuf, "encoding=");
        dummy = StrLen("encoding=");
    }
    if (ptr != NULL)
    {
        // ǂݔ΂
        ptr = ptr + dummy;
        
        // 󔒕ǂݔ΂
        while ((*ptr == ' ')||(*ptr == '\t')||(*ptr == '"'))
        {
            ptr++;
        }

        if (StrNCaselessCompare(ptr, "iso-2022-jp", StrLen("iso-2022-jp")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_JIS;
        }
        else if (StrNCaselessCompare(ptr, "euc-jp", StrLen("euc-jp")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_EUC;
        }
        else if (StrNCaselessCompare(ptr, "x-euc-jp", StrLen("x-euc-jp")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_EUC;
        }
        else if (StrNCaselessCompare(ptr, "shift_jis", StrLen("shift_jis")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        }
        else if (StrNCaselessCompare(ptr, "x-sjis", StrLen("x-sjis")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        }
        else if (StrNCaselessCompare(ptr, "shift-jis", StrLen("shift-jis")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_SHIFTJIS;
        }
        else if (StrNCaselessCompare(ptr, "utf-8", StrLen("utf-8")) == 0)
        {
            kanjiCode = NNSH_KANJICODE_UTF8;
        }
    }

    // RSSɃ`FbNĂꍇɂ́A(I)UTF-8Ƃ
    if (dbData->rssData != 0)
    {
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "kanji :%d, utf-8:%d", 
                                               kanjiCode, NNSH_KANJICODE_UTF8);
#endif // #ifdef USE_REPORTER
        kanjiCode = NNSH_KANJICODE_UTF8;
    }

    // f[^̐擪T
    ptr = StrStr(realBuf, NNSH_HTTP_HEADER_ENDTOKEN);
    if (ptr == NULL)
    {
        // 擪Ȃ΁Af[^ubN̍ŏ͂
        NNsh_DebugMessage(ALTID_ERROR, "Data Failure :", FILE_RECVMSG, ret);
        ptr = realBuf;
    }

    // Rs[f[^̕␳
    //     ptrf[^{fB̐擪ɎĂB
    //     offsetǂݏot@C̐擪̃ItZbgĂB
    ptr = ptr + 4;   // 4́AStrLen(NNSH_HTTP_HEADER_ENDTOKEN) ƓB
    offset = (UInt32) (ptr - realBuf);

    // ^Cg̎擾
    file = StrStr(ptr, "<title");
    if (file == NULL)
    {
        // ^Cg^OłȂꍇ...
        file = StrStr(ptr, "<TITLE");
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "<TITLE(kanji:%d)>", kanjiCode);
#endif // #ifdef USE_REPORTER

    if (file != NULL)
    {
        // ^O̖T...
        file = file + StrLen("<TITLE");
        while (*file != '>')
        {
            file++;
        }
        file++;

        // ^Cgf[^̖T
        chk = StrStr(file, "</TITLE");
        if (chk == NULL)
        {
            chk = StrStr(file, "</title");
        }
        if (chk == NULL)
        {
            chk = file;
            *chk = ' ';
            chk++;
        }
        *chk = '\0';

        // X^Ci[̈Ƀf[^i[(R[h̕ϊYȂI)
        dummy = StrLen(subjDb->threadTitle);

        titleSize = StrLen(file);

#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "</TITLE(len:%lu, size:%d)>", dummy, titleSize);
#endif // #ifdef USE_REPORTER

        switch (kanjiCode)
        {
          case NNSH_KANJICODE_EUC:
            // EUC -> SJϊĊi[
            chk = MEMALLOC_PTR((titleSize * 2) + MARGIN);
            if (chk != NULL)
            {
                StrCopySJ(chk, file);
                StrNCopy(&subjDb->threadTitle[dummy], chk, MAX_THREADNAME - dummy - 1);
                MEMFREE_PTR(chk);
            }
            break;

          case NNSH_KANJICODE_JIS:
            // JIS -> SJϊĊi[(JIS...)
            chk = MEMALLOC_PTR((titleSize * 2) + MARGIN);
            if (chk != NULL)
            {
                StrCopyJIStoSJ(chk, file);
                StrNCopy(&subjDb->threadTitle[dummy], chk, MAX_THREADNAME - dummy - 1);
                MEMFREE_PTR(chk);
            }
             break;

          case NNSH_KANJICODE_UTF8:
            chk = MEMALLOC_PTR((titleSize * 2) + MARGIN);
            if (chk != NULL)
            {
                StrNCopyUTF8toSJ(chk, file, (titleSize * 2));
                StrNCopy(&subjDb->threadTitle[dummy], chk, MAX_THREADNAME - dummy - 1);
                MEMFREE_PTR(chk);
            }
            else
            {
                // UTF8̕ϊłȂꍇ...
                StrNCopy(&subjDb->threadTitle[dummy], file, MAX_THREADNAME - dummy - 1);
            }
            break;                

          case NNSH_KANJICODE_SHIFTJIS:
          default:
            // ̂܂܊i[
            StrNCopy(&subjDb->threadTitle[dummy], file, MAX_THREADNAME - dummy - 1);
            break;
        }
    }

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "TITLE : %s ", subjDb->threadTitle);
#endif // #ifdef USE_REPORTER

    // ݃t@C̃I[v
    ret = OpenFile_NNsh(fileName, NNSH_FILEMODE_CREATE, &fileRefW);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "Write File Open :", fileName, ret);
        goto CLOSE_END;
    }

    // ɓǂݍ߂Ƃ́Af[^̃{fBt@CɃRs[
    ret = errNone;
    offsetW = 0;
    while (ret == errNone)
    {
        readSize = 0;
        MemSet(realBuf, bufSize, 0x00);
        ret  = ReadFile_NNsh(&fileRefR, offset, bufSize, realBuf, &readSize);

        offset  = offset + readSize;
        if ((readSize % 2) != 0)
        {
            // ݃TCYɕ␳(CLIE4p̕ی)
            if (workAround == true)
            {
                realBuf[readSize] = ' ';
                readSize++;
            }
        }
        (void) WriteFile_NNsh(&fileRefW, offsetW, readSize, realBuf, &dummy);
        offsetW = offsetW + readSize;
    }

    // urlL^
    MemSet (realBuf, bufSize, 0x00);
    StrCopy(realBuf, "<br><hr><a href=\"");
    StrCat (realBuf, url);
    StrCat (realBuf, "\">");
    StrCat (realBuf, url);
    StrCat (realBuf, "</a>");
    
    readSize = StrLen(realBuf);
    if ((readSize % 2) != 0)
    {
        // ݃TCYɕ␳(CLIE4p̕ی)
        if (workAround == true)
        {
            realBuf[readSize] = ' ';
            readSize++;
        }
    }
    (void) WriteFile_NNsh(&fileRefW, offsetW, readSize, realBuf, &dummy);
    offsetW = offsetW + readSize;

    // Ot@CTCYL^
    subjDb->fileSize = offsetW;
    
    // BBS^CvɊR[hǉ
    subjDb->bbsType = NNSH_BBSTYPE_HTML | (kanjiCode << NNSH_BBSTYPE_CHAR_SHIFT);

    // VXƂčXV
    subjDb->state = NNSH_SUBJSTATUS_NEW;

    // Xf[^o^ς݂̏ꍇAxf[^폜
    // (Xf[^̂cáAt@Cł̃\[gĂȂ̂œȂAAA)
    if (updateRecord == true)
    {
        // f[^ɂAf[^XV
        ret = UpdateRecord_NNsh(subjRef, index, sizeof(NNshSubjectDatabase), subjDb);
    }
    else
    {
        // f[^ȂAf[^o^
        ret = EntryRecord_NNsh(subjRef, sizeof(NNshSubjectDatabase), subjDb);
    }
    CloseFile_NNsh(&fileRefW);

CLOSE_END:
    // t@C̃N[Y
    Hide_BusyForm(false);
    CloseFile_NNsh(&fileRefR);

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "CLOSE END>>ReadOnlyLogDataPickup()");
#endif // #ifdef USE_REPORTER

FUNC_END:
    // f[^x[X̃N[Y
    CloseDatabase_NNsh(subjRef);

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "FUNC END>>ReadOnlyLogDataPickup"
                      "(subjDB:%x, dateBuf:%x, realBuf:%x)",
                      &subjDb, &dateBuf, &realBuf);
#endif // #ifdef USE_REPORTER

    // 0.125bÂ҂
    //index = SysTicksPerSecond() / 8;
    MEMFREE_PTR(subjDb);
    //SysTaskDelay(index);
    MEMFREE_PTR(dateBuf);
    //SysTaskDelay(index);
    MEMFREE_PTR(realBuf);

#ifdef USE_REPORTER
    HostTraceOutputTL(appErrorClass, "GET URL:%s DONE.", url);
#endif // #ifdef USE_REPORTER

    return (ret);
}

/*==========================================================================*/
/*  GetReadOnlyLogData_NNsh() : QƃÕO擾                          */
/*                                                                          */
/*==========================================================================*/
Err GetReadOnlyLogData_NNsh(void)
{
    Boolean              penState;
    UInt16               dbCount, loop, x, y, number, urlCnt;
    Char                *url, *fileName, dateTime[MAX_GETLOG_DATETIME];
    Char                *urlListCnt[MAX_URL_CNT], *urlList;
    DmOpenRef            dbRef;
    NNshGetLogDatabase  *dbData;

    // URLmۃobt@̎擾
    url = MEMALLOC_PTR((MAX_GETLOG_URL) + MARGIN);
    if (url == NULL)
    {
        return (~errNone);
    }
    MemSet(url, ((MAX_GETLOG_URL) + MARGIN), 0x00);

    // t@Cmۃobt@̎擾
    fileName = MEMALLOC_PTR(MAXLENGTH_FILENAME + MARGIN);
    if (fileName == NULL)
    {
        MEMFREE_PTR(url);
        return (~errNone);
    }
    MemSet(fileName, (MAXLENGTH_FILENAME + MARGIN), 0x00);

    // DBi[̈m
    dbData = MEMALLOC_PTR(sizeof(NNshGetLogDatabase) + MARGIN);
    if (dbData == NULL)
    {
        MEMFREE_PTR(fileName);
        MEMFREE_PTR(url);
        return (~errNone);
    }
    MemSet(dbData, (sizeof(NNshGetLogDatabase) + MARGIN), 0x00);

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        MEMFREE_PTR(dbData);
        MEMFREE_PTR(fileName);
        MEMFREE_PTR(url);
        return (~errNone);
    }

    // R[h擾
    GetDBCount_NNsh(dbRef, &dbCount);

    // p[}lgQƃOf[^ǂݏo
    for (loop = 0; loop < dbCount; loop++)
    {
        // R[h̓ǂݏo
        GetRecord_NNsh(dbRef, loop, sizeof(NNshGetLogDatabase), dbData);

        // DB̃xA擾xƓꍇAAA
        // (x[̎͑SĂ擾)
        if (((NNshGlobal->NNsiParam)->getROLogLevel == 0)||
            (dbData->usable == (NNshGlobal->NNsiParam)->getROLogLevel))
        {
            // Of[^̒o
            MemSet(url, (MAX_GETLOG_URL), 0x00);
            StrNCopy(url, dbData->dataURL, (MAX_GETLOG_URL));
            MemSet(fileName, MAXLENGTH_FILENAME, 0x00);
            MemSet(dateTime, MAX_GETLOG_DATETIME, 0x00);
            (void) ReadOnlyLogDataPickup(dbData, url, fileName, loop, 0, 0, dateTime);
            if (dbData->getDepth != 0)
            {
                // PKw̃Of[^擾
                urlCnt = MAX_URL_CNT;

                // BUSYEBhE\
                Show_BusyForm(MSG_CHECK_URLLIST);

                // Ot@CURLꗗ擾
                (void) getLogFileList(fileName, dbData->dataURL, dbData->tokenId, &urlCnt, urlListCnt, &urlList);

                Hide_BusyForm(false);

                for (number = 0; number < urlCnt; number++)
                {
                    // O擾(̈URL͉̊֐Ŕj󂳂邽)
                    MemSet(url, (MAX_GETLOG_URL), 0x00);
                    StrNCopy(url, urlListCnt[number], (MAX_GETLOG_URL));
                    MemSet(fileName, MAXLENGTH_FILENAME, 0x00);
#ifdef USE_REPORTER
                    HostTraceOutputTL(appErrorClass, "SUB get URL(%d):%s ", number, url);
#endif // #ifdef USE_REPORTER
                    (void) ReadOnlyLogDataPickup(dbData, url, fileName, loop, 1, number, NULL);
                }

                // URLꗗ
                MEMFREE_PTR(urlList);
            }
            // 擾ςĂꍇɂ́AXV
            if (dateTime[0] != '\0')
            {
                if (StrCompare(dbData->getDateTime, dateTime) != 0)
                {
                    MemMove(dbData->getDateTime, dateTime, MAX_GETLOG_DATETIME);
                    dbData->lastUpdate = TimGetSeconds();     // XVi[
                    dbData->state      = NNSH_SUBJSTATUS_NEW; // XV}[N
#ifdef USE_REPORTER
                    HostTraceOutputTL(appErrorClass, "Update DateTime:%s(%lu)", dbData->getDateTime, dbData->lastUpdate);
#endif // #ifdef USE_REPORTER
                    UpdateRecord_NNsh(dbRef, loop, sizeof(NNshGetLogDatabase), dbData);
                }
#if 0
                else
                {
                    // 擾ςĂȂꍇɂ́AXV}[N
                    dbData->state      = NNSH_SUBJSTATUS_NOT_YET;
                    UpdateRecord_NNsh(dbRef, loop, sizeof(NNshGetLogDatabase), dbData);
                }
#endif
            }
        }

        // y̏ԂE(ʃ^bvĂ邩mF)
        EvtGetPen(&x, &y, &penState);
        if (penState == true)
        {
            // y_EĂA~邩mFs
            if (NNsh_ErrorMessage(ALTID_CONFIRM,
                                  MSG_CONFIRM_ABORT_GETLOG, 
                                  MSG_NOTCHECK_RECORDS, dbCount - loop) == 0)
            {
                // OKꂽAbreak
                break;
            }
        }
    }

    // f[^x[X
    CloseDatabase_NNsh(dbRef);

    // DBR[ḧJ
    MEMFREE_PTR(dbData);
    MEMFREE_PTR(fileName);
    MEMFREE_PTR(url);

    return (errNone); 
}

/*-------------------------------------------------------------------------*/
/*   Function :   Handler_LogGetURL                                        */
/*                                      QƃO̎擾ݒCxgnh */
/*                 gpO[oȕϐ                                */
/*                                      NNshGlobal->work1  : SR[h  */
/*                                      NNshGlobal->work2  : \R[h  */
/*                        NNshGlobal->jumpSelection : ҏWR[h̑ */
/*                                                        (VK>1, ҏW>0) */
/*-------------------------------------------------------------------------*/
Boolean Handler_LogGetURL(EventType *event)
{
    UInt16              keyCode;
    NNshGetLogDatabase  dbData;
    DmOpenRef           dbRef;
    FormType           *frm;

    // ݂̃tH[擾
    switch (event->eType)
    { 
      // j[I
      case menuEvent:
        // ҏWCxgs
        return (NNsh_MenuEvt_Edit(event));
        break;

      case keyDownEvent:
        frm = FrmGetActiveForm();

        // L[R[hɂď𕪊򂳂
        keyCode = KeyConvertFiveWayToJogChara(event);
        switch (keyCode)
        {
          case vchrPageDown:
          case vchrJogDown:
          case vchrTrgJogDown:
          case vchrThumbWheelDown:
          case vchrJogRight:
          case chrUnitSeparator:  // J[\L[()̏
            // R[hɈړ
            if (NNshGlobal->work2 == 0)
            {
                // f[^̖AXVȂ
                return (true);
            }
            // f[^XV
            effectLogGetURL(frm);

            (NNshGlobal->work2)--;
            NNshGlobal->jumpSelection = 0;
            break;

          case vchrPageUp:
          case vchrJogUp:
          case vchrTrgJogUp:
          case vchrThumbWheelUp:
          case vchrJogLeft:
          case chrRecordSeparator:   // J[\L[()̏
            // OR[hɈړ
            if (((NNshGlobal->work2 + 1) == NNshGlobal->work1)||
                 (NNshGlobal->work1 == 0))
            {
                // f[^̐擪AXVȂ
                return (true);
            }
            // f[^XV
            effectLogGetURL(frm);

            (NNshGlobal->work2)++;
            NNshGlobal->jumpSelection = 0;
            break;

          case chrRightArrow:     // J[\L[E(5wayE)
          case chrLeftArrow:         // J[\L[(5way)
          case vchrThumbWheelPush:
          case vchrJogRelease:
          case chrCarriageReturn:
          case chrLineFeed:
          case chrEscape:
          default:
            return (false);
            break;
        }
        // QƃO`[WpDB̎擾
        OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
        if (dbRef == 0)
        {
            // ODB̃I[vsAI
            return (false);
        }

        // f[^ǂݏo
        MemSet(&dbData, sizeof(NNshGetLogDatabase), 0x00);
        GetRecord_NNsh(dbRef, NNshGlobal->work2, sizeof(NNshGetLogDatabase),
                       &dbData);

        // ǂݏof[^ʂɔf
        displayLogDataInfo(frm, &dbData);

        // DBN[Y
        CloseDatabase_NNsh(dbRef);
        return (true);
        break;

      case ctlSelectEvent:
        frm = FrmGetActiveForm();
        switch (event->data.ctlSelect.controlID)
        {
          case BTNID_GETLOG_PREV:
            // OR[hɈړ
            if (((NNshGlobal->work2 + 1) == NNshGlobal->work1)||
                 (NNshGlobal->work1 == 0))
            {
                // f[^̐擪AXVȂ
                return (true);
            }
            // f[^XV
            effectLogGetURL(frm);

            (NNshGlobal->work2)++;
            NNshGlobal->jumpSelection = 0;
            break;

          case BTNID_GETLOG_NEXT:
            // R[hɈړ
            if (NNshGlobal->work2 == 0)
            {
                // f[^̖AXVȂ
                return (true);
            }

            // f[^XV
            effectLogGetURL(frm);

            (NNshGlobal->work2)--;
            NNshGlobal->jumpSelection = 0;
            break;

          case BTNID_GETLOG_NEW:
            // VK擾쐬(f[^𖖔Ɉړ)
            // f[^XV
            effectLogGetURL(frm);

            // f[^ʂɔf
            MemSet(&dbData, sizeof(NNshGetLogDatabase), 0x00);
            dbData.usable = 1;
            displayLogDataInfo(frm, &dbData);
            NNshGlobal->jumpSelection = 1;
            NNshGlobal->work2 = 0;
            return (true);
            break;

          case BTNID_GETLOG_DELETE:
            // R[h폜
            if ((NNshGlobal->work1 != 0)&&(NNshGlobal->jumpSelection == 0))
            {
                // f[^{ɍ폜Ă悢mF
                if (NNsh_ConfirmMessage(ALTID_CONFIRM, "",
                                        MSG_CONFIRM_DELETE_DATA, 0) == 0)
                {
                    // QƃO`[WpDB̎擾
                    OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
                    if (dbRef == 0)
                    {
                        // ODB̃I[vsAI
                        return (false);
                    }
                    // R[h폜
                    DeleteRecordIDX_NNsh(dbRef, NNshGlobal->work2);
                    (NNshGlobal->work1)--;

                    if (NNshGlobal->work1 == NNshGlobal->work2)
                    {
                        // R[h폜ꍇ...
                        (NNshGlobal->work2)--;
                    }

                    // DBN[Y
                    CloseDatabase_NNsh(dbRef);
                }
            }            
            break;

          default:
            // Ȃ
            return (false);
            break;
        }
        // QƃO`[WpDB̎擾
        OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
        if (dbRef == 0)
        {
            // ODB̃I[vsAI
            return (false);
        }

        // f[^ǂݏo
        MemSet(&dbData, sizeof(NNshGetLogDatabase), 0x00);
        GetRecord_NNsh(dbRef, NNshGlobal->work2, sizeof(NNshGetLogDatabase),
                       &dbData);

        // ǂݏof[^ʂɔf
        displayLogDataInfo(frm, &dbData);

        // DBN[Y
        CloseDatabase_NNsh(dbRef);
        return (true);
        break;

      default: 
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   effectLogGetURL                                          */
/*                                              \f[^̃R[h𔽉f */
/*                 gpO[oȕϐ                                */
/*                                      NNshGlobal->work1  : SR[h  */
/*                                      NNshGlobal->work2  : \R[h  */
/*                        NNshGlobal->jumpSelection : ҏWR[h̑ */
/*                                                        (VK>1, ҏW>0) */
/*-------------------------------------------------------------------------*/
static Boolean effectLogGetURL(FormType *frm)
{
    DmOpenRef           dbRef;
    UInt16              data;
    Char               *ptr;
    NNshGetLogDatabase  dbData;
    FieldType          *fldP;
    MemHandle           txtH;
    
    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        return (false);
    }
    
    MemSet(&dbData, sizeof(NNshGetLogDatabase), 0x00);
    
    // OURL̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_GETLOG_URLSET));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        MemSet(dbData.dataURL, MAX_GETLOG_URL, 0x00);
        if (*ptr != '\0')
        {
            StrNCopy(dbData.dataURL, ptr, MAX_GETLOG_URL);
            MemHandleUnlock(txtH);
        }
        else
        {
            // URLw肳ȂAI
            MemHandleUnlock(txtH);
            CloseDatabase_NNsh(dbRef);
            return (false);
        }
    }

    // 񃌃x̐ݒ
    data  = LstGetSelection(FrmGetObjectPtr(frm, 
                                     FrmGetObjectIndex(frm, LSTID_GETLOG_USE)));
    dbData.usable = (UInt8) data;

    // RSS[hǂ
    data = 0;
    UpdateParameter(frm, CHKID_GETLOG_RSSDATA, &(data));
    dbData.rssData = (UInt8) data;

    // O擾Ȃǂ(O擾Ȃꍇɂ͂PKw擾Ȃ)
    data = 0;
    UpdateParameter(frm, CHKID_NOTGETLOG, &(data));
    dbData.wwwcMode = (UInt8) data;

    // PKw擾
    UpdateParameter(frm, CHKID_GETLOG_DEPTH, &(data));
    if ((dbData.wwwcMode == 0)&&(data != 0))
    {
        dbData.getDepth = 1;
    }
    else
    {
        dbData.getDepth = 0;
    }

    // Owb_̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_GETLOG_HEADER));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        MemSet(dbData.dataTitlePrefix, MAX_DATAPREFIX, 0x00);
        if (*ptr != '\0')
        {
            StrNCopy(dbData.dataTitlePrefix, ptr, MAX_DATAPREFIX);
        }
        MemHandleUnlock(txtH);
    }

    // 擾於̂̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_GETLOG_TITLE));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        MemSet(dbData.dataTitle, MAX_TITLE_LABEL, 0x00);
        if (*ptr != '\0')
        {
            StrNCopy(dbData.dataTitle, ptr, MAX_TITLE_LABEL);
        }
        MemHandleUnlock(txtH);
    }

    // ؂蕶ID̎擾
    data  = LstGetSelection(FrmGetObjectPtr(frm, 
                                     FrmGetObjectIndex(frm, LSTID_NORMTOKEN)));
    if (NNshGlobal->work4 != NULL)
    {
        dbData.tokenId = NNshGlobal->work4[data];
    }

    // Tu؂蕶ID擾
    data  = LstGetSelection(FrmGetObjectPtr(frm, 
                                     FrmGetObjectIndex(frm, LSTID_SUBTOKEN)));
    if (NNshGlobal->work4 != NULL)
    {
        dbData.subTokenId = NNshGlobal->work4[data];
    }

    // R[h̎擾
    data  = LstGetSelection(FrmGetObjectPtr(frm, 
                                     FrmGetObjectIndex(frm, LSTID_KANJICODE)));
    dbData.kanjiCode = (UInt8) data;

    if (NNshGlobal->jumpSelection == 0)
    {
        // R[hXV
        UpdateRecord_NNsh(dbRef, NNshGlobal->work2,
                          sizeof(NNshGetLogDatabase), &dbData);
    }
    else
    {
        // R[ho^
        EntryRecord_NNsh(dbRef, sizeof(NNshGetLogDatabase), &dbData);
        (NNshGlobal->work1)++;
    }

    // f[^x[X
    CloseDatabase_NNsh(dbRef);

    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   displayLogDataInfo                                       */
/*                                                      QƃO擾̐ݒ */
/*                 gpO[oȕϐ                                */
/*                                      NNshGlobal->work1  : SR[h  */
/*                                      NNshGlobal->work2  : \R[h  */
/*                        NNshGlobal->jumpSelection : ҏWR[h̑ */
/*                                                        (VK>1, ҏW>0) */
/*-------------------------------------------------------------------------*/
static Boolean displayLogDataInfo(FormType *frm, NNshGetLogDatabase *dbData)
{
    UInt16 data;

    // `FbN{bNX̔f(PKw擾)
    data = dbData->getDepth;

    SetControlValue(frm, CHKID_GETLOG_DEPTH, &data);

    // RSSf[^ǂ
    data = dbData->rssData;
    SetControlValue(frm, CHKID_GETLOG_RSSDATA, &data);

    // O擾Ȃǂ
    data = dbData->wwwcMode;
    SetControlValue(frm, CHKID_NOTGETLOG, &data);

    // ^CgvtBbNX
    NNshWinSetFieldText(frm, FLDID_GETLOG_HEADER, false,
                        dbData->dataTitlePrefix, MAX_DATAPREFIX);

    // 擾URL
    NNshWinSetFieldText(frm, FLDID_GETLOG_URLSET, false, 
                        dbData->dataURL, MAX_GETLOG_URL);

    // 擾̖
    NNshWinSetFieldText(frm, FLDID_GETLOG_TITLE, true, 
                        dbData->dataTitle, MAX_TITLE_LABEL);

    // 񃌃xݒ
    data = dbData->usable;
    NNshWinSetPopItems(frm, POPTRID_GETLOG_USE, LSTID_GETLOG_USE, data);

    // R[hݒ
    data = dbData->kanjiCode;
    NNshWinSetPopItems(frm, POPTRID_KANJICODE, LSTID_KANJICODE, data);

    // |bvAbvgK̐ݒ

    // (؂p^[1)
    data = ConvertTokenListNum(dbData->tokenId);
    NNshWinSetPopItems(frm, POPTRID_NORMTOKEN, LSTID_NORMTOKEN, data);

    // (؂p^[2)
    data = ConvertTokenListNum(dbData->subTokenId);
    NNshWinSetPopItems(frm, POPTRID_SUBTOKEN,  LSTID_SUBTOKEN, data);

   return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   SetLogGetURL                                             */
/*                                                      QƃO擾̐ݒ */
/*                 gpO[oȕϐ                                */
/*                                      NNshGlobal->work1  : SR[h  */
/*                                      NNshGlobal->work2  : \R[h  */
/*                        NNshGlobal->jumpSelection : ҏWR[h̑ */
/*                                                        (VK>1, ҏW>0) */
/*-------------------------------------------------------------------------*/
Boolean SetLogGetURL(UInt16 recNum)
{
    Boolean              ret = false;
    FormType            *frm, *prevFrm;
    DmOpenRef            dbRef;
    NNshGetLogDatabase  *dbData;
    UInt16               labelCnt;
    UInt32              *idList;
    NNshWordList         separatorChoice;

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_PERMANENTLOG, DBVERSION_PERMANENTLOG, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        return (false);
    }

    dbData = MEMALLOC_PTR(sizeof(NNshGetLogDatabase) + MARGIN);
    if (dbData == NULL)
    {
        return (false);
    }
    MemSet(dbData, (sizeof(NNshGetLogDatabase) + MARGIN), 0x00);

    // R[h擾
    GetDBCount_NNsh(dbRef, &(NNshGlobal->work1));

#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, " SetLogGetURL(%d) : recNum:%d", 
                          recNum, NNshGlobal->work1);
#endif // #ifdef USE_REPORTER

    // x擾
    labelCnt = GetLogTokenLabelList(&separatorChoice, &idList);
    NNshGlobal->work4 = idList;

    // f[^̏
    //  work1 F R[h
    //  work2 F \R[h
    //  jumpSelection F VKR[htO(PȂVK)
    //  work4 F ؂f[^XgIDXg|C^
    if ((recNum != NNSH_ITEM_LASTITEM)&&(recNum < NNshGlobal->work1))
    {
        // 郌R[h|CgĊJꍇ
        NNshGlobal->work2 = recNum;
        NNshGlobal->jumpSelection = 0;
    }
    else
    {
        // VKR[hǉ̏ꍇ...
        NNshGlobal->work2 = 0;
        NNshGlobal->jumpSelection = 1;        
    }

    // _CAO\
    prevFrm = FrmGetActiveForm();
    PrepareDialog_NNsh(FRMID_GETLOG_INPUT, &frm, true);
    if (frm == NULL)
    {
        // f[^x[X
        CloseDatabase_NNsh(dbRef);
        ReleaseWordList(&separatorChoice);
        MEMFREE_PTR(idList);
        MEMFREE_PTR(dbData);
        return (false);
    }

    // |bvAbvgK̐ݒ
    if (labelCnt != 0)
    {
        NNshWinSetPopItemsWithList(frm, POPTRID_NORMTOKEN, LSTID_NORMTOKEN, &separatorChoice, 0);
        NNshWinSetPopItemsWithList(frm, POPTRID_SUBTOKEN,  LSTID_SUBTOKEN,  &separatorChoice, 0);
    }

    // R[hPȂꍇA͐VKR[hǉ̏ꍇ
    if ((NNshGlobal->work1 == 0)||(NNshGlobal->jumpSelection == 1))
    {
        // ̃R[hf[^ʂɕ\
        dbData->usable = 1;
    }
    else
    {
        // Ō̃R[hf[^ʂɕ\ꍇ...
        if (NNshGlobal->work2 == NNSH_ITEM_BOTTOMITEM)
        {
            NNshGlobal->work2 = NNshGlobal->work1 - 1;
        }
        GetRecord_NNsh(dbRef, NNshGlobal->work2,
                       sizeof(NNshGetLogDatabase), dbData);
        NNshGlobal->jumpSelection = 0;
    }

    displayLogDataInfo(frm, dbData);

    // f[^x[X
    CloseDatabase_NNsh(dbRef);

    // Cxgnh̐ݒ
    FrmSetEventHandler(frm, Handler_LogGetURL);

    // QƃO擾̐ݒ_CAO\
    if (FrmDoDialog(frm) == BTNID_GETLOG_OK)
    {
        // \f[^̃R[h𔽉f
        ret = effectLogGetURL(frm);
    }

    // _CAO\̌Еt
    PrologueDialog_NNsh(prevFrm, frm, true);

    // ẍJ
    ReleaseWordList(&separatorChoice);
    MEMFREE_PTR(idList);
    MEMFREE_PTR(dbData);

    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :  effectLogToken                                            */
/*                                    Ő؂ݒf[^x[Xɔf */
/*-------------------------------------------------------------------------*/
static Boolean effectLogToken(FormType *frm)
{
    NNshLogTokenDatabase *dbData;
    DmOpenRef             dbRef;
    Char                 *ptr;
    FieldType            *fldP;
    MemHandle             txtH;
    UInt16                cnt;
    
    dbData = MEMALLOC_PTR(sizeof(NNshLogTokenDatabase) + MARGIN);
    if (dbData == NULL)
    {
        // ̈mێsAI
        return (false);
    }

    // f[^̏
    MemSet(dbData, (sizeof(NNshLogTokenDatabase) + MARGIN), 0x00);

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        MEMFREE_PTR(dbData);
        return (false);
    }

    // f[^VKo^mF
    if ((NNshGlobal->work3 == 0)&&(cnt != 0))
    {
        // R[hhc擾AR[hIDɊi[
        GetRecordID_NNsh(dbRef, (NNshGlobal->work2), &(dbData->id));
    }

    // Owb_̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_GETLOG_HEADER));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        if (*ptr != '\0')
        {
            StrNCopy(dbData->tokenPatternName, ptr, MAX_DATAPREFIX);
        }
        MemHandleUnlock(txtH);
    }

    // Jn̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_GETLOG_START));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        if (*ptr != '\0')
        {
            StrNCopy(dbData->startToken, ptr, MAX_DATATOKEN);
        }
        MemHandleUnlock(txtH);
    }

    // I̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_GETLOG_END));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        if (*ptr != '\0')
        {
            StrNCopy(dbData->endToken, ptr, MAX_DATATOKEN);
        }
        MemHandleUnlock(txtH);
    }
    
    // g[N̎擾
    fldP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, FLDID_GETLOG_INDEX));
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        ptr = MemHandleLock(txtH);
        if (*ptr != '\0')
        {
            StrNCopy(dbData->dataToken, ptr, MAX_DATATOKEN);
        }
        MemHandleUnlock(txtH);
    }

    // R[h擾
    GetDBCount_NNsh(dbRef, &(cnt));

    // f[^VKo^mF
    if ((NNshGlobal->work3 != 0)||(cnt == 0))
    {
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, " CREATE NEW RECORD : %d ", cnt);
#endif // #ifdef USE_REPORTER

        // R[ho^
        EntryRecord_NNsh(dbRef, sizeof(NNshLogTokenDatabase), dbData);

        // R[hhc擾AR[hIDɊi[
        GetRecordID_NNsh(dbRef, 0, &(dbData->id));

        NNshGlobal->work2 = 0;
        (NNshGlobal->work1)++;
    }

    // R[hXV
    UpdateRecord_NNsh(dbRef, NNshGlobal->work2,
                      sizeof(NNshLogTokenDatabase), dbData);

    // DBN[Y
    CloseDatabase_NNsh(dbRef);
    
    MEMFREE_PTR(dbData);
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :  displayLogToken                                           */
/*                                                  Ő؂ݒ𔽉f */
/*-------------------------------------------------------------------------*/
static Boolean displayLogToken(FormType *frm, UInt16 recNum)
{
    NNshLogTokenDatabase *dbData;
    DmOpenRef            dbRef;


    dbData = MEMALLOC_PTR(sizeof(NNshLogTokenDatabase) + MARGIN);
    if (dbData == NULL)
    {
        // ̈mێsAI
        return (false);
    }

    // f[^̏
    MemSet(dbData, (sizeof(NNshLogTokenDatabase) + MARGIN), 0x00);
    
    // recNum  0xffff ̎́A󕶎\(DBf[^͎擾Ȃ)
    if (recNum != NNSH_DATABASE_BLANK)
    {
        // QƃO`[WpDB̎擾
        OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
        if (dbRef == 0)
        {
            // ODB̃I[vsAI
            MEMFREE_PTR(dbData);
            return (false);
        }

        // f[^ǂݏo
        GetRecord_NNsh(dbRef, recNum, sizeof(NNshLogTokenDatabase), dbData);

        // DBN[Y
        CloseDatabase_NNsh(dbRef);
    }

    // 擾f[^ʂɔf

    // ؂p^[
    NNshWinSetFieldText(frm, FLDID_GETLOG_HEADER, false,
                        dbData->tokenPatternName, MAX_DATAPREFIX);

    // Jn
    NNshWinSetFieldText(frm, FLDID_GETLOG_START, false, 
                        dbData->startToken, MAX_DATATOKEN);

    // I
    NNshWinSetFieldText(frm, FLDID_GETLOG_END, false, 
                        dbData->endToken, MAX_DATATOKEN);

    // ؂蕶
    NNshWinSetFieldText(frm, FLDID_GETLOG_INDEX, true, 
                        dbData->dataToken, MAX_DATATOKEN);

    MEMFREE_PTR(dbData);
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   Handler_setLogToken                                      */
/*                              QƃŐ؂ݒʗpCxgnh */
/*-------------------------------------------------------------------------*/
Boolean Handler_setLogToken(EventType *event)
{
    UInt16              keyCode;
    DmOpenRef           dbRef;
    FormType           *frm;

    // ݂̃tH[擾
    switch (event->eType)
    { 
      // j[I
      case menuEvent:
        // ҏWCxgs
        return (NNsh_MenuEvt_Edit(event));
        break;

      case keyDownEvent:
        frm = FrmGetActiveForm();

        // L[R[hɂď𕪊򂳂
        keyCode = KeyConvertFiveWayToJogChara(event);
        switch (keyCode)
        {
          case vchrPageUp:
          case vchrJogUp:
          case vchrTrgJogUp:
          case vchrThumbWheelUp:
          case vchrJogLeft:
          case chrRecordSeparator:   // J[\L[()̏
            // R[hɈړ
            if (NNshGlobal->work2 == 0)
            {
                // f[^̖AXVȂ
                return (true);
            }
            // f[^XV
            effectLogToken(frm);

            (NNshGlobal->work2)--;
            NNshGlobal->work3 = 0;
            break;

          case vchrPageDown:
          case vchrJogDown:
          case vchrTrgJogDown:
          case vchrThumbWheelDown:
          case vchrJogRight:
          case chrUnitSeparator:  // J[\L[()̏
            // OR[hɈړ
            if (((NNshGlobal->work2 + 1) == NNshGlobal->work1)||
                 (NNshGlobal->work1 == 0))
            {
                // f[^̐擪AXVȂ
                return (true);
            }
            // f[^XV
            effectLogToken(frm);

            (NNshGlobal->work2)++;
            NNshGlobal->work3 = 0;
            break;

          case chrLeftArrow:         // J[\L[(5way)
          case chrRightArrow:     // J[\L[E(5wayE)
          case vchrThumbWheelPush:
          case vchrJogRelease:
          case chrCarriageReturn:
          case chrLineFeed:
          case chrEscape:
          default:
            return (false);
            break;
        }

        // ǂݏof[^ʂɔf
        displayLogToken(frm, NNshGlobal->work2);
        return (true);
        break;

      case ctlSelectEvent:
        frm = FrmGetActiveForm();
        switch (event->data.ctlSelect.controlID)
        {
          case BTNID_GETLOG_NEXT:
            // OR[hɈړ(ǎ{^Ƃ...)
            if (((NNshGlobal->work2 + 1) == NNshGlobal->work1)||
                 (NNshGlobal->work1 == 0))
            {
                // f[^̐擪AXVȂ
                return (true);
            }
            // f[^XV
            effectLogToken(frm);

            (NNshGlobal->work2)++;
            NNshGlobal->work3 = 0;
            break;

          case BTNID_GETLOG_PREV:
            // R[hɈړ(ǑO{^Ƃ...)
            if (NNshGlobal->work2 == 0)
            {
                // f[^̖AXVȂ
                return (true);
            }

            // f[^XV
            effectLogToken(frm);

            (NNshGlobal->work2)--;
            NNshGlobal->work3 = 0;
            break;

          case BTNID_GETLOG_NEW:
            // VK擾쐬(f[^𖖔Ɉړ)
            // f[^XV
            effectLogToken(frm);

            // f[^ʂɔf
            NNshGlobal->work3 = 1;
            NNshGlobal->work2 = 0;
            displayLogToken(frm, NNSH_DATABASE_BLANK);
            return (true);
            break;

          case BTNID_GETLOG_DELETE:
            // R[h폜
            if ((NNshGlobal->work1 != 0)&&(NNshGlobal->work3 == 0))
            {
                // f[^{ɍ폜Ă悢mF
                if (NNsh_ConfirmMessage(ALTID_CONFIRM, "",
                                        MSG_CONFIRM_DELETE_DATA, 0) == 0)
                {
                    // QƃO`[WpDB̎擾
                    OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
                    if (dbRef == 0)
                    {
                        // ODB̃I[vsAI
                        return (false);
                    }
                    // R[h폜
                    DeleteRecordIDX_NNsh(dbRef, NNshGlobal->work2);
                    (NNshGlobal->work1)--;

                    if (NNshGlobal->work1 == NNshGlobal->work2)
                    {
                        // R[h폜ꍇ...
                        (NNshGlobal->work2)--;
                    }

                    // DBN[Y
                    CloseDatabase_NNsh(dbRef);
                }
            }            
            break;

          default:
            // Ȃ
            return (false);
            break;
        }

        // ǂݏof[^ʂɔf
        displayLogToken(frm, NNshGlobal->work2);

        return (true);
        break;

      default: 
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   SetLogCharge_LogToken                                    */
/*                                                    ؂p^[̓o^ */
/*=========================================================================*/
Boolean SetLogCharge_LogToken(UInt16 recNum)
{
    Boolean       ret = false;
    FormType     *prevFrm, *diagFrm;
    UInt16        btnId;
    DmOpenRef     dbRef;

    // ʂ
    ret     = false;
    prevFrm = FrmGetActiveForm();

    // QƃO؂DB̎擾
    OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "LOGTOKEN DB Open Failure.");
#endif // #ifdef USE_REPORTER
        return (false);
    }

    // R[h擾
    GetDBCount_NNsh(dbRef, &(NNshGlobal->work1));

#ifdef USE_REPORTER
        HostTraceOutputTL(appErrorClass, "TOKEN DB count : %d", NNshGlobal->work1);
#endif // #ifdef USE_REPORTER

    // f[^x[X
    CloseDatabase_NNsh(dbRef);

    // \nf[^̔fi[N̈̎gp@j
    //   work1F݂̃R[h
    //   work2F\̃R[hԍ
    //   work3FVKR[hǉiPȂǉj
    NNshGlobal->work2 = recNum;
    NNshGlobal->work3 = (NNshGlobal->work1 == 0) ? 1 : 0;

    // _CAO\
    PrepareDialog_NNsh(FRMID_GETLOG_TOKENSET, &diagFrm, true);
    if (diagFrm == NULL)
    {
        return (false);
    }

    // f[^̔f
    displayLogToken(diagFrm, NNshGlobal->work2);

    // Cxgnh̐ݒ
    FrmSetEventHandler(diagFrm, Handler_setLogToken);

    // EBhE̕\
    btnId = FrmDoDialog(diagFrm);
    if (btnId == BTNID_GETLOG_OK)
    {
         // \f[^R[hɔf
         effectLogToken(diagFrm);
         ret = true;
    }

    // _CAO\̌Еt
    PrologueDialog_NNsh(prevFrm, diagFrm, true);

    // f[^x[X̃\[gsĂ
    OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
    QsortRecord_NNsh(dbRef, NNSH_KEYTYPE_UINT32, 0);
    CloseDatabase_NNsh(dbRef);

    return (ret);
}

/*=========================================================================*/
/*   Function :   GetLogToken                                              */
/*                                                    ؂p^[̎擾 */
/*=========================================================================*/
Err GetLogToken(UInt32 key, NNshLogTokenDatabase *record)
{
   Err       ret;
   DmOpenRef dbRef;
   UInt16    index;

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        return (false);
    }

    // idkeyɂČ
    ret = SearchRecord_NNsh(dbRef, &key, NNSH_KEYTYPE_UINT32, 0,
                            sizeof(NNshLogTokenDatabase), record, &index);

    // DBN[Y
    CloseDatabase_NNsh(dbRef);

    return (ret);
}

/*=========================================================================*/
/*   Function :  ConvertTokenListNum                                       */
/*                                      ؂p^[IDXgԍɕϊ */
/*=========================================================================*/
UInt16 ConvertTokenListNum(UInt32 key)
{
   Err       ret;
   DmOpenRef dbRef;
   UInt16    index;
   NNshLogTokenDatabase record;

    // keyw̏ꍇɂ́A0
    if (key == 0)
    {
        return (0);
    }

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        return (0);
    }

    // idkeyɂČ
    index = 0;
    ret = SearchRecord_NNsh(dbRef, &key, NNSH_KEYTYPE_UINT32, 0,
                            sizeof(NNshLogTokenDatabase), &record, &index);
    if (ret != errNone)
    {
        index = 0;
    }

    // DBN[Y
    CloseDatabase_NNsh(dbRef);

    return (index);
}

/*=========================================================================*/
/*   Function :   GetLogTokenLabelList                                     */
/*                                                ؂p^[̈ꗗ擾 */
/*=========================================================================*/
UInt16 GetLogTokenLabelList(NNshWordList *wordList, UInt32 **idList)
{
    Err                   ret;
    Char                 *nameP, *strBuf;
    UInt32               *idP;
    DmOpenRef             dbRef;
    UInt16                index, count, recCount;
    MemHandle             dataH;
    NNshLogTokenDatabase *data;

    // ϐ̏
    MemSet(wordList, sizeof(NNshWordList), 0x00);
    *idList = NULL;

    // QƃO`[WpDB̎擾
    OpenDatabase_NNsh(DBNAME_LOGTOKEN, DBVERSION_LOGTOKEN, &dbRef);
    if (dbRef == 0)
    {
        // ODB̃I[vsAI
        return (0);
    }

    // R[h擾
    GetDBCount_NNsh(dbRef, &count);
    if (count == 0)
    {
        return (0);
    }

    // IDi[̈m
    *idList = MEMALLOC_PTR(sizeof(UInt32) * count + MARGIN);
    if (*idList == NULL)
    {
        return (0);
    }
    MemSet(*idList, (sizeof(UInt32) * count + MARGIN), 0x00);
    idP = *idList;

    // xi[̈m
    strBuf = MEMALLOC_PTR((sizeof(Char) * (MAX_STRLEN)) * count + MARGIN);
    if (strBuf == NULL)
    {
        MEMFREE_PTR(*idList);
        return (0);
    }
    MemSet(strBuf, ((sizeof(Char) * (MAX_STRLEN)) * count + MARGIN), 0x00);
    nameP = strBuf;

    recCount = 0;
    for (index = 0; index < count; index++)
    {
        // R[hf[^̎擾
        ret = GetRecordReadOnly_NNsh(dbRef, index, &dataH, (void **) &data);
        if (ret == errNone)
        {
            if (recCount != 0)
            {
                StrCat(nameP, ",");
            }

            // ǂݏof[^mۂ̈ɔf
            *idP = data->id;
            idP++;
            if (data->tokenPatternName[0] != '\0')
            {
                // 擾
                StrCat(nameP, data->tokenPatternName);
            }
            else
            {
                StrCat(nameP, "???");
            }

            // R[hf[^̕\
            nameP = nameP + StrLen(nameP);

            recCount++;
        }
        // R[hAւ
        ReleaseRecordReadOnly_NNsh(dbRef, dataH);
    }

    // xꗗXgɕ\\֕ϊ...
    SeparateWordList(strBuf, wordList);
    MEMFREE_PTR(strBuf);

    // DBN[Y
    CloseDatabase_NNsh(dbRef);

    return (recCount);
}

/*=========================================================================*/
/*   Function :   SelectLogToken                                           */
/*                                                    ؂p^[̑I */
/*=========================================================================*/
UInt16 SelectLogToken(UInt32 *selection)
{
    Char         *ptr;
    FormType     *prevFrm, *diagFrm;
    UInt32       *idList;
    UInt16        btnId, nofItems;
    MemHandle     listH;
    ListType     *lstP;
    NNshWordList  wordList;
    
    // 
    listH     = 0;
    *selection = 0;
    btnId     = BTNID_JUMPCANCEL;
    prevFrm   = FrmGetActiveForm();
    MemSet(&wordList, sizeof(NNshWordList), 0x00);

    // Og[NƂ肾
    nofItems = GetLogTokenLabelList(&wordList, &idList);

    // ACe̊mF([A߂)
    if (nofItems == 0)
    {
        // ؂p^[Ȃ
        return (BTNID_JUMPCANCEL);
    }

    // _CAO\
    PrepareDialog_NNsh(FRMID_DIRSELECTION, &diagFrm, false);
    if (diagFrm == NULL)
    {
        return (BTNID_JUMPCANCEL);
    }

    // Xg̐ݒ
    lstP  = FrmGetObjectPtr(diagFrm,
                                FrmGetObjectIndex(diagFrm, LSTID_JUMPLIST));

    ptr = MemHandleLock(wordList.wordmemH);
    LstSetListChoices(lstP, (Char **) ptr, wordList.nofWord);
    LstSetSelection  (lstP, 0);
    LstSetTopItem    (lstP, 0);

    // Cxgnh̐ݒ
    FrmSetEventHandler(diagFrm, Handler_JumpSelection);

    // WvNA
    NNshGlobal->jumpSelection = 0;

    // _CAÕI[vA̓͂҂
    btnId = FrmDoDialog(diagFrm);

    // _CAO\̌Еt
    PrologueDialog_NNsh(prevFrm, diagFrm, false);

    // nhAbN
    MemHandleUnlock(wordList.wordmemH);

    if (btnId == BTNID_JUMPEXEC)
    {
        // Iꂽ
        *selection = idList[NNshGlobal->jumpSelection];        
    }

    // Ƃ܂
    MEMFREE_PTR(idList);
    ReleaseWordList(&wordList);

    return (btnId);
}

#endif  // #ifdef USE_LOGCHARGE
