/*============================================================================*
 *  FILE: 
 *     symbols.h
 *
 *  Description: 
 *     symbol definitions for NNsh.
 *
 *===========================================================================*/

//////////////////////////////////////////////////////////////////////////////
/***  DATABASE VERSIONS  ***/
#define SOFT_PREFID           100
#define SOFT_PREFVERSION      204

#define NNSH_PREFERID         200
#define NNSH_PREFERTYPE       105

#define SOFT_DBTYPE_ID        'Data'
#define OFFLINE_DBTYPE_ID     'GIKO'

#define DBNAME_BBSLIST        "BBS-NNsi"
#define DBVERSION_BBSLIST     160

#define DBNAME_SUBJECT        "Subject-NNsi"
#define DBVERSION_SUBJECT     160

#define DBNAME_SETTING        "Settings-NNsi"
#define DBVERSION_SETTING     111
#define DBSIZE_SETTING        32
#define DBVERSION_XML_SETTING 100

#define DBNAME_DIRINDEX       "DirIndex-NNsi"
#define DBVERSION_DIRINDEX    100

#define DBNAME_GETRESERVE     "GetReserve-NNsi"
#define DBVERSION_GETRESERVE  100

#define DBNAME_PERMANENTLOG    "LogPermanent-NNsi"
#define DBVERSION_PERMANENTLOG 100

#define DBNAME_TEMPORARYLOG    "LogTemporary-NNsi"
#define DBVERSION_TEMPORARYLOG 100

#define DBNAME_NGWORD          "NGWord-NNsi"
#define DBVERSION_NGWORD       100

#define DBNAME_MACROSCRIPT     "Macro-NNsi"
#define DBVERSION_MACROSCRIPT  100

#define DBNAME_RUNONCEMACRO    "RunOnce-NNsi"
#define DBNAME_MACRORESULT     "MacroResult-NNsi"
#define DBVERSION_MACRO        100

#define DBNAME_LOGTOKEN        "LogToken-NNsi"
#define DBVERSION_LOGTOKEN     100

#define NNSH_CREATORID_PREPARE_NEWARRIVAL 'mlDA'

//////////////////////////////////////////////////////////////////////////////

#define RSCID_createThreadIndexSub_ARM     1     // ARMlet֐ԍ̂P
#define RSCID_parseMessage_ARM             2     // ARMlet֐ԍ̂Q

//////////////////////////////////////////////////////////////////////////////

/** buffer size(small) **/
#define TINYBUF                      8
#define MINIBUF                     48
#define BUFSIZE                    128
#define HIDEBUFSIZE                128
#define PASSSIZE                     8
#define BIGBUF                     640
#define PREVBUF                     12
#define JUMPBUF                     16
#define NGWORD_LEN                  40
#define OYSTERID_LEN                64
#define OYSTER_LEN                  64
#define SEARCH_HEADLEN              16
#define MAX_GETLOG_RECORDS        2048

#define MAX_TIMEOUT_VALUE          999

#define MAX_LOGRECLEN               40
#define MAX_STRLEN                  32

/** ꎞmۗ̈̕(5120 < x < 61000) **/
#define NNSH_WORKBUF_MIN          5120
#define NNSH_WORKBUF_MAX         61000
#define NNSH_WORKBUF_DEFAULT     32750
#define MARGIN                       4
#define FREE_SPACE_MARGIN         2048

/** ݎɊmۂobt@TCY **/
#define NNSH_WRITEBUF_MIN         4096
#define NNSH_WRITEBUF_MAX        16384
#define NNSH_WRITEBUF_DEFAULT     8192

#define NNSH_WRITELBL_MAX           26
#define NNSH_WRITELBL_HEAD        ""

#define NNSH_NEWTHREAD_MAX          32
#define NNSH_NEWTHREAD_LBLHEAD    "X:"

/** BBS-DB̕TCY **/
#define MAX_URL                     80
#define MAX_BOARDNAME               40
#define MAX_NICKNAME                16
#define LIMIT_BOARDNAME             20

/** Thread-DB ̕TCY **/
#define MAX_THREADFILENAME          32
#define MAX_THREADNAME              72
#define MAX_DIRNAME                 40
#define LIMIT_TITLENAME_DEFAULT     72
#define LIMIT_TITLENAME_MINIMUM     12
#define MAX_DEPTH                   10
#define MAX_LISTLENGTH              24

/** GetData-DB̕TCY **/
#define MAX_DATAPREFIX              32
#define MAX_DATATOKEN               80
#define MAX_TITLE_LABEL             32
#define MAX_GETLOG_URL             244
#define MAX_GETLOG_DATETIME         38
#define MAX_URL_CNT                 82

/** URLꗗ̕\TCY **/
#define MAX_NAMELABEL               48
#define MAX_URL_LIST                24

/** ^Cgуẍ̗TCY **/
#define BBSSEL_PAGEINFO             12
#define NNSH_MSGTITLE_BUFSIZE       10
#define SEPARATOR_LEN               24

/** VFSt@C̍őTCY  **/
#define MAXLENGTH_FILENAME          256

/** _E[hɑz肷HTTPwb_TCY **/
#define NNSH_HTTPGET_HEADERMAX      400
#define NNSH_DOWNLOADSIZE_MIN      2048

/** ʐM^CAEgl(tick) **/
#define NNSH_NET_TIMEOUT           2500

/** bZ[W̍ő僌Xԍ **/
#define NNSH_MESSAGE_MAXNUMBER     1005
#define NNSH_MESSAGE_MAXLIMIT      25000
#define NNSH_MESSAGE_LIMIT         1000

/** BBS URL **/
#define URL_BBSTABLE_OLD         "http://www6.ocn.ne.jp/~mirv/bbstable.html"
#define URL_BBSTABLE             "http://www.ff.iij4u.or.jp/~ch2/bbstable.html"

#define URL_PREFIX                     "test/read.cgi/"
#define URL_PREFIX_IMODE               "test/r.i/"
#define URL_PREFIX_MACHIBBS            "bbs/read.pl?BBS="
#define URL_PREFIX_MACHIBBS_IMODE      "bbs/read.pl?IMODE=TRUE&BBS="
#define URL_PREFIX_SHITARABA           "cgi-bin/read.cgi?bbs="
#define URL_PREFIX_SHITARABA_IMODE     "cgi-bin/read.cgi?bbs="
#define URL_PREFIX_SHITARABAJBBS       "bbs/read.cgi?BBS="
#define URL_PREFIX_SHITARABAJBBS_IMODE "bbs/i.cgi?BBS="
#define FILE_THREADLIST                "subject.txt"

#define URL_PROTOCOL_USESSL            "https://"

#define MAX_REDIRECT_COUNT          3

/** default font ID **/
#define NNSH_DEFAULT_FONT           stdFont
#define NNSH_DEFAULT_FONT_HR        stdFont

#define NNSH_NOTENTRY_THREAD        0xffff
#define NNSH_NOTENTRY_BBS           0xffff
#define NNSH_DATABASE_BLANK         0xffff

/** OFFLINE LOG(for GIKO Shippo) **/
#define OFFLINE_THREAD_NAME         "QƃO"
#define OFFLINE_THREAD_NICK         "!GikoShippo/"
#define OFFLINE_THREAD_URL          "file://"

#define FAVORITE_THREAD_NAME        "Cɓ"
#define GETALL_THREAD_NAME          "擾ςݑS"
#define NOTREAD_THREAD_NAME         "ǂ"
#define CUSTOM1_THREAD_NAME         "擾G["
#define CUSTOM2_THREAD_NAME         "Palm֘A"
#define CUSTOM3_THREAD_NAME         "VK(3ȓ)"
#define CUSTOM4_THREAD_NAME         "ő咴"
#define CUSTOM5_THREAD_NAME         "擾ۗ"

#define CUSTOM1_THREAD_HEAD         "1>"
#define CUSTOM2_THREAD_HEAD         "2>"
#define CUSTOM3_THREAD_HEAD         "3>"
#define CUSTOM4_THREAD_HEAD         "4>"
#define CUSTOM5_THREAD_HEAD         "5>"


#define NNSH_NOF_SPECIAL_BBS        9   // Ȕ̐
#define NNSH_SELBBS_NOTREAD         0   // ǂ
#define NNSH_SELBBS_GETALL          1   // 擾ςݑS
#define NNSH_SELBBS_FAVORITE        2   // CɓX
#define NNSH_SELBBS_CUSTOM1         3   // CUSTOM1
#define NNSH_SELBBS_CUSTOM2         4   // CUSTOM2
#define NNSH_SELBBS_CUSTOM3         5   // CUSTOM3
#define NNSH_SELBBS_CUSTOM4         6   // CUSTOM4
#define NNSH_SELBBS_CUSTOM5         7   // CUSTOM5
#define NNSH_SELBBS_OFFLINE         8   // OFFLINEX

// for NaNaShi FILE NAMEs
#define FILE_WRITEMSG               "write.txt"
#define FILE_WRITENAME              "writeName.txt"
#define FILE_WRITEMAIL              "writeMail.txt"
#define FILE_RECVMSG                "recv.txt"
#define FILE_SENDMSG                "send.txt"
#define FILE_XML_NNSISET            "NNsiSet.xml"
#define FILE_LOGCHARGE_PREFIX       "NNsiLog"
#define FILE_LOGCHARGE_SUFFIX       ".html"

#define NNSH_HTTP_CONTENT_LENGTH    "Content-Length:"

#define DATAFILE_PREFIX             "/PALM/Programs/NNsh/"
#define LOGDATAFILE_PREFIX          "/PALM/Programs/2ch/"
#define LOGDIR_FILE                 "/PALM/Programs/2ch/logdir.txt"
#define DATAFILE_SUFFIX             ".dat"
#define CGIFILE_SUFFIX              ".cgi"

//  time diference between from 'Jan/01/1904' to 'Jan/01/1970'.
#define TIME_CONVERT_1904_1970      (2082844800 - 32400)
#define TIME_CONVERT_1904_1970_UTC  (2082844800)
#define TIME_24HOUR_SECOND          ((Int32) 24 * ((Int32) 60 * (Int32) 60))

/** VFS SETTINGS **/
#define NNSH_NOTSUPPORT_VFS         0xf000
#define NNSH_VFS_DISABLE            0x0000
#define NNSH_VFS_ENABLE             0x0001
#define NNSH_VFS_WORKAROUND         0x0002
#define NNSH_VFS_USEOFFLINE         0x0004
#define NNSH_VFS_DBBACKUP           0x0008
#define NNSH_VFS_DBIMPORT           0x0010
#define NNSH_VFS_DIROFFLINE         0x0020
#define NNSH_VFS_USE_CF             0x0040

#define NNSH_COPY_PALM_TO_VFS       0
#define NNSH_COPY_VFS_TO_VFS        1
#define NNSH_COPY_VFS_TO_PALM       2
#define NNSH_COPY_PALM_TO_PALM      4

#define NNSH_FILEMODE_CREATE        1
#define NNSH_FILEMODE_READWRITE     2
#define NNSH_FILEMODE_READONLY      4
#define NNSH_FILEMODE_TEMPFILE      8
#define NNSH_FILEMODE_APPEND        16

#define FILEMGR_STATE_DISABLED      0
#define FILEMGR_STATE_OPENED_VFS    1
#define FILEMGR_STATE_OPENED_STREAM 2

/** BBS-DB̕\(Iʂŕ\邩/Ȃ) **/
#define NNSH_BBSSTATE_VISIBLE       0x01         // \
#define NNSH_BBSSTATE_INVISIBLE     0x00         // \
#define NNSH_BBSSTATE_VISIBLEMASK   0xfe         // \E\p}XN

#define NNSH_BBSSTATE_LEVELMASK     0x0e         // Xxo}XN
#define NNSH_BBSSTATE_NOTFAVOR      0xf1         // XxNA
#define NNSH_BBSSTATE_FAVOR_L1      0x02         // XxL1
#define NNSH_BBSSTATE_FAVOR_L2      0x04         // XxL2
#define NNSH_BBSSTATE_FAVOR_L3      0x06         // XxL3
#define NNSH_BBSSTATE_FAVOR_L4      0x08         // XxL4
#define NNSH_BBSSTATE_FAVOR         0x0e         // XxHIGH

#define NNSH_BBSSTATE_SUSPEND       0x10   // u擾~vBBSł
#define NNSH_BBSSTATE_NOTSUSPEND    0xef   // u擾~vBBSł͂Ȃ(MASKl)

/** BBS-DB̃{[h^Cv **/
#define NNSH_BBSTYPE_2ch                 0x00    // 2ch(ʏ탂[h)
#define NNSH_BBSTYPE_MACHIBBS            0x01    // ܂BBS(ꃂ[h)
#define NNSH_BBSTYPE_SHITARABA           0x02    // BBS
#define NNSH_BBSTYPE_SHITARABAJBBS_OLD   0x03    // @JBBS
#define NNSH_BBSTYPE_OTHERBBS            0x04    // 2ch݊BBS
#define NNSH_BBSTYPE_PLUGINSUPPORT       0x05    // 2ch`ϊBBS
#define NNSH_BBSTYPE_HTML                0x06    // html`f[^
#define NNSH_BBSTYPE_SHITARABAJBBS_RAW   0x07    // @JBBS(RAWMODE)
#define NNSH_BBSTYPE_PLAINTEXT           0x08    // ʏ̃eLXg`
#define NNSH_BBSTYPE_ERROR               0xff    // {[h^CvG[
#define NNSH_BBSTYPE_MASK                0x1f    // {[h^CvMASK
#define NNSH_BBSTYPE_CHARSETMASK         0xe0    // {[h̕R[h
#define NNSH_BBSTYPE_CHAR_SJIS           0x00    // WR[h(SHIFT JIS)
#define NNSH_BBSTYPE_CHAR_EUC            0x20    // EUCR[h
#define NNSH_BBSTYPE_CHAR_JIS            0x40    // JISR[h(iso-2022-jp)
#define NNSH_BBSTYPE_CHAR_SHIFT             5    // EVtg

/** ꗗ\BBSꗗCɓ肩 **/
#define NNSH_FAVORLIST_MODE         1
#define NNSH_BBSLIST_MODE           0 

// f[^x[X̃L[^Cv()
#define NNSH_KEYTYPE_CHAR           0
#define NNSH_KEYTYPE_UINT32         1
#define NNSH_KEYTYPE_UINT16         2
#define NNSH_KEYTYPE_SUBJECT        3

// HTTPbZ[W쐬Ɏw
#define HTTP_SENDTYPE_GET                    10
#define HTTP_SENDTYPE_GET_NOTMONA            11
#define HTTP_SENDTYPE_POST                   20
#define HTTP_SENDTYPE_POST_2chLOGIN          24
#define HTTP_SENDTYPE_POST_OTHERBBS          30
#define HTTP_SENDTYPE_POST_MACHIBBS          40
#define HTTP_SENDTYPE_POST_SHITARABAJBBS     80
#define HTTP_SENDTYPE_POST_SHITARABA         90
#define HTTP_SENDTYPE_MASK               0x00ff
#define HTTP_RANGE_OMIT             0xffffffff
#define HTTP_GETSUBJECT_LEN         4096
#define HTTP_GETLOG_LEN             1536
#define HTTP_GETLOG_START           0
#define HTTP_GETSUBJECT_START       0
#define HTTP_GETSUBJECT_PART        0

// 
#define NNSH_SEARCH_ALL             0
#define NNSH_SEARCH_FORWARD         1
#define NNSH_SEARCH_BACKWARD       -1

// ݃bZ[WmFR}h
#define NNSH_WRITECHK_SPID          0
#define NNSH_WRITECHK_REPLY         1

// bZ[W̑
#define NNSH_MSGATTR_NOTSPECIFY    0xff   // uCɓvw͎w肵Ȃ
#define NNSH_MSGATTR_NOTFAVOR      0x4f   // uCɓvXłȂ(MASKl)
#define NNSH_MSGATTR_FAVOR_L1      0x10   // uCɓvx()
#define NNSH_MSGATTR_FAVOR_L2      0x20   // uCɓvx()
#define NNSH_MSGATTR_FAVOR_L3      0x30   // uCɓvx()
#define NNSH_MSGATTR_FAVOR_L4      0x80   // uCɓvx()
#define NNSH_MSGATTR_FAVOR         0xb0   // uCɓvX()
#define NNSH_MSGATTR_NOTERROR      0xbf   // uG[vXłȂ(MASKl)
#define NNSH_MSGATTR_ERROR         0x40   // uG[vXł
#define NNSH_MSGATTR_GETRESERVE    0x08   // u擾\vXł
#define NNSH_MSGATTR_NOTRESERVE    0xf7   // u擾\vXNA(MASK)

#define NNSH_ATTRLABEL_TITLE       ", Level:" 
#define NNSH_ATTRLABEL_NOTFAVOR    "-"    // uCɓvł͂Ȃ
#define NNSH_ATTRLABEL_FAVOR_L1    "L"    // uCɓvx()
#define NNSH_ATTRLABEL_FAVOR_L2    "1"    // uCɓvx()
#define NNSH_ATTRLABEL_FAVOR_L3    "2"    // uCɓvx()
#define NNSH_ATTRLABEL_FAVOR_L4    "3"    // uCɓvx()
#define NNSH_ATTRLABEL_FAVOR       "H"    // uCɓvx()

#define NUMBER_OF_JOGMASKS          4

// ꎞ(݁AWO񂵏ԂL)
#define NNSH_TEMPTYPE_PUSHEDJOGUP   16
#define NNSH_TEMPTYPE_PUSHEDJOGDOWN  8
#define NNSH_TEMPTYPE_CLEARSTATE     0

//  ̑̏Ԓl
#define NNSH_NOT_EFFECTIVE          0
#define NNSH_UPDATE_DISPLAY         1
#define NNSH_SILK_CONTROL           1

#define NNSH_DISABLE                0
#define NNSH_ENABLE                 1

// NNsĩf[^x[XXV
#define NNSH_DB_UPDATE_BBS          0x0001
#define NNSH_DB_UPDATE_SUBJECT      0x0002
#define NNSH_DB_UPDATE_SETTING      0x0004
#define NNSH_DB_UPDATE_DIRINDEX     0x0008

#define NNSH_DB_MASK_BBS            0xfffe
#define NNSH_DB_MASK_SUBJECT        0xfffd
#define NNSH_DB_MASK_SETTING        0xfffb
#define NNSH_DB_MASK_DIRINDEX       0xfff7

//////////////////////////////////////////////////////////////////////////////

/********** HTMLԉ͗p ********/
#define HTTP_ANCHORSTATE_NORMAL     101
#define HTTP_ANCHORSTATE_ANCHOR     102
#define HTTP_ANCHORSTATE_LABEL      103
#define HTTP_ANCHORSTATE_KANJI      104

/**********  Xǂݏoԗp  *********/
#define NNSH_SUBJSTATUS_NOT_YET      0
#define NNSH_SUBJSTATUS_NEW          1
#define NNSH_SUBJSTATUS_UPDATE       2
#define NNSH_SUBJSTATUS_REMAIN       3
#define NNSH_SUBJSTATUS_ALREADY      4
#define NNSH_SUBJSTATUS_DELETE       5
#define NNSH_SUBJSTATUS_UNKNOWN      6
#define NNSH_SUBJSTATUS_GETERROR     7
#define NNSH_SUBJSTATUS_OVER         8

#define NNSH_MSGSTATE_NOTMODIFIED   10
#define NNSH_MSGSTATE_ERROR         20


#define NNSH_GETLOGSTATE_SELECTED    0x0002
#define NNSH_GETLOGSTATE_UPDATE      0x0001
#define NNSH_GETLOGSTATE_DATETIME    0x0004
#define NNSH_GETLOGSTATE_NOTMODIFIED 0x0000
#define NNSH_GETLOGSTATE_MASK_UPDATE 0x0001
#define NNSH_GETLOGSTATE_MASK_SELECT 0x0002

#define NNSH_ERRORCODE_PARTGET        (~errNone - 12)
#define NNSH_ERRORCODE_FAILURECONNECT (~errNone -  5)
#define NNSH_ERRORCODE_THREADNOTHING  (~errNone - 88)
#define NNSH_ERRORCODE_WRONGVFSMODE   (~errNone - 10)
#define NNSH_ERRORCODE_COPYFAIL       (~errNone - 11)
#define NNSH_ERRORCODE_NOTFOUND       (~errNone - 12)

/**********  bZ[Wp[Xp  *********/
#define MSGSTATUS_NAME              1
#define MSGSTATUS_EMAIL             2
#define MSGSTATUS_DATE              3
#define MSGSTATUS_NORMAL            4

/**********  BBSLX  **************/
#define NNSH_BBSLIST_AGAIN         -1            // XēxmF


/*********** VmF{R}h ********/
#define NNSH_NEWARRIVAL_NORMAL      0            // ʏ擾[h
#define NNSH_NEWARRIVAL_ONLYMESNUM  1            // XԎw\̂̂̂

/////////////////////////////////////////////////////////////////////////////

/*** DATA TOKENS ***/
#define DATA_SEPARATOR              "<>"
#define DATA_NEWLINE                "<br>"

/** for BBS NAME PARSER **/
#define HTTP_TOKEN_ST_ANCHOR        "<A"
#define HTTP_TOKEN_ED_ANCHOR        "</A>"
#define HTTP_TOKEN_END              ">"


#define NNSH_KANJICODE_SHIFTJIS     0x00
#define NNSH_KANJICODE_EUC          0x01
#define NNSH_KANJICODE_JIS          0x02
#define NNSH_KANJICODE_UTF8         0x03


#define NNSH_CHARCOLOR_ESCAPE       '\x1b'
#define NNSH_CHARCOLOR_NORMAL       '\x09'
#define NNSH_CHARCOLOR_HEADER       '\x0b'
#define NNSH_CHARCOLOR_BOLDHEADER   '\x0f'
#define NNSH_CHARCOLOR_FOOTER       '\x0c'
#define NNSH_CHARCOLOR_INFORM       '\x0e'
#define NNSH_CHARCOLOR_ANCHOR       '\x08'
#define NNSH_CHARCOLOR_BOLDDATA     '\x11'

#define NNSH_HTTP_HEADER_ENDTOKEN   "\x0d\x0a\x0d\0a"
#define NNSH_NGSET_SEPARATOR        ','
#define NNSH_FIELD_SEPARATOR        "<>"
#define NNSH_FIELD_SEPARATOR_MACHI  ","
#define NNSH_RECORD_SEPARATOR       "\x0a"
#define NNSH_SUBJTITLE_END          "("

#define NNSH_JBBSTOKEN_START        "\x0a<dt>"
#define NNSH_JBBSTOKEN_END          "<br><br>\x0a"
#define NNSH_JBBSTOKEN_MSGSTART     "\xcc\xbe\xc1\xb0\xa1\xa7" // OF
#ifdef OLD_MACHIBBS_TOKEN
#define NNSH_MACHITOKEN_START       "\x0d\x0a<dt>"
#define NNSH_MACHITOKEN_END         "<br><br>\x0a\x0d\x0a"
#else
#define NNSH_MACHITOKEN_START       "\x0a<dt>"
#define NNSH_MACHITOKEN_END         "<br><br>\x0a"
#endif
#define NNSH_JBBSTOKEN_RAW_START    "\x0d\x0a"
#define NNSH_JBBSTOKEN_RAW_START_RES "<>"
#define NNSH_JBBSTOKEN_RAW_END_RES  "\x0a"
#define NNSH_MACHITOKEN_MSGSTART    "OF"
#define NNSH_MACHINAME_SUFFIX       "[܂BBS]"
#define NNSH_SHITARABA_SUFFIX       "[]"
#define NNSH_SHITARABAJBBS_SUFFIX   "[@JBBS]"

#define NNSH_TOKEN_BEFORE_NUMBER     0x01    // g[N̑Oɐ
#define NNSH_TOKEN_BEFORE_LETTER     0x02    // g[N̑Oɕ
#define NNSH_TOKEN_AFTER_NUMBER      0x10    // g[Ňɐ
#define NNSH_TOKEN_AFTER_LETTER      0x20    // g[Ňɕ

/** **/
#define NNSH_SYMBOL_WRITE_DONE      "݂܂B"
#define NNSH_SYMBOL_WRITE_NG        "dqqnq"

#define NNSH_DEVICE_NORMAL         0x0000     // WPalm
#define NNSH_DEVICE_HANDERA        0x0001     // Handera 330
#define NNSH_DEVICE_DIASUPPORT     0x0002     // Dynamic Input AreaT|[g@
#define NNSH_DEVICE_GARMIN         0x0003     // Garmin iQUE 3600

#define NNSH_VFS_USEMEDIA_ANY       0
#define NNSH_VFS_USEMEDIA_CF        1
#define NNSH_VFS_USEMEDIA_MS        2
#define NNSH_VFS_USEMEDIA_SD        3
#define NNSH_VFS_USEMEDIA_SM        4
#define NNSH_VFS_USEMEDIA_RD        5
#define NNSH_VFS_USEMEDIA_DoC       6

#define NNSH_JUMPMSG_LEN            10
#define NNSH_JUMPMSG_HEAD           ">>"

#define NNSH_JUMPMSG_BACK           "P߂"
#define NNSH_JUMPMSG_TO_LIST        "ꗗ"
#define NNSH_JUMPMSG_OPEN_MENU      "j["
#define NNSH_JUMPMSG_UPDATE         "擾"
#define NNSH_JUMPMSG_HANGUP         "ؒf"
#define NNSH_JUMPMSG_TOP            "擪"
#define NNSH_JUMPMSG_BOTTOM         ""
#define NNSH_JUMPMSG_OPENWEB        "SIWeb"
#define NNSH_JUMPMSG_CHANGEVIEW     "`惂[hύX"
#define NNSH_JUMPMSG_FAVORITE       "X"
#define NNSH_JUMPMSG_OUTPUTMEMO     ""
#define NNSH_JUMPMSG_BOOKMARK       "ݒ"
#define NNSH_JUMPMSG_DEVICEINFO     "foCX"
#define NNSH_JUMPMSG_OPENLINK       "NJ"
#define NNSH_JUMPMSG_EXECA2DA       "a2DA(AAQ)"
#define NNSH_JUMPMSG_BTOOTH_ON      "Bt On"
#define NNSH_JUMPMSG_BTOOTH_OFF     "Bt Off"
#define NNSH_JUMPMSG_MEMOURL        "MemoURL֏o"
#define NNSH_JUMPMSG_TOGGLERAWMODE  "RAW/ʏؑ"
#define NNSH_JUMPMSG_SELECTSEPA     "؂ύX"
#define NNSH_JUMPMSG_EDITSEPA       "؂ҏW"

#define NNSH_NOF_JUMPMSG_EXT        21
#define NNSH_JUMPSEL_BACK           0x8001
#define NNSH_JUMPSEL_TO_LIST        0x8002
#define NNSH_JUMPSEL_OPEN_MENU      0x8003
#define NNSH_JUMPSEL_UPDATE         0x8004
#define NNSH_JUMPSEL_HANGUP         0x8005
#define NNSH_JUMPSEL_TOP            0x8006
#define NNSH_JUMPSEL_BOTTOM         0x8007
#define NNSH_JUMPSEL_OPENWEB        0x8008
#define NNSH_JUMPSEL_CHANGEVIEW     0x8009
#define NNSH_JUMPSEL_FAVORITE       0x800a
#define NNSH_JUMPSEL_OUTPUTMEMO     0x800b
#define NNSH_JUMPSEL_BOOKMARK       0x800c
#define NNSH_JUMPSEL_DEVICEINFO     0x800d
#define NNSH_JUMPSEL_OPENLINK       0x800e
#define NNSH_JUMPSEL_EXECA2DA       0x800f
#define NNSH_JUMPSEL_BTOOTH_ON      0x8011
#define NNSH_JUMPSEL_BTOOTH_OFF     0x8012
#define NNSH_JUMPSEL_MEMOURL        0x8013
#define NNSH_JUMPSEL_TOGGLERAWMODE  0x8014
#define NNSH_JUMPSEL_SELECTSEPA     0x8015
#define NNSH_JUMPSEL_EDITSEPA       0x8016

#define NNSH_JUMPMSG_OPENBBS        "I"
#define NNSH_JUMPMSG_OPENMENU       "j["
#define NNSH_JUMPMSG_OPENNEW        "VmF"
#define NNSH_JUMPMSG_OPENLIST       "ꗗ擾"
#define NNSH_JUMPMSG_OPENGET        "X擾"
#define NNSH_JUMPMSG_OPENINFO       "X"
#define NNSH_JUMPMSG_OPENMES        "XQ"
#define NNSH_JUMPMSG_DISCONNECT     "ؒf"
#define NNSH_JUMPMSG_COPYMSG        "QƂփRs["
#define NNSH_JUMPMSG_DELMSG         "X폜"
#define NNSH_JUMPMSG_GRAPHMODE      "`惂[hύX"
#define NNSH_JUMPMSG_MULTISW1       "ړISW1"
#define NNSH_JUMPMSG_MULTISW2       "ړISW2"
#define NNSH_JUMPMSG_NNSIEND        "NNsiI"
#define NNSH_JUMPMSG_SHOWDEVINFO    "foCX"
#define NNSH_JUMPMSG_DIRSELECTION   "DirI(chdir)"
#define NNSH_JUMPMSG_CHANGELOGLOC   "OʒuύX"
#define NNSH_JUMPMSG_CHANGELOGDIR   "DirύX(move)"
#define NNSH_JUMPMSG_BT_ON          "Bt On"
#define NNSH_JUMPMSG_BT_OFF         "Bt Off"
#define NNSH_JUMPMSG_OPENGETLOGLIST "QƃOꗗ"

#define NNSH_ITEMLEN_JUMPLIST       14      // XgACe
#define NNSH_JUMPSEL_NUMLIST        21      // XgACe
#define NNSH_JUMPSEL_OPENBBS        0x9000  // I
#define NNSH_JUMPSEL_OPENMENU       0x9001  // j[
#define NNSH_JUMPSEL_DISCONNECT     0x9002  // ؒf
#define NNSH_JUMPSEL_OPENNEW        0x9003  // VmF
#define NNSH_JUMPSEL_OPENLIST       0x9004  // ꗗ擾
#define NNSH_JUMPSEL_OPENGET        0x9005  // X擾
#define NNSH_JUMPSEL_OPENMES        0x9006  // XQ
#define NNSH_JUMPSEL_OPENINFO       0x9007  // X
#define NNSH_JUMPSEL_COPYMSG        0x9008  // QƂփRs[
#define NNSH_JUMPSEL_DELMSG         0x9009  // X폜
#define NNSH_JUMPSEL_GRAPHMODE      0x900a  // `惂[hύX
#define NNSH_JUMPSEL_MULTISW1       0x900b  // ړISW1
#define NNSH_JUMPSEL_MULTISW2       0x900c  // ړISW2
#define NNSH_JUMPSEL_NNSIEND        0x900d  // NNsiI
#define NNSH_JUMPSEL_SHOWDEVINFO    0x900e  // foCX
#define NNSH_JUMPSEL_DIRSELECTION   0x900f  // fBNgI
#define NNSH_JUMPSEL_CHANGELOGLOC   0x9010  // OʒuύX
#define NNSH_JUMPSEL_CHANGELOGDIR   0x9011  // fBNgύX
#define NNSH_JUMPSEL_BT_ON          0x9012  // Bt On
#define NNSH_JUMPSEL_BT_OFF         0x9013  // Bt Off
#define NNSH_JUMPSEL_OPENGETLOGLIST 0x9014  // QƃOꗗ

#define NNSH_ITEMLEN_GETLOGJUMP     14      // XgACe
#define NNSH_NOF_JUMPMSG_GETLOG     15
#define NNSH_JUMPSEL_GETLOGRETURN   0xA001
#define NNSH_JUMPSEL_GETLOG_OPEN    0xA002
#define NNSH_JUMPSEL_GETLOGBROWSER  0xA003
#define NNSH_JUMPSEL_GETLOG_MEMOURL 0xA004
#define NNSH_JUMPSEL_GETLOG_CHECK   0xA005
#define NNSH_JUMPSEL_GETLOG_OPENMNU 0xA006
#define NNSH_JUMPSEL_GETLOG_LEVEL   0xA007
#define NNSH_JUMPSEL_GETLOG_DISCONN 0xA008
#define NNSH_JUMPSEL_GETLOG_BT_ON   0xA009
#define NNSH_JUMPSEL_GETLOG_BT_OFF  0xA00A
#define NNSH_JUMPSEL_GETLOG_NNSIEND 0xA00B
#define NNSH_JUMPSEL_GETLOG_EDIT    0xA00C  // 
#define NNSH_JUMPSEL_GETLOG_NEW     0xA00D  // 
#define NNSH_JUMPSEL_GETLOG_SEPA    0xA00E  // 
#define NNSH_JUMPSEL_GETLOG_WWWINFO 0xA00F

#define NNSH_JUMPMSG_GETLOGRETURN   "Xꗗ"
#define NNSH_JUMPMSG_GETLOG_OPEN    "J"
#define NNSH_JUMPMSG_GETLOGBROWSER  "uEUŊJ"
#define NNSH_JUMPMSG_GETLOG_MEMOURL "MemoURLɑ"
#define NNSH_JUMPMSG_GETLOG_CHECK   "VmF"
#define NNSH_JUMPMSG_GETLOG_OPENMNU "j["
#define NNSH_JUMPMSG_GETLOG_LEVEL   "LevelύX"
#define NNSH_JUMPMSG_GETLOG_DISCONN "ؒf"
#define NNSH_JUMPMSG_GETLOG_BT_ON   "Bt On"
#define NNSH_JUMPMSG_GETLOG_BT_OFF  "Bt Off"
#define NNSH_JUMPMSG_GETLOG_NNSIEND "NNsiI"

#define NNSH_JUMPMSG_GETLOG_EDIT    "ҏW"
#define NNSH_JUMPMSG_GETLOG_NEW     "VKo^"
#define NNSH_JUMPMSG_GETLOG_SEPA    "ؕҏW"
#define NNSH_JUMPMSG_GETLOG_WWWINFO "TCg"


#define NNSH_STEP_ITEMUP           -1
#define NNSH_STEP_ITEMDOWN          1
#define NNSH_STEP_PAGEUP           -1
#define NNSH_STEP_PAGEDOWN          1
#define NNSH_STEP_REDRAW            0
#define NNSH_STEP_UPDATE           10
#define NNSH_STEP_TO_BOTTOM       100
#define NNSH_STEP_TO_TOP          NNSH_STEP_UPDATE
#define NNSH_STEP_NEWOPEN         200

#define NNSH_ITEM_LASTITEM         0xffff
#define NNSH_ITEM_BOTTOMITEM       0xfffd

#define NNSH_DISP_NOTHING          0x0000   // Ȃ
#define NNSH_DISP_UPPERLIMIT       0x0001   // 
#define NNSH_DISP_HALFWAY          0x0002   // r
#define NNSH_DISP_ALL              0x0004   // S\
#define NNSH_DISP_LOWERLIMIT       0x0008   // 

#define NNSH_DISPMSG_NOTHING       "Ȃ"
#define NNSH_DISPMSG_UPPERLIMIT    ""
#define NNSH_DISPMSG_HALFWAY       "r"
#define NNSH_DISPMSG_ALL           "S\"
#define NNSH_DISPMSG_LOWERLIMIT    ""
#define NNSH_DISPMSG_UNKNOWN       "?????"

#define NNSH_MSGNUM_UNKNOWN        0xffff
#define NNSH_MSGNUM_NOTDISPLAY     0x0000

#define NNSH_LIMIT_COPYBUFFER      2000
#define NNSH_LIMIT_MEMOPAD         4000
#define NNSH_LIMIT_RETRY           5
#define NNSH_MEMOBUFFER_MERGIN     96

#define NNSH_BUSYWIN_MAXLEN        32

#define NNSH_WRITE_DELAYTIME       7
#define NNSH_NEWTHREAD_DELAYTIME   2
#define NNSH_WRITE_DELAYSECOND     45

#define NNSH_MSGTOKENSTATE_NONE    0
#define NNSH_MSGTOKENSTATE_MESSAGE 1
#define NNSH_MSGTOKENSTATE_END     2

#define NNSH_INPUTWIN_SEARCH       "TITLE"
#define NNSH_INPUTWIN_GETMESNUM    "X擾(XԎw)"
#define NNSH_INPUTWIN_MODIFYTITLE  "X^CgύX"
#define NNSH_INPUTWIN_NGWORD1      "NGP̓o^"
#define NNSH_INPUTWIN_NGWORD2      "NGQ̓o^"
#define NNSH_INPUTWIN_SETPASS      "NNsiN[hݒ"
#define NNSH_INPUTWIN_ENTPASS      "Register..."
#define NNSH_INPUTWIN_RESOLVE      "Host Name"

#define NNSH_DIALOG_USE_SEARCH      10
#define NNSH_DIALOG_USE_GETMESNUM   20
#define NNSH_DIALOG_USE_MODIFYTITLE 40
#define NNSH_DIALOG_USE_SEARCH_MESSAGE 60
#define NNSH_DIALOG_USE_SETNGWORD   80
#define NNSH_DIALOG_USE_PASS       100
#define NNSH_DIALOG_USE_RESOLVE    110
#define NNSH_DIALOG_USE_INPUTURL   120

// _CAOȗݒ
#define NNSH_OMITDIALOG_NOTHING      0x00
#define NNSH_OMITDIALOG_CONFIRM      0x01
#define NNSH_OMITDIALOG_WARNING      0x02
#define NNSH_OMITDIALOG_INFORMATION  0x04
#define NNSH_OMITDIALOG_ALLOMIT      ((NNSH_OMITDIALOG_CONFIRM)|(NNSH_OMITDIALOG_WARNING)|(NNSH_OMITDIALOG_INFORMATION))

// ړI{^֘A̐ݒ
#define NNSH_SWITCHUSAGE_FORMMASK   0x3f00
#define NNSH_SWITCHUSAGE_FUNCMASK   0x00ff

#define NNSH_SWITCHUSAGE_TITLE      0x2100

#define NNSH_SWITCHUSAGE_NOUSE      0x00  // ړIXCb`gpȂ
#define NNSH_SWITCHUSAGE_GETPART    0x01  // X擾[h(ꊇ/)
#define NNSH_SWITCHUSAGE_HANZEN     0x02  // pJiSpJiϊ
#define NNSH_SWITCHUSAGE_USEPROXY   0x03  // ProxyoRŃANZX
#define NNSH_SWITCHUSAGE_CONFIRM    0x04  // mF_CAȌȗ

#define NNSH_SWITCHUSAGE_SUBJECT    0x05  // XꗗS擾؂ւ  (ꗗʗp)
#define NNSH_SWITCHUSAGE_TITLEDISP  0x06  // Xꗗ`惂[hؑ  (ꗗʗp)
#define NNSH_SWITCHUSAGE_MSGNUMBER  0x07  // XꗗMSGԍ       (ꗗʗp)
#define NNSH_SWITCHUSAGE_GETRESERVE 0x08  // X擾ۗ[h      (ꗗʗp)
#define NNSH_SWITCHUSAGE_IMODEURL   0x09  // i-mode URLgp[h    (ꗗʗp)
#define NNSH_SWITCHUSAGE_BLOCKDISP  0x0a  // ][\[h        (ꗗʗp)
#define NNSH_SWITCHUSAGE_MACHINEW   0x0b  // ܂BBSVmF   (ꗗʗp)
#define NNSH_SWITCHUSAGE_USEPLUGIN  0x0c  // VmFɃ[mF  (ꗗʗp)
#define NNSH_SWITCHUSAGE_LISTUPDATE 0x0d  // ꗗ擾ƃXXV      (ꗗʗp)
#define NNSH_SWITCHUSAGE_NOREADONLY 0x0e  // 擾ςݑSĂɂ͎QƃOȂ
#define NNSH_SWITCHUSAGE_NORDOLY_NW 0x0f  // ǂɂ͎QƃOȂ
#define NNSH_SWITCHUSAGE_DISCONN_NA 0x10  // VmFɉؒf
#define NNSH_SWITCHUSAGE_PREEXEC_NA 0x11  // VmFODAs

// ړI{^̏ݒl
#define NNSH_SWITCH1USAGE_DEFAULT   NNSH_SWITCHUSAGE_GETPART    // X擾[h
#define NNSH_SWITCH2USAGE_DEFAULT   NNSH_SWITCHUSAGE_USEPROXY   // ProxyoRł̃ANZX

#define NNSH_SUBJSTATUSMSG_NOT_YET  "擾"
#define NNSH_SUBJSTATUSMSG_NEW      "VK擾"
#define NNSH_SUBJSTATUSMSG_UPDATE   "XV擾"
#define NNSH_SUBJSTATUSMSG_REMAIN   "ǂ"
#define NNSH_SUBJSTATUSMSG_ALREADY  ""
#define NNSH_SUBJSTATUSMSG_UNKNOWN  "ԕs"

/** X **/
#define MAX_SEARCH_STRING 64

#define NNSH_VIEW_SEARCHSTRING_HEADER  "ID:"  // p񒊏owb_

/** X@ **/
#define NNSH_SEARCH_METHOD_FROM_TOP    0 //擪猟
#define NNSH_SEARCH_METHOD_NEXT        1 //
#define NNSH_SEARCH_METHOD_PREV        2 //O
#define NNSH_SEARCH_METHOD_FROM_BOTTOM 3 //猟

/** bZ[W擾@ **/
#define GET_MESSAGE_TYPE_TOP    1 // ւ̌p
#define GET_MESSAGE_TYPE_HALF   2 // XQƗp
#define GET_MESSAGE_TYPE_BOTTOM 3 // 擪ւ̌p


// FORM ID LIST
#define NNSH_FRMID_THREAD        0x1200    // ꗗ
#define NNSH_FRMID_MESSAGE       0x1201    // QƉ
#define NNSH_FRMID_DUMMY         0x1202    // _~[
#define NNSH_FRMID_WRITE_MESSAGE 0x1203    // ݉
#define NNSH_FRMID_GETLOGLIST    0x1204    // QƃOꗗ


// ړI{^̐ݒ
#define MAX_CAPTION                  6
#define LIMIT_CAPTION                4

#define MULTIBTN1_CAPTION_DEFAULT    "Q"
#define MULTIBTN1_FEATURE_DEFAULT    MULTIBTN_FEATURE_OPEN

#define MULTIBTN2_CAPTION_DEFAULT    "擾"
#define MULTIBTN2_FEATURE_DEFAULT    MULTIBTN_FEATURE_GET

#define MULTIBTN3_CAPTION_DEFAULT    "폜"
#define MULTIBTN3_FEATURE_DEFAULT    MULTIBTN_FEATURE_DELETE

#define MULTIBTN4_CAPTION_DEFAULT    "ؒf"
#define MULTIBTN4_FEATURE_DEFAULT    MULTIBTN_FEATURE_DISCONN

#define MULTIBTN5_CAPTION_DEFAULT    "ꗗ"
#define MULTIBTN5_FEATURE_DEFAULT    MULTIBTN_FEATURE_GETLIST

#define MULTIBTN6_CAPTION_DEFAULT    "V"
#define MULTIBTN6_FEATURE_DEFAULT    MULTIBTN_FEATURE_NEWARRIVAL

#define UPBTN_FEATURE_DEFAULT        MULTIBTN_FEATURE_SELECTPREV
#define DOWNBTN_FEATURE_DEFAULT      MULTIBTN_FEATURE_SELECTNEXT

#define JOGPUSH_FEATURE_DEFAULT      MULTIBTN_FEATURE_OPEN
#define JOGBACK_FEATURE_DEFAULT      MULTIBTN_FEATURE_SELMENU
#define CAPTURE_FEATURE_DEFAULT      MULTIBTN_FEATURE_INFO

#define LEFTBTN_FEATURE_DEFAULT      MULTIBTN_FEATURE_PREVPAGE
#define RIGHTBTN_FEATURE_DEFAULT     MULTIBTN_FEATURE_NEXTPAGE

#define MULTIBTN_FEATURE_MASK        0x00ff
#define MULTIBTN_FEATURE             0x7600

// ꗗʂ̋@\ݒi@\ԍj
//    ݒp^CǵA\[XŒ`(ƓĂKv)
#define MULTIBTN_FEATURE_INFO        0  // ""
#define MULTIBTN_FEATURE_OPEN        1  // "Q"
#define MULTIBTN_FEATURE_GET         2  // "X擾"
#define MULTIBTN_FEATURE_ALLGET      3  // "VK()擾"
#define MULTIBTN_FEATURE_PARTGET     4  // "擾"
#define MULTIBTN_FEATURE_DELETE      5  // "X폜"
#define MULTIBTN_FEATURE_SORT        6  // "X"
#define MULTIBTN_FEATURE_MODTITLE    7  // "X^CύX"
#define MULTIBTN_FEATURE_OPENWEB     8  // "uEUŊJ"
#define MULTIBTN_FEATURE_MESNUM      9  // "XԎw擾"
#define MULTIBTN_FEATURE_SEARCH     10  // "X^C"
#define MULTIBTN_FEATURE_NEXT       11  // ""
#define MULTIBTN_FEATURE_PREV       12  // "O"
#define MULTIBTN_FEATURE_TOP        13  // "擪ֈړ"
#define MULTIBTN_FEATURE_BOTTOM     14  // "ֈړ"
#define MULTIBTN_FEATURE_GETBBS     15  // "BBSꗗ擾"
#define MULTIBTN_FEATURE_USEBBS     16  // "gpBBSI"
#define MULTIBTN_FEATURE_COPYGIKO   17  // "QƃOCOPY"
#define MULTIBTN_FEATURE_DELNOTGET  18  // "擾ꗗ폜"
#define MULTIBTN_FEATURE_DBCOPY     19  // "DBVFSCOPY"
#define MULTIBTN_FEATURE_GRAPHMODE  20  // "`惂[hύX"
#define MULTIBTN_FEATURE_ROTATE     21  // "ʂ̉](HE)"
#define MULTIBTN_FEATURE_FONT       22  // "tHgύX"
#define MULTIBTN_FEATURE_NETWORK    23  // "Networkݒ"
#define MULTIBTN_FEATURE_SELMENU    24  // "Ij["
#define MULTIBTN_FEATURE_DISCONN    25  // "ؒf"
#define MULTIBTN_FEATURE_GETLIST    26  // "Xꗗ擾"
#define MULTIBTN_FEATURE_NEWARRIVAL 27  // "VmF"
#define MULTIBTN_FEATURE_NNSHSET    28  // "NNsiݒ(T)"
#define MULTIBTN_FEATURE_NNSHSET1   29  // "NNsiݒ-1"
#define MULTIBTN_FEATURE_NNSHSET2   30  // "NNsiݒ-2"
#define MULTIBTN_FEATURE_NNSHSET3   31  // "NNsiݒ-3"
#define MULTIBTN_FEATURE_NNSHSET4   32  // "NNsiݒ-4"
#define MULTIBTN_FEATURE_NNSHSET5   33  // "NNsiݒ-5"
#define MULTIBTN_FEATURE_NNSHSET6   34  // "NNsiݒ-6"
#define MULTIBTN_FEATURE_NNSHSET7   35  // "NNsiݒ-7"
#define MULTIBTN_FEATURE_NNSHSET8   36  // "NNsiݒ-8"
#define MULTIBTN_FEATURE_NNSHSET9   37  // "NNsiݒ-9"
#define MULTIBTN_FEATURE_VERSION    38  // "o[W"
#define MULTIBTN_FEATURE_SELECTNEXT 39  // "P"
#define MULTIBTN_FEATURE_SELECTPREV 40  // "P"
#define MULTIBTN_FEATURE_PREVPAGE   41  // "Oy[W"
#define MULTIBTN_FEATURE_NEXTPAGE   42  // "y[W"
#define MULTIBTN_FEATURE_NNSIEND    43  // "NNsiI"
#define MULTIBTN_FEATURE_NGWORD1    44  // "NG1ݒ"
#define MULTIBTN_FEATURE_NGWORD2    45  // "NG2ݒ"
#define MULTIBTN_FEATURE_USER1TAB   46  // "[U1^u"
#define MULTIBTN_FEATURE_USER2TAB   47  // "[U2^u"
#define MULTIBTN_FEATURE_DEVICEINFO 48  // "foCX"
#define MULTIBTN_FEATURE_GOTODUMMY  49  // "_~[ʂ"
#define MULTIBTN_FEATURE_NEWTHREAD  50  // "X"
#define MULTIBTN_FEATURE_USER3TAB   51  // "[U3^u"
#define MULTIBTN_FEATURE_USER4TAB   52  // "[U4^u"
#define MULTIBTN_FEATURE_USER5TAB   53  // "[U5^u"
#define MULTIBTN_FEATURE_DIRSELECT  54  // "DirI"
#define MULTIBTN_FEATURE_TABINFO    55  // "^u"
#define MULTIBTN_FEATURE_MOVELOGLOC 56  // "OǗύX"
#define MULTIBTN_FEATURE_MOVELOGDIR 57  // "DirύX"
#define MULTIBTN_FEATURE_TO_NOTREAD 58  // "'ǂ'"
#define MULTIBTN_FEATURE_TO_GETALL  59  // "'擾ςݑS'"
#define MULTIBTN_FEATURE_LOGCHARGE  60  // "QƃO擾"
#define MULTIBTN_FEATURE_OPENURL    61  // "URL擾"
#define MULTIBTN_FEATURE_SETNGWORD3 62  // "NG-3ݒ"
#define MULTIBTN_FEATURE_SETLOGCHRG 63  // "QƃO擾ݒ"
#define MULTIBTN_FEATURE_BT_ON      64  // "Bt-On"
#define MULTIBTN_FEATURE_BT_OFF     65  // "Bt-Off"
#define MULTIBTN_FEATURE_TO_OFFLINE 66  // 'QƃO' 
#define MULTIBTN_FEATURE_TO_FAVOR   67  // 'Cɓ'
#define MULTIBTN_FEATURE_TO_USER1   68  // '[U1'
#define MULTIBTN_FEATURE_TO_USER2   69  // '[U2'
#define MULTIBTN_FEATURE_TO_USER3   70  // '[U3'
#define MULTIBTN_FEATURE_TO_USER4   71  // '[U4'
#define MULTIBTN_FEATURE_TO_USER5   72  // '[U5'
#define MULTIBTN_FEATURE_MACRO_EXEC 73  // MACROs
#define MULTIBTN_FEATURE_MACRO_VIEW 74  // MACRO\
#define MULTIBTN_FEATURE_MACRO_LOG  75  // MACROO\
#define MULTIBTN_FEATURE_MACRO_SET  76  // MACROݒ
#define MULTIBTN_FEATURE_SELECT_BBS 77  // I
#define MULTIBTN_FEATURE_OYSTERLOGIN 78 // 'OC'
#define MULTIBTN_FEATURE_USAGE      79  // wv
#define MULTIBTN_FEATURE_SETTOKEN   80  // ؂ݒ
#define MULTIBTN_FEATURE_OPENGETLOGLIST 81 // QƃO擾ꗗʂ
#define MULTIBTN_FEATURE_SEARCHBBS  82     // 
#define MULTIBTN_FEATURE_NEXTSEARCHBBS  83 // 
#define MULTIBTN_FEATURE_BEAMURL    84     // URLBeam
#define MULTIBTN_FEATURE_UPDATERESNUM 85   // 擾ς݃XԍXV

#define HARDKEY_FEATURE_MASK         0x00ff
#define HARDKEY_FEATURE              0x0000

// n[hL[̐ݒ
#define HARDKEY_FEATURE_DONOTHING    0  // NNsiŐ䂵Ȃ
#define HARDKEY_FEATURE_CONTROLNNSI  1  // NNsiŐ䂷
#define HARDKEY_FEATURE_TRANSJOGPUSH 2  // JOG PUSHƓɂ
#define HARDKEY_FEATURE_TRANSJOGBACK 3  // JOG BACKƓɂ

#define NNSH_BLOCKDISP_NOFMSG        5

#define NNSH_VFSDB_SETTING           0
#define NNSH_VFSDB_SUBJECT           1
#define NNSH_VFSDB_BBSLIST           2

#define NNSH_CONDITION_AND           0x0000  // AND
#define NNSH_CONDITION_OR            0x0001  // OR
#define NNSH_CONDITION_ALL           0x0003  // (S)

#define NNSH_CONDITION_NOTREADONLY   0x0004  // QƃO͏O(rbg)

#define NNSH_CONDITION_LOGLOC_ALL    0x0018  // 
#define NNSH_CONDITION_LOGLOC_PALM   0x0008  // PalmO
#define NNSH_CONDITION_LOGLOC_VFS    0x0010  // VFSO

#define NNSH_CONDITION_GETERR_ALL    0x0060  // 
#define NNSH_CONDITION_GETERR_NONE   0x0020  //  G[Ȃ
#define NNSH_CONDITION_GETERR_ERROR  0x0040  //  擾G[

#define NNSH_CONDITION_GETRSV_ALL    0x0180  // 
#define NNSH_CONDITION_GETRSV_RSV    0x0080  //  ۗX
#define NNSH_CONDITION_GETRSV_NONE   0x0100  //  ۗX

#define NNSH_THREADLEVEL_MASK        0x00ff  // Xx}XN
#define NNSH_THREADCOND_MASK         0x7f00  // Xԃ}XN
#define NNSH_THREADCOND_SHIFT        8       // Xԃ}XN

#define NNSH_THREADLEVEL_UPPER       0       // Xx hȏh
#define NNSH_THREADLEVEL_LOWER       1       // Xx hȉh
#define NNSH_THREADLEVEL_ELSE        2       // Xx hȊOh
#define NNSH_THREADLEVEL_MATCH       3       // Xx hh

#define NNSH_BOARD_MATCH             0       // ݒ hh
#define NNSH_BOARD_ELSE              1       // ݒ hȊOh

// dX̃`FbN@
#define NNSH_DUP_CHECK_HIGH          1       // g
#define NNSH_DUP_CHECK_SLOW          2       // ͎gȂᑬ
#define NNSH_DUP_NOCHECK             3       // d`FbNsȂ

#define NNSH_STRING_SELECTION        0x0100  // 
#define NNSH_STRING_SETMASK          0x00ff  // 
#define NNSH_STRING_OR               0x0001  // 
#define NNSH_STRING_CUSTOM2_DEFAULT1 "Palm"
#define NNSH_STRING_CUSTOM2_DEFAULT2 "palm"
#define NNSH_STRING_CUSTOM2_DEFAULT3 "CLIE"

#define NNSH_LEVEL_ERROR            0x0000
#define NNSH_LEVEL_WARN             0x0001
#define NNSH_LEVEL_INFO             0x0002
#define NNSH_LEVEL_CONFIRM          0x0004
#define NNSH_LEVEL_DEBUG            0x0010

#define NNSH_TITLE_HARDKEYSET_TITLE  "ꗗʃn[hL[ݒ"
#define NNSH_HARDKEYCONTROL_TITLE    "n[hL[ݒ"
#define NNSH_TITLE_HARDKEYVIEW_TITLE "QƉʃn[hL[ݒ"
#define NNSH_TITLE_GETLOGLIST_TITLE  "QƃOꗗʃn[hL[ݒ"

#define MULTIVIEWBTN_FEATURE_MASK    0x00ff
#define MULTIVIEWBTN_FEATURE         0x7300

#define GETLOGBTN_FEATURE_MASK       0x00ff
#define GETLOGBTN_FEATURE            0x0000

#define UPBTN_VIEWFEATURE_DEFAULT    MULTIVIEWBTN_FEATURE_PAGEUP
#define DOWNBTN_VIEWFEATURE_DEFAULT  MULTIVIEWBTN_FEATURE_PAGEDOWN

#define JOGPUSH_VIEWFEATURE_DEFAULT  MULTIVIEWBTN_FEATURE_GETPART
#define JOGBACK_VIEWFEATURE_DEFAULT  MULTIVIEWBTN_FEATURE_BACKTOLIST
#define CAPTURE_VIEWFEATURE_DEFAULT  MULTIVIEWBTN_FEATURE_INFO

#define LEFTBTN_VIEWFEATURE_DEFAULT  MULTIVIEWBTN_FEATURE_PREVIOUS
#define RIGHTBTN_VIEWFEATURE_DEFAULT MULTIVIEWBTN_FEATURE_NEXT

#define NNSH_DEFAULT_VIEW_LVLBTNFEATURE   MULTIVIEWBTN_FEATURE_INFO
#define NNSH_DEFAULT_VIEW_TITLESELFEATURE MULTIVIEWBTN_FEATURE_BACKTOLIST


// QƉʂ̋@\ݒi@\ԍj
//    ݒp^CǵA\[XŒ`(ƓĂKv)
#define MULTIVIEWBTN_FEATURE_INFO        0  // "X"
#define MULTIVIEWBTN_FEATURE_BACKTOLIST  1  // "ꗗʂ"
#define MULTIVIEWBTN_FEATURE_WRITE       2  // ""
#define MULTIVIEWBTN_FEATURE_GETPART     3  // "擾"
#define MULTIVIEWBTN_FEATURE_GETMESNUM   4  // "XԎw擾"
#define MULTIVIEWBTN_FEATURE_GOTOTOP     5  // "擪MSG"
#define MULTIVIEWBTN_FEATURE_PREVIOUS    6  // "OMSG"
#define MULTIVIEWBTN_FEATURE_PAGEUP      7  // "OXN["
#define MULTIVIEWBTN_FEATURE_PAGEDOWN    8  // "XN["
#define MULTIVIEWBTN_FEATURE_NEXT        9  // "MSG"
#define MULTIVIEWBTN_FEATURE_GOTOBOTTOM 10  // "MSG"
#define MULTIVIEWBTN_FEATURE_JUMP       11  // "Go"
#define MULTIVIEWBTN_FEATURE_RETURN     12  // "P߂"
#define MULTIVIEWBTN_FEATURE_COPY       13  // "Rs["
#define MULTIVIEWBTN_FEATURE_SELECTALL  14  // "񂷂ׂđI"
#define MULTIVIEWBTN_FEATURE_OPENWEB    15  // "Web"
#define MULTIVIEWBTN_FEATURE_SELANDWEB  16  // "I+Web"
#define MULTIVIEWBTN_FEATURE_OUTPUTMEMO 17  // "o"
#define MULTIVIEWBTN_FEATURE_SEARCH     18  // ""
#define MULTIVIEWBTN_FEATURE_SEARCHNEXT 19  // ""
#define MULTIVIEWBTN_FEATURE_SEARCHPREV 20  // "O"
#define MULTIVIEWBTN_FEATURE_SEARCHTOP  21  // "擪猟"
#define MULTIVIEWBTN_FEATURE_SEARCHBTM  22  // "猟"
#define MULTIVIEWBTN_FEATURE_CHANGEFONT 23  // "tHgύX"
#define MULTIVIEWBTN_FEATURE_DRAWMODE   24  // "`惂[hύX"
#define MULTIVIEWBTN_FEATURE_ROTATE     25  // "ʂ̉](HE)"
#define MULTIVIEWBTN_FEATURE_DISCONNECT 26  // "ؒf"
#define MULTIVIEWBTN_FEATURE_SETNETWORK 27  // "Networkݒ"
#define MULTIVIEWBTN_FEATURE_BOOKMARK   28  // "ݒ"
#define MULTIVIEWBTN_FEATURE_DEVICEINFO 29  // "foCX"
#define MULTIVIEWBTN_FEATURE_PAGEDOWN10 30  // "10X"
#define MULTIVIEWBTN_FEATURE_PAGEUP10   31  // "10XO"
#define MULTIVIEWBTN_FEATURE_GOTODUMMY  32  // "_~[ʂ"
#define MULTIVIEWBTN_FEATURE_OPENURL    33  // "NJ"
#define MULTIVIEWBTN_FEATURE_EXECA2DA   34  // "A2DAN"
#define MULTIVIEWBTN_FEATURE_BT_ON      35  // "Bt On"
#define MULTIVIEWBTN_FEATURE_BT_OFF     36  // "Bt Off"
#define MULTIVIEWBTN_FEATURE_USAGE      37  // "wv"
#define MULTIVIEWBTN_FEATURE_MEMOURL    38  // "MemoURL֑"
#define MULTIVIEWBTN_FEATURE_CHANGERAW  39  // "RAW[hؑ"
#define MULTIVIEWBTN_FEATURE_CHGSEPA    40  // "؂蕶ύX"
#define MULTIVIEWBTN_FEATURE_EDITSEPA   41  // "؂蕶ҏW"
#define MULTIVIEWBTN_FEATURE_OPENURL_HTTP 42 // "URLJ(MSG璊o)"
#define MULTIVIEWBTN_FEATURE_MEMOURLDA  43  // "MemoURL(DAoR)"

// Notify̍XV
#define NNSH_VFS_UNMOUNTED              100
#define NNSH_VFS_UNMOUNTED_WRITE        101
#define NNSH_VFS_UNMOUNTED_MESSAGE      102
#define NNSH_VFS_UNMOUNTED_OTHER        103
#define NNSH_VFS_MOUNTED                110

#define NNSH_DISP_RESIZED               200


// NG`FbNgpEȂ
#define NNSH_USE_NGWORD1AND2            0x01
#define NNSH_USE_NGWORD3                0x10

// a2DAƂ̘Ag@\p`
#define A2DA_NNSIEXT_AADATASTART  "<NNsi:NNsiExt type=\"AA\">"
#define A2DA_NNSIEXT_ENDDATA      "</NNsi:NNsiExt>"
#define A2DA_NNSIEXT_SRC_STREAM   "<NNsi:Source>stream</NNsi:Source>"
#define A2DA_NNSIEXT_DATANAME     "<NNsi:Name>"
#define A2DA_NNSIEXT_ENDDATANAME  "</NNsi:Name>"
#define A2DA_NNSIEXT_NNSICREATOR  "<NNsi:Creator>NNsi</NNsi:Creator>"

#define nnDA_NNSIEXT_VIEWSTART    "<NNsi:NNsiExt type=\"VIEW\">"
#define nnDA_NNSIEXT_ENDVIEW      "</NNsi:NNsiExt>"
#define nnDA_NNSIEXT_INFONAME     "<NNsi:Info>"
#define nnDA_NNSIEXT_ENDINFONAME  "</NNsi:Info>"

#define nnDA_NNSIEXT_FILE         "FILE:"
#define nnDA_NNSIEXT_HELPLIST     "HELP:LIST"
#define nnDA_NNSIEXT_HELPVIEW     "HELP:VIEW"
#define nnDA_NNSIEXT_HELPFAVORTAB "HELP:FAVORTAB"
#define nnDA_NNSIEXT_HELPNNSISET  "HELP:NNSISET"
#define nnDA_NNSIEXT_HELPGETLOG   "HELP:GETLOG"
#define nnDA_NNSIEXT_FILERECVFILE "FILE:NNsi:recv.txt"
#define nnDA_NNSIEXT_FILESENDFILE "FILE:NNsi:send.txt"
#define nnDA_NNSIEXT_VIEWMEM      "MEM:"
#define nnDA_NNSIEXT_VIEWMEM_FOLD "FOLDMEM:"
#define nnDA_NNSIEXT_FOLDHTMLFILE "FOLDHTMLFILE:NNsi:"

// NNsiԒʐMp`
#define NNSI_EXCHANGEINFO_SUFFIX  "nsi"

// Xԍ
#define NNSI_NNSIEXT_THREADNUMBER_START "<NNsi:NNsiExt type=\"THREAD\">"
#define NNSI_NNSIEXT_THREADNUMBER_END   "</NNsi:NNsiExt>"

// URL
#define NNSI_NNSIEXT_URL_START          "<NNsi:NNsiExt type=\"URL\">"
#define NNSI_NNSIEXT_URL_END            "</NNsi:NNsiExt>"


// QƃOꗗʂ̋@\ꗗ
#define NNSH_GETLOG_FEATURE_NONE           0xffff   // @\Ȃ
#define NNSH_GETLOG_FEATURE_CLOSE_GETLOG        0   // ꗗʂ
#define NNSH_GETLOG_FEATURE_CHECK_NEWARRIVAL    1   // VmF
#define NNSH_GETLOG_FEATURE_EDITITEM            2   // TCgڍ
#define NNSH_GETLOG_FEATURE_PREVITEM            3   // P
#define NNSH_GETLOG_FEATURE_NEXTITEM            4   // P
#define NNSH_GETLOG_FEATURE_PREVPAGE            5   // Oy[W
#define NNSH_GETLOG_FEATURE_NEXTPAGE            6   // y[W
#define NNSH_GETLOG_FEATURE_TOP                 7   // 擪
#define NNSH_GETLOG_FEATURE_BOTTOM              8   // 
#define NNSH_GETLOG_FEATURE_CREATELIST          9   // ꗗč\z
#define NNSH_GETLOG_FEATURE_EDIT_SEPARATOR     10   // ؕҏW
#define NNSH_GETLOG_FEATURE_ENTRY_NEWSITE      11   // TCgo^
#define NNSH_GETLOG_FEATURE_OPEN_GETLEVEL      12   // LevelύX
#define NNSH_GETLOG_FEATURE_REDRAW             13   // ĕ`
#define NNSH_GETLOG_FEATURE_OPENWEB            14   // uEUŊJ
#define NNSH_GETLOG_FEATURE_BT_ON              15   // Bt On
#define NNSH_GETLOG_FEATURE_BT_OFF             16   // Bt Off
#define NNSH_GETLOG_FEATURE_DISCONNECT         17   // ؒf
#define NNSH_GETLOG_FEATURE_NETCONFIG          18   // Networkݒ
#define NNSH_GETLOG_FEATURE_DEVICEINFO         19   // foCX
#define NNSH_GETLOG_FEATURE_OPEN_DUMMY         20   // _~[ʂ
#define NNSH_GETLOG_FEATURE_OPEN_NNSISET       21   // NNsiݒʂ
#define NNSH_GETLOG_FEATURE_SHOWVERSION        22   // o[W
#define NNSH_GETLOG_FEATURE_HELP               23   // 
#define NNSH_GETLOG_FEATURE_NNSIEND            24   // NNsiI
#define NNSH_GETLOG_FEATURE_OPENMENU           25   // Ij[
#define NNSH_GETLOG_FEATURE_OPEN_NNSI          26   // NNsiŊJ
#define NNSH_GETLOG_FEATURE_OPEN_MEMOURL       27   // MemoURLŊJ
#define NNSH_GETLOG_FEATURE_OPEN_GETLOGMENU    28   // j[J
#define NNSH_GETLOG_FEATURE_FORCE_DISCONNECT   29   // ؒf-2
#define NNSH_GETLOG_FEATURE_CONFIG_GETLOG      30   // QƃOꗗݒ
#define NNSH_GETLOG_FEATURE_SITE_INFORMATION   31   // TCg
#define NNSH_GETLOG_FEATURE_BEAM_URL           32   // URLBEAM

#define NNSH_GETLOG_NEWARRIVAL_LOG         0x8000   // ǃO
#define NNSH_GETLOG_NEWARRIVAL_CLEAR_MASK  0x7fff   // ǃOOFF

// SSL[h`
#define NNSH_SSLMODE_NOTSSL             0
#define NNSH_SSLMODE_SSLV3              1
#define NNSH_SSLMODE_SSL_V2SPECIAL      2

#ifdef USE_SSL
#ifdef USE_SSL_V2

//
#define NNSHSSL_STATE_MASK             0x0FFF
#define NNSHSSL_STATE_CONNECT          0x1000
#define NNSHSSL_STATE_ACCEPT           0x2000
#define NNSHSSL_STATE_INIT        (NNSHSSL_STATE_CONNECT|NNSHSSL_STATE_ACCEPT)
#define NNSHSSL_STATE_BEFORE           0x4000

#define NNSHSSL_STATE_OK               0x03
#define NNSHSSL_STATE_RENEGOTIATE     (0x04|NNSHSSL_STATE_INIT)

/* Protocol Version Codes */
#define SSL2_VERSION                   0x0002
#define SSL2_VERSION_MAJOR             0x00
#define SSL2_VERSION_MINOR             0x02
/* #define SSL2_CLIENT_VERSION          0x0002 */
/* #define SSL2_SERVER_VERSION          0x0002 */

#define NNSHSSL2_MAX_RECORD_LENGTH_3_BYTE_HEADER  16383 /* 2^14-1 */

/* SSLv2 */
/* client */
#define SSL2_ST_SEND_CLIENT_HELLO            (0x10|NNSHSSL_STATE_CONNECT)
#define SSL2_ST_GET_SERVER_HELLO             (0x20|NNSHSSL_STATE_CONNECT)
#define SSL2_ST_SEND_CLIENT_MASTER_KEY       (0x30|NNSHSSL_STATE_CONNECT)
#define SSL2_ST_CREATE_ENCRYPTION_KEY        (0x31|NNSHSSL_STATE_CONNECT)
#define SSL2_ST_SEND_CLIENT_FINISHED         (0x40|NNSHSSL_STATE_CONNECT)
#define SSL2_ST_GET_SERVER_VERIFY            (0x60|NNSHSSL_STATE_CONNECT)
#define SSL2_ST_GET_SERVER_FINISHED          (0x70|NNSHSSL_STATE_CONNECT)
#define SSL2_ST_START_ENCRYPTION             (0x80|NNSHSSL_STATE_CONNECT)

/* Protocol Message Codes */
#define SSL2_MT_ERROR                         0
#define SSL2_MT_CLIENT_HELLO                  1
#define SSL2_MT_CLIENT_MASTER_KEY             2
#define SSL2_MT_CLIENT_FINISHED               3
#define SSL2_MT_SERVER_HELLO                  4
#define SSL2_MT_SERVER_VERIFY                 5
#define SSL2_MT_SERVER_FINISHED               6
#define SSL2_MT_REQUEST_CERTIFICATE           7
#define SSL2_MT_CLIENT_CERTIFICATE            8

//#define SSL2_CHALLENGE_LENGTH                32
#define SSL2_CHALLENGE_LENGTH                16
#define SSL2_MD5_HASH_LENGTH                 16
#define SSL2_RWKEY_LENGTH                    SSL2_MD5_HASH_LENGTH
#define SSL2_MASTERKEY_LENGTH                16
// #define SSL2_MASTERKEY_LENGTH             128
// #define SSL2_SSL_SESSION_ID_LENGTH         16
#define SSL2_MAX_SSL_SESSION_ID_LENGTH       32
#endif  // #ifdef USE_SSL_V2
#endif  // #ifdef USE_SSL


#ifdef USE_MACRO

// MOx
#define NNSH_MACROLOGLEVEL_FATAL    0
#define NNSH_MACROLOGLEVEL_ERROR    1
#define NNSH_MACROLOGLEVEL_WARN     2
#define NNSH_MACROLOGLEVEL_INFO     3
#define NNSH_MACROLOGLEVEL_DEBUG    9

// opR[h(\[XƈvKv)
#define NNSH_MACROCMD_MACROEND 0   // }NI
#define NNSH_MACROCMD_MOVE     1   // 
#define NNSH_MACROCMD_ADD      2   // Z
#define NNSH_MACROCMD_SUB      3   // Z
#define NNSH_MACROCMD_MESSAGE  4   // Oo
#define NNSH_MACROCMD_EXECUTE  5   // @\̎s
#define NNSH_MACROCMD_CMP      6   // l̔r
#define NNSH_MACROCMD_JMP      7   // Wv
#define NNSH_MACROCMD_JZ       8   // vꍇWv
#define NNSH_MACROCMD_JNZ      9   // vȂꍇWv
#define NNSH_MACROCMD_BEEP    10   // r[v炷
#define NNSH_MACROCMD_OPERATE 11   // NNsiݒ̒lݒ
#define NNSH_MACROCMD_BBSTYPE 12   // BBS^Cv
#define NNSH_MACROCMD_STRSTR  13   // 񂪊܂܂邩ǂ
#define NNSH_MACROCMD_STRCMP  14   // 񂪈v邩ǂ
#define NNSH_MACROCMD_SETTABNUM 15 // ^uɊ܂܂鐔
#define NNSH_MACROCMD_GETMESNUM 16 // XɊ܂܂郁bZ[W
#define NNSH_MACROCMD_MESSTATUS 17 // XԂ
#define NNSH_MACROCMD_AND     18   // _
#define NNSH_MACROCMD_OR      19   // _a
#define NNSH_MACROCMD_XOR     20   // rI_a
#define NNSH_MACROCMD_IMPORT  21   // NNsiݒC|[g
#define NNSH_MACROCMD_EXPORT  22   // NNsiݒGNX|[g
#define NNSH_MACROCMD_STATUS  23   // NNsiݒ̒l擾
#define NNSH_MACROCMD_LAUNCHDA 24  // DAN
#define NNSH_MACROCMD_CLIPCOPY  25  // Nbv{[hɃRs[
#define NNSH_MACROCMD_CLIPADD   26  // Nbv{[hɒǉ
#define NNSH_MACROCMD_CLIPINSTR 27  // Nbv{[h̕Ɋ܂܂邩mF
#define NNSH_MACROCMD_TITLECLIP 28  // X^CgNbv{[hɃRs[
#define NNSH_MACROCMD_SET_FINDBBSSTR 29 // ^up̐ݒ
#define NNSH_MACROCMD_SET_FINDTHREADSTR  30 // X^Cp̐ݒ
#define NNSH_MACROCMD_UPDATE_RESNUM  31 // X̃XԍXV(1.03)
#define NNSH_MACROCMD_JPL       32   // l̏ꍇɂ̓Wv(1.03)
#define NNSH_MACROCMD_JMI       33   // l̏ꍇɂ̓Wv(1.03)
#define NNSH_MACROCMD_OUTPUTTITLE 34 // X^CgOo(1.03)
#define NNSH_MACROCMD_OUTPUTCLIP 35  // Nbv{[h̓eOo(1.03)
#define NNSH_MACROCMD_REMARK    36   // ߕ(Ȃ) (1.03)
#define NNSH_MACROCMD_PUSH      37   // X^bNPUSH(1.04)
#define NNSH_MACROCMD_POP       38   // X^bNPOP(1.04)
#define NNSH_MACROCMD_GETRECNUM 39   // R[hԍ擾(1.04)
#define NNSH_MACROCMD_FINDTHREADSTRCOPY 40 // XNbv{[h(1.04)

// f[^̑֘Aw(NNsiݒ̕ύXƂ)
#define NNSH_MACROOPCMD_DISABLE            0xffff  // (}NȂ)
#define NNSH_MACROOPCMD_AUTOSTARTMACRO     0xfffe  // (}NsSET)
#define NNSH_MACROOPCMD_NEWARRIVAL_LINE    0xfffd  // (VmF̉ؒf)
#define NNSH_MACROOPCMD_NEWARRIVAL_DA      0xfffc  // (VmFDAN)
#define NNSH_MACROOPCMD_NEWARRIVAL_ROLOG   0xfffb  // (QƃO擾x)
#define NNSH_MACROOPCMD_NEWARRIVAL_BEEP    0xfffa  // (VmF̃r[v)
#define NNSH_MACROOPCMD_COPY_AND_DELETE    0xfff9  // (QƃOɃRs[폜)

#define NNSH_MACROCMD_VIEWTITLE  "}Ne"
#define NNSH_MACROLOG_VIEWTITLE  "}Ns"

#define MAX_HALT_OPERATION     100   // @\s̐
#define MAX_LOGVIEW_BUFFER      80   //
#define MAX_LOGOUTPUT_BUFFER    72   //
#define MAX_FUNCCHAR_BUF        20   //
#define TEXTBUFSIZE            256

// }ÑWX^֘A
#define NOF_REGISTER             16  // WX^̐
#define NNSH_MACROOP_NOSPECIFY 0x00  // wȂ
#define NNSH_MACROOP_IMMEDIATE 0x01  // lw

#define NNSH_MACROOP_GR_OFFSET 0xe0  // WX^ItZbg
#define NNSH_MACROOP_GR0       0xe0  // GR0
#define NNSH_MACROOP_GR1       0xe1  // GR1
#define NNSH_MACROOP_GR2       0xe2  // GR2
#define NNSH_MACROOP_GR3       0xe3  // GR3
#define NNSH_MACROOP_GR4       0xe4  // GR4
#define NNSH_MACROOP_GR5       0xe5  // GR5
#define NNSH_MACROOP_GR6       0xe6  // GR6
#define NNSH_MACROOP_GR7       0xe7  // GR7
#define NNSH_MACROOP_GR8       0xe8  // GR8
#define NNSH_MACROOP_GR9       0xe9  // GR9
#define NNSH_MACROOP_GRa       0xea  // GRa
#define NNSH_MACROOP_GRb       0xeb  // GRb
#define NNSH_MACROOP_GRc       0xec  // GRc
#define NNSH_MACROOP_GRd       0xed  // GRd
#define NNSH_MACROOP_GRe       0xee  // GRe
#define NNSH_MACROOP_GRf       0xef  // GRf
#define NNSH_MACROOP_GR_MAX    0xef  // WX^ől
#define NNSH_MACROOP_BUF0      0xf0  // eLXgobt@

#endif  // #ifdef USE_MACRO

#define  ICMP_ECHOREPLY       0
#define  ICMP_DEST_UNREACH    3
#define  ICMP_SOURCE_QUENCH   4
#define  ICMP_REDIRECT        5
#define  ICMP_ECHO            8
#define  ICMP_TIME_EXCEEDED  11
#define  ICMP_PARAMETERPROB  12
#define  ICMP_TIMESTAMP      13
#define  ICMP_TIMESTAMPREPLY 14
#define  ICMP_INFO_REQUEST   15
#define  ICMP_INFO_REPLY     16
#define  ICMP_MASKREQ        17
#define  ICMP_MASKREPLY      18
 
#define  ICMP_NET_UNREACH     0
#define  ICMP_HOST_UNREACH    1
#define  ICMP_PROT_UNREACH    2
#define  ICMP_PORT_UNREACH    3
#define  ICMP_FRAG_NEEDED     4
#define  ICMP_SR_FAILED       5
#define  ICMP_NET_UNKNOWN     6
#define  ICMP_HOST_UNKNOWN    7
#define  ICMP_HOST_ISOLATED   8
#define  ICMP_NET_UNR_TOS    11
#define  ICMP_HOST_UNR_TOS   12
#define  ICMP_PKT_FILTERED   13
#define  ICMP_PREC_VIOLATION 14
#define  ICMP_PREC_CUTOFF    15
