#include <stdlib.h>
#include <stdio.h>

#ifdef _WIN32
# include <windows.h>
#else /* _WIN32 */
# include <unistd.h>
#endif /* _WIN32 */

/**/

#include "Common.h"

/**/

WSCindexData gEncodingTab;

/**/

void SleepSec( unsigned sec )
{
#ifdef _WIN32
	Sleep( sec * 1000 );
#else /* _WIN32 */
	sleep( sec );
#endif /* _WIN32 */
}

/**/

bool CompareString( WSCstring s1, WSCstring s2 )
{
	for( long i = 0; ; i++ ){
		if( s1[i] != s2[i] )
			return false;

		if( s1[i] == '\0' )
			break;
	}

	return true;
}

/**/

WSCstring ConvHomeFileName( WSCstring fileName )
{
#ifdef _WIN32
	WSCstring slash = "\\";
	WSCstring tmp( ::WSGIappEnvironment()->getEnv( "HOME" ), WS_EN_SJIS );
#else //_WIN32
	WSCstring slash = "/";
	WSCstring tmp( ::WSGIappEnvironment()->getEnv( "HOME" ), WS_EN_EUCJP );
#endif //_WIN32

	WSCstring dirName( "", WS_EN_DEFAULT );
	dirName.setString( tmp.getString( WS_EN_DEFAULT ), WS_EN_DEFAULT );

	dirName << slash;
	dirName.replaceString( slash + slash, slash, 0 );

	return( dirName + fileName );
}

/**/

void InitEncoding( void )
{
	gEncodingTab["ISO8859_15"] = (void *)WS_EN_ISO8859_15;
	gEncodingTab["UTF8"] = (void *)WS_EN_UTF8;
	gEncodingTab["KOI8R"] = (void *)WS_EN_KOI8R;
	gEncodingTab["EUCJP"] = (void *)WS_EN_EUCJP;
	gEncodingTab["SJIS"] = (void *)WS_EN_SJIS;
	gEncodingTab["EUCKR"] = (void *)WS_EN_EUCKR;
	gEncodingTab["EUCCN"] = (void *)WS_EN_EUCCN;
	gEncodingTab["BIG5"] = (void *)WS_EN_BIG5;
}

/**/

WSCstring GetEncodingList( void )
{
	if( gEncodingTab.getNum() <= 0 )
		InitEncoding();

	WSCstring list;
	long max = gEncodingTab.getNum();
	for( long i = 0; i < max; i++ ){
		WSCstring idx = gEncodingTab.getIndex( i );
		list << idx;
		if( (i + 1) < max )
			list << ",";
	}

	return list;
}

/**/

long ConvStrToEncoding( WSCstring str )
{
	if( gEncodingTab.getNum() <= 0 )
		InitEncoding();

	long en = (long)(gEncodingTab[str]);

	return en;
}

/**/

WSCstring ConvEncodingToStr( long en )
{
	if( gEncodingTab.getNum() <= 0 )
		InitEncoding();

	long max = gEncodingTab.getNum();
	for( long i = 0; i < max; i++ ){
		long data = (long)gEncodingTab.getData( i );
		if( data == en ){
			return( gEncodingTab.getIndex( i ) );
		}
	}

	return( gEncodingTab.getIndex( 0 ) );
}

/**/

