/*
 * Copyright 2013-2018 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.misc;

import java.util.HashMap;
import java.util.Map;

public class Trie {

	public static class Node {
		//
		private Map<Integer, Node> nodes = new HashMap<Integer, Node>();

		public Node get(int ch) {
			return nodes.get(ch);
		}

		public boolean containsEdge(int ch) {
			return nodes.containsKey(ch);
		}

		public Iterable<Integer> getEdges() {
			return nodes.keySet();
		}

		public int countEdges() {
			return nodes.size();
		}
	}

	//
	private Node root = new Node();

	public Node getRoot() {
		return root;
	}

	public void add(String string) {
		Node node = root;
		for(int i = 0; i < string.length(); i++) {
			int ch = string.charAt(i);
			if(node.containsEdge(ch)) {
				node = node.get(ch);
			} else {
				Node nodeNew = new Node();
				node.nodes.put(ch, nodeNew);
				node = nodeNew;
			}
		}
	}
}
