/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.nano;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2009
 */
public abstract class LispReal extends LispComplex
implements Comparable<LispReal> {

	/*
	 * (non-Javadoc)
	 * @see net.morilib.lisp.Datum#getReal()
	 */
	public LispReal getReal() {
		return this;
	}

	/*
	 * (non-Javadoc)
	 * @see net.morilib.lisp.Datum#getImagDouble()
	 */
	public double getImagDouble() {
		return 0.0;
	}

	/*
	 * (non-Javadoc)
	 * @see net.morilib.lisp.Datum#getImag()
	 */
	public LispReal getImag() {
		if(isNaN()) {
			return LispDouble.NaN;
		} else if(isExact()) {
			return LispInteger.ZERO;
		} else {
			return LispDouble.ZERO;
		}
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(LispReal o) {
		return isLessThan(o) ? -1 : (isMoreThan(o) ? 1 : 0);
	}

	/**
	 * 
	 * @param x
	 * @return
	 */
	public abstract boolean isLessThan(LispReal x);

	/**
	 * 
	 * @param x
	 * @return
	 */
	public abstract boolean isMoreThan(LispReal x);

	/**
	 * 
	 * @return
	 */
	public abstract int signum();

	/* (non-Javadoc)
	 * @see net.morilib.lisp.LispNumber#toExact()
	 */
	@Override
	public abstract LispExactReal toExact();

	/* (non-Javadoc)
	 * @see net.morilib.lisp.LispNumber#toInexact()
	 */
	@Override
	public abstract LispReal toInexact();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isInfinity();

	/**
	 * 
	 * @return
	 */
	public LispReal abs() {
		return (signum() >= 0) ? this : (LispReal)this.uminus(); 
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.LispComplex#isNaN()
	 */
	public abstract boolean isNaN();

	/* (non-Javadoc)
	 * @see net.morilib.lisp.LispNumber#isOne()
	 */
	public abstract boolean isOne();

	/* (non-Javadoc)
	 * @see net.morilib.lisp.LispNumber#uminus()
	 */
	public abstract LispReal uminus();

	/* (non-Javadoc)
	 * @see net.morilib.lisp.LispComplex#getResult()
	 */
	public abstract String toWrite();

	/* (non-Javadoc)
	 * @see net.morilib.lisp.LispNumber#norm2()
	 */
	@Override
	public LispReal norm() {
		return (signum() < 0) ? uminus() : this;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.LispNumber#conjugate()
	 */
	@Override
	public LispReal conjugate() {
		return this;
	}

	/**
	 * 
	 * @return
	 */
	public abstract LispReal floor();

	/**
	 * 
	 * @return
	 */
	public abstract LispReal ceil();

	/**
	 * 
	 * @param r
	 * @return
	 */
	public abstract LispReal remainder(LispReal r);

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public abstract int hashCode();

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public abstract boolean equals(Object o);

}
