/*
 * Copyright 2013-2014 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.cmd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import net.morilib.nina.NinaConsole;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;

public interface NinaInfo extends NinaConsole {

	/**
	 * 
	 * @return
	 */
	public String getOutputFilename();

	/**
	 * 
	 * @return
	 */
	public String getFilename();

	/**
	 * 
	 * @return
	 */
	public String getOriginalFilename();

	/**
	 * 
	 * @return
	 */
	public String getClassName();

	/**
	 * 
	 * @return
	 */
	public String getBufSize();

	/**
	 * 
	 * @param s
	 * @return
	 */
	public Object getTitleFile(String s);

	/**
	 * 
	 * @return
	 */
	public Object getOutputDir();

	/**
	 * 
	 * @return
	 */
	public NinaConsole getConsole();

	/**
	 * 
	 * @return
	 */
	public Object getInjectFile();

	/**
	 * 
	 * @param path
	 * @param file
	 * @return
	 * @throws IOException
	 */
	public OutputStream getOutputStream(Object path,
			String file) throws IOException;

	/**
	 * 
	 * @param file
	 * @return
	 * @throws IOException
	 */
	public OutputStream getOutputStream(
			Object file) throws IOException;

	/**
	 * 
	 * @param path
	 * @param file
	 * @return
	 * @throws IOException
	 */
	public InputStream getInputStream(Object path,
			String file) throws IOException;

	/**
	 * 
	 * @param file
	 * @return
	 * @throws IOException
	 */
	public InputStream getInputStream(
			Object file) throws IOException;

	/**
	 * 
	 */
	public void postprocess();

	/**
	 * 
	 * @return
	 */
	public ShFile getShOutputDir(ShFileSystem fs);

	/**
	 * 
	 * @return
	 */
	public ShFile getShOutputFile(ShFileSystem fs, String p, String f);

}
