/*
 * Copyright 2013-2014 Yuichiro Moriguchi
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * morilib Nina Version: 0.4.15.533
 *
 * Nina homepage:      http://nina.morilib.net/
 * Plugin update site: http://nina.morilib.net/update-site/
 */

package net.morilib.nina;
import java.util.ArrayList;
import java.util.List;

/**
 */
public  class DoubleQuoteTokenizer   {

	/* @@@-PARSER-CODE-START-@@@ */
	static class TokenException extends RuntimeException {
	}

	static abstract class Engine {
		abstract int step(int c) throws java.io.IOException;
		abstract boolean accepted();
		abstract boolean isDead();
		abstract boolean isEmptyTransition();
		abstract int execaction(int c);
		abstract boolean isend();
		abstract int recover(Exception e);
		abstract int deadState();
		abstract int stateSize();
		abstract int finallyState();
	}
	static final int INVALIDTOKEN = 0x7fff7fff;
	private static final int NINA_BEGIN = -2;
	private static final int NINA_EOF = -1;
	private static final int NINA_ACCEPT = -8;
	private static final int NINA_FAIL = -9;
	private static final int NINA_HALT_ACCEPT = -91;
	private static final int NINA_HALT_REJECT = -72;
	private static final int NINA_YIELD = -85;
	private static final int NINA_STACKLEN = 72;
	static final int NINA_DISCARDSTATE = 0x40000000;
	static final int INITIAL = 0;
	static final int INDENT = 1;

	private int STATE;
	private int[] __sts = new int[NINA_STACKLEN];
	private Engine[] __stk = new Engine[NINA_STACKLEN];
	private Object[][] __stv = new Object[NINA_STACKLEN][];
	private int __slen = 0;
	private int unread = -1;

	Object _;
	java.util.List<Object> _l;
	Object yieldObject;
	Throwable exception;

	StringBuffer $buffer;
	int $int;
	java.math.BigInteger $bigint;
	Number $num;

	java.util.Stack<java.io.Reader> streamStack =
			new java.util.Stack<java.io.Reader>();

	void _initlist() {
		_l = new java.util.ArrayList<Object>();
	}

	void _addlist(Object x) {
		_l.add(x);
	}


	private int _unreadl = -1;

	void INCLUDE(java.io.Reader rd) {
		streamStack.push(rd);
	}

	void INCLUDE(String name) throws java.io.IOException {
		java.io.InputStream ins;

		ins = new java.io.FileInputStream(name);
		INCLUDE(new java.io.InputStreamReader(ins));
	}

	int readComment() throws java.io.IOException {
		return streamStack.peek().read();
	}
	int _read1l() throws java.io.IOException {
		int c;

		while(streamStack.size() > 0) {
			if((c = readComment()) >= 0) {
				return c;
			} else if(streamStack.size() > 1) {
				streamStack.pop().close();
			} else {
				streamStack.pop();
			}
		}
		return NINA_EOF;
	}

	int _read1() throws java.io.IOException {
		int c;

		if(_unreadl != -1) {
			c = _unreadl;
			_unreadl = -1;
		} else if((c = _read1l()) == '\r' && (c = _read1l()) != '\n') {
			_unreadl = c;
			c = '\r';
		}
		return c;
	}

	private int _read() throws java.io.IOException {
		int c;

		while(true) {
			if(unread != -1) {

				c = unread;
				unread = -1;
				__logprint("Read unread: ", c);
			} else if((c = _read1()) != -1) {
				__logprint("Read: ", c);
			} else {
				__logprint("Read end-of-file");
			}
			return c;
		}
	}

	void UNGET(int c) {
		unread = c;
		__logprint("Set unread: ", c);
	}

	void __sleep(int m) {
		try {
			Thread.sleep(m);
		} catch(InterruptedException e) {
			throw new RuntimeException(e);
		}
	}

	private void __logprint(String s, int c) {
	}

	private void __logopen() {
	}

	private void __logprint(String s) {
	}

	private void __logclose() {
	}

	private void __puttrace() {
	}


	private int doubleQuoteTokenizer_step(int  $c)  throws java.io.IOException {
		switch(STATE) {
		case 0:
			if(($c == '\\')) {
				STATE = 1;
				return 1;
			} else if($c >= 0) {
				STATE = 2;
				return 1;
			}
			return 0;
		case 2:
			if(($c == '\\')) {
				STATE = 1;
				return 1;
			} else if(($c == '/')) {
				STATE = 3;
				return 1;
			} else if(($c == '|')) {
				STATE = 4;
				return 1;
			} else if($c >= 0) {
				STATE = 2;
				return 1;
			}
			return 0;
		case 4:
			if($c >= 0) {
				STATE = 2;
				return 1;
			}
			return 0;
		case 3:
			if(($c == '\\')) {
				STATE = 5;
				return 1;
			} else if(($c == '`')) {
				STATE = 6;
				return 1;
			} else if(($c == '!')) {
				STATE = 7;
				return 1;
			} else if($c >= 0) {
				STATE = 8;
				return 1;
			}
			return 0;
		case 8:
			if(($c == '\\')) {
				STATE = 5;
				return 1;
			} else if(($c == '|')) {
				STATE = 4;
				return 1;
			} else if($c >= 0) {
				STATE = 8;
				return 1;
			}
			return 0;
		case 7:
			if($c >= 0) {
				STATE = 8;
				return 1;
			}
			return 0;
		case 6:
			if(($c == '`')) {
				STATE = 9;
				return 1;
			} else if($c >= 0) {
				STATE = 6;
				return 1;
			}
			return 0;
		case 9:
			if($c >= 0) {
				lok.append('`');  regex = null;
				STATE = 6;
				return 1;
			}
			return 0;
		case 5:
			if(($c == '|')) {
				STATE = 8;
				return 1;
			} else if($c >= 0) {
				lok.append('\\');
				STATE = 8;
				return 1;
			}
			return 0;
		case 1:
			if(($c == '/') || ($c == '\\') || ($c == '|')) {
				STATE = 2;
				return 1;
			} else if($c >= 0) {
				buf.append('\\');
				STATE = 2;
				return 1;
			}
			return 0;
		}
		return 0;
	}

	private boolean doubleQuoteTokenizer_accepted() {
		return (STATE == 0 ||
				STATE == 1 ||
				STATE == 2 ||
				STATE == 3 ||
				STATE == 4 ||
				STATE == 5 ||
				STATE == 6 ||
				STATE == 7 ||
				STATE == 8 ||
				STATE == 9);
	}

	int doubleQuoteTokenizer_execaction(int  $c) {
		switch(STATE) {
		case 1:
			break;
		case 9:
			regex = lok.substring(1);
			break;
		case 6:
			lok.appendCodePoint($c);
			break;
		case 3:
			lok = new StringBuffer();
			break;
		case 5:
			break;
		case 4:
			_adds();
			break;
		case 7:
			invl = true;
			break;
		case 0:
			break;
		case 2:
			buf.appendCodePoint($c);
			break;
		case 8:
			lok.appendCodePoint($c);
			break;
		}
		return 1;
	}

	boolean doubleQuoteTokenizer_isend() {
		return false;
	}

	private final Engine ENGINE_doubleQuoteTokenizer = new Engine() {

		int step(int c) throws java.io.IOException {
			return doubleQuoteTokenizer_step(c);
		}

		boolean accepted() {
			return doubleQuoteTokenizer_accepted();
		}

		int execaction(int c) {
			return doubleQuoteTokenizer_execaction(c);
		}

		boolean isend() {
			return doubleQuoteTokenizer_isend();
		}

		int recover(Exception e) {
			return -1;
		}

		int deadState() {
			return -1;
		}

		int stateSize() {
			return 10;
		}

		int finallyState() {
			return -1;
		}

		boolean isDead() {
		return false;
		}

		boolean isEmptyTransition() {
		return false;
		}

		public String toString() {
			return "doubleQuoteTokenizer";
		}

	};

	void __stkpush(int st, Engine en) {
		Object[][] c;
		Engine[] b;
		int[] a;

		if(__slen >= __sts.length) {
			a = new int[__sts.length * 2];
			b = new Engine[__stk.length * 2];
			c = new Object[__stk.length * 2][];
			System.arraycopy(__sts, 0, a, 0, __sts.length);
			System.arraycopy(__stk, 0, b, 0, __stk.length);
			System.arraycopy(__stv, 0, c, 0, __stv.length);
			__sts = a;
			__stk = b;
			__stv = c;
		}
		__sts[__slen] = st;
		__stk[__slen] = en;
		__stv[__slen++] = new Object[en.stateSize()];
	}

	private int _parse(int x, Boolean rt, boolean skip,
			int[] st) throws java.io.IOException {
		boolean b = false, p = skip;
		int c = x;
		Engine en;
		int a;

		b = __stk[__slen - 1].accepted();
		if(rt.booleanValue()) {
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_ACCEPT:
				__logprint("accept " + __stk[__slen - 1]);
				st[0] = NINA_ACCEPT;  return -1;
			case NINA_FAIL:
				__logprint("match failed: begin");
				__puttrace();
				st[0] = NINA_FAIL;  return -1;
			case NINA_HALT_ACCEPT:
				__logprint("machine halted: begin");
				st[0] = NINA_HALT_ACCEPT;  return -1;
			case NINA_HALT_REJECT:
				__logprint("machine halted: begin");
				st[0] = NINA_HALT_REJECT;  return -1;
			case NINA_YIELD:
				__logprint("machine yielded: ", c);
				st[0] = NINA_YIELD;  return -1;
			}
		}

		try {
			do {
				en = __stk[__slen - 1];
				if(p) {
					p = false;
				} else if((a = en.step(c)) > 0) {
					__logprint("transit to state " + STATE + ": ", c);
					b = en.accepted();
					switch(en.execaction(c)) {
					case NINA_ACCEPT:
						__logprint("accept " + __stk[__slen - 1]);
						UNGET(c);
						st[0] = NINA_ACCEPT;  return -1;
					case NINA_FAIL:
						__logprint("match failed: ", c);
						__puttrace();
						UNGET(c);
						st[0] = NINA_FAIL;  return -1;
					case NINA_HALT_ACCEPT:
						__logprint("machine halted: ", c);
						st[0] = NINA_HALT_ACCEPT;  return -1;
					case NINA_HALT_REJECT:
						__logprint("machine halted: ", c);
						st[0] = NINA_HALT_REJECT;  return -1;
					case NINA_YIELD:
						__logprint("machine yielded: ", c);
						st[0] = NINA_YIELD;  return -1;
					}
				} else if(a < 0) {
					__logprint("entering " + __stk[__slen - 1]);
					return c;
				} else if(b) {
					__logprint("accept " + __stk[__slen - 1]);
					UNGET(c);
					st[0] = NINA_ACCEPT;  return -1;
				} else if(c == -1) {
					if(!b)  throw new TokenException();
					st[0] = NINA_ACCEPT;
					return -1;
				} else {
					__logprint("match failed: ", c);
					__puttrace();
					UNGET(c);
					st[0] = NINA_FAIL;  return -1;
				}

				if(__stk[__slen - 1].isEmptyTransition()) {
					// do nothing
				} else if(!__stk[__slen - 1].isDead()) {
					c = _read();
				} else if(b) {
					__logprint("accept " + __stk[__slen - 1]);
					st[0] = NINA_ACCEPT;  return -1;
				} else {
					__logprint("match failed: ", c);
					__puttrace();
					st[0] = NINA_FAIL;  return -1;
				}
			} while(true);
		} catch(RuntimeException e) {
			UNGET(c);
			throw e;
		}
	}

	private Boolean execfinally() {
		int a, b;

		if((a = __stk[__slen - 1].finallyState()) >= 0) {
			b = STATE;  STATE = a;
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_HALT_ACCEPT:
				__slen = 0;
				return Boolean.TRUE;
			case NINA_HALT_REJECT:
				__slen = 0;
				return Boolean.FALSE;
			}
			STATE = b;
		}
		return null;
	}

	private int getdeadstate() {
		return __stk[__slen - 1].deadState();
	}

	private int getrecover(Exception e) {
		return __stk[__slen - 1].recover(e);
	}

	boolean parse(Engine entry) throws java.io.IOException {
		Boolean b = Boolean.FALSE;
		int[] a = new int[1];
		boolean skip = true;
		int c = 0;

		__logopen();
		try {
			if(__slen == 0) {
				b = Boolean.TRUE;
				__stkpush(0, entry);
			}

			ot: while(true) {
				try {
					if((c = _parse(c, b, skip, a)) != -1) {
						skip = false;
					} else if(a[0] == NINA_FAIL) {
						while((STATE = getdeadstate()) < 0) {
							if((b = execfinally()) != null)  break ot;
							if(__slen-- <= 1) {
								throw new TokenException();
							}
						}
						skip = true;
					} else if(a[0] == NINA_HALT_ACCEPT) {
						if((b = execfinally()) != null)  break;
						__slen = 0;
						b = Boolean.TRUE;  break;
					} else if(a[0] == NINA_HALT_REJECT) {
						if((b = execfinally()) != null)  break;
						__slen = 0;
						b = Boolean.FALSE;  break;
					} else if(a[0] == NINA_YIELD) {
						return false;
					} else if(__slen > 1) {
						if((b = execfinally()) != null)  break;
						STATE = __sts[--__slen];
						skip = true;
					} else {
						if((b = execfinally()) != null)  break;
						b = new Boolean(__stk[--__slen].accepted());
						break;
					}
				} catch(RuntimeException e) {
					exception = e;
					if(__slen <= 0)  throw e;
					while((STATE = getrecover(e)) < 0) {
						if((b = execfinally()) != null)  return b;
						if(__slen-- <= 1)  throw e;
					}
				}
				b = Boolean.TRUE;
			}
			if(!b.booleanValue())  throw new TokenException();
			return b.booleanValue();
		} finally {
			__logclose();
		}
	}

	boolean parse(java.io.Reader rd) throws java.io.IOException {
		streamStack.push(rd);
		return parse(ENGINE_doubleQuoteTokenizer);
	}

	static boolean parseAll(java.io.Reader rd) throws java.io.IOException {
		DoubleQuoteTokenizer o = new DoubleQuoteTokenizer();

		return o.parse(rd);
	}

	void setStream(java.io.Reader rd) {
		if(streamStack.size() == 0) {
			throw new IllegalStateException();
		}
		yieldObject = rd;
		streamStack.push(rd);
	}

	Object parseNext() throws java.io.IOException {
		Object o;

		if(streamStack.size() == 0) {
			throw new IllegalStateException();
		} else if(yieldObject == null) {
			return null;
		} else if(parse(ENGINE_doubleQuoteTokenizer)) {
			if(yieldObject == null)  throw new NullPointerException();
			o = yieldObject;  yieldObject = null;
			return o;
		} else {
			if(yieldObject == null)  throw new NullPointerException();
			return yieldObject;
		}
	}

	static void puts(String s) {
		System.out.println(s);
	}

	boolean parse(java.io.InputStream rd) throws java.io.IOException {
		return parse(new java.io.InputStreamReader(rd));
	}

	static boolean parseAll(
			java.io.InputStream rd) throws java.io.IOException {
		return parseAll(new java.io.InputStreamReader(rd));
	}

	/* @@@-PARSER-CODE-END-@@@ */
public static class Elems {

	private String string, lookahead, regex;
	private boolean invertLookahead;

	private Elems(String s, String l, String r, boolean j) {
		string = s;
		lookahead = l;
		regex = r;
		invertLookahead = j;
	}

	public String getString() {
		return string;
	}

	public String getLookahead() {
		return lookahead;
	}

	public String getRegex() {
		return regex;
	}

	public boolean isInvertLookahead() {
		return invertLookahead;
	}

}

private boolean invl = false;
private StringBuffer buf = new StringBuffer();
private StringBuffer lok = null;
private List<Elems> list = new ArrayList<Elems>();
private String regex;

private void _adds() {
	if(invl && lok.length() == 0) {
		invl = false;
		lok.append('!');
	}

	if(buf.length() > 0) {
		list.add(new Elems(buf.toString(),
				(lok != null && regex == null) ? lok.toString() : null,
				regex, invl));
		buf = new StringBuffer();
		lok = null;
		invl = false;
	}
}

public static List<Elems> parse(String s) {
	DoubleQuoteTokenizer a = new DoubleQuoteTokenizer();

	try {
		a.parse(new java.io.StringReader(s));
		a._adds();
		return a.list;
	} catch(java.io.IOException e) {
		throw new RuntimeException(e);
	}
}

}
