/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.unix.regex;

import java.util.List;
import net.morilib.unix.misc.WideString;
import net.morilib.unix.misc.WideStringBuilder;
import net.morilib.unix.regex.BasicPattern;

public class BasicMatcher {
    private WideString str;
    private BasicPattern pt;
    private WideStringBuilder[] captured;

    BasicMatcher(BasicPattern pt, WideString str) {
        this.pt = pt;
        this.str = str;
    }

    private void initcap() {
        this.captured = new WideStringBuilder[10];
    }

    private void putcap(List<Integer> cap, int c) {
        for (Integer i : cap) {
            if (this.captured[i] == null) {
                this.captured[i.intValue()] = new WideStringBuilder();
            }
            this.captured[i].append(c);
        }
    }

    private boolean delcap(List<Integer> cap) {
        for (Integer i : cap) {
            if (this.captured[i] == null) continue;
            if (this.captured[i].length() <= 0) {
                return false;
            }
            this.captured[i].deleteCharAt(this.captured[i].length() - 1);
        }
        return true;
    }

    private boolean capend(BasicPattern.Elm e, int k) {
        return e.captured > 0 && k >= this.captured[e.captured].length();
    }

    private boolean isaccepted(int j) {
        int bb = 0;
        int i = j;
        while (i < this.pt.elements.size()) {
            BasicPattern.Elm e = this.pt.elements.get(i);
            if (e.chars != null) {
                if (e.repeatFrom != 0) {
                    return false;
                }
                for (Integer k : e.capture) {
                    bb |= 1 << k;
                }
            } else if ((bb & 1 << e.captured) == 0) {
                return this.captured[e.captured] != null && this.captured[e.captured].length() == 0;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    int matches(WideString s, int n, int t) {
        i = n;
        j = t;
        k = 0;
        m = -1;
        x = -1;
        f = this.pt.flags;
        e = null;
        while ((l = ++i) < s.length()) {
            block9: {
                c = s.charAt(i);
                do {
                    if (j < this.pt.elements.size()) continue;
                    return i;
                } while (this.capend(e = this.pt.elements.get(j), k) && ++j > 0);
                if (e.capture != null && e.capture.size() > 0) {
                    m = Math.max(m, e.capture.get(e.capture.size() - 1));
                }
                if (e.repeatFrom < 0) break block9;
                x = i;
                while (i < s.length() && e.isok(i - x)) {
                    c = s.charAt(i);
                    if (!e.chars.contains(c, f)) break;
                    this.putcap(e.capture, c);
                    ++i;
                }
                if (i - x >= e.repeatFrom) ** GOTO lbl34
                return -1;
lbl-1000:
                // 1 sources

                {
                    y = m + 1;
                    while (y < 10) {
                        this.captured[y] = null;
                        ++y;
                    }
                    if (!this.delcap(e.capture)) {
                        return -1;
                    }
                    --i;
lbl34:
                    // 2 sources

                    ** while (i >= l && (x = this.matches((WideString)s, (int)i, (int)(j + 1))) < 0)
                }
lbl35:
                // 1 sources

                return i < l ? -1 : x;
            }
            if (e.chars != null) {
                if (!e.chars.contains(c, f)) break;
                this.putcap(e.capture, c);
                ++j;
                continue;
            }
            if (this.captured[e.captured].charAt(k) != c) {
                return -1;
            }
            ++i;
            if ((k += c > 65535 ? 2 : 1) < this.captured[e.captured].length()) continue;
            ++j;
            k = 0;
        }
        return this.isaccepted(j) != false ? i : -1;
    }

    public boolean matches() {
        this.initcap();
        if ((this.pt.flags & 2) != 0 || this.pt.isAnchorBoth()) {
            return this.matchesAll();
        }
        if (this.pt.isAnchorBegin()) {
            return this.matches(this.str, 0, 0) >= 0;
        }
        int i = 0;
        while (i <= this.str.length()) {
            int z = this.matches(this.str, i, 0);
            if (this.pt.isAnchorEnd() && z >= this.str.length() || this.pt.isNoAnchors() && z >= 0) {
                return true;
            }
            this.initcap();
            ++i;
        }
        return false;
    }

    public boolean matchesAll() {
        this.initcap();
        return this.matches(this.str, 0, 0) >= this.str.length();
    }

    private boolean iswordend(int z) {
        return z >= this.str.length() || z >= 0 && Character.isWhitespace(this.str.charAt(z));
    }

    public boolean matchesWholeWord() {
        if ((this.pt.flags & 2) != 0 || this.pt.isAnchorBoth()) {
            return this.matchesAll();
        }
        if (this.pt.isAnchorBegin()) {
            return this.matches(this.str, 0, 0) >= 0;
        }
        int i = 0;
        while (i <= this.str.length()) {
            if (i <= 0 || Character.isWhitespace(this.str.charAt(i - 1))) {
                this.initcap();
                int z = this.matches(this.str, i, 0);
                if (this.pt.isAnchorEnd() && z >= this.str.length() || this.pt.isNoAnchors() && this.iswordend(z)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private WideString rep2(String r) {
        WideStringBuilder b = new WideStringBuilder();
        int INI = 10;
        int ESC = 20;
        int stat = 10;
        int i = 0;
        while (i < r.length()) {
            int c = r.codePointAt(i);
            switch (stat) {
                case 10: {
                    if (c == 92) {
                        stat = 20;
                        break;
                    }
                    b.append(c);
                    break;
                }
                case 20: {
                    if (c < 49 || c > 57) {
                        b.append(c);
                    } else {
                        int p = c - 48;
                        if (this.captured[p] != null) {
                            b.append(this.captured[p]);
                        }
                    }
                    stat = 10;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            i += c > 65535 ? 2 : 1;
        }
        return b.toWideString();
    }

    public String replace(String replacement, int occurence) {
        WideStringBuilder s = new WideStringBuilder();
        int o = 1;
        int q = -1;
        int i = 0;
        while (i <= this.str.length()) {
            this.initcap();
            int p = this.matches(this.str, i, 0);
            if (p < 0) {
                if (i < this.str.length()) {
                    s.append(this.str.charAt(i));
                }
                ++i;
                continue;
            }
            if (p > i || q != i) {
                WideString r = this.rep2(replacement);
                if (occurence <= 0 || occurence == o++) {
                    s.append(r);
                    if (occurence > 0) {
                        if (p >= this.str.length()) break;
                        s.append(this.str.substring(p));
                        break;
                    }
                } else {
                    s.append(this.str.substring(i, p));
                }
                q = i = p;
                continue;
            }
            if (i < this.str.length()) {
                s.append(this.str.charAt(i));
            }
            ++i;
        }
        return s.toString();
    }

    public String replaceAll(String replacement) {
        return this.replace(replacement, -1);
    }

    public String replaceFirst(String replacement) {
        return this.replace(replacement, 1);
    }
}

