/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShTree;
import net.morilib.sh.ShTreeExpressionMachine;
import net.morilib.sh.misc.XtraceStream;

public class ShTreeIf
implements ShTree {
    private List<ShTree> conditions;
    private List<ShTree> block;
    private ShTree elseblock;

    public ShTreeIf(List<ShTree> conditions, List<ShTree> block, ShTree elseblock) {
        this.conditions = new ArrayList<ShTree>(conditions);
        this.block = new ArrayList<ShTree>(block);
        this.elseblock = elseblock;
    }

    @Override
    public int eval(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run, InputStream in, PrintStream out, PrintStream err, XtraceStream p) throws IOException, ShSyntaxException {
        int i = 0;
        while (i < this.conditions.size()) {
            int a = this.conditions.get(i).eval(env, fs, cmds, run, in, out, err, p);
            if (a == 0) {
                return this.block.get(i).eval(env, fs, cmds, run, in, out, err, p);
            }
            ++i;
        }
        if (this.elseblock != null) {
            return this.elseblock.eval(env, fs, cmds, run, in, out, err, p);
        }
        return 0;
    }

    @Override
    public void compileInternally(ShTreeExpressionMachine.Builder b, Object brk, Object cnt) {
        Object l1 = null;
        Object l2 = new Object();
        int i = 0;
        while (i < this.conditions.size()) {
            if (i > 0) {
                b.addLabel(l1);
            }
            this.conditions.get(i).compileInternally(b, brk, cnt);
            l1 = new Object();
            b.addJmpZ(l1);
            this.block.get(i).compileInternally(b, brk, cnt);
            b.addJmp(l2);
            ++i;
        }
        if (this.elseblock != null) {
            b.addJmp(l2);
            b.addLabel(l1);
            this.elseblock.compileInternally(b, brk, cnt);
            b.addLabel(l2);
        } else {
            b.addLabel(l1);
            b.addLabel(l2);
        }
        b.addRes();
    }

    public String toString() {
        StringBuffer b = new StringBuffer("if ");
        String d = "";
        int i = 0;
        while (i < this.block.size()) {
            b.append(d).append(this.conditions.get(i));
            b.append("\nthen\n").append(this.block.get(i)).append('\n');
            d = "elif ";
            ++i;
        }
        if (this.elseblock != null) {
            b.append("else\n").append(this.elseblock).append('\n');
        }
        return b.append("fi").toString();
    }
}

