/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.regec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import net.morilib.nina.cmd.NinaInfo;
import net.morilib.nina.misc.SimpleTemplateParser;
import net.morilib.nina.regec.RegexCompilerException;
import net.morilib.nina.translate.AbstractNinaTranslator;

public class NinaRegexCompiler {
    private static InputStream getTemplate(String lang) {
        String s = "regex" + lang + ".nina.stemplate";
        InputStream ins = NinaRegexCompiler.class.getResourceAsStream(s);
        return ins;
    }

    public static byte[] createNinaSource(String name, String regex, String lang, String pkg) throws IOException {
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        InputStream ins = NinaRegexCompiler.getTemplate(lang);
        if (ins == null) {
            return null;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("lang", lang);
        m.put("regex", regex.replaceAll("/", "\\\\/"));
        m.put("classname", name);
        m.put("pkg", pkg);
        SimpleTemplateParser.apply(ins, ous, m);
        return ous.toByteArray();
    }

    public static void createTargetSource(String name, String regex, String lang, String pkg, NinaInfo info, PrintStream pr) throws IOException {
        Reader rd = null;
        try {
            byte[] a = NinaRegexCompiler.createNinaSource(name, regex, lang, pkg);
            if (a == null) {
                throw new RegexCompilerException("unsupported language");
            }
            rd = new InputStreamReader(new ByteArrayInputStream(a));
            AbstractNinaTranslator t = AbstractNinaTranslator.getTranslator(lang);
            t.translate(String.valueOf(name) + ".nina", rd, info, new ArrayList<String>(), new HashMap<String, String>(), pr);
        }
        finally {
            if (rd != null) {
                rd.close();
            }
            pr.flush();
        }
    }
}

