/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.automata.DFA;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaConsole;
import net.morilib.nina.NinaDFAPattern;
import net.morilib.nina.NinaException;
import net.morilib.nina.NinaNFA;
import net.morilib.nina.NinaNFAPattern;
import net.morilib.nina.NinaParser;
import net.morilib.nina.NinaPattern;
import net.morilib.nina.NinaSubautomata;
import net.morilib.nina.Quadro;
import net.morilib.util.CharCodes;

public final class Nina {
    public static final String VERSION = "0.5.0";
    public static final String REVISION = "$Rev: 673 $";
    private static final Pattern FANM = Pattern.compile("(.*/)?([^/.]+)(\\..*)?");
    private static final Pattern CDLM = Pattern.compile("-+");
    private static final Pattern REVS = Pattern.compile("[0-9]+");
    private static final Pattern PTN1 = Pattern.compile("#header[ \t]+(.*)[ \t]+(.*)([ \t]+(.*))?");

    private Nina() {
    }

    public static String getRevision() {
        Matcher m = REVS.matcher(REVISION);
        if (m.find()) {
            return m.group();
        }
        return "0";
    }

    static Object prendClasse(String s) {
        return Nina.prendClasse("", s);
    }

    static Object prendClasse(String d, String n) {
        String s = n;
        try {
            if (s.indexOf(46) < 0) {
                s = String.valueOf(d) + "." + n;
            }
            Class<?> c = Class.forName(s);
            return c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (InstantiationException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
    }

    static void apelle(Object o, String s, Object ... os) {
        Class[] a = new Class[os.length];
        Class<?> c = o.getClass();
        try {
            int i = 0;
            while (i < os.length) {
                a[i] = os[i].getClass();
                ++i;
            }
            Method m = c.getMethod(s, a);
            m.invoke(o, os);
        }
        catch (SecurityException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
    }

    static void apelleInt(Object o, String s, int n) {
        Class<?> c = o.getClass();
        try {
            Method m = c.getMethod(s, Integer.TYPE);
            m.invoke(o, n);
        }
        catch (SecurityException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new NinaException(e, "reflecterror", new Object[0]);
        }
    }

    static int prendCharcode(String charset, int c) {
        try {
            int x = CharCodes.unicodeToOtherCode((char)c, charset);
            return x;
        }
        catch (UnsupportedEncodingException e) {
            throw new NinaException(e, "unsupportedcharset", charset);
        }
    }

    static String getAutomatonName(String s) {
        if (s.equalsIgnoreCase("full")) {
            return "DFABuilder";
        }
        if (s.equalsIgnoreCase("NFA")) {
            return "NFABuilder";
        }
        if (s.equalsIgnoreCase("Markov")) {
            return "MarkovBuilder";
        }
        if (s.endsWith("Builder")) {
            return s;
        }
        throw new NinaException("subautomatonnotfound", s);
    }

    static int len(char c, boolean notfull) {
        Character.UnicodeBlock b = Character.UnicodeBlock.of(c);
        if (notfull) {
            return 1;
        }
        if (b == null) {
            return 1;
        }
        if (c >= '\uff01' && c <= '\uff60') {
            return 2;
        }
        if (c >= '\uffe0' && c <= '\uffe6') {
            return 2;
        }
        if (b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT) || b.equals(Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT) || b.equals(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B) || b.equals(Character.UnicodeBlock.KATAKANA) || b.equals(Character.UnicodeBlock.HIRAGANA) || b.equals(Character.UnicodeBlock.HANGUL_SYLLABLES)) {
            return 2;
        }
        return 1;
    }

    static int len(String s, boolean notfull) {
        int r = 0;
        int i = 0;
        while (i < s.length()) {
            r += Nina.len(s.charAt(i), notfull);
            ++i;
        }
        return r;
    }

    static int[] toiarray(String s, boolean notfull) {
        int[] a = new int[Nina.len(s, notfull)];
        int i = 0;
        int j = 0;
        while (j < s.length()) {
            int m = Nina.len(s.charAt(j), notfull);
            a[i] = s.charAt(j);
            int k = i + 1;
            while (k < i + m) {
                a[k] = -1;
                ++k;
            }
            i += m;
            ++j;
        }
        return a;
    }

    static InputStream findLib(String n, List<String> libs) {
        File f = new File(n);
        if (f.isFile()) {
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        for (String s : libs) {
            f = new File(new File(s), n);
            if (!f.isFile()) continue;
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static String[] readHeader(String fn, List<String> l) throws IOException {
        String[] a = new String[3];
        try (BufferedReader r = null;){
            Matcher m;
            InputStream i = Nina.findLib(fn, l);
            if (i == null) {
                throw new NinaException("filenotfound", fn);
            }
            r = new BufferedReader(new InputStreamReader(i));
            String s = r.readLine();
            if (s != null && (m = PTN1.matcher(s)).matches()) {
                a[0] = m.group(1);
                a[1] = m.group(2);
                a[2] = m.group(4);
            }
            String[] stringArray = a;
            return stringArray;
        }
    }

    static List<int[]> readImport(String fn, List<String> lb, String enc, boolean notfull) throws IOException {
        boolean b = false;
        try (BufferedReader r = null;){
            String s;
            InputStreamReader d;
            if (enc != null) {
                try {
                    d = new InputStreamReader(Nina.findLib(fn, lb), enc);
                }
                catch (UnsupportedEncodingException e) {
                    d = new InputStreamReader(Nina.findLib(fn, lb));
                }
            } else {
                d = new InputStreamReader(Nina.findLib(fn, lb));
            }
            r = new BufferedReader(d);
            ArrayList<int[]> l = new ArrayList<int[]>();
            while ((s = r.readLine()) != null) {
                if (b) {
                    b = !CDLM.matcher(s).matches();
                    continue;
                }
                b = CDLM.matcher(s).matches();
                if (b) continue;
                l.add(Nina.toiarray(s, notfull));
            }
            ArrayList<int[]> arrayList = l;
            return arrayList;
        }
    }

    public static String getFAName(NinaSubautomata b, String s) {
        if (b != null && "main".equals(s)) {
            return b.getMainname();
        }
        Matcher m = FANM.matcher(s);
        if (!m.matches()) {
            throw new RuntimeException();
        }
        return m.group(2);
    }

    public static NinaAction compile(String name, String s, Map<String, String> prms, NinaSubautomata sub, List<String> l, NinaConsole cons) {
        return NinaParser.compile(Quadro.read(name, s, l), null, null, prms, sub, cons, cons, 0);
    }

    public static NinaAction compile(String name, Reader rd, List<String> libs, Map<String, String> prms, NinaSubautomata sub, NinaConsole cons) throws IOException {
        return NinaParser.compile(Quadro.read(name, rd, libs), null, libs, prms, sub, cons, cons, 0);
    }

    public static NinaAction compile(String name, Reader rd, Map<String, String> prms, NinaSubautomata sub, List<String> l, NinaConsole cons) throws IOException {
        return NinaParser.compile(Quadro.read(name, rd, l), null, null, prms, sub, cons, cons, 0);
    }

    public static NinaAction compileResource(String name, Map<String, String> prms, NinaSubautomata sub, List<String> l, NinaConsole cons) throws IOException {
        return NinaParser.compile(Quadro.readResource(name, l), null, null, prms, sub, cons, cons, 0);
    }

    public static NinaAction trace(String name, String s, Map<String, String> prms, NinaSubautomata sub, List<String> l, NinaConsole cons, boolean pause) {
        return NinaParser.compile(Quadro.read(name, s, l), null, null, prms, sub, cons, cons, 2 | (pause ? 1 : 0));
    }

    public static NinaAction trace(String name, Reader rd, Map<String, String> prms, NinaSubautomata sub, List<String> l, NinaConsole cons, boolean pause) throws IOException {
        return NinaParser.compile(Quadro.read(name, rd, l), null, null, prms, sub, cons, cons, 2 | (pause ? 1 : 0));
    }

    public static NinaAction traceResource(String name, Map<String, String> prms, NinaSubautomata sub, List<String> l, NinaConsole cons, boolean pause) throws IOException {
        return NinaParser.compile(Quadro.readResource(name, l), null, null, prms, sub, cons, cons, 2 | (pause ? 1 : 0));
    }

    private static NinaPattern cst(Object o) {
        if (o instanceof NinaNFA) {
            return new NinaNFAPattern((NinaNFA)o);
        }
        if (o instanceof DFA) {
            return new NinaDFAPattern((DFA)o);
        }
        throw new ClassCastException();
    }

    public static NinaPattern pattern(String name, String s, Map<String, String> prms, NinaSubautomata sub, List<String> l, NinaConsole cons) {
        return Nina.cst(Nina.compile(name, s, prms, sub, l, cons).getMachine());
    }

    public static NinaPattern pattern(String name, String s, Map<String, String> prms, NinaSubautomata sub, NinaConsole cons) {
        return Nina.cst(Nina.compile(name, s, prms, sub, Collections.emptyList(), cons).getMachine());
    }

    public static NinaPattern pattern(String name, Reader rd, Map<String, String> prms, NinaSubautomata sub, List<String> l, NinaConsole cons) throws IOException {
        return Nina.cst(Nina.compile(name, rd, prms, sub, l, cons));
    }

    public static NinaPattern pattern(String name, Reader rd, Map<String, String> prms, NinaSubautomata sub, NinaConsole cons) throws IOException {
        return Nina.cst(Nina.compile(name, rd, prms, sub, Collections.emptyList(), cons));
    }

    public static NinaPattern patternResource(String name, Map<String, String> prms, NinaSubautomata sub, List<String> l, NinaConsole cons) throws IOException {
        return Nina.cst(Nina.compileResource(name, prms, sub, l, cons).getMachine());
    }

    public static NinaPattern patternTrace(String name, String s, Map<String, String> prms, NinaSubautomata sub, List<String> l, NinaConsole cons, boolean z) {
        return Nina.cst(Nina.trace(name, s, prms, sub, l, cons, z));
    }

    public static NinaPattern patternTrace(String name, Reader rd, Map<String, String> prms, NinaSubautomata sub, List<String> l, NinaConsole cons, boolean z) throws IOException {
        return Nina.cst(Nina.trace(name, rd, prms, sub, l, cons, z));
    }

    public static NinaPattern patternResourceTrace(String name, Map<String, String> prms, NinaSubautomata sub, List<String> l, NinaConsole cons, boolean z) throws IOException {
        return Nina.cst(Nina.traceResource(name, prms, sub, l, cons, z));
    }
}

