/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.AlphabetsNotDiscreteException;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAEdges;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.dfa.DFAs;
import net.morilib.nina.DFABuilder;
import net.morilib.range.Interval;
import net.morilib.range.Range;
import net.morilib.util.Tuple2;

class BuildMachine
implements DFA<Object, Object, Void>,
NFA<Object, Object, Void> {
    String name;
    private DFAState<Object, Object, Void> initial;
    private transient Set<Object> allStates;

    BuildMachine(String name, DFAState<Object, Object, Void> init) {
        this.name = name;
        this.initial = init;
        this.allStates = new HashSet<DFAState<Object, Object, Void>>(DFAs.allStateRanges(init));
    }

    @Override
    public boolean isState(NFAState o) {
        return this.allStates.contains(o);
    }

    @Override
    public Set<NFAState> getStates(NFAState s, Object a) {
        if (!this.isState(s)) {
            return Collections.emptySet();
        }
        DFAState<Object, Object, Void> d = ((DFABuilder.DBS)s).go(a);
        if (d.isDead()) {
            return Collections.emptySet();
        }
        return Collections.singleton(d);
    }

    @Override
    public Set<NFAState> getStates(NFAState s, Range r) {
        if (!this.isState(s)) {
            return Collections.emptySet();
        }
        DFABuilder.DBS d = (DFABuilder.DBS)s;
        HashSet<NFAState> x = new HashSet<NFAState>();
        for (Tuple2<Interval, DFABuilder.DBS> t : d.edges.entries()) {
            for (Interval v : r.intervals()) {
                if (!t.getA().equals(v)) continue;
                x.add(t.getB());
            }
        }
        return x;
    }

    @Override
    public Set<NFAState> getStates(NFAState s, EnumSet<TextBound> b) {
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getStatesEpsilon(NFAState s) {
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getStatesBound(NFAState s, EnumSet<TextBound> b) {
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getInitialStates() {
        return Collections.singleton(this.initial);
    }

    @Override
    public boolean isInitialState(NFAState o) {
        return this.initial.equals(o);
    }

    @Override
    public boolean isFinal(NFAState s) {
        return this.isState(s) && ((DFABuilder.DBS)s).isAccepted();
    }

    @Override
    public boolean isFinalAny(Set<NFAState> ss) {
        for (NFAState s : ss) {
            if (!this.isFinal(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NFAEdges<Object> getEdges(NFAState s) {
        return this.isState(s) ? (DFABuilder.DBS)s : null;
    }

    @Override
    public Set<Interval> nextAlphabets(NFAState s) {
        HashSet<Interval> x = new HashSet<Interval>();
        if (this.isState(s)) {
            DFABuilder.DBS d = (DFABuilder.DBS)s;
            for (Tuple2<Interval, DFABuilder.DBS> t : d.edges.entries()) {
                x.add(t.getA());
            }
            return x;
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<Interval> nextAlphabets(Set<NFAState> ss) {
        HashSet<Interval> x = new HashSet<Interval>();
        for (NFAState s : ss) {
            x.addAll(this.nextAlphabets(s));
        }
        return x;
    }

    @Override
    public Set<Object> nextDiscreteAlphabets(NFAState s) {
        throw new AlphabetsNotDiscreteException();
    }

    @Override
    public Iterable<Object> nextDiscreteAlphabets(Set<NFAState> s) {
        throw new AlphabetsNotDiscreteException();
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        HashSet<NFAState> x = new HashSet<NFAState>();
        for (Object s : this.allStates) {
            if (!((DFABuilder.DBS)s).isAccepted()) continue;
            x.add((DFABuilder.DBS)s);
        }
        return x;
    }

    @Override
    public Set<Void> getMatchTag(NFAState s) {
        return Collections.emptySet();
    }

    @Override
    public Set<Void> getMatchTagEnd(NFAState s) {
        return Collections.emptySet();
    }

    @Override
    public Set<Object> getAccept(NFAState s) {
        if (this.isAccepted(s)) {
            return Collections.singleton(s);
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isAccepted(NFAState s) {
        return this.isState(s) && ((DFABuilder.DBS)s).isAccepted();
    }

    @Override
    public DFAState<Object, Object, Void> getInitialState() {
        return this.initial;
    }
}

