/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.io.Serializable;
import java.util.List;
import net.morilib.lisp.nano.Atom;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispUtils;
import net.morilib.lisp.nano.Subr;
import net.morilib.lisp.nano.Undef;
import net.morilib.lisp.nano.subr.SubrUtils;
import net.morilib.lisp.nano.subr.TernaryArgs;

public final class LispString
extends Atom
implements Serializable {
    private static final long serialVersionUID = -2492989855710883745L;
    public static final LispString EMPTY = new LispString("");
    private String value;

    public LispString(String value) {
        if (value == null) {
            throw new NullPointerException("string is null");
        }
        this.value = value;
    }

    public LispString(LispString str) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.value = str.value;
    }

    public static LispString valueOf(String s) {
        return new LispString(s);
    }

    public boolean isEqualTo(LispString a) {
        return this.value.equals(a.value);
    }

    @Override
    public String getString() {
        return this.value;
    }

    public void setString(String value) {
        this.value = value;
    }

    public LispString toLispString() {
        return this;
    }

    @Override
    public String toDisplay() {
        return this.value;
    }

    @Override
    public String toWrite() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.value.length()) {
            char c = this.value.charAt(i);
            if (c == '\\') {
                b.append("\\\\");
            } else if (c == '\"') {
                b.append("\\\"");
            } else {
                b.append(c);
            }
            ++i;
        }
        return "\"" + b.toString() + "\"";
    }

    @Override
    public boolean isTypeString() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LispString) {
            return this.value.equals(((LispString)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        return "\"" + this.value + "\"";
    }

    public static class StringCopyS
    extends Subr {
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            String s = SubrUtils.getString(c3a, mesg);
            return this.execute(c1a, c2a, s, 0, s.length(), mesg);
        }

        protected Datum execute(Datum c1a, Datum c2a, String str, int b, int e, LispMessage mesg) {
            char[] t = SubrUtils.getString(c1a, mesg).toCharArray();
            char[] s = str.toCharArray();
            int ts = SubrUtils.getSmallInt(c2a, mesg);
            if (ts >= t.length) {
                throw mesg.getError("err.string.outofrange", c1a);
            }
            if (e - b > t.length - ts) {
                throw mesg.getError("err.string.outofrange");
            }
            System.arraycopy(s, b, t, ts, e - b);
            ((LispString)c1a).value = new String(t);
            return Undef.UNDEF;
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            int e;
            int b;
            String s;
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() == 3) {
                return this.execute(l.get(0), l.get(1), l.get(2), env, mesg);
            }
            if (l.size() == 4) {
                s = SubrUtils.getString(l.get(2), mesg);
                b = SubrUtils.getSmallInt(l.get(3), mesg);
                e = s.length();
                if (b >= s.length()) {
                    throw mesg.getError("err.string.outofrange", l.get(3));
                }
            } else if (l.size() == 5) {
                s = SubrUtils.getString(l.get(2), mesg);
                b = SubrUtils.getSmallInt(l.get(3), mesg);
                e = SubrUtils.getSmallInt(l.get(4), mesg);
                if (b >= s.length()) {
                    throw mesg.getError("err.string.outofrange", l.get(3));
                }
                if (e > s.length()) {
                    throw mesg.getError("err.string.outofrange", l.get(4));
                }
                if (b > e) {
                    throw mesg.getError("err.range.invalid");
                }
            } else {
                throw mesg.getError("err.argument", body);
            }
            return this.execute(l.get(0), l.get(1), s, b, e, mesg);
        }
    }

    public static class StringSetS
    extends TernaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            char[] cs = SubrUtils.getString(c1a, mesg).toCharArray();
            int i = SubrUtils.getSmallInt(c2a, mesg);
            char ch = SubrUtils.getCharacter(c3a, mesg);
            if (i < 0 || i >= cs.length) {
                throw mesg.getError("err.string.outofrange", c2a);
            }
            cs[i] = ch;
            ((LispString)c1a).value = new String(cs);
            return Undef.UNDEF;
        }
    }
}

