/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.c.pre.parser;

import java.io.IOException;
import java.util.ArrayList;
import net.morilib.c.pre.CpreSyntaxException;
import net.morilib.c.pre.expr.CpreAdder;
import net.morilib.c.pre.expr.CpreBitAndOp;
import net.morilib.c.pre.expr.CpreBitNotOp;
import net.morilib.c.pre.expr.CpreBitOrOp;
import net.morilib.c.pre.expr.CpreBitXorOp;
import net.morilib.c.pre.expr.CpreCommaOp;
import net.morilib.c.pre.expr.CpreConditionOp;
import net.morilib.c.pre.expr.CpreDefinedOp;
import net.morilib.c.pre.expr.CpreDivider;
import net.morilib.c.pre.expr.CpreExpression;
import net.morilib.c.pre.expr.CpreLeftShifter;
import net.morilib.c.pre.expr.CpreLiteralFloat;
import net.morilib.c.pre.expr.CpreLiteralInteger;
import net.morilib.c.pre.expr.CpreLogicalAndOp;
import net.morilib.c.pre.expr.CpreLogicalNotOp;
import net.morilib.c.pre.expr.CpreLogicalOrOp;
import net.morilib.c.pre.expr.CpreMultiplier;
import net.morilib.c.pre.expr.CpreNegater;
import net.morilib.c.pre.expr.CpreRelationOp;
import net.morilib.c.pre.expr.CpreRemainderOp;
import net.morilib.c.pre.expr.CpreRightShifter;
import net.morilib.c.pre.expr.CpreSubtracter;
import net.morilib.c.pre.parser.CpreFloatToken;
import net.morilib.c.pre.parser.CpreIntegerToken;
import net.morilib.c.pre.parser.CpreLexer;
import net.morilib.c.pre.parser.CpreOperator;
import net.morilib.c.pre.parser.CpreOperatorType;
import net.morilib.c.pre.parser.CpreRelop1;
import net.morilib.c.pre.parser.CpreRelop2;
import net.morilib.c.pre.parser.CpreSymbol;
import net.morilib.c.pre.parser.CpreToken;

public final class CpreParser {
    private CpreParser() {
    }

    static CpreExpression identifier(CpreLexer rd) throws IOException {
        CpreToken t = rd.getToken();
        if (t instanceof CpreIntegerToken) {
            rd.nextToken();
            return new CpreLiteralInteger(t.getInteger());
        }
        if (t instanceof CpreFloatToken) {
            rd.nextToken();
            return new CpreLiteralFloat(t.getFloat());
        }
        if (t.equals(CpreOperator.DEFINED)) {
            rd.nextToken();
            rd.eatToken(CpreOperator.LPAREN);
            t = rd.getToken();
            if (!(t instanceof CpreSymbol)) {
                throw new CpreSyntaxException(rd.getLineNumber(), "symbol", t);
            }
            rd.nextToken();
            rd.eatToken(CpreOperator.RPAREN);
            return new CpreDefinedOp(t.getString());
        }
        if (t instanceof CpreSymbol) {
            return new CpreLiteralInteger(0L);
        }
        if (t.equals(CpreOperator.LPAREN)) {
            rd.nextToken();
            CpreExpression e = CpreParser.parseExpression(rd);
            rd.eatToken(CpreOperator.RPAREN);
            return e;
        }
        throw new CpreSyntaxException(rd.getLineNumber(), "identifier", t);
    }

    static CpreExpression unaries(CpreLexer rd) throws IOException {
        CpreToken t = rd.getToken();
        if (t.equals(CpreOperator.ADD)) {
            t = rd.nextToken();
            return CpreParser.identifier(rd);
        }
        if (t.equals(CpreOperator.SUB)) {
            t = rd.nextToken();
            return new CpreNegater(CpreParser.identifier(rd));
        }
        if (t.equals(CpreOperator.L_NOT)) {
            t = rd.nextToken();
            return new CpreLogicalNotOp(CpreParser.identifier(rd));
        }
        if (t.equals(CpreOperator.B_NOT)) {
            t = rd.nextToken();
            return new CpreBitNotOp(CpreParser.identifier(rd));
        }
        return CpreParser.identifier(rd);
    }

    static CpreExpression factor(CpreLexer rd) throws IOException {
        CpreToken t;
        ArrayList<CpreExpression> l = new ArrayList<CpreExpression>();
        ArrayList<CpreToken> m = new ArrayList<CpreToken>();
        l.add(CpreParser.unaries(rd));
        m.add(null);
        while ((t = rd.getToken()).equals(CpreOperator.MUL) || t.equals(CpreOperator.DIV) || t.equals(CpreOperator.MOD)) {
            m.add(t);
            rd.nextToken();
            l.add(CpreParser.unaries(rd));
        }
        CpreExpression e = (CpreExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            if (((CpreToken)m.get(i)).equals(CpreOperator.MUL)) {
                e = new CpreMultiplier(e, (CpreExpression)l.get(i));
            } else if (((CpreToken)m.get(i)).equals(CpreOperator.DIV)) {
                e = new CpreDivider(e, (CpreExpression)l.get(i));
            } else if (((CpreToken)m.get(i)).equals(CpreOperator.MOD)) {
                e = new CpreRemainderOp(e, (CpreExpression)l.get(i));
            }
            ++i;
        }
        return e;
    }

    static CpreExpression term(CpreLexer rd) throws IOException {
        CpreToken t;
        ArrayList<CpreExpression> l = new ArrayList<CpreExpression>();
        ArrayList<CpreToken> m = new ArrayList<CpreToken>();
        l.add(CpreParser.factor(rd));
        m.add(null);
        while ((t = rd.getToken()).equals(CpreOperator.ADD) || t.equals(CpreOperator.SUB)) {
            m.add(t);
            rd.nextToken();
            l.add(CpreParser.factor(rd));
        }
        CpreExpression e = (CpreExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            if (((CpreToken)m.get(i)).equals(CpreOperator.ADD)) {
                e = new CpreAdder(e, (CpreExpression)l.get(i));
            } else if (((CpreToken)m.get(i)).equals(CpreOperator.SUB)) {
                e = new CpreSubtracter(e, (CpreExpression)l.get(i));
            }
            ++i;
        }
        return e;
    }

    static CpreExpression sft(CpreLexer rd) throws IOException {
        CpreToken t;
        ArrayList<CpreExpression> l = new ArrayList<CpreExpression>();
        ArrayList<CpreToken> m = new ArrayList<CpreToken>();
        l.add(CpreParser.term(rd));
        m.add(null);
        while ((t = rd.getToken()).equals(CpreOperator.SHIFTL) || t.equals(CpreOperator.SHIFTR)) {
            m.add(t);
            rd.nextToken();
            l.add(CpreParser.term(rd));
        }
        CpreExpression e = (CpreExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            if (((CpreToken)m.get(i)).equals(CpreOperator.SHIFTL)) {
                e = new CpreLeftShifter(e, (CpreExpression)l.get(i));
            } else if (((CpreToken)m.get(i)).equals(CpreOperator.SHIFTR)) {
                e = new CpreRightShifter(e, (CpreExpression)l.get(i));
            }
            ++i;
        }
        return e;
    }

    static CpreExpression relop1(CpreLexer rd) throws IOException {
        CpreToken t;
        ArrayList<CpreExpression> l = new ArrayList<CpreExpression>();
        ArrayList<CpreOperatorType> m = new ArrayList<CpreOperatorType>();
        l.add(CpreParser.sft(rd));
        m.add(null);
        while ((t = rd.getToken()) instanceof CpreRelop1) {
            m.add(t.getRelation());
            rd.nextToken();
            l.add(CpreParser.sft(rd));
        }
        CpreExpression e = (CpreExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = new CpreRelationOp(e, (CpreExpression)l.get(i), (CpreOperatorType)((Object)m.get(i)));
            ++i;
        }
        return e;
    }

    static CpreExpression relop2(CpreLexer rd) throws IOException {
        CpreToken t;
        ArrayList<CpreExpression> l = new ArrayList<CpreExpression>();
        ArrayList<CpreOperatorType> m = new ArrayList<CpreOperatorType>();
        l.add(CpreParser.relop1(rd));
        m.add(null);
        while ((t = rd.getToken()) instanceof CpreRelop2) {
            m.add(t.getRelation());
            rd.nextToken();
            l.add(CpreParser.relop1(rd));
        }
        CpreExpression e = (CpreExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = new CpreRelationOp(e, (CpreExpression)l.get(i), (CpreOperatorType)((Object)m.get(i)));
            ++i;
        }
        return e;
    }

    static CpreExpression band(CpreLexer rd) throws IOException {
        ArrayList<CpreExpression> l = new ArrayList<CpreExpression>();
        l.add(CpreParser.relop2(rd));
        while (rd.getToken().equals(CpreOperator.B_AND)) {
            rd.nextToken();
            l.add(CpreParser.relop2(rd));
        }
        CpreExpression e = (CpreExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = new CpreBitAndOp(e, (CpreExpression)l.get(i));
            ++i;
        }
        return e;
    }

    static CpreExpression bxor(CpreLexer rd) throws IOException {
        ArrayList<CpreExpression> l = new ArrayList<CpreExpression>();
        l.add(CpreParser.band(rd));
        while (rd.getToken().equals(CpreOperator.B_XOR)) {
            rd.nextToken();
            l.add(CpreParser.band(rd));
        }
        CpreExpression e = (CpreExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = new CpreBitXorOp(e, (CpreExpression)l.get(i));
            ++i;
        }
        return e;
    }

    static CpreExpression bor(CpreLexer rd) throws IOException {
        ArrayList<CpreExpression> l = new ArrayList<CpreExpression>();
        l.add(CpreParser.bxor(rd));
        while (rd.getToken().equals(CpreOperator.B_OR)) {
            rd.nextToken();
            l.add(CpreParser.bxor(rd));
        }
        CpreExpression e = (CpreExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = new CpreBitOrOp(e, (CpreExpression)l.get(i));
            ++i;
        }
        return e;
    }

    static CpreExpression logand(CpreLexer rd) throws IOException {
        ArrayList<CpreExpression> l = new ArrayList<CpreExpression>();
        l.add(CpreParser.bor(rd));
        while (rd.getToken().equals(CpreOperator.L_AND)) {
            rd.nextToken();
            l.add(CpreParser.bor(rd));
        }
        CpreExpression e = (CpreExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = new CpreLogicalAndOp(e, (CpreExpression)l.get(i));
            ++i;
        }
        return e;
    }

    static CpreExpression logor(CpreLexer rd) throws IOException {
        ArrayList<CpreExpression> l = new ArrayList<CpreExpression>();
        l.add(CpreParser.logand(rd));
        while (rd.getToken().equals(CpreOperator.L_OR)) {
            rd.nextToken();
            l.add(CpreParser.logand(rd));
        }
        CpreExpression e = (CpreExpression)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = new CpreLogicalOrOp(e, (CpreExpression)l.get(i));
            ++i;
        }
        return e;
    }

    static CpreExpression cond(CpreLexer rd) throws IOException {
        CpreExpression e = CpreParser.logor(rd);
        if (rd.getToken().equals(CpreOperator.TRI1)) {
            rd.nextToken();
            CpreExpression f = CpreParser.parseExpression(rd);
            rd.eatToken(CpreOperator.TRI2);
            CpreExpression g = CpreParser.parseExpression(rd);
            return new CpreConditionOp(e, f, g);
        }
        return e;
    }

    static CpreExpression commaop(CpreLexer rd) throws IOException {
        CpreExpression e = CpreParser.cond(rd);
        if (rd.getToken().equals(CpreOperator.COMMA)) {
            rd.nextToken();
            return new CpreCommaOp(e, CpreParser.commaop(rd));
        }
        return e;
    }

    public static CpreExpression parseExpression(CpreLexer rd) throws IOException {
        return CpreParser.commaop(rd);
    }
}

