/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.c.pre;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.morilib.c.pre.CpreSyntaxException;
import net.morilib.c.pre.CpreUtils;

public class CpreMacros {
    private Map<String, String> macros;
    private Map<String, List<String>> macroArgs;

    public CpreMacros() {
        this.macros = new HashMap<String, String>();
        this.macroArgs = new HashMap<String, List<String>>();
    }

    public CpreMacros(CpreMacros m) {
        this.macros = new HashMap<String, String>(m.macros);
        this.macroArgs = new HashMap<String, List<String>>(m.macroArgs);
    }

    String substituteArgs(Reader rd, Map<String, String> args) throws IOException {
        StringBuffer b1 = null;
        S2 st = S2.INI;
        int qch = -1;
        StringBuffer b0 = new StringBuffer();
        while (true) {
            int c = rd.read();
            switch (st) {
                case INI: {
                    if (CpreUtils.isCMacroIdentifierStart(c)) {
                        b1 = new StringBuffer().appendCodePoint(c);
                        st = S2.EX1;
                        break;
                    }
                    if (c == 34 || c == 39) {
                        b0.appendCodePoint(c);
                        qch = c;
                        st = S2.DQ1;
                        break;
                    }
                    if (c == 35) {
                        b1 = new StringBuffer();
                        st = S2.EX2;
                        break;
                    }
                    if (c < 0) {
                        return b0.toString();
                    }
                    b0.appendCodePoint(c);
                    break;
                }
                case EX1: {
                    if (CpreUtils.isCMacroIdentifierPart(c)) {
                        b1.append((char)c);
                        break;
                    }
                    String t = args.get(b1.toString().trim());
                    b0.append(t != null ? t : b1);
                    if (c < 0) {
                        return b0.toString();
                    }
                    if (c == 34 || c == 39) {
                        b0.appendCodePoint(c);
                        qch = c;
                        st = S2.DQ1;
                        break;
                    }
                    if (c == 35) {
                        b1 = new StringBuffer();
                        st = S2.EX2;
                        break;
                    }
                    b0.appendCodePoint(c);
                    st = S2.INI;
                    break;
                }
                case EX2: {
                    String t;
                    if (CpreUtils.isCMacroIdentifierPart(c)) {
                        b1.append((char)c);
                        break;
                    }
                    if (c == 35) {
                        b0.append('#').append('#');
                        st = S2.INI;
                        break;
                    }
                    if (b1.length() > 0) {
                        b0.append('\"');
                        t = args.get(b1.toString());
                        if (t != null) {
                            t = t.replaceAll("\\\\", "\\\\\\\\");
                            t = t.replaceAll("\"", "\\\\\"");
                        } else {
                            b0.append(b1);
                        }
                        b0.append(t);
                        b0.append('\"');
                        if (c < 0) {
                            return b0.toString();
                        }
                        if (c == 34 || c == 39) {
                            b0.appendCodePoint(c);
                            qch = c;
                            st = S2.DQ1;
                            break;
                        }
                        if (c == 35) {
                            b1 = new StringBuffer();
                            st = S2.EX2;
                            break;
                        }
                        b0.appendCodePoint(c);
                        st = S2.INI;
                        break;
                    }
                    b0.append('#');
                    if (c < 0) {
                        return b0.toString();
                    }
                    if (c == 34 || c == 39) {
                        b0.appendCodePoint(c);
                        qch = c;
                        st = S2.DQ1;
                        break;
                    }
                    if (c == 35) {
                        b1 = new StringBuffer();
                        st = S2.EX2;
                        break;
                    }
                    b0.appendCodePoint(c);
                    st = S2.INI;
                    break;
                }
                case DQ1: {
                    if (c == qch) {
                        st = S2.INI;
                    } else if (c == 92) {
                        st = S2.DQ2;
                    } else if (c < 0) {
                        return b0.toString();
                    }
                    b0.appendCodePoint(c);
                    break;
                }
                case DQ2: {
                    if (c < 0) {
                        return b0.toString();
                    }
                    b0.appendCodePoint(c);
                    st = S2.DQ1;
                }
            }
        }
    }

    public void define(String name, String value) {
        this.macros.put(name, value);
    }

    public void define(String name, String value, List<String> args) {
        this.macros.put(name, value);
        if (args != null) {
            this.macroArgs.put(name, new ArrayList<String>(args));
        }
    }

    public String substitute(String name) {
        return this.macros.get(name);
    }

    public String substitute(String name, int lineno, List<String> args) {
        List<String> a;
        if (name.equals("defined") || (a = this.macroArgs.get(name)) == null) {
            return null;
        }
        if (a.size() != args.size()) {
            throw new CpreSyntaxException(lineno, "wrong number of arguments: require " + a.size() + " but " + args.size());
        }
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            int i = 0;
            while (i < a.size()) {
                m.put(a.get(i), args.get(i));
                ++i;
            }
            StringReader r = new StringReader(this.macros.get(name));
            String s = this.substituteArgs(r, m);
            return s;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void undef(String name) {
        this.macros.remove(name);
    }

    public boolean isDefined(String name) {
        return this.macros.containsKey(name);
    }

    private static enum S2 {
        INI,
        EX1,
        EX2,
        DQ1,
        DQ2;

    }
}

