/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.range.Interval;
import net.morilib.range.Range;

public final class NFAEpsilonBound<T, A, B>
extends NFAObject<T, A, B> {
    final NFAState beginState = new NFAObject.IntStateObject(this, 0);
    final NFAState endState = new NFAObject.IntStateObject(this, 1);
    private TextBound aBound = null;

    private NFAEpsilonBound(TextBound bound) {
        this.aBound = bound;
    }

    public static <T, A, B> NFAEpsilonBound<T, A, B> newInstance() {
        return new NFAEpsilonBound<T, A, B>(null);
    }

    public static <T, A, B> NFAEpsilonBound<T, A, B> newInstance(TextBound bound) {
        return new NFAEpsilonBound<T, A, B>(bound);
    }

    @Override
    protected NFAEpsilonBound<T, A, B> clone() {
        return NFAEpsilonBound.newInstance(this.aBound);
    }

    @Override
    void addStates(Set<NFAState> res, NFAState state, T a) {
    }

    @Override
    void addStates(Set<NFAState> res, NFAState state, Range a) {
    }

    @Override
    void addStatesBound(Set<NFAState> res, NFAState state, EnumSet<TextBound> a) {
        if (a.contains((Object)this.aBound) && state.equals(this.beginState)) {
            res.add(this.endState);
        }
    }

    @Override
    void addInitialStates(Set<NFAState> res) {
        res.add(this.beginState);
    }

    @Override
    void addStatesEpsilon(Set<NFAState> res, NFAState state) {
        if (this.aBound == null && state.equals(this.beginState)) {
            res.add(this.endState);
        }
    }

    @Override
    public boolean isState(NFAState o) {
        if (o instanceof NFAObject.IntStateObject) {
            NFAObject.IntStateObject s = (NFAObject.IntStateObject)o;
            return s.equals(this.beginState) || s.equals(this.endState);
        }
        return false;
    }

    @Override
    public boolean isInitialState(NFAState o) {
        return this.beginState.equals(o);
    }

    @Override
    public boolean isFinal(NFAState state) {
        return this.endState.equals(state);
    }

    @Override
    public Set<Interval> nextAlphabets(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<T> nextDiscreteAlphabets(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        return Collections.singleton(this.endState);
    }

    @Override
    public Set<B> getMatchTag(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<B> getMatchTagEnd(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<A> getAccept(NFAState state) {
        return Collections.emptySet();
    }
}

