/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.range;

import junit.framework.TestCase;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/02/20
 */
public class CharsetParserTest extends TestCase {

	static void eqr(String r, Range g) {
		assertEquals(g, CharsetParser.parse(r, "UTF-8"));
	}

	public void testC0001() {
		eqr("a", CharSets.parse("a"));
		eqr("a-z", CharSets.parse("a-z"));
		eqr("a-zA-Z", CharSets.parse("a-zA-Z"));
		eqr("-", CharSets.parse("\\-"));
		eqr("-z", CharSets.parse("\\-z"));
		eqr("a-", CharSets.parse("\\-a"));
	}

	public void testC0002() {
		eqr("^a", CharSets.parse("^a"));
		eqr("^a-z", CharSets.parse("^a-z"));
	}

	public void testC0003() {
		eqr("[a]", CharSets.parse("a"));
		eqr("[a-z]", CharSets.parse("a-z"));
	}

	public void testC0004() {
		eqr("a-z&&[def]", CharSets.parse("def"));
		eqr("a-x&&[c-z]", CharSets.parse("c-x"));
	}

	public void testC0005() {
		eqr("a-z[def]", CharSets.parse("a-z"));
		eqr("a-x[c-z]", CharSets.parse("a-z"));
	}

	public void testC0006() {
		eqr("a-z&&[^def]", CharSets.parse("a-cg-z"));
		eqr("a-x&&[^c-z]", CharSets.parse("a-b"));
	}

	public void testC0007() {
		eqr("\\n", CharSets.parse("\n"));
		eqr("\\r", CharSets.parse("\r"));
		eqr("\\t", CharSets.parse("\t"));
		eqr("\\n\\t\\r", CharSets.parse("\n\t\r"));
		eqr("\\s", CharSets.ASCII_WHITESPACE);
		eqr("\\S", CharSets.NOT_ASCII_WHITESPACE);
		eqr("\\w", CharSets.ASCII_WORD);
		eqr("\\W", CharSets.NOT_ASCII_WORD);
		eqr("\\d", CharSets.NUMBERS);
		eqr("\\D", CharSets.NOT_NUMBER);
		eqr("\\]a", CharSets.parse("\\]a"));
		eqr("\\]\\-", CharSets.parse("\\]\\-"));
		eqr("\\]\\\\\\[\\-\\&", CharSets.parse("\\\\\\&\\[\\]\\-"));
		eqr("^\\\\\\&\\[\\]\\-", CharSets.parse("^\\\\\\&\\[\\]\\-"));
	}

}
