/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import java.util.Collections;

import net.morilib.nina.NinaParser;
import junit.framework.TestCase;

public class NinaErrorTest extends TestCase {

	static void drv(String s, boolean pause) {
		NFABuilder a;
		NinaParser m;
		Quadro q;

		q = Quadro.read("A", s, Collections.<String>emptyList());
		a = new NFABuilder();
		m = new NinaParser(q, a, Collections.<String, String>emptyMap(),
				new NinaSubautomata("a"),
				new NinaConsoleStub(), new NinaConsoleStub());
		try {
			while(m.step() == null);
			fail();
		} catch(NinaException e) {
			// ok
		}
	}

	public void test0001() {
		String s =
				"#machine NFABuilder\n" +
				" =========       \n" +
				" =aaa     =      \n" +
				" =       =       \n" +
				" =========       \n" +
				"";
		drv(s, false);
	}

	public void test0002() {
		String s =
				"#machine NFABuilder\n" +
				" =========       \n" +
				" =aaa    =       \n" +
				" =        =      \n" +
				" =========       \n" +
				"";
		drv(s, false);
	}

	public void test0003() {
		String s =
				"#machine NFABuilder\n" +
				" =========       \n" +
				" =aaa    =       \n" +
				" =      ==      \n" +
				" ======= =       \n" +
				"";
		drv(s, false);
	}

	public void test0004() {
		String s =
				"#machine NFABuilder\n" +
				" =========       \n" +
				" =aaa    =       \n" +
				"  =      =      \n" +
				" =========       \n" +
				"";
		drv(s, false);
	}

	public void test0005() {
		String s =
				"#machine NFABuilder\n" +
				" =========       \n" +
				"  =aaa   =       \n" +
				" =       =      \n" +
				" =========       \n" +
				"";
		drv(s, false);
	}

	public void test0011() {
		String s =
				"#machine NFABuilder\n" +
				" =========       \n" +
				" =aaa    >b\\    \n" +
				" =     @*=*v*    \n" +
				" ===^=====  *    \n" +
				"    \\--<    *    \n" +
				"       ******    \n" +
				"";
		drv(s, false);
	}

	public void test0012() {
		String s =
				"#machine NFABuilder\n" +
				" =========       \n" +
				" =aaa    <b\\    \n" +
				" =     @*=*^*    \n" +
				" ===v=====  *    \n" +
				"    \\a->    *    \n" +
				"       ******    \n" +
				"";
		drv(s, false);
	}

	public void test0021() {
		String s =
				"#machine DFABuilder\n" +
				"#label lb1=${lb3}\n" +
				"#label lb2='bb'\n" +
				"#label lb3=${lb1}\n" +
				" *S***                      @*****\n" +
				" *b  >-------${lb1}--------->aa  *\n" +
				" **^**                      **v***\n" +
				"   +---------${lb2}-----------+  \n" +
				"";
		drv(s, false);
	}

}
