/*
 * Copyright 2013-2014 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.unicode;

public final class UnicodeUtils {

	/**
	 * 
	 * @param c
	 * @return
	 */
	public static int toKatakana(int c) {
		if(c < 0x3041) {
			return c;
		} else if(c <= 0x3096) {
			return c + (0x30A1 - 0x3041);
		} else {
			return c;
		}
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	public static String toKatakana(String s) {
		StringBuffer b;

		b = new StringBuffer();
		for(int k = 0; k < s.length(); k++) {
			b.append((char)toKatakana(s.charAt(k)));
		}
		return b.toString();
	}

	/**
	 * 
	 * @param c
	 * @return
	 */
	public static int toHiragana(int c) {
		if(c < 0x30A1) {
			return c;
		} else if(c <= 0x30F6) {
			return c + (0x3041 - 0x30A1);
		} else {
			return c;
		}
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	public static String toHiragana(String s) {
		StringBuffer b;

		b = new StringBuffer();
		for(int k = 0; k < s.length(); k++) {
			b.append((char)toHiragana(s.charAt(k)));
		}
		return b.toString();
	}

	/**
	 * 
	 * @param c
	 * @return
	 */
	public static boolean isFullWidthLatin(int c) {
		return c >= 0xFF01 && c <= 0xFF5E;
	}

	/**
	 * 
	 * @param c
	 * @return
	 */
	public static int toFullWidthLatin(int c) {
		if(c < 0x21) {
			return c;
		} else if(c <= 0x7E) {
			return c + (0xFF01 - 0x21);
		} else {
			return c;
		}
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	public static String toFullWidthLatin(String s) {
		StringBuffer b;

		b = new StringBuffer();
		for(int k = 0; k < s.length(); k++) {
			b.append((char)toFullWidthLatin(s.charAt(k)));
		}
		return b.toString();
	}

	/**
	 * 
	 * @param c
	 * @return
	 */
	public static int toHalfWidthLatin(int c) {
		if(c < 0xFF01) {
			return c;
		} else if(c <= 0xFF5E) {
			return c + (0x21 - 0xFF01);
		} else {
			return c;
		}
	}

	/**
	 * 
	 * @param s
	 * @return
	 */
	public static String toHalfWidthLatin(String s) {
		StringBuffer b;

		b = new StringBuffer();
		for(int k = 0; k < s.length(); k++) {
			b.append((char)toHalfWidthLatin(s.charAt(k)));
		}
		return b.toString();
	}

}
