/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.directive;

import net.morilib.c.pre.CpreMacros;
import net.morilib.c.pre.CpreSyntaxException;

public class CpreElse implements CpreDirective {

	public CpreIfState execute(CpreMacros macros, String line,
			int ln, CpreIfState stat) {
		if(stat.isTopLevel()) {
			throw new CpreSyntaxException(
					ln, "this directive must follow #if");
		} else if(stat.isDone()) {
			throw new CpreSyntaxException(
					ln, "this directive must not follow #else");
		} else if(stat.isProcessing() || stat.isProcessed()) {
			return CpreIfState.DONE;
		} else {
			return CpreIfState.PROCESSING_ELSE;
		}
	}

}
