/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.nano.java6;

import java.util.Arrays;
import java.util.List;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.Scheme;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/02/17
 */
public class SchlushEngineFactory implements ScriptEngineFactory {

	//
	static final Scheme SCHEME = Scheme.newInstance();

	//
	Environment environ;

	/**
	 * 
	 */
	public SchlushEngineFactory() {
		environ = new Environment(SCHEME.getGlobalEnvironment());
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getEngineName()
	 */
	@Override
	public String getEngineName() {
		return "morilib Schluessel Scheme Engine";
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getEngineVersion()
	 */
	@Override
	public String getEngineVersion() {
		return Scheme.SCHLUSH_VERSION;
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getExtensions()
	 */
	@Override
	public List<String> getExtensions() {
		return Arrays.asList("scm");
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getMimeTypes()
	 */
	@Override
	public List<String> getMimeTypes() {
		return Arrays.asList("application/x-scluessel");
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getNames()
	 */
	@Override
	public List<String> getNames() {
		return Arrays.asList("scheme", "schluessel");
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getLanguageName()
	 */
	@Override
	public String getLanguageName() {
		return "Scheme";
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getLanguageVersion()
	 */
	@Override
	public String getLanguageVersion() {
		return "5";
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getParameter(java.lang.String)
	 */
	@Override
	public Object getParameter(String key) {
		if(key == null) {
			return null;
		} else if(key.equals(ScriptEngine.ENGINE)) {
			return getEngineName();
		} else if(key.equals(ScriptEngine.ENGINE_VERSION)) {
			return getEngineVersion();
		} else if(key.equals(ScriptEngine.NAME)) {
			return "scheme";
		} else if(key.equals(ScriptEngine.LANGUAGE)) {
			return getLanguageName();
		} else if(key.equals(ScriptEngine.LANGUAGE_VERSION)) {
			return getLanguageVersion();
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getMethodCallSyntax(java.lang.String, java.lang.String, java.lang.String[])
	 */
	@Override
	public String getMethodCallSyntax(String obj, String m,
			String... args) {
		return null;
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getOutputStatement(java.lang.String)
	 */
	@Override
	public String getOutputStatement(String toDisplay) {
		return "(display " + toDisplay + ")";
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getProgram(java.lang.String[])
	 */
	@Override
	public String getProgram(String... statements) {
		StringBuffer b = new StringBuffer();
		String d = "";

		b.append("(begin ");
		for(String s : statements) {
			b.append(d).append(s);
			d = " ";
		}
		b.append(")");
		return b.toString();
	}

	/* (non-Javadoc)
	 * @see javax.script.ScriptEngineFactory#getScriptEngine()
	 */
	@Override
	public ScriptEngine getScriptEngine() {
		return new SchlushScriptEngine(this);
	}

}
