/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import net.morilib.automata.DFAState;
import net.morilib.nina.NinaDFAPattern;
import net.morilib.nina.NinaMatcher;

public class NinaDFAMatcher
implements NinaMatcher {
    private NinaDFAPattern pattern;
    private DFAState<Object, Object, Void> etat;
    private String str;
    private String matched = null;

    NinaDFAMatcher(NinaDFAPattern p, String s) {
        this.pattern = p;
        this.str = s;
        this.etat = this.pattern.getInitialState();
    }

    @Override
    public boolean matches() {
        int i = 0;
        while (i < this.str.length()) {
            this.etat = this.etat.goInt(this.str.charAt(i));
            if (i + 1 == this.str.length() && this.etat.isAccepted()) {
                this.matched = this.str;
                return true;
            }
            if (this.etat.isDead()) {
                return false;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean lookingAt() {
        StringBuilder matches = new StringBuilder();
        int i = 0;
        while (i < this.str.length()) {
            char a = this.str.charAt(i);
            this.etat = this.etat.goInt(a);
            matches.appendCodePoint(a);
            if (this.etat.isAccepted()) {
                this.matched = matches.toString();
            }
            if (this.etat.isDead()) break;
            ++i;
        }
        return this.matched != null;
    }

    @Override
    public boolean find() {
        StringBuilder matches = new StringBuilder();
        int i = 0;
        while (i < this.str.length()) {
            char a = this.str.charAt(i);
            this.etat = this.etat.goInt(a);
            matches.appendCodePoint(a);
            if (this.etat.isAccepted()) {
                this.matched = matches.toString();
            }
            if (this.etat.isDead()) {
                if (this.matched != null) break;
                this.reset();
                matches = new StringBuilder();
            }
            ++i;
        }
        return this.matched != null;
    }

    @Override
    public String group() {
        return this.matched;
    }

    @Override
    public void reset() {
        this.etat = this.pattern.getInitialState();
        this.matched = null;
    }
}

