/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import net.morilib.lisp.nano.LispComplex;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispInteger;
import net.morilib.lisp.nano.LispNumber;
import net.morilib.lisp.nano.LispReal;
import net.morilib.lisp.nano.LispSmallInt;
import net.morilib.lisp.nano.LispString;

public abstract class LispExactReal
extends LispReal {
    @Override
    public abstract LispExactReal uminus();

    @Override
    public LispExactReal toExact() {
        return this;
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public boolean isInfinity() {
        return false;
    }

    public LispReal multiply(int n) {
        return (LispReal)this.mul(new LispSmallInt(n));
    }

    @Override
    public boolean isExact() {
        return true;
    }

    public LispReal power(int n) {
        if (n < 0) {
            return this.power(-n).inv().getReal();
        }
        if (n == 0) {
            return LispInteger.ONE;
        }
        if (n == 1) {
            return this;
        }
        LispReal r = this;
        int i = 1;
        while (i < n) {
            r = (LispReal)((LispComplex)r).mul(this);
            ++i;
        }
        return r;
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispDouble) {
            return new LispDouble(this.getRealDouble() + x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex((LispReal)this.add(c.getReal()), c.getImag());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispDouble) {
            return new LispDouble(this.getRealDouble() - x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex((LispReal)this.sub(c.getReal()), c.getImag().uminus());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispDouble) {
            return new LispDouble(this.getRealDouble() * x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex((LispReal)this.mul(c.getReal()), (LispReal)this.mul(c.getImag()));
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispDouble) {
            return new LispDouble(this.getRealDouble() / x.getRealDouble());
        }
        if (x instanceof LispComplex) {
            LispReal xr = x.getReal();
            LispReal xi = x.getImag();
            LispReal xn = (LispReal)xr.mul(xr).add(xi.mul(xi));
            return LispComplex.newComplex((LispReal)this.mul(xr).div(xn), (LispReal)this.mul(xi).uminus().div(xn));
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispReal remainder(LispReal r) {
        if (!r.isExact()) {
            double x = Math.IEEEremainder(this.getRealDouble(), r.getRealDouble());
            return new LispDouble(x);
        }
        if (r.signum() > 0) {
            LispReal b = r;
            while (this.compareTo(r) > 0) {
                b = (LispReal)b.sub(r);
            }
            return b;
        }
        LispReal b = r;
        while (this.compareTo(r) < 0) {
            b = (LispReal)b.add(r);
        }
        return b;
    }

    @Override
    public LispString toLispString(int radix, int precision) {
        return this.toLispString(radix);
    }
}

