/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.statement;

import java.util.Collection;
import net.morilib.awk.nano.AwkReturnException;
import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.statement.AwkExpressionMachine;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

public class AwkSequence
extends AwkExpression {
    private AwkExpression[] exprs;

    public AwkSequence(Collection<AwkExpression> exprs) {
        this.exprs = exprs.toArray(new AwkExpression[0]);
    }

    @Override
    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        AwkValue v = AwkUndefined.UNDEF;
        try {
            AwkExpression[] awkExpressionArray = this.exprs;
            int n = this.exprs.length;
            int n2 = 0;
            while (n2 < n) {
                AwkExpression e = awkExpressionArray[n2];
                v = e.eval(ns, o);
                ++n2;
            }
            return v;
        }
        catch (AwkReturnException e) {
            return e.getValue();
        }
    }

    @Override
    public void compileInternally(AwkExpressionMachine.Builder b, Object brk, Object cnt) {
        AwkExpression[] awkExpressionArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            AwkExpression e = awkExpressionArray[n2];
            e.compileInternally(b, brk, cnt);
            ++n2;
        }
    }
}

