/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano;

import net.morilib.awk.nano.value.AwkValue;

/**
 * return文にて発生される例外です。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkReturnException extends RuntimeException {

	private AwkValue value;

	/**
	 * 例外を発生します。
	 * 
	 * @param value 戻り値
	 */
	public AwkReturnException(AwkValue value) {
		this.value = value;
	}

	/**
	 * 戻り値を返します。
	 */
	public AwkValue getValue() {
		return value;
	}

}
