/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.PrintStream;
import java.util.ResourceBundle;
import net.morilib.nina.NinaParser;
import net.morilib.nina.Quadro;

public class NinaException
extends RuntimeException {
    private static final String CLSNAME = NinaException.class.getPackage().getName().replace('.', '/');
    private static ResourceBundle msgs = ResourceBundle.getBundle(String.valueOf(CLSNAME) + "/nina_messages");
    private NinaParser parser = null;
    private Quadro quadro = null;

    public static String getMessage(String s, Object ... os) {
        String t = msgs.getString(s);
        if (t != null) {
            return String.format(t, os);
        }
        return "unknown";
    }

    public NinaException(String msgcode, Object ... os) {
        super(NinaException.getMessage(msgcode, os));
    }

    public NinaException(NinaParser q, String msgcode, Object ... os) {
        super(NinaException.getMessage(msgcode, os));
        this.parser = q;
    }

    public NinaException(Quadro q, String msgcode, Object ... os) {
        super(NinaException.getMessage(msgcode, os));
        this.quadro = q;
    }

    public NinaException(Throwable cause, String msgcode, Object ... os) {
        super(NinaException.getMessage(msgcode, os), cause);
    }

    public void printTrace(PrintStream o) {
        if (this.parser != null) {
            this.parser.printTrace(o);
        } else if (this.quadro != null) {
            this.quadro.printTrace(o);
        }
    }
}

