/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.misc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public final class EncoderDecoder {
    private EncoderDecoder() {
    }

    static int _getchar(InputStream ins, Charset encoding) throws IOException {
        CharsetDecoder cd = encoding.newDecoder();
        ByteBuffer bb = ByteBuffer.allocate(8);
        CharBuffer cb = CharBuffer.allocate(8);
        byte[] a = new byte[8];
        int i = 0;
        while (i < a.length) {
            int b = ins.read();
            if (b < 0) {
                return -1;
            }
            a[i] = (byte)b;
            bb.put(a, 0, i + 1).flip();
            if (cd.decode(bb, cb, true).isUnderflow()) {
                cd.flush(cb);
                if (cb.flip().hasRemaining()) {
                    return cb.get();
                }
            } else {
                bb.clear();
            }
            ++i;
        }
        return -1;
    }

    public static int getchar(InputStream ins, Charset encoding) throws IOException {
        return EncoderDecoder._getchar(ins, encoding != null ? encoding : Charset.defaultCharset());
    }

    public static int getchar(InputStream ins) throws IOException {
        return EncoderDecoder.getchar(ins, Charset.defaultCharset());
    }

    public static int read(InputStream ins, Charset encoding, char[] a, int begin, int length) throws IOException {
        int i = begin;
        while (i < begin + length) {
            int c = EncoderDecoder.getchar(ins, encoding);
            if (c < 0) {
                return i > begin ? i - begin : -1;
            }
            a[i] = (char)c;
            ++i;
        }
        return length;
    }

    public static int read(InputStream ins, Charset encoding, char[] a) throws IOException {
        return EncoderDecoder.read(ins, encoding, a, 0, a.length);
    }

    public static int read(InputStream ins, char[] a, int begin, int length) throws IOException {
        return EncoderDecoder.read(ins, null, a, begin, length);
    }

    public static int read(InputStream ins, char[] a) throws IOException {
        return EncoderDecoder.read(ins, null, a, 0, a.length);
    }
}

