/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.directive;

import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.morilib.c.pre.CPreprocessorReader;
import net.morilib.c.pre.CpreMacros;
import net.morilib.c.pre.CpreSyntaxException;
import net.morilib.c.pre.expr.CpreExpression;
import net.morilib.c.pre.expr.CpreValue;
import net.morilib.c.pre.parser.CpreLexer;
import net.morilib.c.pre.parser.CpreParser;

public class CpreElif implements CpreDirective {

	static final Pattern PI1 =
		Pattern.compile("(.*)[ \t]*");

	public CpreIfState execute(CpreMacros macros, String line,
			int ln, CpreIfState stat) {
		Matcher m = PI1.matcher(line);
		CpreExpression e;
		StringReader r;
		CpreValue v;
		String s;

		if(!m.matches()) {
			throw new RuntimeException();
		} else if(stat.isTopLevel()) {
			throw new CpreSyntaxException(
					ln, "this directive must follow #if");
		} else if(stat.isDone()) {
			throw new CpreSyntaxException(
					ln, "this directive must not follow #else");
		} else if(stat.isProcessing() || stat.isProcessed()) {
			return CpreIfState.PROCESSED;
		}

		try {
			s = CPreprocessorReader.substitute(m.group(1), ln, macros);
			r = new StringReader(s);
			e = CpreParser.parseExpression(new CpreLexer(ln, r));
			v = e.eval(ln, macros);
			return v.toBoolean() ?
					CpreIfState.PROCESSING : CpreIfState.UNPROCESSED;
		} catch(IOException e1) {
			throw new RuntimeException(e1);
		}
	}

}
