/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.parser;

public class CpreOperator extends CpreToken {

	public static final CpreOperator ADD = new CpreOperator("+");
	public static final CpreOperator SUB = new CpreOperator("-");
	public static final CpreOperator MUL = new CpreOperator("*");
	public static final CpreOperator DIV = new CpreOperator("/");
	public static final CpreOperator MOD = new CpreOperator("%");
	public static final CpreOperator B_XOR = new CpreOperator("^");
	public static final CpreOperator B_AND = new CpreOperator("&");
	public static final CpreOperator B_OR  = new CpreOperator("|");
	public static final CpreOperator L_AND = new CpreOperator("&&");
	public static final CpreOperator L_OR  = new CpreOperator("||");
	public static final CpreOperator L_NOT = new CpreOperator("!");
	public static final CpreOperator TRI1 = new CpreOperator("?");
	public static final CpreOperator TRI2 = new CpreOperator(":");
	public static final CpreOperator LPAREN = new CpreOperator("(");
	public static final CpreOperator RPAREN = new CpreOperator(")");
	public static final CpreOperator INC = new CpreOperator("++");
	public static final CpreOperator DEC = new CpreOperator("--");
	public static final CpreOperator B_NOT = new CpreOperator("~");
	public static final CpreOperator COMMA = new CpreOperator(",");
	public static final CpreOperator SHIFTL = new CpreOperator("<<");
	public static final CpreOperator SHIFTR = new CpreOperator(">>");
	public static final CpreOperator DEFINED =
		new CpreOperator("defined");

	CpreOperator(String desc) {
		super(desc);
	}

}
