/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.util.Set;
import net.morilib.automata.NFAState;
import net.morilib.automata.nfa.NFAs;
import net.morilib.nina.NinaMatcher;
import net.morilib.nina.NinaNFAPattern;

public class NinaNFAMatcher
implements NinaMatcher {
    private NinaNFAPattern pattern;
    private Set<NFAState> etats;
    private String str;
    private String matched = null;

    NinaNFAMatcher(NinaNFAPattern p, String s) {
        this.pattern = p;
        this.str = s;
        this.etats = this.pattern.getInitialStates();
    }

    @Override
    public boolean matches() {
        StringBuilder matches = new StringBuilder();
        Set<NFAState> t = this.etats;
        int i = 0;
        while (i < this.str.length()) {
            char a = this.str.charAt(i);
            matches.appendCodePoint(a);
            t = NFAs.getStates(this.pattern.nfa, this.etats, Integer.valueOf(a));
            this.etats = NFAs.getEpsilonReachable(this.pattern.nfa, t);
            if (this.etats.isEmpty()) {
                return false;
            }
            ++i;
        }
        if (this.pattern.nfa.isFinalAny(this.etats)) {
            this.matched = matches.toString();
            return true;
        }
        this.matched = null;
        return false;
    }

    @Override
    public boolean lookingAt() {
        StringBuilder matches = new StringBuilder();
        Set<NFAState> t = this.etats;
        int i = 0;
        while (i < this.str.length()) {
            char a = this.str.charAt(i);
            matches.appendCodePoint(a);
            t = NFAs.getStates(this.pattern.nfa, this.etats, Integer.valueOf(a));
            this.etats = NFAs.getEpsilonReachable(this.pattern.nfa, t);
            if (this.etats.isEmpty()) break;
            if (this.pattern.nfa.isFinalAny(this.etats)) {
                this.matched = matches.toString();
            }
            ++i;
        }
        return this.matched != null;
    }

    @Override
    public boolean find() {
        StringBuilder matches = new StringBuilder();
        Set<NFAState> t = this.etats;
        int i = 0;
        while (i < this.str.length()) {
            char a = this.str.charAt(i);
            matches.appendCodePoint(a);
            t = NFAs.getStates(this.pattern.nfa, this.etats, Integer.valueOf(a));
            this.etats = NFAs.getEpsilonReachable(this.pattern.nfa, t);
            if (this.etats.isEmpty()) {
                if (this.matched != null) break;
                matches = new StringBuilder();
                this.reset();
            } else if (this.pattern.nfa.isFinalAny(this.etats)) {
                this.matched = matches.toString();
            }
            ++i;
        }
        return this.matched != null;
    }

    @Override
    public String group() {
        return this.matched;
    }

    @Override
    public void reset() {
        this.etats = this.pattern.getInitialStates();
        this.matched = null;
    }
}

