/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.morilib.automata.lr.ContextFreeGrammar;
import net.morilib.automata.lr.ContextFreeRule;
import net.morilib.automata.lr.LALR1Table;
import net.morilib.automata.lr.LR1Table;
import net.morilib.automata.lr.LRConflict;
import net.morilib.deculture.misc.ConstantNonterminal;
import net.morilib.deculture.parser.DecultureAction;
import net.morilib.deculture.parser.DecultureDefinition;
import net.morilib.deculture.parser.DecultureReader;

public class LRObject {
    private DecultureDefinition def;
    private DecultureAction act;
    private ContextFreeGrammar grammar;
    private LR1Table table;
    private Map<ContextFreeRule, Object> actionMap = new HashMap<ContextFreeRule, Object>();
    private Map<Object, Integer> nonterminalMap = new HashMap<Object, Integer>();
    private Map<String, String> subautomata = new HashMap<String, String>();
    private int nonterminalNumber = 0;

    public DecultureDefinition getDefinition() {
        return this.def;
    }

    public ContextFreeGrammar getGrammar() {
        return this.grammar;
    }

    public LR1Table getTable() {
        return this.table;
    }

    public Collection<LRConflict> getConflicts() {
        return this.table.getConflicts();
    }

    public Object getAction(ContextFreeRule rule) {
        return this.actionMap.get(rule);
    }

    public void setAction(ContextFreeRule rule, Object action) {
        this.actionMap.put(rule, action);
    }

    public void removeAction(ContextFreeRule rule) {
        this.actionMap.remove(rule);
    }

    public int howManyShiftReduceConflicts() {
        int r = 0;
        for (LRConflict t : this.table.getConflicts()) {
            r += t.isShiftReduce() ? 1 : 0;
        }
        return r;
    }

    public int howManyReduceReduceConflicts() {
        int r = 0;
        for (LRConflict t : this.table.getConflicts()) {
            r += t.isReduceReduce() ? 1 : 0;
        }
        return r;
    }

    public int getNonterminalNumber(Object o) {
        if (this.nonterminalMap.containsKey(o)) {
            return this.nonterminalMap.get(o);
        }
        this.nonterminalMap.put(o, this.nonterminalNumber);
        return this.nonterminalNumber++;
    }

    public int getStartNumber() {
        return this.table.getInitialStateID();
    }

    public Map<ContextFreeRule, Object> getActionMap() {
        return Collections.unmodifiableMap(this.actionMap);
    }

    public Map<String, String> getSubautomata() {
        return Collections.unmodifiableMap(this.subautomata);
    }

    private void _put(ContextFreeGrammar g) {
    }

    public static LRObject parse(Reader rd) throws IOException {
        LRObject p = new LRObject();
        p.def = new DecultureDefinition();
        p.def.parse(new DecultureReader(rd));
        p.act = new DecultureAction(p.def);
        p.act.parse(new DecultureReader(rd));
        p.actionMap = p.act.getActions();
        p.subautomata = p.act.getSubautomata();
        p.grammar = ContextFreeGrammar.newInstance(p.act.getActions().keySet(), new ConstantNonterminal(p.def.getStartSymbolName()));
        p._put(p.getGrammar());
        p.table = LALR1Table.create(p.grammar, p.def.getPriority(), p.def.getAssociativity());
        return p;
    }
}

