/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.LispBoolean;
import net.morilib.lisp.nano.LispComplex;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispInteger;
import net.morilib.lisp.nano.LispRational;
import net.morilib.lisp.nano.LispReal;

public class NanoNumberParser {
    private static final int NINA_ACCEPT = -1;
    private static final int NINA_FAIL = -9;
    private static final int NINA_HALT_ACCEPT = -91;
    private static final int NINA_HALT_REJECT = -72;
    private static final int NINA_BEGIN = -2;
    private static final int NINA_STACKLEN = 72;
    static final int INITIAL = 0;
    private int STATE;
    private int[] __sts = new int[72];
    private Engine[] __stk = new Engine[72];
    private Object[][] __stv = new Object[72][];
    private int __slen = 0;
    private int unread = -1;
    private StringBuffer nbf;
    private StringBuffer dbf;
    private StringBuffer fbf;
    private LispReal real;
    private Datum num;
    private final Engine ENGINE_intx = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return NanoNumberParser.this.intx_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return NanoNumberParser.this.intx_accepted();
        }

        @Override
        int execaction(int c) {
            return NanoNumberParser.this.intx_execaction(c);
        }

        @Override
        boolean isend() {
            return NanoNumberParser.this.intx_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return -1;
        }

        @Override
        int stateSize() {
            return 5;
        }

        public String toString() {
            return "intx";
        }
    };
    private final Engine ENGINE_real = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return NanoNumberParser.this.real_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return NanoNumberParser.this.real_accepted();
        }

        @Override
        int execaction(int c) {
            return NanoNumberParser.this.real_execaction(c);
        }

        @Override
        boolean isend() {
            return NanoNumberParser.this.real_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return -1;
        }

        @Override
        int stateSize() {
            return 9;
        }

        public String toString() {
            return "real";
        }
    };
    private final Engine ENGINE_nanoNumberParser = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return NanoNumberParser.this.nanoNumberParser_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return NanoNumberParser.this.nanoNumberParser_accepted();
        }

        @Override
        int execaction(int c) {
            return NanoNumberParser.this.nanoNumberParser_execaction(c);
        }

        @Override
        boolean isend() {
            return NanoNumberParser.this.nanoNumberParser_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return 10;
        }

        @Override
        int stateSize() {
            return 11;
        }

        public String toString() {
            return "nanoNumberParser";
        }
    };
    private final Engine ENGINE_number = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return NanoNumberParser.this.number_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return NanoNumberParser.this.number_accepted();
        }

        @Override
        int execaction(int c) {
            return NanoNumberParser.this.number_execaction(c);
        }

        @Override
        boolean isend() {
            return NanoNumberParser.this.number_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return -1;
        }

        @Override
        int stateSize() {
            return 10;
        }

        public String toString() {
            return "number";
        }
    };

    private void ib() {
        this.real = LispInteger.ONE;
        this.num = null;
    }

    private void ia() {
        this.nbf = new StringBuffer();
        this.fbf = null;
        this.dbf = null;
    }

    private void an(int c) {
        if (c != 43) {
            this.nbf.append((char)c);
        }
    }

    private void ad(int c) {
        this.dbf.append((char)c);
    }

    private void af(int c) {
        if (this.fbf == null) {
            this.fbf = this.nbf;
        }
        this.fbf.append((char)c);
    }

    private LispReal getr() {
        if (this.dbf != null) {
            return LispRational.newRational(new BigInteger(this.nbf.toString()), new BigInteger(this.dbf.toString()));
        }
        if (this.fbf != null) {
            return new LispDouble(Double.parseDouble(this.fbf.toString()));
        }
        return LispInteger.valueOf(new BigInteger(this.nbf.toString()));
    }

    private LispReal getr(int rdx) {
        if (this.dbf != null) {
            return LispRational.newRational(new BigInteger(this.nbf.toString(), rdx), new BigInteger(this.dbf.toString(), rdx));
        }
        return LispInteger.valueOf(new BigInteger(this.nbf.toString(), rdx));
    }

    private static Datum _exec(String s) {
        try {
            NanoNumberParser r = new NanoNumberParser();
            r.parse(new StringReader(s));
            return r.num;
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public static Datum parseNumber(String s, int rdx) {
        if (s.length() == 0) {
            return LispBoolean.FALSE;
        }
        if (s.charAt(0) == '#') {
            return NanoNumberParser._exec(s);
        }
        if (rdx == 10) {
            return NanoNumberParser._exec("#d" + s);
        }
        if (rdx == 8) {
            return NanoNumberParser._exec("#o" + s);
        }
        if (rdx == 16) {
            return NanoNumberParser._exec("#x" + s);
        }
        if (rdx == 2) {
            return NanoNumberParser._exec("#b" + s);
        }
        return LispBoolean.FALSE;
    }

    private int _read(Reader rd) throws IOException {
        int c;
        if (this.unread >= 0) {
            c = this.unread;
            this.unread = -1;
            this.__logprint("Read unread: ", c);
        } else {
            c = rd.read();
            if (c >= 0) {
                this.__logprint("Read: ", c);
            } else {
                this.__logprint("Read end-of-file");
            }
        }
        return c;
    }

    void UNGET(int c) {
        this.unread = c;
        this.__logprint("Set unread: ", c);
    }

    private void __logprint(String s, int c) {
    }

    private void __logopen() {
    }

    private void __logprint(String s) {
    }

    private void __logclose() {
    }

    private void __puttrace() {
    }

    private int intx_step(Reader __rd, int $c) throws IOException {
        boolean __g = true;
        switch (this.STATE) {
            case 0: {
                if (__g && $c == 43) {
                    this.STATE = 1;
                    return 1;
                }
                if (__g && $c == 45) {
                    this.STATE = 1;
                    return 1;
                }
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 2;
                    return 1;
                }
                if (__g && $c >= 65 && $c <= 70) {
                    this.STATE = 2;
                    return 1;
                }
                if (__g && $c >= 97 && $c <= 102) {
                    this.STATE = 2;
                    return 1;
                }
                return 0;
            }
            case 2: {
                if (__g && $c == 47) {
                    this.STATE = 3;
                    return 1;
                }
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 2;
                    return 1;
                }
                if (__g && $c >= 65 && $c <= 70) {
                    this.STATE = 2;
                    return 1;
                }
                if (__g && $c >= 97 && $c <= 102) {
                    this.STATE = 2;
                    return 1;
                }
                return 0;
            }
            case 3: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 4;
                    return 1;
                }
                if (__g && $c >= 65 && $c <= 70) {
                    this.STATE = 4;
                    return 1;
                }
                if (__g && $c >= 97 && $c <= 102) {
                    this.STATE = 4;
                    return 1;
                }
                return 0;
            }
            case 4: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 4;
                    return 1;
                }
                if (__g && $c >= 65 && $c <= 70) {
                    this.STATE = 4;
                    return 1;
                }
                if (__g && $c >= 97 && $c <= 102) {
                    this.STATE = 4;
                    return 1;
                }
                return 0;
            }
            case 1: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 2;
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    private boolean intx_accepted() {
        return this.STATE == 2 || this.STATE == 4;
    }

    int intx_execaction(int $c) {
        switch (this.STATE) {
            case 3: {
                this.dbf = new StringBuffer();
                break;
            }
            case 0: {
                this.ia();
                break;
            }
            case 4: {
                this.ad($c);
                break;
            }
            case 2: {
                this.an($c);
                break;
            }
            case 1: {
                this.an($c);
            }
        }
        return 1;
    }

    boolean intx_isend() {
        return false;
    }

    private int real_step(Reader __rd, int $c) throws IOException {
        boolean __g = true;
        switch (this.STATE) {
            case 0: {
                if (__g && $c == 43) {
                    this.STATE = 1;
                    return 1;
                }
                if (__g && $c == 45) {
                    this.STATE = 1;
                    return 1;
                }
                if (__g && $c == 46) {
                    this.STATE = 2;
                    return 1;
                }
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 3;
                    return 1;
                }
                return 0;
            }
            case 3: {
                if (__g && $c == 46) {
                    this.STATE = 2;
                    return 1;
                }
                if (__g && $c == 47) {
                    this.STATE = 4;
                    return 1;
                }
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 3;
                    return 1;
                }
                if (__g && $c == 69) {
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 70) {
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 101) {
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 102) {
                    this.STATE = 5;
                    return 1;
                }
                return 0;
            }
            case 5: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 6;
                    return 1;
                }
                return 0;
            }
            case 6: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 6;
                    return 1;
                }
                return 0;
            }
            case 4: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 7;
                    return 1;
                }
                return 0;
            }
            case 7: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 7;
                    return 1;
                }
                return 0;
            }
            case 2: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 8;
                    return 1;
                }
                return 0;
            }
            case 8: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 8;
                    return 1;
                }
                if (__g && $c == 69) {
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 70) {
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 101) {
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 102) {
                    this.STATE = 5;
                    return 1;
                }
                return 0;
            }
            case 1: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 3;
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    private boolean real_accepted() {
        return this.STATE == 3 || this.STATE == 6 || this.STATE == 7 || this.STATE == 8;
    }

    int real_execaction(int $c) {
        switch (this.STATE) {
            case 8: {
                this.af($c);
                break;
            }
            case 3: {
                this.an($c);
                break;
            }
            case 7: {
                this.ad($c);
                break;
            }
            case 2: {
                this.af($c);
                break;
            }
            case 0: {
                this.ia();
                break;
            }
            case 1: {
                this.an($c);
                break;
            }
            case 5: {
                this.af($c);
                break;
            }
            case 4: {
                this.dbf = new StringBuffer();
                break;
            }
            case 6: {
                this.af($c);
            }
        }
        return 1;
    }

    boolean real_isend() {
        return false;
    }

    private int nanoNumberParser_step(Reader __rd, int $c) throws IOException {
        boolean __g = true;
        switch (this.STATE) {
            case 0: {
                if (__g && $c == 35) {
                    this.STATE = 1;
                    return 1;
                }
                return 0;
            }
            case 1: {
                if (__g && $c == 98) {
                    this.STATE = 2;
                    return 1;
                }
                if (__g && $c == 100) {
                    this.STATE = 3;
                    return 1;
                }
                if (__g && $c == 111) {
                    this.STATE = 4;
                    return 1;
                }
                if (__g && $c == 120) {
                    this.STATE = 5;
                    return 1;
                }
                return 0;
            }
            case 5: {
                this.__stkpush(6, this.ENGINE_intx);
                this.STATE = 0;
                return -1;
            }
            case 6: {
                return 0;
            }
            case 4: {
                this.__stkpush(7, this.ENGINE_intx);
                this.STATE = 0;
                return -1;
            }
            case 7: {
                return 0;
            }
            case 3: {
                this.__stkpush(8, this.ENGINE_number);
                this.STATE = 0;
                return -1;
            }
            case 8: {
                return 0;
            }
            case 2: {
                this.__stkpush(9, this.ENGINE_intx);
                this.STATE = 0;
                return -1;
            }
            case 9: {
                return 0;
            }
            case 10: {
                return 0;
            }
        }
        return 0;
    }

    private boolean nanoNumberParser_accepted() {
        return this.STATE == 0 || this.STATE == 6 || this.STATE == 7 || this.STATE == 8 || this.STATE == 9 || this.STATE == 10;
    }

    int nanoNumberParser_execaction(int $c) {
        switch (this.STATE) {
            case 8: {
                this.num = this.num != null ? this.num : this.real;
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 10: {
                this.num = LispBoolean.FALSE;
                break;
            }
            case 7: {
                this.num = this.getr(8);
                break;
            }
            case 3: {
                break;
            }
            case 9: {
                this.num = this.getr(2);
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.num = this.getr(16);
                break;
            }
        }
        return 1;
    }

    boolean nanoNumberParser_isend() {
        return false;
    }

    private int number_step(Reader __rd, int $c) throws IOException {
        boolean __g = true;
        switch (this.STATE) {
            case 0: {
                if (__g && $c == 45) {
                    this.UNGET($c);
                    this.STATE = 1;
                    return 1;
                }
                this.__stkpush(2, this.ENGINE_real);
                this.STATE = 0;
                return -1;
            }
            case 2: {
                if (__g && $c == 43) {
                    this.STATE = 1;
                    return 1;
                }
                if (__g && $c == 45) {
                    this.UNGET($c);
                    this.STATE = 1;
                    return 1;
                }
                if (__g && $c == 64) {
                    this.STATE = 3;
                    return 1;
                }
                return 0;
            }
            case 3: {
                this.__stkpush(4, this.ENGINE_real);
                this.STATE = 0;
                return -1;
            }
            case 4: {
                return 0;
            }
            case 1: {
                if (__g && $c == 45) {
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 105) {
                    this.STATE = 6;
                    return 1;
                }
                this.__stkpush(7, this.ENGINE_real);
                this.STATE = 0;
                return -1;
            }
            case 7: {
                if (__g && $c == 105) {
                    this.STATE = 8;
                    return 1;
                }
                return 0;
            }
            case 8: {
                return 0;
            }
            case 6: {
                return 0;
            }
            case 5: {
                if (__g && $c == 105) {
                    this.STATE = 9;
                    return 1;
                }
                return 0;
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    private boolean number_accepted() {
        return this.STATE == 2 || this.STATE == 4 || this.STATE == 6 || this.STATE == 8 || this.STATE == 9;
    }

    int number_execaction(int $c) {
        switch (this.STATE) {
            case 7: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.num = LispComplex.newComplex(this.real, LispInteger.ONE);
                break;
            }
            case 0: {
                this.ib();
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                this.num = LispComplex.newPolar(this.real.getRealDouble(), this.getr().getRealDouble());
                break;
            }
            case 2: {
                this.real = this.getr();
                break;
            }
            case 9: {
                this.num = LispComplex.newComplex(this.real, LispInteger.valueOf(-1));
                break;
            }
            case 8: {
                this.num = LispComplex.newComplex(this.real, this.getr());
            }
        }
        return 1;
    }

    boolean number_isend() {
        return false;
    }

    void __stkpush(int st, Engine en) {
        if (this.__slen >= this.__sts.length) {
            int[] a = new int[this.__sts.length * 2];
            Engine[] b = new Engine[this.__stk.length * 2];
            Object[][] c = new Object[this.__stk.length * 2][];
            System.arraycopy(this.__sts, 0, a, 0, this.__sts.length);
            System.arraycopy(this.__stk, 0, b, 0, this.__stk.length);
            System.arraycopy(this.__stv, 0, c, 0, this.__stv.length);
            this.__sts = a;
            this.__stk = b;
            this.__stv = c;
        }
        this.__sts[this.__slen] = st;
        this.__stk[this.__slen] = en;
        this.__stv[this.__slen++] = new Object[en.stateSize()];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int _parse(Reader rd, int x) throws IOException {
        boolean b = false;
        int c = x;
        b = this.__stk[this.__slen - 1].accepted();
        if (rd == null) {
            throw new RuntimeException("can not recurse");
        }
        switch (this.__stk[this.__slen - 1].execaction(-2)) {
            case -1: {
                this.__logprint("accept " + this.__stk[this.__slen - 1]);
                return -1;
            }
            case -9: {
                this.__logprint("match failed: begin");
                this.__puttrace();
                return -9;
            }
            case -91: {
                this.__logprint("machine halted: begin");
                return -91;
            }
            case -72: {
                this.__logprint("machine halted: begin");
                return -72;
            }
        }
        try {
            do {
                Engine en = this.__stk[this.__slen - 1];
                if (c < 0) continue;
                int a = en.step(rd, c);
                if (a > 0) {
                    this.__logprint("transit to state " + this.STATE + ": ", c);
                    b = en.accepted();
                    switch (en.execaction(c)) {
                        case -1: {
                            this.__logprint("accept " + this.__stk[this.__slen - 1]);
                            this.UNGET(c);
                            return -1;
                        }
                        case -9: {
                            this.__logprint("match failed: ", c);
                            this.__puttrace();
                            this.UNGET(c);
                            return -9;
                        }
                        case -91: {
                            this.__logprint("machine halted: ", c);
                            return -91;
                        }
                        case -72: {
                            this.__logprint("machine halted: ", c);
                            return -72;
                        }
                    }
                    continue;
                }
                if (a < 0) {
                    this.__logprint("entering " + this.__stk[this.__slen - 1]);
                    return c;
                }
                if (b) {
                    this.__logprint("accept " + this.__stk[this.__slen - 1]);
                    this.UNGET(c);
                    return -1;
                }
                this.__logprint("match failed: ", c);
                this.__puttrace();
                this.UNGET(c);
                return -9;
            } while ((c = this._read(rd)) >= 0);
            if (!b) {
                throw new TokenException();
            }
            return -1;
        }
        catch (RuntimeException e) {
            this.UNGET(c);
            throw e;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean parse(Reader rd, Engine entry) throws IOException {
        block15: {
            c = -1;
            this.__logopen();
            try {
                this.__stkpush(0, entry);
lbl5:
                // 2 sources

                block7: while (true) {
                    block14: {
                        try {
                            block13: {
                                block8: while (true) {
                                    if ((c = this._parse(rd, c)) >= 0) {
                                        continue;
                                    }
                                    if (c != -9) break block13;
                                    do {
                                        if ((this.STATE = this.__stk[this.__slen - 1].deadState()) < 0) ** break;
                                        continue block8;
                                    } while (this.__slen-- > 1);
                                    break;
                                }
                                throw new TokenException();
                            }
                            if (c == -91) {
                                this.__slen = 0;
                            }
                            break;
                        }
                        catch (RuntimeException e) {
                            break block14;
                        }
                        this.__logclose();
                        return true;
                    }
                    do {
                        if ((this.STATE = this.__stk[this.__slen - 1].recover(e)) >= 0) continue block7;
                    } while (this.__slen-- > 1);
                    throw new TokenException();
                }
            }
            catch (Throwable var5_6) {
                this.__logclose();
                throw var5_6;
            }
            {
                if (c != -72) ** GOTO lbl-1000
                this.__slen = 0;
            }
            this.__logclose();
            return false;
lbl-1000:
            // 1 sources

            {
                if (this.__slen <= 1) break block15;
                this.STATE = this.__sts[--this.__slen];
                ** continue;
            }
        }
        var6_5 = this.__stk[this.__slen - 1].accepted();
        this.__logclose();
        return var6_5;
    }

    boolean parse(Reader rd) throws IOException {
        return this.parse(rd, this.ENGINE_nanoNumberParser);
    }

    boolean parse(InputStream rd) throws IOException {
        return this.parse(new InputStreamReader(rd));
    }

    static boolean parseAll(Reader rd) throws IOException {
        NanoNumberParser o = new NanoNumberParser();
        return o.parse(rd);
    }

    static boolean parseAll(InputStream rd) throws IOException {
        return NanoNumberParser.parseAll(new InputStreamReader(rd));
    }

    static abstract class Engine {
        Engine() {
        }

        abstract int step(Reader var1, int var2) throws IOException;

        abstract boolean accepted();

        abstract int execaction(int var1);

        abstract boolean isend();

        abstract int recover(Exception var1);

        abstract int deadState();

        abstract int stateSize();
    }

    static class TokenException
    extends RuntimeException {
        TokenException() {
        }
    }
}

