/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.translate;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;

import net.morilib.nina.Nina;
import net.morilib.nina.NinaParser;
import net.morilib.nina.NinaSubautomata;
import net.morilib.nina.Quadro;
import net.morilib.nina.cmd.NinaInfo;
import net.morilib.nina.cmd.NinatOptions;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/12/11
 */
public class ProxyNinaTranslator implements NinaTranslator {

	//
	private AbstractNinaTranslator proxy = null;

	/* (non-Javadoc)
	 * @see net.morilib.nina.translate.NinaTranslator#reportStatistics(java.io.PrintStream)
	 */
	@Override
	public void reportStatistics(PrintStream std) {
		proxy.reportStatistics(std);
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.compiler.NinaTranslater#translate(java.io.Reader, java.io.PrintWriter)
	 */
	@Override
	public void translate(String name, Reader rd, NinaInfo opts,
			List<String> libs, Map<String, String> prms,
			PrintStream ot) throws IOException {
		NinaSubautomata s;
		Quadro q;
		String l;
		Object o;
		String n;

		n = Nina.getFAName(null, name);
		s = new NinaSubautomata(n);
		s.put(n, null);
		q = Quadro.read(n, rd, libs);
		o = NinaParser.complie(q, libs, prms, s, opts.getConsole(),
				opts);
		l = q.getOption("targetLanguage");
		if(l != null && !l.equals("")) {
			proxy = AbstractNinaTranslator.getTranslator(l);
		} else {
			proxy = new NinaTranslatorJava();
		}
		proxy.quadro = q;
		proxy.translateQuadro(n, o, opts, prms, s, ot);
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.translate.NinaTranslator#compile(java.lang.String, java.io.Reader, net.morilib.nina.cmd.NinatOptions, java.util.Map)
	 */
	@Override
	public Object compile(String name, Reader rd, NinatOptions opts,
			List<String> libs,
			Map<String, String> prms) throws IOException {
		NinaSubautomata s;
		Quadro q;
		String n;

		n = Nina.getFAName(null, name);
		s = new NinaSubautomata(n);
		s.put(n, null);
		q = Quadro.read(n, rd, libs);
		return NinaParser.complie(q, opts.getLibraryList(), prms, s,
				opts.getConsole(), opts);
	}

}
