package net.morilib.nina.translate;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.deculture.parser.DecultureDefinition;
import net.morilib.nina.LRObject;
import net.morilib.nina.Quadro;
import net.morilib.nina.translate.sh.ShNinatBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public abstract class LRTranslator {

	class CatDefinitionPart implements ShProcess {

		@Override
		public int main(ShEnvironment env, ShFileSystem fs,
				InputStream in, PrintStream out, PrintStream err,
				String... args) throws IOException {
			LRObject lr = getlr(args);

			out.println(lr.getDefinition().getDefinition());
			return 0;
		}

	}

	class EchoLexer implements ShProcess {

		@Override
		public int main(ShEnvironment env, ShFileSystem fs,
				InputStream in, PrintStream out, PrintStream err,
				String... args) throws IOException {
			LRObject lr = getlr(args);

			out.print(lr.getDefinition().getLexerName());
			return 0;
		}

	}

	/**
	 * 
	 */
	protected Quadro quadro;

	//
	LRTranslator(Quadro q) {
		quadro = q;
	}

	//
	LRObject getlr(String[] args) {
		return quadro.getLRObject(args[1]);
	}

	/**
	 * 
	 * @return
	 */
	public abstract void setCommands(ShNinatBuiltInCommands c);

	/**
	 * 
	 * @return
	 */
	public abstract String getReturn();

	/**
	 * 
	 * @param buf
	 * @param def
	 * @param g
	 * @param z
	 */
	public abstract void translateVariable(StringBuffer buf,
			DecultureDefinition def, Object g, int z);

}
