/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.arith;

public class ShExprRelop1 extends ShExprOp {

	public static final ShExprRelop1 LT =
		new ShExprRelop1(ShExprOpType.LT, "<");
	public static final ShExprRelop1 LE =
		new ShExprRelop1(ShExprOpType.LE, "<=");
	public static final ShExprRelop1 GT =
		new ShExprRelop1(ShExprOpType.GT, ">");
	public static final ShExprRelop1 GE =
		new ShExprRelop1(ShExprOpType.GE, ">=");

	private ShExprOpType operator;

	private ShExprRelop1(ShExprOpType op, String desc) {
		super(desc);
		operator = op;
	}

	public ShExprOpType getRelation() {
		return operator;
	}

}
