#
# Copyright 2013-2014 Yuichiro Moriguchi
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
sed "s/@@YEAR@@/$YEAR/g
s/@@OWNER@@/$OWNER/g
s/@@ORGANIZATION@@/$ORGANIZATION/g" /license/$LICENSE

[ -z "$PACKAGE" ] || echo "package $PACKAGE;"
[ -z "$EXTENDS" ] || [ -z "$EXTENDS" ] || cln=':'
print_imports
cat definition

if [ -z "$TYPE" ]
then
  nullsym='-1'
  streamsym='System.IO.TextReader'
  rdt='System.IO.TextReader'
else
  nullsym='null'
  rdt="Iterable<$CTYPE>"
  streamsym='java.util.Iterator'
fi
cat << EOF

public $ABSTRACT class ${CLASSNAME}${TEMPLATE} $cln $EXTENDS $IMPLEMENTS
{

	public static readonly object ENDMARKER = new {};
	readonly ${CLASSNAME}${TEMPLATE} __this__;
	const int INITIAL = 0;

	private int STATE;
	private object iseof = null;
	private $CTYPE unread = $nullsym;

	public ${CLASSNAME}()
	{
		__this__ = this;
	}
EOF
cat fragment
#cat fragment | replace_action
echo

if [ -z "$TYPE" ]
then
  cat << EOF
	private int _Read(System.IO.TextReader rd)
	{
		int c;

		if(unread >= 0)
		{
			c = unread;
			unread = -1;
		}
		else if((c = rd.Read()) < 0)
		{
			iseof = ENDMARKER;
		}
		return c;
	}
EOF
else
  cat << EOF
	private $CTYPE _Read(System.Collections.IEnumerator itr)
	{
		$CTYPE c;

		if(unread != null)
		{
			c = unread;
			unread = null;
			return c;
		}
		else if(itr.MoveNext())
		{
			return ($CTYPE)itr.Current;
		}
		else
		{
			return null;
		}
	}
EOF
fi

echo
echo "	private int _Step($CTYPE __c__)"
echo "	{"
echo '		switch(STATE)'
echo '		{'
print_states
echo '		}'
echo '		return 0;'
echo '	}'
echo

echo '	private bool _Accepted()'
echo '	{'
print_accepts
echo '	}'
echo

if [ -z "$TYPE" ]
then
  echo '	private object _Gettoken(System.Text.StringBuilder b)'
  echo '	{'
  echo '		string __r__ = b.ToString();'
else
  echo "	private object _Gettoken($CTYPE[] b)"
  echo "	{"
  echo "		$CTYPE[] __r__ = b;"
fi
echo
echo '		switch(STATE)'
echo '		{'
print_token
echo '		default:  return null;'
echo '		}'
echo '	}'
echo

echo '	private bool _Isdead()'
echo '	{'
print_nfadead
echo '	}'

if [ -z "$TYPE" ]
then
  cat << EOF
	public void reset() {
		STATE = 0;
		iseof = null;
		unread = -1;
	}

	public object searchToken(System.IO.TextReader rd)
	{
		System.Text.StringBuilder b = new System.Text.StringBuilder();
		bool f = false;
		object o = null;
		int c;

		if(iseof != null)  return iseof;
		while((c = _Read(rd)) >= 0) {
			b.Append((char)c);
			if(_Step(c) == 0)
			{
				if(f)
				{
					unread = c;
					STATE = 0;
					return o;
				}
				else
				{
					return null;
				}
			}
			else if(f = _Accepted())
			{
				o = _Gettoken(b);
				if(_Isdead())
				{
					STATE = 0;
					return o;
				}
			}
			else if(_Isdead())
			{
				return null;
			}
		}
		return f ? o : null;
	}
EOF
else
  cat << EOF
	public void reset() {
		STATE = 0;
		iseof = null;
		unread = null;
	}

	public object searchToken(System.Collections.IEnumerator itr)
	{
		$CTYPE[] b = new $CTYPE[0];
		bool f = false;
		object o = null;
		$CTYPE c;

		if(iseof != null)  return iseof;
		while((c = _Read(itr)) != null)
		{
			Array.Resize(ref b, b.Length + 1);
			b[b.Length - 1] = c;
			if(_Step(c) == 0)
			{
				if(f)
				{
					unread = c;
					STATE = 0;
					return o;
				}
				else
				{
					return null;
				}
			}
			else if(f = _Accepted())
			{
				o = _Gettoken(b);
				if(_Isdead())
				{
					STATE = 0;
					return o;
				}
			}
			else if(_Isdead())
			{
				return null;
			}
		}
		return f ? o : null;
	}
EOF
fi
echo
echo '}'
