/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.translate;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Map;

import net.morilib.nina.cmd.NinatOptions;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/23
 */
public interface NinaTranslator {

	/**
	 * 
	 * @param name
	 * @param rd
	 * @param opts
	 * @param prms
	 * @throws IOException
	 */
	public void translate(String name, Reader rd, NinatOptions opts,
			Map<String, String> prms) throws IOException;

	/**
	 * 
	 * @param name
	 * @param rd
	 * @param opts
	 * @param prms
	 * @return
	 * @throws IOException
	 */
	public Object compile(String name, Reader rd, NinatOptions opts,
			Map<String, String> prms) throws IOException;

	/**
	 * 
	 * @param std
	 */
	public void reportStatistics(PrintStream std);

}
