// Translated by Nina
// This source code is under public domain

package net.morilib.nina.translate;
import net.morilib.automata.DFAState;

public  class ReplaceAction   {

	static class TokenException extends RuntimeException {
	}

	static abstract class Engine {
		abstract int step(java.io.Reader __rd, int c) throws java.io.IOException;
		abstract boolean accepted();
		abstract int execaction(int c);
		abstract boolean isend();
		abstract int recover(Exception e);
		abstract int deadState();
		abstract int stateSize();
	}
	private static final int NINA_ACCEPT = -1;
	private static final int NINA_FAIL = -9;
	private static final int NINA_HALT_ACCEPT = -91;
	private static final int NINA_HALT_REJECT = -72;
	private static final int NINA_BEGIN = -2;
	private static final int NINA_STACKLEN = 72;
	static final int INITIAL = 0;

	private int STATE;
	private int[] __sts = new int[NINA_STACKLEN];
	private Engine[] __stk = new Engine[NINA_STACKLEN];
	private Object[][] __stv = new Object[NINA_STACKLEN][];
	private int __slen = 0;

	private int unread = -1;

private static final String STATELABEL = "STATELABEL_";
private static final int SL_LEN = STATELABEL.length();

private boolean exeo = false;
private StringBuffer b1, ot;
private AbstractNinaTranslator action;
private String lb;
private int cn;

ReplaceAction() {}

private void _init() {
	if(b1.length() > 0)  b1 = new StringBuffer();
}

private void _apc(int c) {
	if(c >= 0)  ot.appendCodePoint(c);
}

private void _apb(int c) {
	b1.appendCodePoint(c);
}

private void _apbb() {
	b1.append('\\');
}

@SuppressWarnings("unchecked")
private void _putmp(int c) {
	String t;
	Object o;

	if(c != ';') {
		ot.append(b1.toString());
	} else if((t = b1.toString()).equals("EXIT")) {
		exeo = true;
		ot.append("return NINA_ACCEPT");
	} else if(t.equals("FAIL")) {
		exeo = true;
		ot.append("return NINA_FAIL");
	} else if(t.equals("ACCEPT")) {
		exeo = true;
		ot.append("return NINA_HALT_ACCEPT");
	} else if(t.equals("REJECT")) {
		exeo = true;
		ot.append("return NINA_HALT_REJECT");
	} else if(t.startsWith(STATELABEL)) {
		o = action.builder.getStateByLabel(t.substring(SL_LEN));
		ot.append(action.getStateNo((DFAState<Object, ?, Void>)o));
	} else {
		ot.append(t);
	}
	b1 = new StringBuffer();
}

public static String replace(String s, boolean[] a,
		AbstractNinaTranslator ac, int cn, String lb) {
	ReplaceAction c = new ReplaceAction();

	c.b1 = new StringBuffer();
	c.ot = new StringBuffer();
	c.action = ac;
	c.cn = cn;
	c.lb = lb;
	try {
		c.parse(new java.io.StringReader(s));
	} catch(java.io.IOException e) {
		throw new RuntimeException(e);
	}
	c.ot.append(c.b1);
	a[0] = c.exeo;
	return c.ot.toString();
}


	private int _read(java.io.Reader rd) throws java.io.IOException {
		int c;

		if(unread >= 0) {
			c = unread;
			unread = -1;
			__logprint("Read unread: ", c);
		} else if((c = rd.read()) >= 0) {
			__logprint("Read: ", c);
		} else {
			__logprint("Read end-of-file");
		}
		return c;
	}

	void UNGET(int c) {
		unread = c;
		__logprint("Set unread: ", c);
	}

	private void __logprint(String s, int c) {
	}

	private void __logopen() {
	}

	private void __logprint(String s) {
	}

	private void __logclose() {
	}

	private void __puttrace() {
	}


	private int replaceAction_step(java.io.Reader __rd,
			int  $c) throws java.io.IOException {
		boolean __g = true;

		switch(STATE) {
		case 0:
			if(__g && $c == '"') {
				STATE = 1;
				return 1;
			} else if(__g && $c == '$') {
				STATE = 2;
				return 1;
			} else if(__g && $c == '%') {
				STATE = 3;
				return 1;
			} else if(__g && $c >= 'A' && $c <= 'Z') {
				STATE = 4;
				return 1;
			} else if(__g && $c == '_') {
				STATE = 4;
				return 1;
			} else if(__g && $c >= 'a' && $c <= 'z') {
				STATE = 4;
				return 1;
			} else {
				STATE = 0;
				return 1;
			}
		case 4:
			if(__g && $c >= '0' && $c <= '9') {
				STATE = 4;
				return 1;
			} else if(__g && $c >= 'A' && $c <= 'Z') {
				STATE = 4;
				return 1;
			} else if(__g && $c == '_') {
				STATE = 4;
				return 1;
			} else if(__g && $c >= 'a' && $c <= 'z') {
				STATE = 4;
				return 1;
			} else {
				STATE = 5;
				return 1;
			}
		case 5:
			return 0;
		case 3:
			if(__g && $c == '%') {
				STATE = 6;
				return 1;
			} else if(__g && $c >= '0' && $c <= '9') {
				STATE = 7;
				return 1;
			} else if(__g && $c == '=') {
				STATE = 8;
				return 1;
			} else if(__g && $c >= 'A' && $c <= 'Z') {
				STATE = 7;
				return 1;
			} else if(__g && $c >= 'a' && $c <= 'z') {
				STATE = 7;
				return 1;
			} else if(__g && $c == '{') {
				STATE = 9;
				return 1;
			} else {
				UNGET($c);
				STATE = 10;
				return 1;
			}
		case 10:
			return 0;
		case 9:
			STATE = 11;
			return 1;
		case 11:
			if(__g && $c == '}') {
				STATE = 12;
				return 1;
			} else {
				STATE = 11;
				return 1;
			}
		case 12:
			return 0;
		case 8:
			if(__g && $c == '{') {
				STATE = 13;
				return 1;
			}
			return 0;
		case 13:
			if(__g && $c == '}') {
				STATE = 14;
				return 1;
			} else {
				STATE = 15;
				return 1;
			}
		case 15:
			if(__g && $c == '"') {
				STATE = 16;
				return 1;
			} else if(__g && $c == '\\') {
				STATE = 17;
				return 1;
			} else if(__g && $c == '}') {
				STATE = 14;
				return 1;
			} else {
				STATE = 15;
				return 1;
			}
		case 17:
			if(__g && $c == '"') {
				STATE = 15;
				return 1;
			} else if(__g && $c == '\\') {
				STATE = 15;
				return 1;
			} else {
				_apbb();
				STATE = 15;
				return 1;
			}
		case 16:
			if(__g && $c == '"') {
				STATE = 15;
				return 1;
			} else if(__g && $c == '\\') {
				STATE = 18;
				return 1;
			} else {
				STATE = 16;
				return 1;
			}
		case 18:
			if(__g && $c == '"') {
				STATE = 16;
				return 1;
			} else if(__g && $c == '\\') {
				STATE = 16;
				return 1;
			} else {
				_apbb();
				STATE = 16;
				return 1;
			}
		case 14:
			return 0;
		case 7:
			if(__g && $c >= '0' && $c <= '9') {
				STATE = 7;
				return 1;
			} else if(__g && $c >= 'A' && $c <= 'Z') {
				STATE = 7;
				return 1;
			} else if(__g && $c >= 'a' && $c <= 'z') {
				STATE = 7;
				return 1;
			} else {
				UNGET($c);
				STATE = 12;
				return 1;
			}
		case 6:
			return 0;
		case 2:
			if(__g && $c == '$') {
				STATE = 19;
				return 1;
			} else if(__g && $c >= '0' && $c <= '9') {
				STATE = 20;
				return 1;
			} else if(__g && $c >= 'A' && $c <= 'Z') {
				STATE = 20;
				return 1;
			} else if(__g && $c >= 'a' && $c <= 'z') {
				STATE = 20;
				return 1;
			} else if(__g && $c == '{') {
				STATE = 21;
				return 1;
			} else {
				UNGET($c);
				STATE = 22;
				return 1;
			}
		case 22:
			return 0;
		case 21:
			STATE = 23;
			return 1;
		case 23:
			if(__g && $c == '}') {
				STATE = 24;
				return 1;
			} else {
				STATE = 23;
				return 1;
			}
		case 24:
			return 0;
		case 20:
			if(__g && $c >= '0' && $c <= '9') {
				STATE = 20;
				return 1;
			} else if(__g && $c >= 'A' && $c <= 'Z') {
				STATE = 20;
				return 1;
			} else if(__g && $c >= 'a' && $c <= 'z') {
				STATE = 20;
				return 1;
			} else {
				UNGET($c);
				STATE = 24;
				return 1;
			}
		case 19:
			return 0;
		case 1:
			if(__g && $c == '"') {
				STATE = 0;
				return 1;
			} else {
				STATE = 1;
				return 1;
			}
		}
		return 0;
	}
	private boolean replaceAction_accepted() {
		return (STATE == 0 ||
				STATE == 1 ||
				STATE == 2 ||
				STATE == 3 ||
				STATE == 4 ||
				STATE == 5 ||
				STATE == 6 ||
				STATE == 7 ||
				STATE == 9 ||
				STATE == 10 ||
				STATE == 11 ||
				STATE == 12 ||
				STATE == 14 ||
				STATE == 19 ||
				STATE == 21 ||
				STATE == 20 ||
				STATE == 23 ||
				STATE == 22 ||
				STATE == 24);
	}

	int replaceAction_execaction(int  $c) {
		switch(STATE) {
		case 23:
			_apb($c);
			break;
		case 0:
			_apc($c);               
_init();
			break;
		case 1:
			{ _apc($c); }
			break;
		case 4:
			{ _apb($c);    }
			break;
		case 6:
			action.appendMyPosition(ot, lb, cn);
STATE = INITIAL;
			break;
		case 9:
			break;
		case 3:
			break;
		case 10:
			ot.append('%'); 
STATE = INITIAL;
			break;
		case 17:
			break;
		case 22:
			ot.append('$'); 
STATE = INITIAL;
			break;
		case 8:
			break;
		case 5:
			{ _putmp($c);       
  STATE = INITIAL;  
  UNGET($c);       }
			break;
		case 16:
			_apb($c);
			break;
		case 20:
			_apb($c);
			break;
		case 13:
			break;
		case 2:
			break;
		case 11:
			_apb($c);
			break;
		case 19:
			action.appendReturn(ot);
STATE = INITIAL;
			break;
		case 14:
			ot.append(action.executeMeta(b1.toString()));
STATE = INITIAL;
			break;
		case 24:
			action.appendValue(ot, b1);
b1 = new StringBuffer();   
STATE = INITIAL;
			break;
		case 12:
			action.appendLvalue(ot, b1);
b1 = new StringBuffer();    
STATE = INITIAL;
			break;
		case 15:
			_apb($c);
			break;
		case 7:
			_apb($c);
			break;
		case 18:
			break;
		case 21:
			break;
		}
		return 1;
	}

	boolean replaceAction_isend() {
		return false;
	}

	private final Engine ENGINE_replaceAction = new Engine() {

		int step(java.io.Reader __rd,
				int c) throws java.io.IOException {
			return replaceAction_step(__rd, c);
		}

		boolean accepted() {
			return replaceAction_accepted();
		}

		int execaction(int c) {
			return replaceAction_execaction(c);
		}

		boolean isend() {
			return replaceAction_isend();
		}

		int recover(Exception e) {
			return -1;
		}

		int deadState() {
			return -1;
		}

		int stateSize() {
			return 25;
		}

		public String toString() {
			return "replaceAction";
		}

	};

	void __stkpush(int st, Engine en) {
		Object[][] c;
		Engine[] b;
		int[] a;

		if(__slen >= __sts.length) {
			a = new int[__sts.length * 2];
			b = new Engine[__stk.length * 2];
			c = new Object[__stk.length * 2][];
			System.arraycopy(__sts, 0, a, 0, __sts.length);
			System.arraycopy(__stk, 0, b, 0, __stk.length);
			System.arraycopy(__stv, 0, c, 0, __stv.length);
			__sts = a;
			__stk = b;
			__stv = c;
		}
		__sts[__slen] = st;
		__stk[__slen] = en;
		__stv[__slen++] = new Object[en.stateSize()];
	}

	private int _parse(java.io.Reader rd,
			int x) throws java.io.IOException {
		boolean b = false;
		int c = x, a;
		Engine en;

		b = __stk[__slen - 1].accepted();
		if(rd == null) {
			throw new RuntimeException("can not recurse");
		} else {
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_ACCEPT:
				__logprint("accept " + __stk[__slen - 1]);
				return NINA_ACCEPT;
			case NINA_FAIL:
				__logprint("match failed: begin");
				__puttrace();
				return NINA_FAIL;
			case NINA_HALT_ACCEPT:
				__logprint("machine halted: begin");
				return NINA_HALT_ACCEPT;
			case NINA_HALT_REJECT:
				__logprint("machine halted: begin");
				return NINA_HALT_REJECT;
			}
		}

		try {
			do {
				en = __stk[__slen - 1];
				if(c < 0) {
					// do nothing
				} else if((a = en.step(rd, c)) > 0) {
					__logprint("transit to state " + STATE + ": ", c);
					b = en.accepted();
					switch(en.execaction(c)) {
					case NINA_ACCEPT:
						__logprint("accept " + __stk[__slen - 1]);
						UNGET(c);
						return NINA_ACCEPT;
					case NINA_FAIL:
						__logprint("match failed: ", c);
						__puttrace();
						UNGET(c);
						return NINA_FAIL;
					case NINA_HALT_ACCEPT:
						__logprint("machine halted: ", c);
						return NINA_HALT_ACCEPT;
					case NINA_HALT_REJECT:
						__logprint("machine halted: ", c);
						return NINA_HALT_REJECT;
					}
				} else if(a < 0) {
					__logprint("entering " + __stk[__slen - 1]);
					return c;
				} else if(b) {
					__logprint("accept " + __stk[__slen - 1]);
					UNGET(c);
					return NINA_ACCEPT;
				} else {
					__logprint("match failed: ", c);
					__puttrace();
					UNGET(c);
					return NINA_FAIL;
				}
			} while((c = _read(rd)) >= 0);
			if(!b)  throw new TokenException();
			return NINA_ACCEPT;
		} catch(RuntimeException e) {
			UNGET(c);
			throw e;
		}
	}

	 boolean parse(java.io.Reader rd,
			Engine entry) throws java.io.IOException {
		int c = -1;

		__logopen();
		try {
			__stkpush(0, entry);
			while(true) {
				try {
					if((c = _parse(rd, c)) >= 0) {
						// do nothing
					} else if(c == NINA_FAIL) {
						while((STATE = __stk[__slen - 1].deadState()) < 0) {
							if(__slen-- <= 1) {
								throw new TokenException();
							}
						}
					} else if(c == NINA_HALT_ACCEPT) {
						__slen = 0;
						return true;
					} else if(c == NINA_HALT_REJECT) {
						__slen = 0;
						return false;
					} else if(__slen > 1) {
						STATE = __sts[--__slen];
					} else {
						break;
					}
				} catch(RuntimeException e) {
					if(__slen <= 0)  throw e;
					while((STATE = __stk[__slen - 1].recover(e)) < 0) {
						if(__slen-- <= 1) {
							throw e;
						}
					}
				}
			}
			return __stk[__slen - 1].accepted();
		} finally {
			__logclose();
		}
	}

	 boolean parse(
			java.io.Reader rd) throws java.io.IOException {
		return parse(rd, ENGINE_replaceAction);
	}

	 boolean parse(
			java.io.InputStream rd) throws java.io.IOException {
		return parse(new java.io.InputStreamReader(rd));
	}

	 static boolean parseAll(
			java.io.Reader rd) throws java.io.IOException {
		ReplaceAction o = new ReplaceAction();

		return o.parse(rd);
	}

	 static boolean parseAll(
			java.io.InputStream rd) throws java.io.IOException {
		return parseAll(new java.io.InputStreamReader(rd));
	}

}
