/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.arith;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.arith.ShExprIntegerToken;
import net.morilib.sh.arith.ShExprLexer;
import net.morilib.sh.arith.ShExprOp;
import net.morilib.sh.arith.ShExprOpType;
import net.morilib.sh.arith.ShExprRelop1;
import net.morilib.sh.arith.ShExprRelop2;
import net.morilib.sh.arith.ShExprSymbol;
import net.morilib.sh.arith.ShExprSyntaxException;
import net.morilib.sh.arith.ShExprToken;

public final class ShExprParser {
    private static final BigInteger MONE = BigInteger.valueOf(-1L);

    private ShExprParser() {
    }

    private static BigInteger findvar(ShEnvironment env, ShExprToken t) {
        try {
            String s = env.find(t.getString());
            if (s.equals("")) {
                return BigInteger.ZERO;
            }
            return new BigInteger(s);
        }
        catch (NumberFormatException e1) {
            throw new ShExprSyntaxException();
        }
    }

    private static BigInteger bindvar(ShEnvironment env, ShExprToken t, BigInteger w) {
        if (t instanceof ShExprSymbol) {
            env.bind(t.getString(), w.toString());
            return w;
        }
        throw new ShExprSyntaxException();
    }

    private static BigInteger incdecvar(ShEnvironment env, ShExprToken t, BigInteger w, boolean pre) {
        if (t instanceof ShExprSymbol) {
            String s = t.getString();
            BigInteger v = ShExprParser.findvar(env, t);
            BigInteger x = v.add(w);
            env.bind(s, x.toString());
            return pre ? x : v;
        }
        throw new ShExprSyntaxException();
    }

    private static BigInteger incvar(ShEnvironment env, ShExprToken t, boolean pre) {
        return ShExprParser.incdecvar(env, t, BigInteger.ONE, pre);
    }

    private static BigInteger decvar(ShEnvironment env, ShExprToken t, boolean pre) {
        return ShExprParser.incdecvar(env, t, MONE, pre);
    }

    static BigInteger identifier(ShEnvironment env, ShExprLexer rd) throws IOException {
        ShExprToken t = rd.getToken();
        if (t instanceof ShExprIntegerToken) {
            rd.nextToken();
            return t.getInteger();
        }
        if (t instanceof ShExprSymbol) {
            rd.nextToken();
            return ShExprParser.findvar(env, t);
        }
        if (t.equals(ShExprOp.LPAREN)) {
            rd.nextToken();
            BigInteger e = ShExprParser.parseExpression(env, rd);
            rd.eatToken(ShExprOp.RPAREN);
            return e;
        }
        throw new ShExprSyntaxException();
    }

    static BigInteger incdec1(ShEnvironment env, ShExprLexer rd) throws IOException {
        ShExprToken t = rd.getToken();
        if (t.equals(ShExprOp.INC)) {
            return ShExprParser.incvar(env, rd.nextToken(), true);
        }
        if (t.equals(ShExprOp.DEC)) {
            return ShExprParser.decvar(env, rd.nextToken(), true);
        }
        return ShExprParser.identifier(env, rd);
    }

    static BigInteger incdec2(ShEnvironment env, ShExprLexer rd) throws IOException {
        ShExprToken t = rd.getToken();
        if (!(t instanceof ShExprSymbol)) {
            return ShExprParser.incdec1(env, rd);
        }
        ShExprToken x = rd.nextToken();
        if (x.equals(ShExprOp.INC)) {
            return ShExprParser.incvar(env, t, false);
        }
        if (x.equals(ShExprOp.DEC)) {
            return ShExprParser.decvar(env, t, false);
        }
        rd.backToken(t);
        return ShExprParser.incdec1(env, rd);
    }

    static BigInteger unaries1(ShEnvironment env, ShExprLexer rd) throws IOException {
        ShExprToken t = rd.getToken();
        if (t.equals(ShExprOp.ADD)) {
            t = rd.nextToken();
            return ShExprParser.incdec2(env, rd);
        }
        if (t.equals(ShExprOp.SUB)) {
            t = rd.nextToken();
            return ShExprParser.incdec2(env, rd).negate();
        }
        return ShExprParser.incdec2(env, rd);
    }

    static BigInteger unaries2(ShEnvironment env, ShExprLexer rd) throws IOException {
        ShExprToken t = rd.getToken();
        if (t.equals(ShExprOp.L_NOT)) {
            t = rd.nextToken();
            return BigInteger.valueOf(ShExprParser.unaries1(env, rd).signum() != 0 ? 0 : 1);
        }
        if (t.equals(ShExprOp.B_NOT)) {
            t = rd.nextToken();
            return ShExprParser.unaries1(env, rd).not();
        }
        return ShExprParser.unaries1(env, rd);
    }

    static BigInteger pow(ShEnvironment env, ShExprLexer rd) throws IOException {
        BigInteger v = ShExprParser.unaries2(env, rd);
        if (rd.getToken().equals(ShExprOp.POW)) {
            rd.nextToken();
            return v.pow(ShExprParser.pow(env, rd).intValue());
        }
        return v;
    }

    static BigInteger factor(ShEnvironment env, ShExprLexer rd) throws IOException {
        ShExprToken t;
        ArrayList<BigInteger> l = new ArrayList<BigInteger>();
        ArrayList<ShExprToken> m = new ArrayList<ShExprToken>();
        l.add(ShExprParser.pow(env, rd));
        m.add(null);
        while ((t = rd.getToken()).equals(ShExprOp.MUL) || t.equals(ShExprOp.DIV) || t.equals(ShExprOp.MOD)) {
            m.add(t);
            rd.nextToken();
            l.add(ShExprParser.pow(env, rd));
        }
        BigInteger e = (BigInteger)l.get(0);
        int i = 1;
        while (i < l.size()) {
            if (((ShExprToken)m.get(i)).equals(ShExprOp.MUL)) {
                e = e.multiply((BigInteger)l.get(i));
            } else if (((ShExprToken)m.get(i)).equals(ShExprOp.DIV)) {
                e = e.divide((BigInteger)l.get(i));
            } else if (((ShExprToken)m.get(i)).equals(ShExprOp.MOD)) {
                e = e.remainder((BigInteger)l.get(i));
            }
            ++i;
        }
        return e;
    }

    static BigInteger term(ShEnvironment env, ShExprLexer rd) throws IOException {
        ShExprToken t;
        ArrayList<BigInteger> l = new ArrayList<BigInteger>();
        ArrayList<ShExprToken> m = new ArrayList<ShExprToken>();
        l.add(ShExprParser.factor(env, rd));
        m.add(null);
        while ((t = rd.getToken()).equals(ShExprOp.ADD) || t.equals(ShExprOp.SUB)) {
            m.add(t);
            rd.nextToken();
            l.add(ShExprParser.factor(env, rd));
        }
        BigInteger e = (BigInteger)l.get(0);
        int i = 1;
        while (i < l.size()) {
            if (((ShExprToken)m.get(i)).equals(ShExprOp.ADD)) {
                e = e.add((BigInteger)l.get(i));
            } else if (((ShExprToken)m.get(i)).equals(ShExprOp.SUB)) {
                e = e.subtract((BigInteger)l.get(i));
            }
            ++i;
        }
        return e;
    }

    static BigInteger sft(ShEnvironment env, ShExprLexer rd) throws IOException {
        ShExprToken t;
        ArrayList<BigInteger> l = new ArrayList<BigInteger>();
        ArrayList<ShExprToken> m = new ArrayList<ShExprToken>();
        l.add(ShExprParser.term(env, rd));
        m.add(null);
        while ((t = rd.getToken()).equals(ShExprOp.SHIFTL) || t.equals(ShExprOp.SHIFTR)) {
            m.add(t);
            rd.nextToken();
            l.add(ShExprParser.term(env, rd));
        }
        BigInteger e = (BigInteger)l.get(0);
        int i = 1;
        while (i < l.size()) {
            if (((ShExprToken)m.get(i)).equals(ShExprOp.SHIFTL)) {
                e = e.shiftLeft(((BigInteger)l.get(i)).intValue());
            } else if (((ShExprToken)m.get(i)).equals(ShExprOp.SHIFTR)) {
                e = e.shiftRight(((BigInteger)l.get(i)).intValue());
            }
            ++i;
        }
        return e;
    }

    static BigInteger relop1(ShEnvironment env, ShExprLexer rd) throws IOException {
        ShExprToken t;
        ArrayList<BigInteger> l = new ArrayList<BigInteger>();
        ArrayList<ShExprOpType> m = new ArrayList<ShExprOpType>();
        l.add(ShExprParser.sft(env, rd));
        m.add(null);
        while ((t = rd.getToken()) instanceof ShExprRelop1) {
            m.add(t.getRelation());
            rd.nextToken();
            l.add(ShExprParser.sft(env, rd));
        }
        BigInteger e = (BigInteger)l.get(0);
        int i = 1;
        while (i < l.size()) {
            boolean x;
            switch ((ShExprOpType)((Object)m.get(i))) {
                case LT: {
                    x = e.compareTo((BigInteger)l.get(i)) < 0;
                    break;
                }
                case LE: {
                    x = e.compareTo((BigInteger)l.get(i)) <= 0;
                    break;
                }
                case GT: {
                    x = e.compareTo((BigInteger)l.get(i)) > 0;
                    break;
                }
                case GE: {
                    x = e.compareTo((BigInteger)l.get(i)) >= 0;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            e = BigInteger.valueOf(x ? 1 : 0);
            ++i;
        }
        return e;
    }

    static BigInteger relop2(ShEnvironment env, ShExprLexer rd) throws IOException {
        ShExprToken t;
        ArrayList<BigInteger> l = new ArrayList<BigInteger>();
        ArrayList<ShExprOpType> m = new ArrayList<ShExprOpType>();
        l.add(ShExprParser.relop1(env, rd));
        m.add(null);
        while ((t = rd.getToken()) instanceof ShExprRelop2) {
            m.add(t.getRelation());
            rd.nextToken();
            l.add(ShExprParser.relop1(env, rd));
        }
        BigInteger e = (BigInteger)l.get(0);
        int i = 1;
        while (i < l.size()) {
            boolean x;
            switch ((ShExprOpType)((Object)m.get(i))) {
                case EQ: {
                    x = e.compareTo((BigInteger)l.get(i)) == 0;
                    break;
                }
                case NE: {
                    x = e.compareTo((BigInteger)l.get(i)) != 0;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            e = BigInteger.valueOf(x ? 1 : 0);
            ++i;
        }
        return e;
    }

    static BigInteger band(ShEnvironment env, ShExprLexer rd) throws IOException {
        ArrayList<BigInteger> l = new ArrayList<BigInteger>();
        l.add(ShExprParser.relop2(env, rd));
        while (rd.getToken().equals(ShExprOp.B_AND)) {
            rd.nextToken();
            l.add(ShExprParser.relop2(env, rd));
        }
        BigInteger e = (BigInteger)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = e.and((BigInteger)l.get(i));
            ++i;
        }
        return e;
    }

    static BigInteger bxor(ShEnvironment env, ShExprLexer rd) throws IOException {
        ArrayList<BigInteger> l = new ArrayList<BigInteger>();
        l.add(ShExprParser.band(env, rd));
        while (rd.getToken().equals(ShExprOp.B_XOR)) {
            rd.nextToken();
            l.add(ShExprParser.band(env, rd));
        }
        BigInteger e = (BigInteger)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = e.xor((BigInteger)l.get(i));
            ++i;
        }
        return e;
    }

    static BigInteger bor(ShEnvironment env, ShExprLexer rd) throws IOException {
        ArrayList<BigInteger> l = new ArrayList<BigInteger>();
        l.add(ShExprParser.bxor(env, rd));
        while (rd.getToken().equals(ShExprOp.B_OR)) {
            rd.nextToken();
            l.add(ShExprParser.bxor(env, rd));
        }
        BigInteger e = (BigInteger)l.get(0);
        int i = 1;
        while (i < l.size()) {
            e = e.or((BigInteger)l.get(i));
            ++i;
        }
        return e;
    }

    static BigInteger logand(ShEnvironment env, ShExprLexer rd) throws IOException {
        ArrayList<BigInteger> l = new ArrayList<BigInteger>();
        BigInteger e = BigInteger.ONE;
        l.add(ShExprParser.bor(env, rd));
        while (rd.getToken().equals(ShExprOp.L_AND)) {
            rd.nextToken();
            l.add(ShExprParser.bor(env, rd));
        }
        int i = 0;
        while (i < l.size()) {
            e = (BigInteger)l.get(i);
            if (e.signum() == 0) {
                return e;
            }
            ++i;
        }
        return e;
    }

    static BigInteger logor(ShEnvironment env, ShExprLexer rd) throws IOException {
        ArrayList<BigInteger> l = new ArrayList<BigInteger>();
        l.add(ShExprParser.logand(env, rd));
        while (rd.getToken().equals(ShExprOp.L_OR)) {
            rd.nextToken();
            l.add(ShExprParser.logand(env, rd));
        }
        int i = 0;
        while (i < l.size()) {
            if (((BigInteger)l.get(i)).signum() != 0) {
                return (BigInteger)l.get(i);
            }
            ++i;
        }
        return BigInteger.ZERO;
    }

    static BigInteger cond(ShEnvironment env, ShExprLexer rd) throws IOException {
        BigInteger e = ShExprParser.logor(env, rd);
        if (rd.getToken().equals(ShExprOp.TRI1)) {
            rd.nextToken();
            BigInteger f = ShExprParser.parseExpression(env, rd);
            rd.eatToken(ShExprOp.TRI2);
            BigInteger g = ShExprParser.parseExpression(env, rd);
            return e.signum() != 0 ? f : g;
        }
        return e;
    }

    static BigInteger assign(ShEnvironment env, ShExprLexer rd) throws IOException {
        ShExprToken t = rd.getToken();
        if (!(t instanceof ShExprSymbol)) {
            return ShExprParser.cond(env, rd);
        }
        ShExprToken s = rd.nextToken();
        if (s.equals(ShExprOp.ASSIGN)) {
            rd.nextToken();
            BigInteger v = ShExprParser.assign(env, rd);
            env.bind(t.getString(), v.toString());
            return v;
        }
        if (s.equals(ShExprOp.A_ADD)) {
            rd.nextToken();
            return ShExprParser.bindvar(env, t, ShExprParser.findvar(env, t).add(ShExprParser.assign(env, rd)));
        }
        if (s.equals(ShExprOp.A_SUB)) {
            rd.nextToken();
            return ShExprParser.bindvar(env, t, ShExprParser.findvar(env, t).subtract(ShExprParser.assign(env, rd)));
        }
        if (s.equals(ShExprOp.A_MUL)) {
            rd.nextToken();
            return ShExprParser.bindvar(env, t, ShExprParser.findvar(env, t).multiply(ShExprParser.assign(env, rd)));
        }
        if (s.equals(ShExprOp.A_DIV)) {
            rd.nextToken();
            return ShExprParser.bindvar(env, t, ShExprParser.findvar(env, t).divide(ShExprParser.assign(env, rd)));
        }
        if (s.equals(ShExprOp.A_MOD)) {
            rd.nextToken();
            return ShExprParser.bindvar(env, t, ShExprParser.findvar(env, t).remainder(ShExprParser.assign(env, rd)));
        }
        if (s.equals(ShExprOp.A_SFL)) {
            rd.nextToken();
            return ShExprParser.bindvar(env, t, ShExprParser.findvar(env, t).shiftLeft(ShExprParser.assign(env, rd).intValue()));
        }
        if (s.equals(ShExprOp.A_SFR)) {
            rd.nextToken();
            return ShExprParser.bindvar(env, t, ShExprParser.findvar(env, t).shiftRight(ShExprParser.assign(env, rd).intValue()));
        }
        if (s.equals(ShExprOp.A_BAND)) {
            rd.nextToken();
            return ShExprParser.bindvar(env, t, ShExprParser.findvar(env, t).and(ShExprParser.assign(env, rd)));
        }
        if (s.equals(ShExprOp.A_BXOR)) {
            rd.nextToken();
            return ShExprParser.bindvar(env, t, ShExprParser.findvar(env, t).xor(ShExprParser.assign(env, rd)));
        }
        if (s.equals(ShExprOp.A_BOR)) {
            rd.nextToken();
            return ShExprParser.bindvar(env, t, ShExprParser.findvar(env, t).or(ShExprParser.assign(env, rd)));
        }
        rd.backToken(t);
        return ShExprParser.cond(env, rd);
    }

    static BigInteger commaop(ShEnvironment env, ShExprLexer rd) throws IOException {
        BigInteger e = ShExprParser.assign(env, rd);
        if (rd.getToken().equals(ShExprOp.COMMA)) {
            rd.nextToken();
            return ShExprParser.commaop(env, rd);
        }
        return e;
    }

    public static BigInteger parseExpression(ShEnvironment env, ShExprLexer rd) throws IOException {
        return ShExprParser.commaop(env, rd);
    }
}

