/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.translate;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.dfa.ConvertedDFA;
import net.morilib.automata.dfa.ConvertedRangeDFA;
import net.morilib.automata.dfa.MinimizedRangeDFA;
import net.morilib.nina.DFABuilder;
import net.morilib.nina.NFABuilder;
import net.morilib.nina.Nina;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaNFA;
import net.morilib.nina.NinaParser;
import net.morilib.nina.Quadro;
import net.morilib.nina.cmd.NinatOptions;
import net.morilib.nina.metalang.NinaMetaLanguage;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.nina.translate.sh.ShNinatBuiltInCommands;
import net.morilib.nina.translate.sh.ShNinatFileSystem;
import net.morilib.sh.DefaultShRuntime;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFacade;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShRootEnvironment;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.misc.XtraceStream;

public abstract class AbstractNinaTranslator
implements NinaTranslator {
    protected DFA<Object, ?, Void> dfa;
    protected Quadro quadro;
    protected NinaAction builder;
    protected NinatOptions options;
    private int stateNo = 0;
    private Map<DFAState<Object, ?, Void>, Integer> states = new IdentityHashMap();
    private Set<Integer> accepts = new HashSet<Integer>();
    private Stack<DFAState<Object, ?, Void>> trz = new Stack();
    private Map<String, AbstractNinaTranslator> subfas;
    private String fragment;
    private String machine;
    private String mainname;
    private String name;
    NinaMetaLanguage meta;

    public static AbstractNinaTranslator getTranslator(String lang) {
        try {
            String p = AbstractNinaTranslator.class.getPackage().getName();
            Class<?> c = Class.forName(String.valueOf(p) + ".NinaTranslator" + lang);
            return (AbstractNinaTranslator)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected int getStateNo(DFAState<Object, ?, Void> state) {
        if (this.states.containsKey(state)) {
            return this.states.get(state);
        }
        this.states.put(state, this.stateNo);
        if (state.isAccepted()) {
            this.accepts.add(this.stateNo);
        }
        this.trz.push(state);
        return this.stateNo++;
    }

    protected boolean isStackEmpty() {
        return this.trz.isEmpty();
    }

    protected DFAState<Object, ?, Void> popStack() {
        return this.trz.pop();
    }

    protected int acceptsSize() {
        return this.accepts.size();
    }

    protected Iterable<Integer> acceptsIterable() {
        return this.accepts;
    }

    protected boolean containsState(Object state) {
        return this.states.containsKey(state);
    }

    protected Integer stateNo(Object state) {
        return this.states.get(state);
    }

    protected Set<DFAState<Object, ?, Void>> stateKeys() {
        return this.states.keySet();
    }

    protected int stateSize() {
        return this.states.size();
    }

    protected NinatOptions getOptions() {
        return this.options;
    }

    protected String getMachine() {
        return this.machine;
    }

    protected String getName() {
        return this.name;
    }

    protected Object getAutomaton(String s) {
        return this.subfas.get(s);
    }

    protected Map<String, ?> getAutomata() {
        return this.subfas;
    }

    public abstract void printStates(PrintStream var1);

    public abstract void printObjectStates(PrintStream var1);

    public abstract void printClassStates(PrintStream var1);

    public abstract void printAcceptStates(PrintStream var1);

    public abstract void printAcceptToken(PrintStream var1);

    public abstract void printActions(PrintStream var1);

    public abstract void printImports(List<String> var1, PrintStream var2);

    public abstract void printIsEnd(PrintStream var1);

    protected abstract InputStream openScript() throws IOException;

    protected abstract PrintStream openOutput() throws IOException;

    protected abstract AbstractNinaTranslator newPrototype();

    protected abstract void printRecover(PrintStream var1);

    protected abstract void printDeadState(String var1, PrintStream var2);

    protected abstract void printAttrs(PrintStream var1);

    protected abstract void printFinallyState(PrintStream var1);

    protected abstract void appendValue(StringBuffer var1, StringBuffer var2);

    protected abstract void appendLvalue(StringBuffer var1, StringBuffer var2);

    protected abstract void appendMyPosition(StringBuffer var1, String var2, int var3);

    protected abstract void appendReturn(StringBuffer var1);

    private void printStateSize(String n, PrintStream out) {
        out.printf("\t\t\treturn %d;\n", this.stateSize());
    }

    public AbstractNinaTranslator prototype(String name, Object o) {
        AbstractNinaTranslator x = this.newPrototype();
        x.fragment = this.fragment;
        x.machine = this.machine;
        x.options = this.options;
        x.subfas = this.subfas;
        x.name = name;
        x.meta = this.meta;
        if (o instanceof DFABuilder) {
            x.builder = (DFABuilder)o;
            x.dfa = (DFA)x.builder.getMachine();
        }
        return x;
    }

    String executeMeta(String s) {
        if (this.meta == null) {
            return s;
        }
        return this.meta.execute(s).toString();
    }

    private void processNFA(NinaNFA n, String p, Quadro q, ShNinatBuiltInCommands cmd, ShEnvironment env) throws IOException {
        PrintStream ous = null;
        InputStream ins = null;
        this.dfa = q.getType() == null ? ConvertedRangeDFA.convertDFA(n) : ConvertedDFA.convertDFA(n);
        if (!this.options.getOption("minimize").equalsIgnoreCase("no")) {
            this.dfa = MinimizedRangeDFA.newInstance(this.dfa);
        }
        try {
            try {
                ins = this.openScript();
                ous = this.openOutput();
                ShNinatFileSystem fs = new ShNinatFileSystem(this.fragment, q, this.options);
                cmd.putCommand("print_token", new ShProcess(){

                    @Override
                    public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                        AbstractNinaTranslator.this.printAcceptToken(stdout);
                        return 0;
                    }
                });
                DefaultShRuntime run = new DefaultShRuntime(cmd);
                XtraceStream qs = new XtraceStream(System.out);
                ShFacade.execute(env, (ShFileSystem)fs, (ShBuiltInCommands)cmd, (ShRuntime)run, ins, System.in, ous, System.err, qs);
            }
            catch (ShSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (ous != null) {
                ous.close();
            }
        }
    }

    private AbstractNinaTranslator getsubfa(String[] args) {
        if (args.length > 1) {
            return this.subfas.get(args[1]);
        }
        return this;
    }

    private void processDFA(DFA<Object, Object, Void> d, String p, Quadro q, ShNinatBuiltInCommands cmd, ShEnvironment env) throws IOException {
        PrintStream ous = null;
        InputStream ins = null;
        this.dfa = d;
        try {
            try {
                ins = this.openScript();
                ous = this.openOutput();
                ShNinatFileSystem fs = new ShNinatFileSystem(this.fragment, q, this.options);
                cmd.putCommand("print_actions", new ShProcess(){

                    @Override
                    public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                        AbstractNinaTranslator.this.getsubfa(args).printActions(stdout);
                        return 0;
                    }
                });
                cmd.putCommand("print_recover", new ShProcess(){

                    @Override
                    public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                        AbstractNinaTranslator.this.getsubfa(args).printRecover(stdout);
                        return 0;
                    }
                });
                cmd.putCommand("print_deadstate", new ShProcess(){

                    @Override
                    public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                        AbstractNinaTranslator.this.getsubfa(args).printDeadState(args[1], stdout);
                        return 0;
                    }
                });
                cmd.putCommand("print_statesize", new ShProcess(){

                    @Override
                    public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                        AbstractNinaTranslator.this.getsubfa(args).printStateSize(args[1], stdout);
                        return 0;
                    }
                });
                cmd.putCommand("print_attrs", new ShProcess(){

                    @Override
                    public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                        AbstractNinaTranslator.this.getsubfa(args).printAttrs(stdout);
                        return 0;
                    }
                });
                cmd.putCommand("print_finallystate", new ShProcess(){

                    @Override
                    public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                        AbstractNinaTranslator.this.getsubfa(args).printFinallyState(stdout);
                        return 0;
                    }
                });
                DefaultShRuntime run = new DefaultShRuntime(cmd);
                XtraceStream qs = new XtraceStream(System.out);
                ShFacade.execute(env, (ShFileSystem)fs, (ShBuiltInCommands)cmd, (ShRuntime)run, ins, System.in, ous, System.err, qs);
            }
            catch (ShSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (ous != null) {
                ous.close();
            }
        }
    }

    private ShEnvironment getenv(String p, Quadro q, Map<String, Object> sub) {
        ShRootEnvironment env = new ShRootEnvironment();
        char[] a = this.options.getOutputFilename().toCharArray();
        a[0] = Character.toUpperCase(a[0]);
        env.bind("IFS", " \t");
        env.bind("CLASSNAME", new String(a));
        env.bind("PACKAGE", p);
        env.bind("FILENAME", this.options.getFilename());
        env.bind("OUTPUT_FILENAME", this.options.getOutputFilename());
        String s = this.options.getOption("bufsize");
        s = s.equals("") ? "1024" : s;
        env.bind("BUFSIZE", s);
        env.bind("TEMPLATE", q.getOption("template"));
        env.bind("EXTENDS", q.getOption("extends"));
        env.bind("IMPLEMENTS", q.getOption("implements"));
        env.bind("ABSTRACT", q.isOptionDefined("abstract") ? "abstract" : "");
        env.bind("TOKENERROR", q.isOptionDefined("tokenerror") ? q.getOption("tokenerror") : "TokenException");
        env.bind("ITERATOR", q.getOptionBoolean("iterator") ? "true" : "");
        env.bind("MAINNAME", this.mainname);
        env.bind("DEFAULTAT", q.getOption("default"));
        env.bind("ENABLE_LOOKAHEAD", q.getOption("enableLookahead"));
        env.bind("ENABLE_BACKTRACK", q.getOption("enableBacktrack"));
        env.bind("ENABLE_MATCHER", q.getOption("enableMatcher"));
        env.bind("ENABLE_LOG", q.getOption("enableLog"));
        env.bind("API_ACCESS_MODIFIER", q.getOption("APIAccessModifier"));
        env.bind("READER", q.getOption("reader"));
        s = q.getType();
        if (s == null || s.equals("char")) {
            env.bind("TYPE", "");
            env.bind("CTYPE", "int");
        } else if (s.equals("string")) {
            env.bind("TYPE", s);
            env.bind("CTYPE", "String");
        } else if (s.equals("class")) {
            env.bind("TYPE", s);
            env.bind("CTYPE", "Object");
        } else {
            env.bind("TYPE", s);
            env.bind("CTYPE", s);
        }
        StringBuffer b = new StringBuffer();
        String d = "";
        for (String x : sub.keySet()) {
            b.append(d).append(x);
            d = " ";
        }
        env.bind("SUBAUTOMATA", b.toString());
        return env;
    }

    protected void translateQuadro(String name, Object o, NinatOptions opts, Map<String, String> prms, final Map<String, Object> sub) throws IOException {
        String q;
        this.mainname = name;
        this.subfas = new HashMap<String, AbstractNinaTranslator>();
        this.options = opts;
        String m = this.quadro.getOption("machine");
        if (m != null) {
            m = "unknown";
        }
        this.fragment = this.quadro.getFragment();
        String p = opts.getOption("package");
        if ((p == null || p.equals("")) && ((p = this.quadro.getRootPackage()) == null || p.equals(""))) {
            p = "";
        }
        if ((q = this.quadro.getOption("metaLanguage")) != null && !q.equals("")) {
            this.meta = new NinaMetaLanguage(q);
        }
        if ((q = this.quadro.getFragmentByName("meta")) != null && !q.equals("") && this.meta != null) {
            this.meta.execute(q);
        }
        ShEnvironment env = this.getenv(p, this.quadro, sub);
        ShNinatBuiltInCommands cmd = new ShNinatBuiltInCommands();
        cmd.putCommand("print_states", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator t;
                if (args.length > 1) {
                    t = AbstractNinaTranslator.this.prototype(args[1], sub.get(args[1]));
                    AbstractNinaTranslator.this.subfas.put(args[1], t);
                } else {
                    t = AbstractNinaTranslator.this;
                }
                if (AbstractNinaTranslator.this.quadro.getType() == null) {
                    t.printStates(stdout);
                } else if (AbstractNinaTranslator.this.quadro.getType().equals("class")) {
                    t.printClassStates(stdout);
                } else {
                    t.printObjectStates(stdout);
                }
                return 0;
            }
        });
        cmd.putCommand("print_accepts", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printAcceptStates(stdout);
                return 0;
            }
        });
        cmd.putCommand("print_imports", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printImports(AbstractNinaTranslator.this.quadro.getImports(), stdout);
                return 0;
            }
        });
        cmd.putCommand("print_isend", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.getsubfa(args).printIsEnd(stdout);
                return 0;
            }
        });
        if (o instanceof NFABuilder) {
            this.machine = "nfa";
            this.builder = (NFABuilder)o;
            this.processNFA((NinaNFA)this.builder.getMachine(), p, this.quadro, cmd, env);
        } else if (o instanceof DFABuilder) {
            this.machine = "dfa";
            this.builder = (DFABuilder)o;
            this.processDFA((DFA)this.builder.getMachine(), p, this.quadro, cmd, env);
        } else {
            opts.perror("machinenotsupport", m);
        }
    }

    @Override
    public void translate(String name, Reader rd, NinatOptions opts, Map<String, String> prms) throws IOException {
        HashMap<String, Object> s = new HashMap<String, Object>();
        String n = Nina.getFAName(name);
        s.put(n, null);
        this.quadro = Quadro.read(n, rd);
        NinaAction o = NinaParser.complie(this.quadro, opts.getLibraryList(), prms, s, opts.getConsole());
        this.translateQuadro(n, o, opts, prms, s);
    }

    @Override
    public Object compile(String name, Reader rd, NinatOptions opts, Map<String, String> prms) throws IOException {
        HashMap<String, Object> s = new HashMap<String, Object>();
        String n = Nina.getFAName(name);
        s.put(n, null);
        Quadro q = Quadro.read(n, rd);
        return NinaParser.complie(q, opts.getLibraryList(), prms, s, opts.getConsole());
    }
}

