/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.Scheme;

public class EnvironmentObject
extends Datum {
    private Environment environment;
    private boolean inherit = false;

    EnvironmentObject(Environment environment, boolean inherit) {
        if (environment == null) {
            throw new NullPointerException();
        }
        this.environment = environment;
        this.inherit = inherit;
    }

    static EnvironmentObject newNullEnv(int ver) {
        return new EnvironmentObject(Scheme.newNullEnv(ver), false);
    }

    static EnvironmentObject newRnRSEnv(int ver) {
        return new EnvironmentObject(Scheme.newRnRSEnv(ver), false);
    }

    static EnvironmentObject newInteractionEnv(Environment e) {
        return new EnvironmentObject(e, true);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    boolean isInherit() {
        return this.inherit;
    }

    @Override
    public String toDisplay() {
        return "#<environment>";
    }
}

